;;; -*- Mode: LISP; Syntax: Common-lisp; Package: ON-LV; Base: 10 -*-

(in-package :on-lv)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; scroll bar

(defclass lispview-scroll-bar (component-pane ws::scroll-bar)
	  ((thickness :initform 19)))

(defmethod component-pane-lispview-class ((pane lispview-scroll-bar))
  (ecase (ws::scroll-bar-orientation pane)
    (:horizontal 'lv:horizontal-scrollbar)
    (:vertical 'lv:vertical-scrollbar)))

(defmethod component-pane-resources ((pane lispview-scroll-bar))
  (with-slots (thickness) pane
    ;; why isn't a scroll bar mapped by default like everything else?
    `(:mapped t
	      :client ,pane
	      ,(ecase (ws::scroll-bar-orientation pane)
		 (:horizontal ':height)
		 (:vertical ':width))
	      ,thickness)))

(defmethod lv:view-start ((client lispview-scroll-bar) (scrollbar lv:horizontal-scrollbar))
  0)

(defmethod lv:view-length ((client lispview-scroll-bar) (scrollbar lv:horizontal-scrollbar))
  1)

(defmethod lv:view-min ((client lispview-scroll-bar) (scrollbar lv:horizontal-scrollbar))
  0)

(defmethod lv:view-max ((client lispview-scroll-bar) (scrollbar lv:horizontal-scrollbar))
  100)

(defmethod lv:view-start ((client lispview-scroll-bar) (scrollbar lv:vertical-scrollbar))
  0)

(defmethod lv:view-length ((client lispview-scroll-bar) (scrollbar lv:vertical-scrollbar))
  1)

(defmethod lv:view-min ((client lispview-scroll-bar) (scrollbar lv:vertical-scrollbar))
  0)

(defmethod lv:view-max ((client lispview-scroll-bar) (scrollbar lv:vertical-scrollbar))
  100)


;;; I don't think that we needs these for Lispview.  We instead have 
;;; to write the scroll-bar-client protocol methods on the l-s-b
;;; class (e.g. view-min, view-max).
(defmethod (setf ws::scroll-bar-min-value) :after (new-value (sb lispview-scroll-bar))
  )

(defmethod (setf ws::scroll-bar-max-value) :after (new-value (sb lispview-scroll-bar))
  )

(defmethod (setf ws::scroll-bar-page-increment) :after (new-value (sb lispview-scroll-bar))
  )

(defmethod (setf ws::scroll-bar-orientation) :after (new-value (sb lispview-scroll-bar))
  )
				       
(defmethod ws::compose-space ((sb lispview-scroll-bar))
  (let* ((component (sheet-mirror sb))
	 (region (lv:bounding-region component))
	 (thickness (slot-value sb 'thickness)))
    (ecase (ws::scroll-bar-orientation sb)
      (:vertical
       (ws::make-space-req :hs thickness :hs+ 0 :hs- 0
			   :vs (lv:region-width region) :vs+ +fill+ :vs- +fill+))
      (:horizontal
       (ws::make-space-req :vs thickness :vs+ 0 :vs- 0
			   :hs (lv:region-height region) :hs+ +fill+ :hs- +fill+)))))

(defmethod ws::scroll-bar-set-range ((scroll-bar lispview-scroll-bar) new-min new-max)
  ;;--- do we need to do anything?
  )

(defmethod lv:compute-view-start ((sb lispview-scroll-bar) component motion point)
  (declare (ignore component motion))
  ;; --- should hack page/line increments?
  (case motion
    (:absolute
     (ws::value-change-callback sb (ws::gadget-client sb) (ws::gadget-id sb) point)))
  point)
