;;; -*- Mode: LISP; Syntax: Common-Lisp; Base: 10; Package: ON-LV -*-

(in-package :on-lv)

"Copyright (c) 1991 International Lisp Associates.  All rights reserved."

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; A special class to be used as the
;;; root of the user's pane hierarchy.  All the space in the
;;; frame not "covered" by mirrored widgets will be "backed"
;;; by this pane.  Thus, it's mirror will become the mirror for
;;; stream panes, etc.
;;; We want to be able to create arbitrary components that have this as
;;; the parent, so according to XView/Lispview rules, the mirror has
;;;  to be a PANEL. 
(defclass lispview-root-pane (ws::echoing-layout-mixin component-pane)
  ((lispview-class :allocation :class
		   :initform 'root-panel
		   :reader xcomponent-pane-lispview-class)))

(defclass root-panel (lv:panel)
  ((root-pane :initarg :root-pane
	      :reader root-panel-root-pane))
  (:default-initargs :root-pane nil))

(defclass root-damage (lv:damage-interest) ()
	  )

(defmethod component-pane-resources ((lrp lispview-root-pane))
  ;; initialize the event "interests"
  (list ':interests (list (make-instance 'root-damage)
			  (make-instance 'mouse-moved)
			  (make-instance 'mouse-button-up)
			  (make-instance 'mouse-button-down))
	':root-pane lrp
	;; Leave the background to default, now that the various
	;; container panes don't draw over it.
	;;':background (lv:find-color :name :white)
	))

;;; Add event-dispatching methods here.

;;; When the root is damaged, repaint the whole thing. 
(defmethod lv:receive-event ((component root-panel) (interest root-damage) event)
  ;; --- should really repaint only the damaged region.
  (repaint-sheet (root-panel-root-pane component) +everywhere+))

#||
;;; Can't seem to get the damage events.

;;; debugging code.
(defmethod lv:receive-event ((component root-panel) (interest lv:damage-interest) event)
  (repaint-sheet (root-panel-root-pane component) +everywhere+))

(defmethod lv:receive-event ((component root-panel) (interest lv:mouse-interest) event)
  (print (setq the-event event)))
||#

(defclass mouse-moved (lv:mouse-interest)
  ()
  (:default-initargs :event-spec '(() :move)))

(defmethod lv:receive-event ((component root-panel) (interest mouse-moved) event)
  (distribute-lispview-event (root-panel-root-pane component) event
			     ':pointer-motion :moved-p t
			     :x (lv:mouse-event-x event)
			     :y (lv:mouse-event-y event)))

(defclass mouse-button-down (lv:mouse-interest)
  ()
  (:default-initargs :event-spec '(((:others (or :up :down)))
				   ((or :left :right :middle)
				    :down))))

(defclass mouse-button-up (lv:mouse-interest)
  ()
  (:default-initargs :event-spec '(((:others (or :up :down)))
				   ((or :left :right :middle)
				    :up))))

(defmethod lv:receive-event ((component root-panel) (interest mouse-button-down) event)
  (multiple-value-bind (shifts button-spec)
      (lv:mouse-event-gesture event)
    (let* ((button (first button-spec)))
      (distribute-lispview-event (root-panel-root-pane component) event
				 ':button-press 
				 ;; --- Should use previous X/Y value??
				 :x 0 :y 0
				 ;; use CLX button codes
				 :code (ecase button
					 (:left 1)
					 (:middle 2)
					 (:right 3))))))
  
(defun distribute-lispview-event (sheet event event-key &rest distribution-args
					&key x y &allow-other-keys)
  (let* ((port	           (port sheet))
	 (distributor      (slot-value port 'silica::distributor))
	 )
    (apply #'distribute-device-event
	   distributor
	   port
	   sheet
	   :event-key event-key
	   :event-window (lv:event-object event)
	   :time (lv:event-timestamp event)
	   :native-x x :native-y y
	   ;; --- State is hairy in Lispview
	   :state 0
	   distribution-args)))
#||

;;; Process ONE event and return
;;; Derrived from the basic CLX version in X-PORT.LISP
(defun handle-lispview-event (sheet event)
  (let* ((port	           (port sheet))
	 (distributor      (slot-value port 'silica::distributor))


	 (x 	   	   (second event-info))
	 (y 		   (third event-info))
	 (root-x 	   (fourth event-info))
	 (root-y 	   (fifth event-info))
	 (state 	   (sixth event-info)))

    (macrolet ((distribute (&rest keys)
		 `(let ((sheet (if sheet sheet
				 (mirror->sheet port event-window))))
		    (distribute-device-event
		     distributor
		     port
		     sheet
		     ,@keys
		     :event-window event-window
		     :time 0
		     :native-x x :native-y y
		     ;; ??? Portable state is same as CLX state
		     :state state))))

      ;; Device Events
      (cond ((or (eql clm-event-code xtk::*motion-notify*)
		 (eql clm-event-code xtk::*enter-notify*)
		 (eql clm-event-code xtk::*leave-notify*))
	     (when sheet
	       (distribute :event-key ':pointer-motion :moved-p t)))
       
	    ((eql clm-event-code xtk::*button-press*)
	     ;; --- handle click-type stuff?
	     (let ((code (seventh event-info)))
	       (distribute :event-key ':button-press :code code)))
	    ((eql clm-event-code xtk::*button-release*)
	     ;; --- handle click-type stuff?
	     (let ((code (seventh event-info)))
	       (distribute :event-key ':button-release :code code)))

	    ((or (eql clm-event-code xtk::*key-press*)
		 (eql clm-event-code xtk::*key-release*))
	 
	     (let* ((code (seventh event-info))
		    ;; --- got to rely on CLX, right?
		    (keysym (on-x::x-keysym->keysym
			     (xlib:keycode->keysym 
			      x-display code
			      (xlib:default-keysym-index x-display code state))))
		    (shift-mask (state->shift-mask state))
		    ;; Canonicalize the only interesting key right here.
		    ;; If we get a key labelled "Return", we canonicalize it
		    ;; into #\Newline.
		    ;; This may be misguided, but it'll almost certainly help us
		    ;; in the short run.
		    (char (cond ((and (eql keysym ':return)
				      (or (zerop shift-mask)
					  (= shift-mask (make-shift-mask :shift))))
				 #\Newline)
				(t (xlib:keycode->character x-display code state)))))
	       (distribute :event-key (cond ((eql clm-event-code xtk::*key-press*)
					     ':key-press)
					    ((eql clm-event-code xtk::*key-release*)
					     ':key-release))
			   :code code
			   :keysym keysym
			   :char (and (typep char 'standard-char)
				      char)
			   :keyboard-p t)))
	    
	    ((eql clm-event-code xtk::*expose*)
	     ;;(queue-repaint sheet (sheet-region sheet))
	     (repaint-sheet sheet (sheet-region sheet))
	     )

	    ((eql clm-event-code xtk::*configure-notify*)
	     ;; --- this can trigger a blowout if it runs
	     ;; --- too early during frame creation.  How
	     ;; --- do we tell when it is OK to process them?
	     #+ignore
	     (mirror-region-updated port sheet))

	;;; --- import other clauses from x-port version
	    ))))

||#
