;;; -*- Mode: LISP; Syntax: Common-lisp; Package: ON-LV; Base: 10 -*-

(in-package :on-lv)

;;;; Main window

(defclass lispview-main-window (component-pane)
  ((menu-bar)
   (lispview-class :allocation :class
		   :initform 'lv:window
		   :reader xcomponent-pane-lispview-class)))

;;; --- ??? for some reason, the :READER method above was not getting`
;;; defined.  I finally wrote this as a work-around out of frustration.
;(defmethod component-pane-lispview-class ((class lispview-main-window))
;  'lv:window)

;;; The main-window automatically creates a menu-bar with the
;;; frame's top-level commands.
(defmethod initialize-instance :after ((main-window lispview-main-window)
				       &key
				       menu-group
				       )
  (setf (slot-value main-window 'menu-bar)
	(when menu-group
	  (make-pane 'lispview-menu-bar 
		     :menu-group menu-group
		     :parent main-window
		     ))))

(defmethod ws::compose-space ((pane lispview-main-window))
  ;; fake VBOX behavior
  (let ((total-height 0)
	(max-width 0))
    (dolist (child (sheet-children pane))
      (let ((req (ws::compose-space child)))
	(incf total-height (ws::space-req-vs req))
	(ci::maxf max-width (ws::space-req-hs req))))
    ;; --- must handle the + and - values
    (ws::make-space-req :hs max-width :vs total-height)))

(defmethod ws::allocate-space ((pane lispview-main-window) width height)
  (with-slots (menu-bar) pane
    ;; Assuming main-window has two children, the menu bar and the
    ;; frame contents.
    (let ((other (first (remove menu-bar (sheet-children pane)))))
      (if menu-bar
	  (let* ((mbreq (ws::compose-space menu-bar))
		 (bar-height (ws::space-req-vs mbreq))
		 (rest (- height bar-height)))
	    (move-and-resize-sheet* other 0 0 width rest)
	    (move-and-resize-sheet* menu-bar 0 rest width bar-height))
	  (move-and-resize-sheet* other 0 0 width height)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Menu bar

;;; The top-level application menu bar, holding commands in
;;; pull-down-menu fasion.
(defclass lispview-menu-bar (ws::hbox-layout-mixin component-pane)
  ((menu)
   (lispview-class :allocation :class
		   :initform 'lv:panel
		   :reader xcomponent-pane-lispview-class)))

(defmethod component-pane-resources ((mb lispview-menu-bar))
  ;; --- Don't know how to do auto-layout, sizing the panel
  ;; to fit its buttons, so size it explicitly
  (list :height 40 :width (bounding-rectangle-width (sheet-region mb))))

(defmethod compose-space :around ((mb lispview-menu-bar))
  (let ((req (call-next-method)))
    (ws::space-req+* req :vs 6)))

;;; The menu bar creates buttons for each of its menu-group's
;;; elements.
(defmethod initialize-instance :after ((menu-bar lispview-menu-bar)
				       &key menu-group)
	   (setup-menu-bar menu-bar menu-group))

(defun setup-menu-bar (menu-bar menu-group)
  ;; There is no lispview helper function to take a spec and lay
  ;; out a row of command and menu buttons.
  (doseq (item (menu-group-elements menu-group))
    (let ((label (menu-group-element-string item))
	  (value (menu-group-element-value item))
	  (type  (menu-group-element-type item)))
      (ecase type
	(:command
	 (make-pane 'lispview-command-button
		    :parent menu-bar :command value :label label))
	(:menu-group
	 (make-pane 'lispview-menu-button
		    :parent menu-bar
		    :label label
		    :menu-spec (process-menu-group value))))))
  )

;;; A utility that creates a Lispview "menu spec" from a menu
;;; group.
(defun process-menu-group (menu-group)
  (when menu-group
    (let ((results nil))
      (doseq (item (menu-group-elements menu-group))
	     (let ((label (menu-group-element-string item))
		   (value (menu-group-element-value item))
		   (type  (menu-group-element-type item)))
	       (ecase type
		 ;; This code is port-specific, so it doesn't use the
		 ;; adaptive pane names
		 (:command
		  (push `(,label (lambda () (command-menu-button-handler ',value)))
			results))
		 (:menu-group
		  (push `(,label :menu ,(process-menu-group value))
			results)))))
      (nreverse results))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Menu button
;;; Has an associated menu, containing menu group items.
;;; --- We may do this completely differently in Lispview
(defclass lispview-menu-button (lispview-button-mixin ws::menu-button)
  (;; This holds the actual Lispview menu object
   (menu-spec :initarg :menu-spec)
   (submenu :reader menu-button-submenu
	    :initform nil)
   (lispview-class :allocation :class
		   :initform 'lv:menu-button
		   :reader xcomponent-pane-lispview-class)))

;;; Create the associated menu once we are adopted, since that
;;; menu's parent must be our parent (e.g. the menu-bar)
;(defmethod sheet-adopted :after ((mb lispview-menu-button)
;			  &key &allow-other-keys)
;  (with-slots (menu-spec submenu) button
;    (when menu-spec
;      (setf submenu
;	    ))))
    
;;; We need APPEND method combination so that earler methods will
;;; combine their results with later.
(defmethod component-pane-resources ((mb lispview-menu-button))
  (with-slots (menu-spec submenu) mb
      (setf submenu (make-instance 'lv:menu :menu-spec menu-spec))
    (list ':label (ws::button-label mb)
	  ':menu submenu)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; A subclass of button that knows how to invoke a CLIM
;;; command at activate time.
;;; --- this should all be abstracted to the portable layer

(defclass lispview-command-button (lispview-button-mixin ws::push-button)
  ((command :initarg :command :accessor command-button-command)
   (lispview-class :allocation :class
		   :initform 'lv:command-button
		   :reader xcomponent-pane-lispview-class)))

(defmethod component-pane-resources ((cb lispview-command-button))
  (with-slots (command) cb
    (list ':label (ws::button-label cb)
	  ':command `(lambda () (command-menu-button-handler ',command)))))


(defun command-menu-button-handler (command)
  (fresh-line)
  (format *Trace-output* "Would execute ~S" command))
