(in-package :on-lv)

;;; The medium object 

(defclass clg-lispview-display-medium (on-x::clg-display-medium)
  ()
  )

(defclass clg-lispview-pixmap-medium (on-x::clg-display-medium)
  ()
  )

(defmethod display-medium-type ((port lispview-port) (type (eql :clim)))
  'clg-lispview-display-medium)

(defmethod pixmap-medium-type ((port lispview-port) (type (eql :clim)))
  'clg-lispview-pixmap-medium)
 

;;; 

(defmethod slot-unbound (class (medium clg-lispview-display-medium)
			       (slot-name (eql 'on-x::drawable)))
  (declare #-PCL (ignore class))
  (setf (slot-value medium 'on-x::drawable) 
    (fetch-lispview-clx-window (medium-sheet medium))))

(defmethod fetch-lispview-clx-window ((sheet component-pane))
  (or (component-pane-clx-window sheet)
      (let* ((port (port sheet))
	     (clx-window 
	      (let ((component (sheet-mirror sheet)))
		(assert component)
		(lispview->clx port component))))
	(setf (mirror->sheet port clx-window) sheet
	      (component-pane-clx-window sheet) clx-window)
	clx-window)))

(defmethod fetch-lispview-clx-window (sheet)
  (fetch-lispview-clx-window (sheet-parent sheet))
  #+ignore
  (error "Trying to get x window for ~S" sheet))

(defmethod sheet-medium ((w component-pane)) nil)
