;;; -*- Mode: LISP; Syntax: Common-Lisp; Base: 10; Package: ON-LV -*-

(in-package :on-lv)

"Copyright (c) 1991 International Lisp Associates.  All rights reserved."

(defparameter *lispview-look-and-feel* 
    '(ws::menu-button   lispview-menu-button
      ws::push-button	lispview-push-button
      ws::toggle-button lispview-toggle-button
      ws::scroll-bar	lispview-scroll-bar
      ws::slider	lispview-slider
      )
  )

(defclass lispview-frame-manager (frame-manager ws::style-manager)
  ()
  (:default-initargs
   :pane-class-map *lispview-look-and-feel*))

;;; Some methods from xx-framem.lisp

(defmethod adopt-frame ((frame-manager lispview-frame-manager) (frame frame))
  (with-look-and-feel-realization (frame-manager frame)
    ;; --- surely this should be done at the time this slot
    ;; is set, not read.
    (let ((mg (ws::frame-menu-group frame))) 
      (when mg
	(when (symbolp mg)
	  (setq mg (ws::instantiate-menu-group-from-prototype mg))
	  (setf (ws::frame-menu-group frame) mg)))
      ;; Establish the frame as client for all gadgets
      (let* ((ws::*default-client* frame)
	     (ws::*default-pane-background-ink* ':invisible-ink)
	     (frame-pane (frame-pane frame))
	     ;; The main window holds the menu-bar and the
	     ;; user-defined contents in a vertical stack.
	     (main-window (make-pane 'lispview-main-window
				     :menu-group mg))
	     ;; Put the contents under a special bulletin
	     ;; board pane that will server as the root of the
	     ;; application's pane hierarchy.
	     (root (make-pane 'lispview-root-pane)))
	(adopt-child root frame-pane)
	(adopt-child main-window root)
	(let ((top-sheet
	       (ws::engraft-pane (ws::frame-manager-sheet frame-manager) 
				 main-window
				 :frame frame)))
	  ;; This code should be shared among frame managers.
	  (setf (ws::frame-manager-prop frame :socket-sheet) top-sheet)
	  (apply #'install-settings top-sheet (ws::frame-settings frame)))))
    frame))

;;; Direct copy of code from xx-framem.  We need a shared superclass.
(defmethod ws::enabling-frame ((frame-manager lispview-frame-manager) frame)
  (let ((sheet (ws::frame-manager-prop frame :socket-sheet)))
    (ws::install-settings sheet :state :normal)
    (unless (sheet-enabled-p sheet)
      (enable-sheet sheet))))

;;; Direct copy of code from xx-framem.  We need a shared superclass.
(defmethod disown-frame ((frame-manager lispview-frame-manager) frame)
  (let ((socket (ws::frame-manager-prop frame :socket-sheet)))
    (when socket
      (disown-child (sheet-parent socket) socket))))

;;; Direct copy of code from xx-framem.  We need a shared superclass.
(defmethod ws::laying-out-frame
	   ((frame-manager lispview-frame-manager) frame width height) 
  (let* ((sheet (ws::frame-manager-prop frame :socket-sheet))
	 (child (sheet-child sheet)))
    
    (unless width
      (let ((req (compose-space child)))
	(setq width (ws::space-req-hs req))
	(setq height (ws::space-req-vs req))))
      
    (resize-sheet* sheet width height)
    (ws::size-frame frame  width height)
    (allocate-space child width height)))

(defmethod ws::find-pane-for-frame :around (frame (frame-manager lispview-frame-manager))
   (declare (ignore frame))
   (let ((ws::*default-pane-background-ink* ':invisible-ink))
     (call-next-method)))
