;; -*- Mode: LISP; Syntax: Common-Lisp; Base: 10; Package: ON-LV -*-

(in-package :on-lv)

"Copyright (c) 1991 International Lisp Associates.  All rights reserved."

(defclass component-pane (pane
			   w::mute-input-contract
			   w::mute-output-contract
			   mirrored-sheet-mixin
			   ;; We don't really want permanently-enabled-mixin
			   ;; (which is built into dashboard-child-part)
			   ;; cause it causes us to try to realize-widget
			   ;; at sheet-adopted time, when the parent widget
			   ;; may not yet be realized.
			   ws::dashboard-child-part
			   ws::dashboard-parent-part
			   ws::layout-mixin
			   sheet)
  ((clx-window :initform nil :accessor component-pane-clx-window)))

(defmethod ws::compose-space ((mw component-pane))
  (let* ((component (sheet-mirror mw))
	 (region (lv:bounding-region component)))
    (ws::make-space-req :hs (lv:region-width region)
			:hs+ 0 :hs- 0
			:vs (lv:region-height region)
			:vs+ 0 :vs- 0)))

;;; We only need this for composit widgets, to trigger their layout
;;; code.  We don't yet have any adapting composite widgets.
(defmethod ws::allocate-space ((mw component-pane) width height)
  )

;;; Need to justify this with some commentary.
(defmethod sheet-grafted :after ((sheet component-pane))
  (realize-mirror (port sheet) sheet))

;;; --- This is the work-around for the bug where you can't have
;;; :READER methods and standard methods on the same GF.  So, I
;;; commented out all the reader methods and replaced them with
;;; this.
(defmethod component-pane-lispview-class ((pane component-pane))
  (slot-value pane 'lispview-class))

;;; Wants to have APPEND method combination so that each class
;;; can contribute part of the final init options list.
(defmethod component-pane-resources ((pane component-pane)) nil)

;;; When the mirror component object gets created, we need to update 
;;; the CLIM-side data structures to get the right size, etc.
(defmethod realize-mirror :around ((port lispview-port) (pane component-pane))
  (prog1 
      (call-next-method)
    ;; Must run this after the :AROUND method on SHEET has
    ;; set the SHEET-MIRROR slot.
    (update-native-transformation port pane)))

(defmethod realize-mirror ((port lispview-port) (sheet component-pane))
  ;; --- ?
  (setf (sheet-native-transformation sheet) +identity-transformation+)
  #+debugging
  (lisp:format *trace-output* "~%Mirroring: ~S, lv class: ~S, parent: ~S, resources: ~S"
	       sheet
	       (component-pane-lispview-class sheet) 
	       (sheet-mirror! sheet)
	       (component-pane-resources sheet))
  (apply #'make-instance
	 (component-pane-lispview-class sheet) 
	 ;; Use the next mirror up the tree for the parent.
	 ;; Hopefully it is the root-pane's panel window.
	 :parent (sheet-mirror! sheet)
	 (component-pane-resources sheet)))

(defmethod enable-mirror ((port lispview-port) (sheet component-pane))
  (setf (lv:mapped (sheet-mirror sheet)) t))

;;; --- Pass value-getting requests right through to the component.
;;; --- Maybe this should only be defined for certain widgets,
;;; --- like scroll-bars that have gadget-value-mixin?
;;; --- The alternative is to cache the host widget value in 
;;; --- the value slot.
;;; --- If the value datum needs to be massaged, the individual
;;; --- component's CLIM class should shadow this method.
(defmethod ws::gadget-value ((sheet component-pane))
  (let ((mirror (sheet-mirror sheet)))
    (when mirror
      (lv:value mirror))))

;;; Why was this here?
#+ignore
(defmethod ws::pane-viewport ((sheet component-pane))
  sheet)

;;;  I dunno why we had to define this
(defmethod silica::fetch-delta-transformation ((sheet component-pane) ancestor)
  silica::+identity-transformation+)

;;; fetch-native-transformation on a mirrored sheet
;;; returns the slot-value native-transformation
;;; For an unmirrored sheet, we compose that sheet-transform with the result
;;; of calling fetch-native-transformation on the parent.

;;; When we modify the sheet-native-transformation [update-native-transformation]
;;; we compose it with the sheet-native-transformation of the parent



;;; When you repaint a sheet that is a Lispview component pane,
;;; tell the Lispview objec to redisplay itself.  The only way I
;;; know to do this is to setf its MAPPED state.
(defmethod silica::repaint-sheet-internal :before ((pane component-pane) region)
	   (declare (ignore region))
	   ;; We have to force out any pending CLX draw-rectangle, etc.
	   ;; calls that are pending so that the gadget repaint happens
	   ;; "on top" of the earlier repainting.
	   (port-force-output (port pane))
	   (let ((component (sheet-mirror pane)))
	     (when component
	       (setf (lv:mapped component) t))))
