;;; -*- Mode: LISP; Syntax: Common-lisp; Package: ON-LV; Base: 10 -*-

(in-package :on-lv)

;;; Helper function to get font names.  We use CLX, but hopefully
;;; the names are acceptable to Lispview.
(defun text-style-to-font-name (sheet ts)
  (setq ts (parse-text-style ts))
  (let ((font (w::text-style-mapping (port sheet) nil ts)))
    (when font
      (xlib::font-name font))))

(defclass lispview-label (component-pane)
  (
   (lispview-class :allocation :class
		   :initform 'lv:message
		   :reader xcomponent-pane-lispview-class)
   (label :initarg :label :initform "none")
   ))

(defmethod component-pane-resources ((pane lispview-label))
  (list `:label (slot-value pane 'label)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; A common button superclass to hang shared methods
(defclass lispview-button-mixin (lispview-label)
  ()
  )

(defmethod (setf ws::button-label) :after (new-value (button lispview-button-mixin))
  (setf (lv:label (sheet-mirror button)) new-value))

(defmethod (setf ws::button-text-style) :after (new-value (button lispview-button-mixin))
  (declare (ignore new-value))
  (warn "The Lispview port does not allow the text style of widgets to bechanged."))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Push-button

;;; --- how to handle show as default?
(defclass lispview-push-button (lispview-button-mixin ws::push-button)
  ((lispview-class :allocation :class
		   :initform 'lv:command-button
		   :reader xcomponent-pane-lispview-class))
  )

;;; who knows how we'll do ARM and DISARM
(defmethod component-pane-resources ((pb lispview-push-button))
  (list ':label (ws::button-label pb)
	`:command #'(lambda ()
		      (ws::activate-callback 
			pb
			(ws::gadget-client pb)
			(ws::gadget-id pb)))))

(defmethod (setf ws::push-button-show-as-default-p) :after (new-value (mpb lispview-push-button))
  (declare (ignore new-value))
  (warn "Don't know how to set the show-as-default-p attribute for Lispview buttons"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Toggle-button
(defclass lispview-toggle-button (lispview-button-mixin ws::toggle-button)
  ((lispview-class :allocation :class
		   ;; Implemented as a one-item non-exclusive selection.
		   :initform 'lv:check-box
		   :reader xcomponent-pane-lispview-class)))

(defmethod component-pane-resources ((tb lispview-toggle-button))
  (list ':label (ws::button-label tb)
	;; Use the label to show the name, and one null choice to show the box.
	:choices '("")
	;; select the one item if T
	':value (if (slot-value tb 'ws::value)
		    '("")
		    nil)
	':update-value #'(lambda (new-value)
			   (ws::value-change-callback
			     tb
			     (ws::gadget-client tb)
			     (ws::gadget-id tb)
			     new-value))
	))

;;; --- I assume that call-callbacks can't be handled in CLM.  I think
;;; --- that this method is all that's needed to make the lispview-toggle-button
;;; --- work with the radio-box I just wrote
(defmethod ws::set-gadget-value :after ((tb lispview-toggle-button) new-value &key call-callbacks)
  (declare (ignore call-callbacks))
  (when (sheet-enabled tb)
    ;; If the new value is T, select the on (empty) item.
    ;; NIL, select nothing.
    (setf (lv:value (sheet-mirror tb))
	  (if new-value
	      '("")
	      nil))))
