(in-package "USER")
   
#+lucid
(defun ld (file)
  (load file :if-source-newer :compile :if-source-only :compile))

#+excl
(defun ld (source &aux source-file binary-file)
  (setf source-file (source-file-name source))
  (setf binary-file (binary-file-name source))
  (if (not (probe-file binary-file))
      (compile-file source-file :output-file binary-file)
      (when (> (file-write-date source-file) (file-write-date binary-file))
	    (compile-file source-file :output-file binary-file)))
  (load binary-file))

(ld "on-lv-package")
(ld "lv-port")
(ld "lv-frame-manager")
(ld "lv-component")
(ld "lv-root")
(ld "lv-buttons")
(ld "lv-menus")
(ld "lv-scroll-bar")
(ld "lv-medium-glue")
(ld "lv-slider")
;(ld "events")
;(ld "stream")
