;;; -*- Syntax: Common-Lisp; Package: CLIM-USER; Base: 10; Mode: LISP -*-

#+Silica #.(warn "This file does not work in modern versions of CLIM.")

(defun run-lisp-listener (window &optional (command-table 'clim::user))
  "Run a simple Lisp listener using the window provided."
  (catch 'ci::abort-gesture-seen		;--- this should be abstracted [DCPL]
   (with-activation-characters ('(#+Genera #\End))
    ;(ci::with-input-focus (window)
      (stream-clear-input window)
      (window-clear window)
      (window-expose window)
      (terpri window)
      (let ((*standard-output* window)
	    (*standard-input* window)
	    (*query-io* window))
	(let ((*command-table* command-table))
	  (catch 'ci::exit-cp
	    (loop
	      (multiple-value-bind (command-or-form type)
		  (progn (write-string "=> ")
			 (accept 'command-or-form
				 :stream *standard-input*))
		(cond ((eql (presentation-type-name type)
			    'command)
		       (terpri)
		       (let ((command-function (pop command-or-form))
			     (command-args command-or-form))
			 (apply command-function command-args))
		       (terpri))
		      (t
		       (terpri)
		       (let ((values (multiple-value-list (eval command-or-form))))
			 (fresh-line)
			 (dolist (value values)
			   (present value 'expression)
			   (terpri))
			 (shiftf +++ ++ + command-or-form)
			 (shiftf /// // / values)
			 (shiftf *** ** * (first values))))))))))
      ;)
   ))
  (setf (window-visibility window) nil))

(defvar *listeners* nil)

(defun do-lisp-listener (&key reinit root)
  (let* ((entry (assoc root *listeners*))
	 (p (cdr entry)))
    (when (or (null p) reinit)
      (multiple-value-bind (left top right bottom)
	  (window-inside-edges root)
	(let* ((desired-left 50)
	       (desired-top 50)
	       (desired-width 400)
	       (desired-height 400)
	       (desired-right (+ desired-left desired-width))
	       (desired-bottom (+ desired-top desired-height)))
	  (when (> desired-right right)
	    (setf desired-right right
		  desired-left (max left (- desired-right desired-width))))
	  (when (> desired-bottom bottom)
	    (setf desired-bottom bottom
		  desired-top (max top (- desired-bottom desired-height))))
	  (setq p (ci::open-window-stream 
		    :parent root
		    :left desired-left
		    :top desired-top
		    :right desired-right
		    :bottom desired-bottom
		    :initial-cursor-visibility :off))))
      (if entry
	  (setf (cdr entry) p)
	  (push (cons root p) *listeners*)))
    (run-lisp-listener p)))

;(clim-demo::define-demo "Lisp Listener" (do-lisp-listener :root clim-demo::*demo-root*))

(define-command (com-clear-output-history :command-table user)
    ()
   (window-clear *standard-input*))