;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-DEMO; Base: 10 -*-

(in-package 'clim-demo)

"Copyright (c) 1990, International Lisp Associates.  All rights reserved.
"
(defun grid-demo (stream &optional (count 20))
  (check-type 		;will probably blow up otherwise
    stream clim::sheet)				; --- internal symbol ???
  (window-clear stream)
  (let* ((i 0)
	 (width 400)
	 (height 400)
	 (rows 4)
	 (columns 2)
	 (cell-width (round width columns))
	 (cell-height (round height rows))
	 old-col old-row
	 (medium (silica:sheet-medium stream)))	;---??? needed
    (flet ((draw-cell (row col op)
	     (draw-rectangle* medium (* col cell-width) (* row cell-height)
			      (* (1+ col) cell-width) (* (1+ row) cell-height)
			      :ink (case op
				     (:erase clim::+background+)
				     (:draw clim::+foreground+)))))
      (with-output-recording-options (stream :record-p nil :draw-p t)
	(tracking-pointer (stream)		;was (stream-primary-pointer stream)
	  (:pointer-motion (sheet x y)
	   (declare (ignore sheet))
	   ;; (princ "X")
	   (force-output stream)		;--- why is this needed??
	   (let* ((cur-col (floor x cell-width))
		  (cur-row (floor y cell-height)))
	     (unless (and (eql cur-col old-col)
			  (eql cur-row old-row))
	       (when old-col
		 (draw-cell old-row old-col :erase))
	       (draw-cell cur-row cur-col :draw)
	       (setq old-row cur-row old-col cur-col)))
	   (incf i)
	   (when (> i count)
	     (return-from grid-demo))))))))
