;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10; Lowercase: Yes -*-

;; $fiHeader: view-defs.lisp,v 1.4 91/03/26 12:49:05 cer Exp $

(in-package "CLIM-INTERNALS")

"Copyright (c) 1990, 1991 Symbolics, Inc.  All rights reserved."

;; VIEW protocol class
(defclass view () ())

(defun-inline viewp (object) (typep object 'view))

(defclass textual-view (view) ())

(defclass dialog-view (textual-view) ())

(defclass menu-view (textual-view) ())

(defclass pointer-documentation-view (textual-view) ())

(defclass iconic-view (view) ())

(defvar +textual-view+ (make-instance 'textual-view))
(defvar +dialog-view+ (make-instance 'dialog-view))
(defvar +menu-view+ (make-instance 'menu-view))
(defvar +pointer-documentation-view+ (make-instance 'pointer-documentation-view))
(defvar +iconic-view+ (make-instance 'iconic-view))
