;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10; Lowercase: Yes -*-

(in-package "CLIM-INTERNALS")

"Copyright (c) 1988, 1989, 1990 International Lisp Associates.  All rights reserved."

;;; A specific facility for temporary strings.  This could be replaced by
;;; a general STACK-LET facility if we write something like that.

#-Genera
(defresource temporary-string
	     (&key (length 100) (adjustable t))
  :constructor (make-array length
			   :element-type +string-array-element-type+
			   :fill-pointer 0
			   :adjustable adjustable)
  :matcher (and (eq adjustable (adjustable-array-p temporary-string))
		(or (and (not adjustable)
			 (= length (array-dimension temporary-string 0)))
		    (<= length (array-dimension temporary-string 0))))
  :initializer (setf (fill-pointer temporary-string) 0)
  )

#-Genera ;; Reach into the guts of the resource mechanism
(defun temporary-string-p (string)
  (clim-utils::with-resource-rd ('temporary-string RD)
    (dovector (ts (clim-utils::RD-objects RD))
      (when (eq (clim-utils::os-object ts) string)
	(return-from temporary-string-p t)))))

#-Genera
(defmacro with-temporary-string ((var &key (length 100) (adjustable t)) &body body)
  `(using-resource (,var temporary-string :length ,length :adjustable ,adjustable)
     ,@body))

#-Genera
(defmacro copy-temporary-string-if-necessary (string-var)
  `(if (temporary-string-p ,string-var)
       (setf ,string-var 
	     (make-array (length ,string-var)
                         :element-type +string-array-element-type+
			 :initial-contents ,string-var))
       ,string-var))

#+Genera
(defmacro with-temporary-string ((var &key (length 100) (adjustable t)) &body body)
  `(sys:with-stack-array (,var ,length :element-type 'scl:string-char :adjustable ,adjustable
			  :fill-pointer 0)
     ,@body))

#+Genera
(defun temporary-string-p (string)
  (si:in-stack string))

#+Genera
(defmacro copy-temporary-string-if-necessary (string-var)
  `(setf ,string-var (sys:copy-if-necessary ,string-var)))


;;; Utility.
(defmacro with-temp-substring ((string-var string start end) &body body)
  ;; --- this probably wants to be inline rather than
  ;; creating a continuation, but for testing I'll do it this way.
  `(flet ((with-temp-substring
	    (,string-var) ,@body))
     (declare (dynamic-extent #'with-temp-substring))
     (with-temp-substring-1 ,string ,start ,end #'with-temp-substring)))

(defun with-temp-substring-1 (string start end continuation)
  (unless end (setq end (length string)))
  (let ((length (- end start)))
    (with-temporary-string (temp-string :length length)
      (setf (fill-pointer temp-string) length)
      (replace temp-string string :start2 start :end2 end)
      (funcall continuation temp-string))))

