;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10; Lowercase: Yes -*-

(in-package "CLIM-INTERNALS")

"Copyright (c) 1989, 1990 International Lisp Associates.  All rights reserved."

;;; The trampolines for the actual drawing operations are supplied by
;;; code in graphics-output-recording, but no one arranged for
;;; trampolines for medium-ink, etc.
;;; Maybe this should be done some other way.
(define-slot-trampoline-template w::clg-graphics
				 w::clg-medium
  clim-stream::encapsulating-stream-mixin
  (clim-stream::encapsulating-stream-mixin clim-utils::body)
  nil
  `(let ((clim-stream::encapsulating-stream-mixin
	   (slot-value ,clim-stream::encapsulating-stream-mixin 'stream)))
     ,@clim-utils::body))

(clim-stream::generate-stream-protocol-trampolines)

;;; The protocol stuff doesn't quite support these below:

(defmethod text-style-height ((text-style text-style) (stream encapsulating-stream-mixin))
  (text-style-height text-style (slot-value stream 'stream)))

(defmethod text-style-width ((text-style text-style) (stream encapsulating-stream-mixin))
  (text-style-width text-style (slot-value stream 'stream)))

(defmethod text-style-ascent ((text-style text-style) (stream encapsulating-stream-mixin))
  (text-style-ascent text-style (slot-value stream 'stream)))

(defmethod text-style-descent ((text-style text-style) (stream encapsulating-stream-mixin))
  (text-style-descent text-style (slot-value stream 'stream)))

(defmethod text-style-fixed-width-p ((text-style text-style) (stream encapsulating-stream-mixin))
  (text-style-fixed-width-p text-style (slot-value stream 'stream)))

(defmethod text-size ((stream encapsulating-stream-mixin) string
		      &key (text-style (stream-merged-text-style stream)) (start 0) end)
  (text-size stream string :text-style text-style :start start :end end))
