;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10; Lowercase: Yes -*-

(in-package "CLIM-INTERNALS")

"Copyright (c) 1988, 1989, 1990 International Lisp Associates.  All rights reserved."

;;; What about original self problem??


#-Silica
(progn
;;; Entity protocol
(define-stream-protocol entity-protocol )

(defoperation entity-position entity-protocol ((entity entity-protocol)))

(defoperation entity-set-position entity-protocol
  ((entity entity-protocol) new-x new-y))

(defoperation entity-edges entity-protocol ((entity entity-protocol)))

(defoperation entity-set-edges entity-protocol
  ((entity entity-protocol) new-left new-top new-right new-bottom))
)
#+Silica
(progn
;;; Region protocol
(define-stream-protocol region-protocol)

(defoperation bounding-rectangle* region-protocol ((region region-protocol)))

)

 
;;; Fundamental input --- These should be on fundamental-input-character-stream??
(define-stream-protocol fundamental-input-stream )

(defoperation stream-read-char fundamental-input-stream ((stream fundamental-input-stream)))

(defoperation stream-unread-char fundamental-input-stream
  ((stream fundamental-input-stream) character))

(defoperation stream-read-char-no-hang fundamental-input-stream
  ((stream fundamental-input-stream)))

(defoperation stream-peek-char fundamental-input-stream
  ((stream fundamental-input-stream)))

(defoperation stream-listen fundamental-input-stream ((stream fundamental-input-stream)))

(defoperation stream-read-line fundamental-input-stream ((stream fundamental-input-stream)))

(defoperation stream-clear-input fundamental-input-stream ((stream fundamental-input-stream)))


;;; Extended input
(define-stream-protocol basic-extended-input-protocol
  stream-input-buffer
  stream-pointers
  stream-primary-pointer
  ;; I don't know if this really belongs, but you might ask this of
  ;; a stream that has input editing on.  -York 7/18/90
  stream-text-cursor

  stream-default-view ;; --- added  12/4/92 doughty
  )

(defoperation stream-read-gesture basic-extended-input-protocol
  ((stream basic-extended-input-protocol)
   &key timeout peek-p
   (input-wait-test *input-wait-test*)
   (input-wait-handler *input-wait-handler*)
   (pointer-button-press-handler *pointer-button-press-handler*)))

(defoperation receive-gesture basic-extended-input-protocol 
  ((stream basic-extended-input-protocol)
   gesture))

(defoperation stream-unread-gesture basic-extended-input-protocol
  ((stream basic-extended-input-protocol) gesture))

;;; Extended Input
(defoperation stream-input-wait basic-extended-input-protocol 
  ((stream basic-extended-input-protocol)
   &key timeout input-wait-test))

(defoperation stream-pointer-position* basic-extended-input-protocol
  ((stream basic-extended-input-protocol) &key (timeout 0) pointer))

(defoperation stream-set-pointer-position* basic-extended-input-protocol
  ((stream basic-extended-input-protocol) x y &key pointer))

(defoperation stream-note-pointer-button-press basic-extended-input-protocol
  ((stream basic-extended-input-protocol) pointer button shift-mask x y))

(defoperation stream-pointer-input-rectangle* basic-extended-input-protocol
  ((stream basic-extended-input-protocol) pointer &key min-x min-y max-x max-y))

(defoperation accept-1 basic-extended-input-protocol
  ((stream basic-extended-input-protocol) presentation-type
   &key prompt default query-identifier))

(defoperation prompt-for-accept basic-extended-input-protocol
  ((stream basic-extended-input-protocol)
   prompt
   &key default query-identifier presentation-type))

#+Ignore
(defoperation parse-error-generic basic-extended-input-protocol
  ((stream basic-extended-input-protocol) format-string &rest format-args))


;;; Output

;;; Fundamental output
(define-stream-protocol fundamental-output-stream )
(define-stream-protocol fundamental-character-output-stream )

;;; This is not responsible for wrapping text.
(defoperation stream-write-char fundamental-character-output-stream 
  ((stream fundamental-character-output-stream) char))

(defoperation stream-write-string fundamental-character-output-stream
  ((stream fundamental-character-output-stream) string &optional (start 0) end))

(defoperation stream-terpri fundamental-character-output-stream
  ((stream fundamental-character-output-stream)))

(defoperation stream-fresh-line fundamental-character-output-stream
  ((stream fundamental-character-output-stream)))

(defoperation stream-force-output fundamental-output-stream
  ((stream fundamental-output-stream)))

(defoperation stream-finish-output fundamental-output-stream
  ((stream fundamental-output-stream)))

;;; --- An extra GF in the stream protocol
#+(and :clim-uses-lisp-streams :allegro-v4.0)
(defoperation excl::stream-interactive-force-output fundamental-output-stream
	      ((stream fundamental-output-stream)))

#+ignore ;;; Compile this out of the buffer if you need it.
(defmethod excl::stream-interactive-force-output ((stream encapsulating-stream-mixin))
  (stream-force-output stream))


(defoperation stream-clear-output fundamental-output-stream
  ((stream fundamental-output-stream)))

(defoperation stream-line-column fundamental-output-stream
	      ((stream fundamental-output-stream)))

(defoperation stream-start-line-p fundamental-output-stream
	      ((stream fundamental-output-stream)))

(define-stream-protocol basic-extended-output-protocol
  stream-end-of-line-action
  stream-end-of-page-action
  stream-text-margin)

(defoperation stream-cursor-position* basic-extended-output-protocol
  ((stream basic-extended-output-protocol)))

(defoperation stream-set-cursor-position* basic-extended-output-protocol
  ((stream basic-extended-output-protocol) x y))

(defoperation stream-advance-cursor-x basic-extended-output-protocol
  ((stream basic-extended-output-protocol) amount))

(defoperation stream-advance-cursor-line basic-extended-output-protocol
  ((stream basic-extended-output-protocol)))

(defoperation stream-string-width basic-extended-output-protocol
  ((stream basic-extended-output-protocol) string &key (start 0) end text-style))

(defoperation stream-character-width basic-extended-output-protocol
  ((stream basic-extended-output-protocol) character &optional text-style))

(defoperation stream-line-height basic-extended-output-protocol
  ((stream basic-extended-output-protocol) &optional text-style))

(defoperation formatting-cell-internal basic-extended-output-protocol
  ((stream basic-extended-output-protocol) continuation
   &key (align-x :left) (align-y :top) (record-type 'cell-output-record)))

;; not sure this is the right place...
(defoperation incremental-redisplay basic-extended-output-protocol
  ((stream basic-extended-output-protocol)
   position #+Ignore position-x #+Ignore position-y erases moves draws erase-overlapping move-overlapping))

(defoperation decode-stream-for-writing basic-extended-output-protocol
  ((stream basic-extended-output-protocol) &optional brief-p))

(defoperation stream-scan-string-for-writing basic-extended-output-protocol
  ((stream basic-extended-output-protocol)
   #+Silica medium string start end style cursor-x max-x &optional glyph-buffer))

(defoperation stream-output-glyph-buffer basic-extended-output-protocol
  ((stream basic-extended-output-protocol)))

;;; Is this really an output operation?
(defoperation stream-ensure-cursor-visible basic-extended-output-protocol
  ((stream basic-extended-output-protocol) &optional cx cy))


;;; Window protocol

#+Silica
(define-stream-protocol window-mixin)

#-Silica
(define-stream-protocol window-mixin
  window-parent
  window-children
  window-console
  window-name
  window-depth
  window-viewport
  window-update-region
  window-visibility
  window-label)

#-Silica
(defoperation window-erase-viewport window-mixin ((window window-mixin)))
#-Silica
(defoperation window-set-visibility window-mixin ((window window-mixin) visibility))
#-Silica
(defoperation window-stack-on-top window-mixin ((window window-mixin)))
#-Silica
(defoperation window-stack-on-bottom window-mixin ((window window-mixin)))
#-Silica
(defoperation copy-area-internal window-mixin ((window window-mixin)
					       from-left from-top from-right from-bottom
					       to-left to-top))
(defoperation window-clear window-mixin ((window window-mixin)))
#-Silica
(defoperation window-refresh window-mixin ((window window-mixin)))
#-Silica
(defoperation window-expose window-mixin ((window window-mixin)))

#-Silica
(defoperation window-viewport-position window-mixin ((window window-mixin)))
#-Silica
(defoperation window-set-viewport-position window-mixin
  ((window window-mixin) x y))

#-Silica
(defoperation window-set-viewport-position-pt window-mixin ((window window-mixin) point))

#-Silica
(defoperation redisplay-decorations window-mixin ((window window-mixin)) )

#-Silica
(defoperation window-to-screen-coordinates window-mixin ((window window-mixin) x y))

#-Silica
(defoperation screen-to-window-coordinates window-mixin ((window window-mixin) x y))

#-Silica
(defoperation window-inside-edges window-mixin ((window window-mixin)))

#-Silica
(defoperation window-inside-size window-mixin ((window window-mixin)))

#-Silica
(defoperation window-set-inside-edges window-mixin ((window window-mixin) 
						    new-left new-top new-right new-bottom))

#-Silica
(defoperation window-set-inside-size window-mixin ((window window-mixin) new-width new-height))

#-Silica
(defoperation window-inside-left window-mixin ((window window-mixin)))
#-Silica
(defoperation window-inside-top window-mixin ((window window-mixin)))
#-Silica
(defoperation window-inside-right window-mixin ((window window-mixin)))
#-Silica
(defoperation window-inside-bottom window-mixin ((window window-mixin)))
#-Silica
(defoperation window-inside-width window-mixin ((window window-mixin)))
#-Silica
(defoperation window-inside-height window-mixin ((window window-mixin)))

#-Silica
(defoperation window-label-size window-mixin ((window-mixin window-mixin)
					      &optional (label (window-label window-mixin))))

#-Silica
(defoperation window-note-size-or-position-change window-mixin
  ((window window-mixin) new-left new-top new-right new-bottom))

#-Silica
(defoperation window-shift-visible-region window-mixin
  ((window window-mixin) 
   old-left old-top old-right old-bottom
   new-left new-top new-right new-bottom))

#-Silica
(defoperation window-flush-update-region window-mixin ((window window-mixin)))
#-Silica
(defoperation window-process-update-region window-mixin ((window window-mixin)))

#-Silica
(defoperation window-beep window-mixin ((window window-mixin)))

;;; What shift keys are presently down?
#-Silica
(defoperation window-shift-mask window-mixin ((window window-mixin)))


;;; Output recording.
(define-stream-protocol basic-output-recording
  stream-draw-p stream-record-p
  output-recording-stream-output-record output-recording-stream-highlighted-presentation
  stream-redisplaying-p
  output-recording-stream-current-output-record-stack
  output-recording-stream-output-record-absolute-position
  output-recording-stream-redisplay-output-record
  )

(defoperation add-output-record basic-output-recording
  ((stream basic-output-recording) element))

(defoperation output-recording-stream-replay-internal basic-output-recording
  ((stream basic-output-recording) &optional bounding-rectangle (x-offset 0) (y-offset 0)))

#+Ignore
(defoperation output-recording-stream-replay-inside-region
	      basic-output-recording
  ((stream basic-output-recording) region))

(defoperation with-output-recording-options-internal
	      basic-output-recording
  ((stream basic-output-recording) draw-p record-p continuation))

(defoperation close-current-text-output-record basic-output-recording
  ((stream basic-output-recording) &optional wrapped))

;;;
;;; Graphics protocol is in defs-graphics-generics
;;; Interactive protocol doesn't need to be encapsulated, for obvious reasons.

;;; "Implementation" protocol
(define-stream-protocol implementation-protocol)

(defoperation implementation-pixels-per-point implementation-protocol
  ((stream implementation-protocol)))


#+Silica
(define-stream-protocol pane-protocol)

#+Silica
(defoperation pane-display-function pane-protocol
  ((pane pane-protocol)))

#+Silica
(defoperation pane-display-time pane-protocol
  ((pane pane-protocol)))

#+Silica
(defoperation pane-needs-redisplay pane-protocol
  ((pane pane-protocol)))

#+Silica
(defoperation pane-frame pane-protocol
  ((pane pane-protocol)))

#+Silica
(defoperation update-region pane-protocol
  ((pane pane-protocol) width height &key &allow-other-keys))


#+Silica
(define-stream-protocol sheet-protocol)

#+Silica
(defoperation port sheet-protocol ((sheet sheet-protocol)))

#+Silica
(defoperation sheet-medium sheet-protocol ((sheet sheet-protocol)))
