;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10; Lowercase: Yes -*-

(in-package "CLIM-INTERNALS")

"Copyright (c) 1988, 1989, 1990 International Lisp Associates.  All rights reserved."


;;; Output recording.
(clim-stream::define-stream-protocol basic-output-recording
    stream-draw-p stream-record-p
    stream-redisplaying-p
    output-recording-stream-output-record 
    output-recording-stream-highlighted-presentation
    output-recording-stream-current-output-record-stack
    output-recording-stream-output-record-absolute-position
    output-recording-stream-redisplay-output-record
    )

(defoperation add-output-record basic-output-recording
  ((stream basic-output-recording) element))

(defoperation output-recording-stream-replay-internal basic-output-recording
  ((stream basic-output-recording)
   &optional bounding-rectangle (x-offset 0) (y-offset 0)))

(defoperation with-output-recording-options-internal basic-output-recording
  ((stream basic-output-recording) draw-p record-p continuation))

(defoperation close-current-text-output-record basic-output-recording
  ((stream basic-output-recording) &optional wrapped))
