;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10; Lowercase: Yes -*-

(in-package "CLIM-INTERNALS")

"Copyright (c) 1988, 1989, 1990 International Lisp Associates.  All rights reserved."

;;; This class exists solely to define the output-recording-stream-p method.
;;; Mix this into all output-recording-stream classes.
(defclass fundamental-output-recording ()
    ())

(clim-stream::define-protocol-p-method output-recording-stream-p
    fundamental-output-recording)

;;; This class exists solely to define the stream-redisplayable-p method.
;;; Mix this into all output-recording-stream classes.

(defclass fundamental-redisplayable-output ()
     ()
  )

(clim-stream::define-protocol-p-method stream-redisplayable-p
    fundamental-redisplayable-output)


;;; The initialize-instance method for this class is in output-recording
(defclass basic-output-recording
	 (fundamental-output-recording fundamental-redisplayable-output)
     ((draw-p :initarg :draw-p :accessor stream-draw-p)
      (record-p :initarg :record-p :accessor stream-record-p)
      (redisplaying-p :accessor stream-redisplaying-p :initform nil)
      (output-record :accessor output-recording-stream-output-record
		     :initarg :output-record)
      ;; --- this is called a stack at present although
      ;; --- it's really just a location that gets LETF'd.
      (current-output-record-stack
	:initform nil :accessor output-recording-stream-current-output-record-stack)
      (output-record-absolute-position ;; a hint
	:accessor output-recording-stream-output-record-absolute-position
	:initform (make-point 0 0))
      (redisplay-output-record
	:accessor output-recording-stream-redisplay-output-record
	:initform nil)
      ;; output record for items in the margins (e.g., scroll bars)
      ;; --- is this still necessary? 12/23/91 doughty
      #-Silica
      (marginal-output-record :initform (make-instance 'coordinate-sorted-set-output-record))
      (text-output-record-element :initform nil 
				  :accessor output-recording-stream-text-output-record)
      (highlighted-presentation :initform nil
				:accessor output-recording-stream-highlighted-presentation))
  (:default-initargs :draw-p t
		     :record-p t	;!!!
		     :output-record (make-instance 'top-level-coordinate-sorted-set)
		     )
  )

;;; Exists to hang window&graphics whoppers on.
(defclass graphics-output-recording ()
     ()
  )




