;;; -*- Mode: Lisp; Package: CLIM-INTERNALS; Base: 10.; Syntax: Common-Lisp -*-
;;;
;;;

;;; Printer streams: they have normal extended stream properties, but are not panes.

"Copyright (c) 1991 by International Lisp Associates.  All Rights Reserved."

(in-package "CLIM-INTERNALS")

;;; This stuff actually belongs in Silica...

(defclass mute-child-part (child-part mirrored-sheet-mixin
				      w::dtcr-mixin
				      sheet-rectangle-translation-mixin
				      enabled-slot-mixin)
    ())

(defmethod sheet-parent ((child mute-child-part))
  nil)

(defmethod adopt-child ((parent mute-child-part) child &key)
  (declare (ignore child))
  (error "Cannot adopt any children below ~S" parent))

(defmethod disown-child ((parent mute-child-part) child &key)
  (declare (ignore child))
  (error "Cannot disown any children below ~S" parent))


(define-windowing-contract printer-windowing-contract ()
    ()
  (:contract-name "printing")
  (:parent-part w::mute-parent-part)
  (:child-part mute-child-part))

(define-sheet-class printer-sheet () ()
  (:adult-contract-class printer-windowing-contract)
  (:youth-contract-class printer-windowing-contract))

(defclass printer-stream (pane-extended-stream-mixin	;; Truly awful name

;;; I don't know why the above is needed instead of the following, but it is.
;;; Text doesn't come out right unless you do it.

			   ;; graphics-output-recording
			   ;; sheet-output-recording
			   ;; basic-output-recording
			   ;; output-protocol-mixin
			   printer-sheet)
    ((document-title :reader w::printer-document-title :initform nil :initarg :title))
  (:default-initargs :native-transformation +identity-transformation+
		     :medium :clim))

;;; Should there (also) be a SHEET-REGION-CHANGED method (instead of this one)?
(defmethod initialize-instance :after ((stream printer-stream) &key port)
  (setf (sheet-transformation stream) +identity-transformation+
	(port stream) port
	(stream-default-text-margin stream)
	  (multiple-value-bind (left top right bottom)
	      (mirror-inside-region* port stream)
	    (declare (ignore top bottom))
	    (- right left))))

(defmethod window-clear :before ((window printer-stream))
  (show-page window))

(defmethod show-page ((window printer-stream))
  (show-page (sheet-medium window)))

(defmethod stream-update-region ((stream printer-stream) width height &key)
  (declare (ignore width height)))

(defmethod stream-ensure-cursor-visible ((stream printer-stream) &optional cx cy)
  (declare (ignore cx cy)))

;;; Probably want a "Mute pane" mixin...
(defmethod pane-frame ((stream printer-stream))
  nil)

(defmethod pane-viewport ((stream printer-stream))
  nil)

(defmethod pane-scroller ((stream printer-stream))
  nil)

(defmethod ws::scroll-to ((stream printer-stream) place)
  (declare (ignore place))
  nil)

(defmethod frame-repaint-pane ((frame null) stream
			       &optional bounding-rectangle (x-offset 0) (y-offset 0))
  (output-recording-stream-replay-internal stream bounding-rectangle x-offset y-offset))

(defun make-printer-stream (&key (server-path '(:postscript)) title)
  (let* ((port (find-port :server-path server-path))
	 (printer-stream (make-instance 'printer-stream :port port :title title)))
    ;; --- Will a printer stream always have a medium by now???
    ;; It's safe to do this now.  We need to really figure this out
    ;; before shipping the new, improved Silica.
    (update-native-transformation port printer-stream)
    printer-stream))

(defmethod close ((printer-stream printer-stream) &key abort)
  (close-printer-medium (sheet-medium printer-stream) :abort abort))
