;;; -*- Mode: LISP; Syntax: Common-Lisp; Base: 10; Package: USER -*-

(in-package #-ccl-2 "USER" #+ccl-2 "CL-USER")

"Copyright (c) 1990 International Lisp Associates.  All rights reserved."

;;; Now we define the CLIM-INTERNALS package.

#-(and ccl (not ccl-2)) ; moved to pre-pkgdcl.lisp
(eval-when (compile load eval)
(clim-lisp:defpackage CLIM-INTERNALS
  (:nicknames "CI")						; for debugging ease
  (:use	CLIM-LISP CLIM-UTILS CLIM CLIM-SHARED CLIM-STREAM)

  (:export *clim-package* *clim-internals-package*)

  (:shadowing-import-from CLIM-UTILS
   DEFMETHOD DEFUN FLET LABELS DYNAMIC-EXTENT NON-DYNAMIC-EXTENT)

  ))

;;; This is here to put a distinct "break" in the bin file, so that the
;;; package will actually be defined by the time the DEFVAR's below are
;;; loaded.  -RSL, on advice from JDI, 7/17/90
#+(or excl ccl)
(defun #:random-function-to-break-thing-up ())

(defvar clim-internals:*clim-package* (find-package 'clim))
(defvar clim-internals:*clim-internals-package* (find-package 'clim-internals))

(defmacro clim:define-clim-package (name &rest options)
  (let ((new-options nil)
	(use-list '(CLIM CLIM-LISP)))
    (dolist (option options)
      (if (or (atom option) (not (eql (first option) ':use)))
	  (push option new-options)
	  (setf use-list (append use-list (cdr option)))))
    `(clim-lisp:defpackage ,name
       (:use ,@use-list)
       ,@(nreverse new-options))))

(clim:define-clim-package clim-demo)
(clim:define-clim-package clim-user)
