;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10 -*-

(in-package "CLIM-INTERNALS")

"Copyright (c) 1988, 1989, 1990 International Lisp Associates.  All rights reserved."

;;; Yay!
(defmacro dragging-output ((&optional stream) &body body)
  (default-output-stream stream)
  `(flet ((dragging-output (,stream)
	    ,@body))
     (declare (dynamic-extent #'dragging-output))
     (dragging-output-1 ,stream #'dragging-output)))

#+Silica
(defun entity-center (entity)
  (multiple-value-bind (left top right bottom)
      (entity-edges entity)
    (values (floor (+ left right) 2)
	    (floor (+ top bottom) 2))))

(defun dragging-output-1 (stream continuation)
  (declare (dynamic-extent continuation))
  (let ((output-record (with-output-to-output-record (stream)
			 (funcall continuation stream))))
    (multiple-value-bind (x-off y-off)
	(entity-center output-record)
      (multiple-value-bind (x-start y-start)
	  (entity-position output-record)
	(setq x-off (- x-off x-start) y-off (- y-off y-start)))
      ;; entity-center might reasonably return a rational, but we have to pass
      ;; integers as the offsets to REPLAY ('cause they will eventually figure into
      ;; CLX coordinate calculations)
      (setq x-off (round x-off)
	    y-off (round y-off))
      (with-output-recording-options (stream :record-p nil :draw-p t)
	(let (old-x old-y)
	  (block track
	    (tracking-pointer #-Silica ((stream-primary-pointer stream))
			      #+Silica (stream)
	      (:pointer-motion (#-Silica window #+Silica sheet x y)
	       (when old-x
		 (replay output-record stream))
	       (when (eql #-Silica window #+Silica sheet stream)
		 (setq old-x x old-y y)
		 (output-record-set-position* output-record (- x x-off) (- y y-off))
		 (replay output-record stream)))
	      #-Silica
	      (:pointer-button-press (action)
	       (when old-x (replay output-record stream))
	       (return-from track (values (pointer-button-press-action-x action)
					  (pointer-button-press-action-y action))))
	      #+Silica
	      (:button-release ()
	       (when old-x (replay output-record stream))
	       (return-from track (values old-x old-y))))))))))

#||
()

(defun test-dragging-output (stream)
  (window-clear stream)
  (window-expose stream)
  (format stream "Click somewhere")
  (terpri stream)
  (force-output stream)
  (read-gesture :stream stream)					;wait for click
  (dragging-output (stream)
    (draw-rectangle* stream 0 0 20 20 :filled nil :ink +flipping-ink+)
    (draw-circle* stream 30 30 10 :filled T :ink +flipping-ink+)))

||#
