;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10; Lowercase: Yes -*-

(in-package "CLIM-INTERNALS")

"Copyright (c) 1988, 1989, 1990  International Lisp Associates.  All rights reserved."

;;; Testing the CP.  Eventually this should be extracted into a separate file.
(defun cp-test (stream &optional (command-parser #'command-line-command-parser))
  (window-clear stream)
  (let ((*command-table* 'test-cp))
    (let ((*standard-output* stream))
      (com-show-some-commands))
    ;; initially, just in case there's random stuff lying around.
    (stream-clear-input stream)
    #-Silica
    (window-expose stream)
    ;; ---This sheet's youth contract doesn't support enabling??
    ;; (enable-sheet stream)
    (unwind-protect
	(catch 'exit-cp
	  (progn						; with-input-focus (stream)
	    (let ((count 0))
	      (loop
		(with-simple-abort-restart ("Return to CP-TEST top level")
		  (let ((command (read-command :stream stream
					       :command-parser command-parser
					       :prompt (format nil
							       "Command ~D: " (incf count)))))
		    (fresh-line stream)
		    (let ((command-function (pop command))
			  (command-args command))
		      (let ((*standard-output* stream))
			(apply command-function command-args)))))))))
      #-Silica
      (setf (window-visibility stream) nil)
;    (disable-sheet stream)
      )))

(define-command-table test-cp)

;;; We have to have some shorthand for this.
(add-command-to-command-table "Show File" 'com-show-file 'test-cp)
(add-command-to-command-table "Show Text" 'com-show-text 'test-cp)
(add-command-to-command-table "Show Directory" 'com-show-directory 'test-cp)
(add-command-to-command-table "Show Some Commands" 'com-show-some-commands 'test-cp)
(add-command-to-command-table "Copy File" 'com-copy-file 'test-cp)
(add-command-to-command-table "Hardcopy File" 'com-hardcopy-file 'test-cp)
(add-command-to-command-table "Show Homedir" 'com-show-homedir 'test-cp)
(add-command-to-command-table "Print File Name" 'com-print-file-name 'test-cp)
(add-command-to-command-table "Quit" 'com-quit 'test-cp)

(define-command com-show-file
    ((pathname 'pathname :translator-gesture :left :prompt "file"))
   (show-file pathname))

(define-command com-show-directory
    ((directory 'pathname :prompt "file"))
   (show-directory directory))

(define-command com-show-some-commands
    ()
   (formatting-table ()
     (formatting-row ()
       (formatting-cell ()
	 (present `(com-show-file ,(merge-pathnames "foobar.txt" (user-homedir-pathname)))
		  'command)))
     (formatting-row ()
       (formatting-cell ()
	 (present `(com-show-directory ,(merge-pathnames "*.lisp" (user-homedir-pathname)))
		  'command)))
     (formatting-row ()
       (formatting-cell ()
	 (present `(com-copy-file ,(merge-pathnames "www.xxx" (user-homedir-pathname))
				  ,(merge-pathnames "xxx.yyy" (user-homedir-pathname)))
		  'command)))
     (formatting-row ()
       (formatting-cell ()
	 (present '(com-quit) 'command)))
     ))

(define-command com-copy-file
    ((from-file 'pathname :prompt "from file")
     (to-file 'pathname :default from-file :prompt "to file"))
   (write-string "Would rename ")
   (present from-file 'pathname)
   (write-string " to ")
   (present to-file 'pathname)
   (write-string ".")
   )

(define-presentation-type printer ()
  :parser ((stream &rest args)
	   (declare (dynamic-extent args)
		    (ignore args))
	   (completing-from-suggestions (stream)
	     (suggest "Vermicelli" 'vermicelli)))
  :printer ((object stream &key acceptably)
	    (declare (ignore acceptably))
	    (format stream "~@(~A~)" object)))

(define-command com-hardcopy-file
    ((file 'pathname :translator-gesture :middle)
     (printer 'printer :translator-gesture :left))
   (format t "Would hardcopy ")
   (present file 'pathname)
   (format t " on ")
   (present printer 'printer))

(define-command com-quit
    ()
   (throw 'exit-cp t))

(define-command com-print-file-name
    ((file 'pathname :translator-gesture :middle))
   (format t "The file name was ")
   (present file 'pathname))

(defun show-directory (&optional pathname)
  (let* ((path (or pathname (accept 'pathname :prompt "Pathname: ")))
	 (paths (directory path)))
    (dolist (p paths)
      (with-output-as-presentation (:object p
				    :type 'pathname
				    :stream *standard-output*)
	(write-string (format nil "~A" p))
	(write-char #\Newline)))))

(defun show-file (&optional pathname)
  (let ((path (or pathname (accept 'pathname))))
    (show-file-contents path *standard-output*)))

;;; I can't believe CL doesn't have this
(defun show-file-contents (path stream)
  (with-temporary-string (line-buffer :length 100)
    ;; protect against "wildcard not allowed" errors in Genera
    (with-open-file (f path :if-does-not-exist nil
		       #+Genera :error #+Genera nil)
      (when (and f #+Genera (not (scl:errorp f)))
	(loop
	  (let ((ch (read-char f nil 'eof)))
	    (case ch
	      (eof
		(return-from show-file-contents))
	      (#\return
	       (write-string line-buffer stream)
	       (write-char #\Newline stream)
	       (setf (fill-pointer line-buffer) 0))
	      (otherwise
		(vector-push-extend ch line-buffer)))))))))

(define-command com-show-homedir
    ()
   (show-directory (make-pathname :defaults (user-homedir-pathname)
				  :name :wild
				  :type :wild)))

(define-command com-show-text
    ()
  (dotimes (n 20)
    (format t "This is one of the lines, namely line ~D" n)
    (terpri)))