;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10 -*-

;;; This file might want to be in the ON-X package. --- rsl

(in-package "CLIM-INTERNALS")

"Copyright (c) 1989, 1990, 1991 International Lisp Associates.  All rights reserved."

;;; Character-drawing methods for CLX implementation

(defmacro with-X-stream-glyph-for-character (&body body)
  `(macrolet ((stream-glyph-for-character (medium character appearance &optional our-font)
		`(multiple-value-bind (character-set index)
		     (char-character-set-and-index ,character)
		   (when (eql character-set *standard-character-set*)
		     ;; A little gross, but right, I think:
		     (setf index (xlib::char->card8 ,character)))
		   (let* ((x-font (or ,our-font
				      ;;--- Need some portable function to call
				      (realize-text-style (port ,medium) ,appearance)
				      #+ignore
				      (text-style-mapping (port ,medium)
							  character-set ,appearance)))
			  (escapement-x (xlib:char-width x-font index))
			  (escapement-y 0)
			  (origin-x 0)
			  (origin-y (xlib:font-ascent x-font))
			  (bb-x escapement-x)
			  (bb-y (+ origin-y (xlib:font-descent x-font))))
		     (values index x-font escapement-x escapement-y
			     origin-x origin-y bb-x bb-y)))))
     ,@body))

(defmethod stream-glyph-for-character ((medium on-x::basic-x-medium) character appearance &optional our-font)
  #+Genera
  (declare (values index font escapement-x escapement-y origin-x origin-y bb-x bb-y))
  (with-X-stream-glyph-for-character
    (stream-glyph-for-character medium character appearance our-font)))

(defmethod stream-scan-string-for-writing  ((stream output-protocol-mixin)
					    (medium on-x::basic-x-medium)
					    string start end
					    style cursor-x max-x
					    &optional glyph-buffer)
  #+Genera (declare
	     (values write-char next-char-index new-cursor-x new-baseline new-height font))
  (with-x-stream-glyph-for-character
    (stream-scan-string-for-writing-body)))

;;; --- For now we need stub version of this.
(defmethod clx-lookup-color ((medium on-x::basic-x-medium) color)
  (with-slots (on-x::x-screen) (port medium)
    (cond ((eql color *white*) (xlib:screen-white-pixel on-x::x-screen))
	  ((eql color *black*) (xlib:screen-black-pixel on-x::x-screen))
	  (t (error "Only :BLACK and :WHITE for now.")
	     #+ignore
	     (or (gethash color color-table)
		 (setf (gethash color color-table)
		       (xlib:alloc-color (xlib:screen-default-colormap screen) color)))))))


;;; Debugging aid
(defvar *clx-force-output* nil)

;;;--- These can be replaced with calls to silica:draw-text, etc.

;;; --- This is obsolete now, I think. --- rsl
#-Silica
(defmethod stream-write-char-internal ((medium on-x::basic-x-medium) index x-font color x y)
  (with-slots (on-x::drawable on-x::gcontext) medium
    (xlib:with-gcontext (on-x::gcontext :function boole-1
					:foreground (clx-lookup-color medium color)
					:font x-font)
      ;; Move line down so that the top of the character (not the baseline) is at Y.
      (xlib:draw-glyph on-x::drawable on-x::gcontext x (+ y (xlib:font-ascent x-font)) index)
      (when *clx-force-output*
	(xlib:display-force-output (xlib:window-display on-x::drawable))))))

#-Silica
;;; --- Doesn't CLX have a default translation function that does this?
;;; Too bad we have to copy the glyphs again, but that's life...
(defun noop-translate-function (src src-start src-end font dst dst-start)
  #+Genera (declare (values ending-index horizontal-motion width))
  (ignore font)
  (replace dst src :start1 dst-start :start2 src-start :end2 src-end)
  (values src-end nil nil))

#-Silica
(defmethod stream-write-string-internal ((medium on-x::basic-x-medium)
					 glyph-buffer start end x-font color x y)
  (setq x (floor x) y (floor y))
  (with-slots (on-x::gcontext) medium
    (let ((size (if (find-if #'(lambda (x) (> x 255.)) glyph-buffer :start start :end end)
		    16 :default)))
      (xlib:with-gcontext (on-x::gcontext :function boole-1
					  :foreground (clx-lookup-color medium color)
					  :font x-font)
	;; Move line down so that the top of the characters (not the baseline) is at Y.
	(xlib:draw-glyphs (on-x::drawable medium) on-x::gcontext x (+ y (xlib:font-ascent x-font)) glyph-buffer
			  :start start :end end :translate #'noop-translate-function
			  :size size))
      (when *clx-force-output*
	(xlib:display-force-output (xlib:drawable-display (on-x::drawable medium)))))))

