;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10 -*-

;;; This file contains stuff that helps Silica and CLIM join together.
;;; Some of it will go away as various modules that have implementations
;;; on both sides are consolidated.

;;; No generic for edges on a silica:region, so use rectangle
;;; --- unify and/or replace entity protocol with Silica objects

(in-package "CLIM-INTERNALS")

"Copyright (c) 1990 by International Lisp Associates, Inc.  All rights reserved."

;;; Temporary bridge between old "entity protocol" and new Silica
;;; "region protocol".  These functions all forward to the region stuff.

#+ignore
(defmethod entity-edges-generic ((entity standard-rectangle))
  (values (rectangle-min-x entity)
	  (rectangle-min-y entity)
	  (rectangle-max-x entity)
	  (rectangle-max-y entity)))

(defmacro drawing-in-margin ((stream) &body body)
  (declare (ignore stream))
  `(progn
     (cerror "Continue executing body"
	     "Attempt to use drawing-in-margin, an obsolete CLIM crock")
     ,@body))

;;; These are all here so that we can share source files with the non-Silica version
;;; of CLIM.  In other words, I don't want to have to global-replace entity-foo with
;;; region-foo and then have to fork all those source files in the "PTK" dir.

(defun entity-edges (entity)
  (bounding-rectangle* entity))

(defun entity-set-edges (entity nl nt nr nb)
  (bounding-rectangle-set-edges entity nl nt nr nb))

(defun entity-position (entity &key (return ':multiple))
  (assert (eql return ':multiple)
	  (return)
	  "Only the multiple-value form of entity-position is supported")
  (bounding-rectangle* entity))

(defun entity-set-position (entity nx ny)
  #+cant-use-until-resolving-the-generic-region-mutating-protocol
  (setf* (bounding-rectangle-position* entity) 
	 (values nx ny ))
  ;; In the meanwhile all things that want to can support the one
  ;; setf method on bounding-rectangle*.
  (multiple-value-bind (left top right bottom) (bounding-rectangle* entity)
    (let ((width (- right left))
	  (height (- bottom top)))
      (bounding-rectangle-set-edges entity nx ny (+ nx width) (+ ny height)))))

(defun entity-shift-position (entity dx dy)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (bounding-rectangle-set-edges 
      entity (+ left dx) (+ top dy) (+ right dx) (+ bottom dy))))

(defun entity-position-difference* (x1 y1 x2 y2)
  (values (- x1 x2) (- y1 y2)))

(defun entity-position-difference (entity1 entity2)
  (multiple-value-bind (x1 y1)
      (entity-position entity1)
    (multiple-value-bind (x2 y2)
	(entity-position entity2)
      (entity-position-difference* x1 y1 x2 y2))))

(defun entity-left (entity)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (progn left top right bottom)
    left))

(defun entity-top (entity)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (progn left top right bottom)
    top))

(defun entity-right (entity)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (progn left top right bottom)
    right))

(defun entity-bottom (entity)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (progn left top right bottom)
    bottom))

(defun entity-left-top (entity)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (progn left top right bottom)
    (values left top)))

(defun entity-bottom-right (entity)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (progn left top right bottom)
    (values right bottom)))

(defun entity-size (entity)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (progn left top right bottom)
    (values (- right left) (- bottom top))))

(defun entity-set-size (entity nw nh)
  #+cant-use-until-resolving-the-generic-region-mutating-protocol
  (setf* (bounding-rectangle-dimensions entity) 
	 (values nw nh))
  ;; In the meanwhile all things that want to can support the one
  ;; setf method on bounding-rectangle*.
  (multiple-value-bind (left top) (bounding-rectangle* entity)
    (bounding-rectangle-set-edges entity
				  left top (+ left nw) (+ top nh))))

(defun entity-size-equal (e1 e2)
  (multiple-value-bind (w1 h1)
      (entity-size e1)
  (multiple-value-bind (w2 h2)
      (entity-size e2)
    (and (= w1 w2)
	 (= h1 h2)))))

(defun entity-width (entity)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (progn left top right bottom)
    (- right left)))

(defun entity-height (entity)
  (multiple-value-bind (left top right bottom) 
      (bounding-rectangle* entity)
    (progn left top right bottom)
    (- bottom top)))

;;; ---

(defun entity-contains-position-p (entity x y)
  (region-contains-point*-p entity x y))

(defun entity-contains-ltrb-p (entity minx miny maxx maxy)
  ;;; --- don't we support this directly in Silica?
  (and (region-contains-point*-p entity minx miny)
       (region-contains-point*-p entity maxx maxy)))

(defun entity-overlaps-ltrb-p (entity minx miny maxx maxy)
  (multiple-value-bind (eminx eminy emaxx emaxy)
      (bounding-rectangle* entity)
    (ltrb-overlaps-ltrb-p eminx eminy emaxx emaxy
			  minx miny maxx maxy)))

