;;; -*- Mode: LISP; Syntax: Common-lisp; Package: CLIM-INTERNALS; Base: 10 -*-

(in-package "CLIM-INTERNALS")

"Copyright (c) 1989, 1990, 1991 International Lisp Associates.  All rights reserved."

;;; Character-drawing methods for Genera implementation

;;; This algorithm is a paraphrase of the apparent contents of TV:%DRAW-STRING-CLIPPED-INTERNAL
(defmacro with-genera-stream-glyph-for-character (&body body)
  `(macrolet ((stream-glyph-for-character (medium character appearance &optional our-font)
		`(multiple-value-bind (character-set index)
		     (char-character-set-and-index ,character)
		   ;; For now we are asserting that each string passed
		   ;; to WRITE-STRING will have no appearance changes
		   ;; within it.  This is what our-font is all about.
		   (let* ((font (or ,our-font
				    (text-style-mapping
				      (port ,medium) character-set ,appearance)))
			  (FIT (sys:font-indexing-table font))
			  (LKT (sys:font-left-kern-table font))
			  (CWT (sys:font-char-width-table font))
			  (escapement-x (if (diacritic-char-p ,character) 0
					    (if CWT (aref CWT index)
						(sys:font-char-width font))))
			  (escapement-y 0)
			  (origin-x (if LKT (aref LKT index) 0))
			  (origin-y (sys:font-baseline font))
			  (bb-x (if FIT (- (aref FIT (1+ index)) (aref FIT index))
				    (sys:font-char-width font)))
			  (bb-y (sys:font-char-height font)))
		     (values index font escapement-x escapement-y origin-x origin-y
			     bb-x bb-y)))))
     ,@body))

(defmethod stream-glyph-for-character ((medium on-genera::basic-genera-medium)
				       character appearance &optional our-font)
  #+Genera
  (declare (values index font escapement-x escapement-y origin-x origin-y bb-x bb-y))
  (with-genera-stream-glyph-for-character
    (stream-glyph-for-character medium character appearance our-font)))

(defmethod stream-scan-string-for-writing  ((stream output-protocol-mixin)
					    (medium on-genera::basic-genera-medium)
					    string start end
					    style cursor-x max-x
					    &optional glyph-buffer)
  #+Genera (declare
	     (values write-char next-char-index new-cursor-x new-baseline new-height font))
  (with-genera-stream-glyph-for-character
    (stream-scan-string-for-writing-body)))


#-Silica ;; Only called by the methods below, which are no longer in use...
(defmethod sheet-lookup-color-alu ((stream on-genera::basic-genera-medium) color)
  (with-slots (window) stream
    (multiple-value-bind (r g b)
	(ecase color
	  (:red (values 1 0 0))
	  (:green (values 0 1 0))
	  (:blue (values 0 0 1))
	  (:cyan (values 0 1 1))
	  (:magenta (values 1 0 1))
	  (:yellow (values 1 1 0))
	  (:black (values 0 0 0))
	  (:white (values 1 1 1)))
      (let ((screen (tv:sheet-screen window)))
	(if (scl:operation-handled-p screen :compute-rgb-alu)
	    (scl:send screen :compute-rgb-alu boole-1 r g b)
	    (if (< 1.5 (+ r g b))
		;; near black, show nothing
		boole-andc1
	        ;; near white, show something
		boole-ior
		))))))


;;; This isn't exactly a stream operation, since it is really drawing on
;;; the underlying window itself, not the virtual, scrollable window.  I
;;; am not sure what the correct name for this method should be.

;;; --- This is obsolete now, I think. --- rsl
#-Silica
(defmethod stream-write-char-internal ((medium on-genera::basic-genera-medium) index font color x y)
  (let ((window (slot-value medium 'on-genera::drawable))
	 (stream (medium-sheet medium))
	 #+ignore (x (+ x (tv:sheet-left-margin-size window)))
	 #+ignore (y (+ y (tv:sheet-top-margin-size window))))
    ;; There is apparently no way to draw a glyph exactly where you want
    ;; it on a sheet!  Draw it on the screen instead...
    (tv:sheet-is-prepared (window)
      (tv:sheet-draw-glyph index font x y
			   (if (eq color (stream-foreground stream))
			       (tv:sheet-char-aluf window)
			       (sheet-lookup-color-alu color))
			   window))))

#-Silica ;; Obsolete?
;;; This implementation can't deal with 16-bit fonts at all.
(defmethod stream-write-string-internal ((medium on-genera::basic-genera-medium)
					 glyph-buffer start end font color x y)
  (when (<= end start) (return-from stream-write-string-internal))
  (let* ((glyph-buffer glyph-buffer)
	 (index start)
	 (index8 0)
	 (window (slot-value medium 'on-genera::drawable))
	 (stream (medium-sheet medium))
	 #+ignore (x (+ x (tv:sheet-left-margin-size window)))
	 #+ignore (y (+ y (tv:sheet-top-margin-size window))))
    (declare (sys:array-register glyph-buffer))
    (tv:sheet-is-prepared (window)
      (sys:with-stack-array (glyphs8 (- end start) :element-type 'string-char)
	(declare (sys:array-register glyphs8))
	(loop
	  (when (= index end) (return))
	  (setf (aref glyphs8 index8) (code-char (aref glyph-buffer index)))
	  (incf index)
	  (incf index8))
	(tv:sheet-draw-string window
			      (if (eq color (stream-foreground stream))
				  (tv:sheet-char-aluf window)
				  (sheet-lookup-color-alu color))
			      x y glyphs8 font 0 index8
			      (tv:sheet-width window))))))
