
/*  *************************************************************************
    macevt.c -- The Macintosh Event (and miscellaneous) functions code for:

    MacSCM v1.0

    Author: Kevin Scott Kunzelman (kkunzelm@cam.cornell.edu)

    This code is in the public domain.	You can copy it, sell it, modify it,
    all without any restrictions.
    ************************************************************************/


#include <Desk.h>
#include <Events.h>
#include <Controls.h>
#include <Windows.h>
#include <QuickDraw.h>
#include <TextEdit.h>
#include <Menus.h>
#include <Pascal.h>

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <console.h>

#include "scm.h"
#include "macscm.h"
#include "macevt.h"
#include "macqd.h"
#include "version.h"


/*  ************************************************************************/


static Str255 GStr255;
static char ARG6[] = "arg6";
static char ARG7[] = "arg7";
static char ARG8[] = "arg8";
static char ARG9[] = "arg9";

static char GMacScmVersion[] = MAC_SCM_VERSION;


/*  ************************************************************************/


#define RANDSEED(x)	(qd.randSeed = (long) x)
#define EVT_WHAT(t)	((t).what)
#define EVT_MSG(t)	((t).message)
#define EVT_WHEN(t)	((t).when)
#define EVT_WHERE(t)	((t).where)
#define EVT_MODS(t)	((t).modifiers)
#define EVT_ACTIVE(t)	(EVT_MODS(t) & 1)


/*  ************************************************************************/


#define SUBRS(x)							    \
x("mac-scm-version",	mac_scm_version,    _STRING_FUNC,   GMacScmVersion) \
x("console-hide",	console_hide,	    _UNSPEC_FUNC,   chide(stdin))   \
x("console-show",	console_show,	    _UNSPEC_FUNC,   cshow(stdin))   \
x("rand-seed",		rand_seed,	    INT_FUNC,	    RANDSEED)	    \
x("random",		random,		    _INT_FUNC,	    Random)	    \
x("tick-count",		tick_count,	    _INT_FUNC,	    TickCount)	    \
x("get-next-evt",	get_next_evt,	    _EVT_FUNC,	    GetNextEvent)   \
x("evt-avail",		evt_avail,	    _EVT_FUNC,	    EventAvail)	    \
x("evt-get-what",	evt_get_what,	    EVT_INT_FUNC,   EVT_WHAT)	    \
x("evt-get-msg-int",	evt_get_msg_int,    EVT_INT_FUNC,   EVT_MSG)	    \
x("evt-get-msg-wind",	evt_get_msg_wind,   EVT_WIND_FUNC,  EVT_MSG)	    \
x("evt-get-when",	evt_get_when,	    EVT_INT_FUNC,   EVT_WHEN)	    \
x("evt-get-where",	evt_get_where,	    EVT_PT_FUNC,    EVT_WHERE)	    \
x("evt-get-mods",	evt_get_mods,	    EVT_INT_FUNC,   EVT_MODS)	    \
x("evt-get-active",	evt_get_active,	    EVT_BOOL_FUNC,  EVT_ACTIVE)	    \
x("button?",		button,		    _BOOL_FUNC,	    Button)	    \
x("still-down?",	still_down,	    _BOOL_FUNC,	    StillDown)	    \
x("wait-mouse-up?",	wait_mouse_up,	    _BOOL_FUNC,	    WaitMouseUp)    \
x("get-mouse",		get_mouse,	    _PT_FUNC,	    GetMouse)	    \
x("system-click",	system_click,	    EVTWIND_FUNC,   SystemClick)    \


/*  ************************************************************************/


DECLARE_FUNCS(SUBRS, init_mac_evt)


/*  ************************************************************************/
