/*#########################################
 * toplevel.c
 *
 * Top level fns for the FLAKEY controller
 *
 *#########################################
 */

#include <stdio.h>
#include "display.h"
#include "structures.h"
#include "constants.h"
#include "parameters.h"


void process_events();

int debug = 0;
extern int trace_packets;
extern int trace_commands;
int idle_time = 0;		/* total idle time in loop */
extern int num_bcs;
int step_wait = 0;
extern int single_step_mode;


main(argc,argv)			/* starts up Flakey window */
     int argc; char **argv;
{
  init_window(500,400,.06,argc,argv);
  connected = 0;
  while (1)
    {
      step_wait = 0;
      reset_flakey_vars();
      message("No connection");
      while (!connected)
	{
	  process_events();
	  check_connection();
	  draw_flakey();
	  display_buffer();
	  int_time(100);
	}
      message("opening motor controller...");
      flakey.status = STATUS_NO_HIGH_POWER;
      trace_packets = 0;
      trace_commands = 0;
      if (open_motor_controller(1,1) >= 0)
	{ message("Opened"); }
      command_to_flakey_i(POLLING_COM,ALL_ARG);
      reset_procs();
      while(connected)
	{
	  if (!step_wait)
	    {
	      update_and_comm();
	      idle_time += int_time(100);
	    }
	  if (single_step_mode) step_wait = 1;
	  else step_wait = 0;
	  process_events();
	}
    } 
}


char *hostname = NULL;

check_connection()
{
  if (hostname != NULL)
    {
      if (strncmp(hostname,"/dev/tty",8) == 0) /* use tty port here */
	startup_flakey_server(TTYPORT,hostname);
      else
	startup_flakey_server(TCP,hostname);
      if (connected)		/* succeeded */
	{
	  set_disconnect_state();
	}
      hostname = NULL;
    }
}

extern void
test_control_proc(boolean reset);

extern void
test_wall_proc(boolean reset);

reset_procs()			/* here's where we initialize all procedures */
{
  test_control_proc(true);
  test_wall_proc(true);
  side_segment_proc(true);
}


update_and_comm()		/* process robot movements, send commands */
{
  pulse_proc();			/* pulse robot for info */
  process_waiting_packets();
  motor_proc();			/* send motor commands */
  clamp_proc();			/* clamp to local coords */
  sonar_proc();			/* add in new sonar readings */
  wake_proc();			/* check wake stuff */
  side_segment_proc(false);	/* form side sonar segments */
  test_control_proc(false);	/* do control thing */
  test_wall_proc(false);	/* find wall segments */
  draw_proc();
}


pulse_proc()			/* send motor/sonar info pulses */
{
  static int i = 0;
  i++;
  if (i > 9)
    {
      command_to_flakey_i(PULSE_COM,SONAR_ARG | MOTOR_ARG | 0xF00);
      i = 0;
    }
}


draw_proc()			/* draws relevant info */
{
  reset_flakey_matrix();	/* reset the flakey drawing matrix */
  draw_flakey();
  draw_veloc();
  draw_status();
  draw_sonars();
  draw_wake();
  draw_behaviors();
  draw_pointlist();
  draw_segments();
  display_buffer();
}

