/* 
 * depth-buffers.c -- functions for interpreting depth buffers
 * 
 */

#include <stdio.h>

#include "constants.h"
#include "structures.h"
#include "parameters.h"
#include "dispall.h"

dbuf left_side, right_side;	/* buffers for left/right sonar readings */

int ss_infl_thresh = 100;
int ss_medval_gap = 5;
float ss_medval_slope = 1.1;

int ss_gap_fill = 5;
int ss_gap_fill_brk = 6;

int ss_bkpt_gap = 6;
int ss_bkpt_num = 9;

void				/* interprets side sonar buffer */
conv_ss_buf(dbuf *buf,int side)	/* side = 0 for right, 1 for left, -1 for front */
{
  medval(buf->buf,buf->num,ss_medval_gap,ss_medval_slope,SLBUF_NULL);
/*  interpolate_gaps(buf->buf,buf->num, ss_gap_fill, ss_gap_fill_brk); */
  trans_ss_arr(side,buf->buf,buf->xbuf,buf->ybuf);
  find_breaks(buf->buf,buf->edge,buf->num,ss_bkpt_gap,ss_bkpt_num);
  conv(lap_conv_arr,lap_conv_arr_n,buf->buf,buf->lap,buf->num);
  find_inflections(buf->edge,buf->lap,buf->num,ss_infl_thresh);
}

#define SS_XMIN -2000
#define SS_XMAX   500
#define SS_XNUM    70
#define SS_YMIN   100
#define SS_YMAX  2500
#define SS_YNUM   200

void
init_side_interps()
{
  side_setup(SS_YMIN,SS_YMAX,SS_YNUM,SS_XMIN,SS_XMAX,SS_XNUM);
  left_side.num = SS_XNUM;
  right_side.num = SS_XNUM;
}
