/*
 * loadfile.c -- load a parameter file
 *
 */

#include <stdio.h>
#include <math.h>
#include "structures.h"
#include "parameters.h"
#include "constants.h"

/*
 * Opening and reading a parameter file.
 *
 * Format:
 *   Comment lines begin with semicolon
 *   Parameter lines begin with the parameter name
 *   Different parameters have different formats
 *
 */


char outbuf[100];
char namebuf[100];

shorten(char *name)		/* shorten the file name into outbuf */
{
  int n,i;
  char *p;
  p = namebuf;
  for (n = strlen(name); n > 0; n--)
    {
      if ( name[n-1] == '/' )
	{
	  for (i = n; i < strlen(name); i++)
	    {
	      *p++ = name[i];
	    }
	  n = 0;
	}
    }
  *p = 0;
}


load_file(name)			/* load the file named "name" */
     char *name;
{
  FILE *fp;
  char buf[100];
  int c = 0;
  shorten(name);
  if ((fp = fopen(name, "r")) == NULL)
    { 
      sprintf(outbuf,"Can't open %s",namebuf);
      message(outbuf);
      return(-1);
    }
  else
    {
      while(fgets(buf,100,fp)!=NULL) /* read a line, process it */
	{ proc_line(buf); c++; }
      sprintf(outbuf,"Processed %s",namebuf);
      message(outbuf);
    }
  calc_sonar_masks();
  fclose(fp);
}


char strbuf[100];

proc_line(l,c)			/* process one line */
     char *l;
{
  int n;
  n = 0;
  sscanf(l,";%n",&n);
  if (n>0)			/* comment line */
    return(0);
  sscanf(l," ");		/* get rid of whitespace */
  if (*l == 0) return(0);	/* null line */
  sscanf(l,"%s%n",strbuf,&n);
  if (n>0) return(proc_param(l+n));
  else return(-1);
}


save_float(char *l, float *f)	/* scan for a float and save it */
{
  sscanf(l,"%f",f);
}

save_int(char *l, int *i)	/* scan for an int and save it */
{
  sscanf(l,"%d",i);
}


extern float vel_conv_factor, angle_conv_factor,
             dist_conv_factor, diff_conv_factor,
             range_conv_factor, flakey_radius, flakey_diagonal;

struct floatvar
{
  char *name;
  float *val;
} floatvars[] = { { "VelConvFactor",    &vel_conv_factor },
		  { "AngleConvFactor",  &angle_conv_factor },
		  { "DistConvFactor",   &dist_conv_factor },
		  { "DiffConvFactor",   &diff_conv_factor },
		  { "RangeConvFactor",  &range_conv_factor },
		  { "RobotRadius",      &flakey_radius },
		  { "RobotDiagonal",    &flakey_diagonal },
		  { NULL, NULL }
		};

struct intvar
{
  char *name;
  int *val;
} intvars[] = {	{ "SonarNum", &sonar_num },
		{ NULL, NULL }
	      };
 
extern float sonar_spec_array[MAX_SONARS][5];

int
save_sonar_unit(char *l)
{
  int i, n, x, y, th;
  sscanf(l,"%d%n",&i,&n);
  if (n==0) return(-1);
  else l += n;
  if (i >= sonar_num) return(-1);
  if (i < 0) return(-1);
  sscanf(l,"%d%n",&x,&n);
  if (n==0) return(-1);
  else l += n;
  sscanf(l,"%d%n",&y,&n);
  if (n==0) return(-1);
  else l += n;
  sscanf(l,"%d%n",&th,&n);
  if (n==0) return(-1);
  else l += n;
  sonar_spec_array[i][0] = (float)x;
  sonar_spec_array[i][1] = (float)y;
  sonar_spec_array[i][2] = (float)cos(th*DEG_TO_RAD);
  sonar_spec_array[i][3] = (float)sin(th*DEG_TO_RAD);
  sonar_spec_array[i][4] = (float)(th*DEG_TO_RAD);
  return(0);
}

proc_param(l)			/* process one parameter */
     char *l;
{
  struct floatvar *fp;
  struct intvar *ip;

  fp = floatvars;
  while (fp->val != NULL)
    {
      if (strcmp(strbuf,fp->name) == 0)
	{
	  save_float(l,fp->val);
	  return(0);
	}
      fp++;
    }

  ip = intvars;
  while (ip->val != NULL)
    {
      if (strcmp(strbuf,ip->name) == 0)
	{
	  save_int(l,ip->val);
	  return(0);
	}
      ip++;
    }
  if (strcmp(strbuf,"SonarUnit") == 0)
    save_sonar_unit(l);
  else return(-1);
  return(0);
}


