/* 
 * clamp.c -- functions for clamping to egocentric coords
 * 
 */

#include <stdio.h>

#include "constants.h"
#include "structures.h"
#include "parameters.h"

float clamp_int = 20.0,		/* translation interval */
      clamp_th  = (1.0 * DEG_TO_RAD); /* rotation interval */

extern update_sbuf(float x,float y,float th);
extern update_wbuf(float x,float y,float th);
extern void update_pointlist(float x,float y,float th);

clamp_proc()			/* checks for movement */
{
  float dx, dy, dth;

  dx = flakey.x;  dy = flakey.y;  dth = flakey.th;
  if (ABS(dx) > clamp_int || ABS(dy) > clamp_int || ABS(dth) > clamp_th)
    {
      flakey.x -= dx;		/* update flakey pos */
      flakey.y -= dy;
      flakey.th -= dth;
      
      update_sbuf(dx,dy,dth);	/* update buffers */
      update_wbuf(dx,dy,dth);
      update_pointlist(dx,dy,dth); /* update global points */
    }
}


