/*
 *  Window setup functions for Motif version
 *  Behavior window
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "X11/Xlib.h"
#include "X11/Xutil.h"
#include "X11/Xos.h"
#include "X11/Intrinsic.h"
#include "X11/IntrinsicP.h"
#include "X11/CoreP.h"
#include "X11/Shell.h"
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/DrawingA.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/BulletinB.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>

#include "display.h"
#include "structures.h"
#include "constants.h"
#include "parameters.h"


Widget b_toplevel;		/* top level application */
Widget b_main_window;		/* main window widget */
Widget b_menu_bar;
Widget b_frame;			/* main drawing window */
Widget b_messages;		/* message/info window */
Widget b_column;		/* for behaviors */

void buttonCB();		/* callback function for buttons */
extern XtAppContext app_context;


/* Create behavior buttons */

Widget b_buttons[BS_MAX+1];

void 
create_behavior_buttons(void)	/* sets up possible behavior slots */
{
  Arg args[10];
  int n, i;
  Widget button;
  n = 0;
  XtSetArg(args[n], XmNheight, BS_ROW); n++;
  XtSetArg(args[n], XmNhighlightThickness, 0); n++; 
  for(i=0; i<BS_MAX; i++)
    {
      button = XmCreateToggleButton(b_column,"Behavior",args,n);
      b_buttons[i] = button;
      XtAddCallback(button, XmNvalueChangedCallback, buttonCB, &behaviors[i]);
    }
  b_buttons[BS_MAX] = XmCreateLabel(b_column,"Summation",args,n);
}

void
behavior_buttons(void)		/* sets up behaviors */
{
  Arg args[10];
  int n, i;
  Widget button;
  XmString str;

  for (i=0; i<BS_MAX; i++) /* release all current buttons */
    XtUnmanageChild(b_buttons[i]);    
  XtUnmanageChild(b_buttons[BS_MAX]);

  for (i=0; i<MIN(num_bcs,BS_MAX); i++) /* loop through behavior closures */
    {
      button = b_buttons[i];
      str = XmStringCreateLtoR((behaviors[i]->beh)->name,XmSTRING_DEFAULT_CHARSET);
      n = 0;
      XtSetArg(args[n], XmNlabelString, str); n++;
      XtSetArg(args[n], XmNset, behaviors[i]->running); n++;
      XtSetValues(button,args,n);
      XtManageChild(button);
      XmStringFree(str);
    }
  XtManageChild(b_buttons[BS_MAX]);
}

/* Create the main application window */

Window
create_b_win(int width,int height)
{ 
  Arg args[10];
  int n;
  Widget button, menu_pane, cascade;
  
  b_toplevel = 
    XtAppCreateShell(app_context,"Behaviors",topLevelShellWidgetClass, 
		     display, NULL, 0); 


  /* Main window  */
  n = 0;
  b_main_window = XmCreateMainWindow(b_toplevel,"Behaviors",args,n); 
  XtManageChild(b_main_window);

  /* Create message/info window */
  n = 0;
  XtSetArg(args[n], XmNlabelString, 
	   XmStringCreateLtoR("                            Activity           Turn         Move",XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
  b_messages = XmCreateLabel(b_main_window, "Hey there", args, n);
  XtManageChild(b_messages);


  /* Create menu bar in main window */
  n = 0;
  b_menu_bar = XmCreateMenuBar(b_main_window, "menu_bar", args, n);
  XtManageChild(b_menu_bar);


  /* Create frame for graphics display */
  n = 0;
  b_frame = XmCreateDrawingArea(b_main_window, "drawing", args, n);
  XtManageChild(b_frame);

/*   XtAddCallback(frame, XmNexposeCallback, expose_proc, NULL); */
/*  XtAddCallback(b_frame, XmNresizeCallback, b_resize_proc, NULL); */

  /* Create row/column widget for buttons */
  n = 0;
  XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
  XtSetArg(args[n], XmNnumColumns, 1); n++;
  b_column = XmCreateRowColumn(b_frame, "column", args, n);
  XtManageChild(b_column);

  create_behavior_buttons();
  

  /* Set main window areas and size */
  XmMainWindowSetAreas(b_main_window, b_menu_bar, NULL, NULL, NULL, b_frame);

  n = 0;
  XtSetArg(args[n], XmNmessageWindow, b_messages); n++;
  XtSetArg(args[n], XmNshowSeparator, True); n++;
  XtSetValues(b_main_window, args, n);

  n = 0;
  XtSetArg(args[n], XmNheight, height); n++;
  XtSetArg(args[n], XmNwidth, width); n++;
  XtSetValues(b_toplevel, args, n);

  n = 0;
  XtSetArg(args[n], XmNheight, INFO_HEIGHT); n++;
  XtSetValues(b_messages, args, n);

  XtRealizeWidget(b_toplevel);

  n = 0;
  XtSetArg(args[n], XmNheight, INFO_HEIGHT); n++;
  XtSetValues(b_messages, args, n);

  process_events();

  b_win = XtWindow(b_frame);	/* graphics window */

  return(XtWindow(b_frame));

}


void
buttonCB(w, b, cbs)
     Widget w;
     beh_closure **b;
     XmToggleButtonCallbackStruct *cbs;
{
  int n;
  Arg args[1];

  if (cbs->set == False)	/* unset, turn behavior off */
    {
      (*b)->running = 0;
    }
  else
    {
      (*b)->running = 1;
    }
}
