/*#########################################
 * toplevel.c
 *
 * Top level loops for the ERRATIC simulator
 *
 *#########################################
 */

#include <stdio.h>
#include "structures.h"
#include "constants.h"
#include "parameters.h"


void setup_sim_robot();
void process_events();

int debug = 0;

int nohalt = 1;
int single_step_mode = 0;
int step_wait = 0;
int cycle_time = MIN_CYCLE_TIME;

update_and_comm_loop()		/* update the simulator, communicate */
{
  nohalt = 1;
  single_step_mode = 0;
  while(nohalt)
    update_and_comm();
}


update_and_comm()		/* update and communicate */
{
  process_waiting_packets();
  if (single_step_mode && step_wait)
    {
      process_waiting_packets();
      process_events();
    }
  else
    {
      step_wait = 1;
      update_sim();
      process_events();
      send_client_packets();
    }
  int_time(cycle_time);
}


/* Setup function */

char *tty_port;			/* holds tty port name for communication */

void scroll_to_screen_position();

void
setup_sim(argc,argv)
     int argc; char **argv;
{
  setup_display_window(argc,argv);
  scroll_to_screen_position(0,0);
  if (argc > 1)			/* asking for tty port here */
    {
      tty_port = argv[1];
    }
}


main(argc,argv)			/* starts up the simulator, asking fool questions */
     int argc; char **argv;
{
  char s[100];
  setup_sim_robot();
  setup_sim(argc,argv);
  if (tty_port == NULL)
    startup_erratic_server(TCP,NULL);
  else
    startup_erratic_server(TTYPORT,tty_port);
} 
