/*
 * Definitions for some display functions
 *
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

extern Display *display;	/* screen */
extern GC gc, b_gc, b_gc1, b_gc2; /* drawing GC */
extern GC cgc, b_cgc;		/* clearing GC */
extern GC igc;			/* info window GC */
extern Pixmap graphics_pm;	/* drawing pixmap for double-buffering */
extern Pixmap b_pm;		/* drawing pixmap for double-buffering */
extern Window win;		/* graphics window */
extern Window info_win;		/* info window */
extern Window b_win;		/* graphics window for behaviors */

Window
create_b_win(int width,int height);
Window
create_app(int width,int height,int argc,char **argv);


/* drawing info */

#define CHAR_HEIGHT  14		/* 14 pixels high between lines */
#define CHAR_WIDTH    8		/*  8 pixels wide between chars */
#define INFO_WIDTH   600	/* info window width */
#define INFO_HEIGHT  (4*CHAR_HEIGHT) /* info window min height */
#define INFO_COL_1   8		/* first info column */
#define INFO_COL_2   25		/* first info column */

/* screen conversions */

extern int w_height, w_width;	/* height and width of main display, in pixels */
extern int w_offset_x, w_offset_y; /* center x,y offset, in pixels */
extern int w_offset_dx, w_offset_dy; /* offset displacement from center screen */
extern float w_scale;		/* pixels per mm conversion */

extern int b_height, b_width;	/* height and width of behavior display, in pixels */

/* wake control */

extern int draw_wake_flag;


/* structures for drawings buffers */

struct sX_data			/* structure holding segments */
{
  int end;			/* most we can have */
  int ofw;			/* buffer overflow if > 0 */
  int n;			/* where we're at, initially 0 */
  XSegment *p;			/* pointer to a segment buffer */
};

extern struct sX_data *sx; 

extern XPoint      *pX_buf_p;	/* buffer ptrs for points, segments, and boxes */
extern XRectangle  *rX_buf_p;
extern XArc        *aX_buf_p;
extern XSegment    *sX_buf_p;

extern XPoint      pX_buf[];	/* buffers for points, segments, and boxes */
extern XRectangle  rX_buf[];
extern XArc        aX_buf[];

extern int  pX_buf_n;		/* buffer counters */
extern int  rX_buf_n;
extern int  aX_buf_n;

#define pX_buf_MAX 400
#define rX_buf_MAX 400
#define aX_buf_MAX  50

#define put_point(mx,my) { pX_buf_p->x = (int)(mx), \
			   pX_buf_p->y = (int)(my), \
			   pX_buf_p++;        \
			     if (++pX_buf_n >= pX_buf_MAX)  \
			       { pX_buf_p--; pX_buf_n--; } }

#define put_box(mx,my,mw,mh) { rX_buf_p->x = (int)(mx), \
			   rX_buf_p->y = (int)(my), \
			   rX_buf_p->width = (int)(mw), \
			   rX_buf_p->height = (int)(mh), \
			   rX_buf_p++;        \
			   if (++rX_buf_n >= rX_buf_MAX)  \
			   { rX_buf_p--; rX_buf_n--; } }

#define put_vector(mx1,my1,mx2,my2) { \
  sX_buf_p = (sx->p) + (sx->n); \
  sX_buf_p->x1 = (int)(mx1); \
  sX_buf_p->y1 = (int)(my1); \
  sX_buf_p->x2 = (int)(mx2); \
  sX_buf_p->y2 = (int)(my2); \
  if (  (++(sx->n)) >= (sx->end) )  \
     { (sx->n)--; (sx->ofw)++; } }

#define put_arc(mx,my,mw,mh,a1,a2) { \
     aX_buf_p->x = (int)(mx); \
     aX_buf_p->y = (int)(my); \
     aX_buf_p->width = (int)(mw); \
     aX_buf_p->height = (int)(mh); \
     aX_buf_p->angle1 = (int)(a1); \
     aX_buf_p->angle2 = (int)(a2); \
     aX_buf_p++;        \
     if (++aX_buf_n >= aX_buf_MAX)  \
       { aX_buf_p--; aX_buf_n--; } }

#define put_text(mx,my,mstr,mlen) \
  XDrawImageString(display,info_win,igc,mx,my,mstr,mlen)

#define draw_info_string(s,x,y,l) draw_str(s,(x)*CHAR_WIDTH,((y)+1)*CHAR_HEIGHT,l)
#define draw_info_num(n,d,x,y) draw_num(n,d,(x)*CHAR_WIDTH,((y)+1)*CHAR_HEIGHT)

#define check_alive if (win ==  0) return(-1)



/* Translation to screen coords.  Real +x on flakey translates to "up" on the
 *   screen, and real +y is to Flakey's left, i.e, "left" on the screen.  
 *   So we have: +x -> scaled -y,  +y -> scaled -x.
 */


typedef struct			/* this is a 3x3 2D rotation/translation matrix */
{				
  float a11;
  float a12;
  float a13;
  float a21;
  float a22;
  float a23;
  float a31;
  float a32;
  float a33;
}  rotm;

extern rotm screen_matrix; /* scales to screen coords from rw */
extern rotm flakey_screen_matrix; /* scales to screen coords from flakey */
extern rotm flakey_matrix; /* scales to rw coords from flakey */

#define scalex(x) (screen_matrix.a13 + (screen_matrix.a12 * (x))) 
#define scaley(y) (screen_matrix.a23 + (screen_matrix.a21 * (y))) 
#define dscale(x) (screen_matrix.a12 * (x)) 
#define xscale(x,y) scalex(- y)
#define yscale(x,y) scaley(- x)
#define dxscale(x,y) dscale(- y)
#define dyscale(x,y) dscale(- x)

#define draw_fl_vec(x1,y1,x2,y2) draw_rm_vec(x1,y1,x2,y2,&flakey_screen_matrix)
#define draw_fl_box(x,y,dx,dy) draw_rm_rect(x,y,dx,dy,&flakey_screen_matrix)
#define draw_rw_vec(x1,y1,x2,y2) draw_rm_vec(x1,y1,x2,y2,&screen_matrix)
#define draw_rw_box(x,y,dx,dy) draw_rm_rect(x,y,dx,dy,&screen_matrix)
#define draw_rw_arc(x,y,dx,dy,a1,a2) draw_rm_arc(x,y,dx,dy,a1,a2,&screen_matrix)


/* drawing fns */

extern 
draw_rm_rect(float x,float y,int dx,int dy,rotm *rm); 
				/* draws a rectangle using rw coords */
extern
draw_rm_vec(float x1,float y1,float x2,float y2,rotm *rm); 
				/* draws this vector, using rw coords */


/*** drawing on the behavior window ***/

#define BS_MAX 10		/* max number of BS's */

#define BS_ROW 25		/* height of each row of text */
#define BS_BAR 40		/* width of each bar */
#define BS_AC_SCALE 0.5		/* accel -- pixel per unit*/
#define BS_TR_SCALE -5		/* turn  -- positive angles on left */

#define clear_bs_area(x,y,w,h) \
  XFillRectangle(display,b_pm,b_cgc,x,y,w,h)

#define copy_bs_area(x,y,w,h) \
  XCopyPlane(display, b_pm, b_win, b_gc, x, y, w, h, x, y, 1); 

#define draw_bs_line(x0,y0,x1,y1) \
  XDrawLine(display,b_pm,b_gc1,x0,y0,x1,y1)

void				/* draw a thick line on the display */
draw_bs_bar(int x0,int y0,int l);

void				/* draw all behaviors */
draw_behaviors(void);
