/* 
 * C functions to read and write the IO buffers
 *
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sgtty.h>

#define MAX_IN_SIZE 256
#define MAX_OUT_SIZE 256

int comm_in_line, comm_out_line; /* file descriptors */

char out_buf[MAX_OUT_SIZE];
char  in_buf[MAX_IN_SIZE];
char temp_buf[MAX_OUT_SIZE];
int in_buf_p, in_buf_max;	/* current pointer, max chars in buffer */
int out_buf_p;


put_buf_byte(n)			/* puts a byte, forces output if buffer full */
 
{ if (out_buf_p >= MAX_OUT_SIZE) /* need to write here */
    { write(comm_out_line,out_buf,MAX_OUT_SIZE);
      out_buf_p = 0;
    }
  
  out_buf[out_buf_p++] = n;
}

write_out_buf()			/* writes the buffer out */

{  write(comm_out_line,out_buf,out_buf_p);
   out_buf_p = 0;
 }

/*-------- read buffer routines for getting chars from the stream -------*/

int debug_stream = 0;		/* for printing out received chars */

get_buf_byte()			/* returns one char from buffer, does */
				/* a READ if necessary */
{ 
  int c;
  if (in_buf_p >= in_buf_max)	/* need to do a READ */
    { in_buf_max = read(comm_in_line,in_buf,MAX_IN_SIZE); 
      in_buf_p = 0;
      if (in_buf_max < 0) {perror("read fault"); 
			   in_buf_max = 0;
			   return(-1);}; /* we failed to read anything */
    }
  
  c = 0xff & in_buf[in_buf_p++];
  if (debug_stream) printf(" %d ",c);
  return(c);
}


char *form_arg_string()		/* returns a pointer to a string */
{
  int i;
  char *p;
  p = temp_buf;
  i = get_buf_byte();		/* string length */
  if (i <= 0 || i > 100) i = 100;
  while (i--)
    { *p++ = get_buf_byte(); }
  *p = 0;
  p = temp_buf;
  return(p);
}


clear_in_buf()			/* clear out input buffer */

{ in_buf_p = 0;
  in_buf_max = 0;
}


int
check_in_buf(int wait)		/* returns 0 if no input waiting, 1 if yes */
     
{ int f;
  struct timeval tp;		/* time interval structure for timeout */
  fd_set fdset;			/* fd set ??? */
  
  if ( in_buf_p < in_buf_max )	/* have some chars in the buffer */
    { return(in_buf_max - in_buf_p); }
  else
    { tp.tv_sec = wait / 1000;		/* we're polling */
      tp.tv_usec = (wait % 1000) * 1000;

      FD_ZERO(&fdset);
      FD_SET(comm_in_line,&fdset);
      f = comm_in_line + 1;
      f = select(f,&fdset,NULL,NULL,&tp) ;
      if (f >= 1)		/* we have something, could be a refused connect */
	{ in_buf_max = read(comm_in_line,in_buf,MAX_IN_SIZE); 
	  in_buf_p = 0;
	  if (in_buf_max < 0) {perror("read fault"); 
			       in_buf_max = 0;
			       return(-1);} /* we failed to read anything */
	  else
	    { return(in_buf_max - in_buf_p); }
	}
      else return(0);
     }
}


wait_in_buf()			/* wait until there's input */
{ if (in_buf_p == in_buf_max)	/* need to do a READ */
    { in_buf_max = read(comm_in_line,in_buf,MAX_IN_SIZE); 
      in_buf_p = 0;
      if (in_buf_max < 0) {in_buf_max = 0;}; /* we failed to read anything */
    }
}

write_in_buf_to_file(fd,n)	/* write out N chars from the in buffer to FD */
int n,fd;
{ in_buf[in_buf_p + n] = 0;	/* zero-terminate this line */
  return(write(fd,in_buf+in_buf_p,n+1)); 
}

write_array_to_file(fd,n,arr)	/* write out N chars from the array to FD */
int n,fd;
int arr[];
{ int i;
  char *op;
  op = temp_buf;
  for (i = 0; i < n; i++)
    *op++ = arr[i];
  *op++ = 0;	/* zero-terminate this line */
  return(write(fd,temp_buf,n+1)); 
}


write_in_buf_to_array(arr,n,rev)	/* write out N chars from in buffer to LISP arr */
int n, rev;			/* rev is 0 for normal order, 1 for reverse */
int arr[];
{ int i,j;
  if (rev)
    { i = in_buf_p;
      for (j=n-1; j >= 0; j--)
	{ arr[j] = 0xff & in_buf[i++]; }
    }
  else
    { i = in_buf_p;
      for (j=0; j < n; j++)
	{ arr[j] = 0xff & in_buf[i++]; }
    }
}


input_comm_line(fd)		/* set up comm fd's */
int fd;
{
  if (fd < 0) return(comm_in_line);
  else
    { comm_in_line = fd;
      in_buf_p = 0;
      in_buf_max = 0;	
    }
}

output_comm_line(fd)		/* set up comm fd's */
int fd;
{
  if (fd < 0) return(comm_in_line);
  else
    { comm_out_line = fd; 
      out_buf_p = 0;
    }
}


/* -------------- Check a file for read available ---------------- */

listen_in_buf(fd,wait)		/* returns 0 if no input waiting, 1 if yes */
				/* wait is time in ms to wait */
{ int f;
  struct timeval tp;		/* time interval structure for timeout */
  fd_set fdset;			/* fd set ??? */
  
  tp.tv_sec = 0;		/* we're polling */
  tp.tv_usec = 0;
  if (wait > 1000) tp.tv_sec = (wait / 1000);
  else tp.tv_usec = wait * 1000;

  FD_ZERO(&fdset);
  FD_SET(fd,&fdset);
  f = fd + 1;
  f = select(f,&fdset,NULL,NULL,&tp) ;
  return(f);
}

