;;; -*- Mode: Common-Lisp; Package: Lisp; Base: 10 -*-
;;; Pre-base stuff for setting up environments or packages.
;;; Copyright (C) 1992, Drew McDermott, Yale University (see "copyright" file).
             
;; ============================ VERSION CONTROL
;; !S is NISP's host-system filter, !D for Lisp dialect (COMMON or T).
;; #+ and #- are CL's own mechanism, used where appropriate (see below).

;; These functions can be used to help make customizations (sample values for
;; some machines currently used at Yale provided):
;; (lisp-implementation-type)
;;      HP: "Hewlett-Packard Common Lisp" or "HP Common Lisp II"
;;     VAX: "VAX LISP"
;;      TI: "Zetalisp"
;; (machine-type)
;;      HP: "Hewlett-Packard Series 300", "9000/350", ...
;;    TOPS: "DEC MicroVAX-II"
;;      TI: "Explorer"
;; (software-type)
;;      HP: "HP-UX"
;;    TOPS: "VMS"
;;      TI: "Zetalisp"
;; hopefully too specific:
;;   (lisp-implementation-version), (machine-version) (software-version)

;; Some relevent members of *features* lists for use with #+ and #- :
;;      HP: (HP) or (:HP :LUCID)
;;     VAX: (VAX VMS DEC)
;;      TI: (:TI :EXPLORER)
;;  S-3650: (:SYMBOLICS 3600 :LISPM)

;; Note that you may well need to make changes to suit your local hardware,
;; software and directory structures.

;;; ********************* PACKAGES & READTABLES

;(MAKE-PACKAGE "NISP")

;;; ***> IMPORTANT!!! <***
; If you are using a Lisp roughly like that described in CLTL2, please
; add :NEWFANGLED to the *FEATURES* list.

(PUSH ':NEWFANGLED *FEATURES*)

#+:NEWFANGLED
(PROGN
; Please edit the nicknames to achieve legality.
(RENAME-PACKAGE "COMMON-LISP" "COMMON-LISP" '("LISP" "CL"))
(RENAME-PACKAGE "COMMON-LISP-USER" "COMMON-LISP-USER" '("USER" "CL-USER"))

(DEFPACKAGE "NISP" (:USE "COMMON-LISP"))

)

#-:NEWFANGLED
(PROGN
(RENAME-PACKAGE "LISP" "LISP" '("COMMON-LISP" "CL"))
(RENAME-PACKAGE "USER" "USER" '("COMMON-LISP-USER" "CL-USER"))
(MAKE-PACKAGE "NISP")
(USE-PACKAGE "LISP" "NISP")
)

(IN-PACKAGE "NISP")

; The following must eventually be declared naughty:
; DEFTYPE, DEFCLASS

; A list of symbols from LISP package shadowed in NISP.  Each entry
; is a pair (nisp-version lisp-version).
(DEFVAR NAUGHTY-NISP-SYMBOLS* '())
(DEFVAR PACKAGES-USING-NISP* '())
;(DEFVAR USER-USING-NISP* NIL)

(CL:DEFUN NAUGHTY-NISP-SYMBOLS (SYMS)
   (LET ((NISP-PACKAGE (FIND-PACKAGE "NISP")))
      (SHADOW SYMS NISP-PACKAGE)
      (DOLIST (S SYMS)
	 (LET ((NISP-VERSION (INTERN (SYMBOL-NAME S) NISP-PACKAGE)))
	    (LET ((P (ASSOC NISP-VERSION NAUGHTY-NISP-SYMBOLS*
			    :TEST #'EQ)))
               (COND ((NOT P)
		      (SETF P (LIST NISP-VERSION NIL))
		      (SETF NAUGHTY-NISP-SYMBOLS*
			    (CONS P NAUGHTY-NISP-SYMBOLS*)))   )
		(SETF (CADR P)
		      (INTERN (SYMBOL-NAME S)
			      (FIND-PACKAGE "COMMON-LISP")))
		;(EXPORT (LIST NISP-VERSION))
		)))
      (DOLIST (PU PACKAGES-USING-NISP*)
	  (SHADOWING-IMPORT SYMS PU)   )))

(DEFPARAMETER LISP-READ-TABLE* *READTABLE*)
(DEFPARAMETER NISP-READ-TABLE* (COPY-READTABLE NIL))

(EVAL-WHEN (EVAL COMPILE LOAD)
  (SETQ *READTABLE* NISP-READ-TABLE*))

(CL:DEFUN GOTONISP ()
   (SETF *READTABLE* NISP-READ-TABLE*)
   #+HARLEQUIN-COMMON-LISP (LET ()
                             (DECLARE (SPECIAL TTYIN* TTYOUT*))
                             (SETQ TTYIN* *STANDARD-INPUT*)
                             (SETQ TTYOUT* *STANDARD-OUTPUT*))
   (IN-PACKAGE "NISP")   )

(CL:DEFUN LEAVENISP ()
   (SETF *READTABLE* LISP-READ-TABLE*)
   (IN-PACKAGE "CL-USER")   )

; This function runs Nisp in the package PU, and changes the readtable 
; accordingly.  In order to make the world look Nispish, it does some 
; drastic things.  If you just want to use the Nisp package, there are
; synonyms for the unfortunate names Nisp uses for some functions.
(CL:DEFUN NISP-PENETRATE-PACKAGE (PU)
   (LET ((MUTANTS (MAPCAR #'CAR NAUGHTY-NISP-SYMBOLS*)))
      (COND ((NULL PACKAGES-USING-NISP*)
	     (EXPORT MUTANTS (FIND-PACKAGE "NISP")))   )
      (SHADOWING-IMPORT MUTANTS PU)   )
   (USE-PACKAGE (LIST (FIND-PACKAGE "NISP")) PU)
   (SETF PACKAGES-USING-NISP* (ADJOIN PU PACKAGES-USING-NISP*))
   ;(SETF USER-USING-NISP* T)
   )

; This function undoes the work of the previous function
(CL:DEFUN NISP-WITHDRAW-FROM-PACKAGE (PU)
   (SHADOWING-IMPORT (MAPCAR #'CADR NAUGHTY-NISP-SYMBOLS*) PU)
   (SETF PACKAGES-USING-NISP* (DELETE PU PACKAGES-USING-NISP*))
   (COND ((NULL PACKAGES-USING-NISP*)
	  (UNEXPORT (MAPCAR #'CAR NAUGHTY-NISP-SYMBOLS*)
		    (FIND-PACKAGE "NISP")))   )
   (UNUSE-PACKAGE (LIST (FIND-PACKAGE "NISP")) PU)   )

(CL:DEFUN USE-NISP ()
   (SETF *READTABLE* NISP-READ-TABLE*)
   (NISP-PENETRATE-PACKAGE (FIND-PACKAGE "CL-USER")))

(CL:DEFUN UNUSE-NISP ()
   (SETF *READTABLE* LISP-READ-TABLE*)
   (NISP-WITHDRAW-FROM-PACKAGE (FIND-PACKAGE "CL-USER"))   )

(NAUGHTY-NISP-SYMBOLS '(SYMBOL COMPLEMENT DEFUN DEFMACRO
			;IGNORE
			LOOP WITH-OUTPUT-TO-STRING))

(CL:DEFUN IGNORE-CONVERT (BODY)
   (COND ((AND (NOT (NULL BODY))
	       (CONSP (CAR BODY))
	       (EQ (CAAR BODY) 'IGNORE))
	  `((DECLARE (CL:IGNORE ,@(CDAR BODY))) ,@(CDR BODY)))
	 (T BODY)   ))

(CL:DEFMACRO DEFUN (NAME ARGS &REST BODY)
   `(CL:DEFUN ,NAME ,ARGS ,@(IGNORE-CONVERT BODY))   )

(CL:DEFMACRO DEFMACRO (NAME ARGS &REST BODY)
   `(CL:DEFMACRO ,NAME ,ARGS ,@(IGNORE-CONVERT BODY))   )

(EXPORT '(=< \\ ->FLOAT ->INTEGER ->PATHNAME -F -A
	  -NOCONTINUE -NOVALUE 

	  ADJOIN= ADJOINQ ALL ASCII->CHAR ASK ASSOC= ASSOCQ ATAN2
	  ATTACH-DATAFUN AT-RUN-TIME AT-COMPILE-TIME

	  BIND BIT-FIELD BY

	  CAR-EQ CEILING2 CHAR CHAR->ASCII CHAR->STRING CHAR->SYMBOL CHAR=<
	  CHARCEIL* CHARFLOOR* COMPLEMENT= COMPILE 
          COMPLEMENTQ CONDENSE CONS-PATHNAME CONSET CR

	  D DATAFUN DATAFUN-TABLE DEPENDS-ON
	  DISPLAYWIDTH DNODUP DNODUP= DNODUPQ
	  DREMOVE-EVERY DREMOVE-EVERY-IF DREMOVE-EVERY= DREMOVE-EVERYQ
	  DREMOVE1 DREMOVE1-IF DREMOVE1= DREMOVE1Q
	  DREVERSE DROP DSKLAP DSKLAP-COMPILE*

	  E EARROR ERROUT ERROUT-SET EVALFILE EXISTS EXIT

	  FILESPECS->PATHNAMES FILTER FL< FL> FL>= FL= FL=< FL* FL+ FL- FL/
	  FLABELS FLOOR2 FLRANDOM FOR FORALL FRESH-TABLE FROM
	  FUN-NAME FUNDEF->FUN FUNDEF->LAMBDA FUNKTION
	  FX< FX> FX>= FX= FX=< FX* FX+ FX- FX/ FXRANDOM

	  GET-FUNDEF GSET GVAL

	  HERALD HOST-DIALECT* HOST-SYS*

	  IN INCLUDE-IF INITIALIZED-ARRAY INTERCEPT
	  INTERSECTION= INTERSECTIONQ
	  IS-ALPHABETIC IS-ARRAY IS-CHAR IS-DIGIT IS-EOF IS-EVEN IS-FIXNUM
	  IS-FLOAT IS-FUN-NAME IS-HASH-TABLE IS-INTEGER IS-LOWER-CASE IS-MACRO
	  IS-MAGIC IS-NUMBER IS-ODD IS-PAIR IS-PATHNAME IS-RATIO IS-RATIONAL
	  IS-STRING IS-SUBLIST IS-SUBLIST= IS-SUBLISTQ IS-SYMBOL IS-TAIL
	  IS-UPPER-CASE IS-VECTOR IS-WHITESPACE

	  LASTELT LASTTAIL LCONC LEN LINESTRING LINELIST
	  LIST->STRING LIST->SYMBOL LIST->VALUES LIST->VECTOR
	  LIST-CONCAT LIST-COPY LIST-ELT LIST-SUBSEQ LOADOREVAL
	  LRECORD

	  MACRO-EXPAND-EXP MAKE-EQ-HASH-TABLE MAKE-VECTOR
	  MAPELTAND MAPELTCOLLECT MAPELTCONC MAPELTDO MAPELTLIST MAPELTOR
	  MAPELTREDUCE MAPELTSOME MAPMAC
	  MAPTAILAND MAPTAILAPPEND MAPTAILCOLLECT MAPTAILCONC MAPTAILDO
	  MAPTAILLIST MAPTAILSOME 
	  MEMBER= MEMBERQ  ; MEMQ -- usually already present
	  MSG MULTIPLE-VALUE-LET

	  N NO NEEDED-BY-MACROS NEWLINE* NISCOM NODUP NODUP= NODUPQ
	  NTHELT NTHTAIL NUMBER->STRING NISP NISP-READ-TABLE*

	  OBJ OK ONE-MACRO-EXPAND ONE-VALUE OPENI OPENO OUT

	  PASS PATHNAME->STRING PEEK PLIST PP PRINTWIDTH PROBEF PROP PUT-FUNDEF

	  Q QUOTIENT

	  READ-OBJECTS-FROM-STRING READMAC
	  REBIND-ERROUT REBIND-STDIN REBIND-STDOUT REMAINDER
	  REMOVE-EVERY REMOVE-EVERY-IF REMOVE-EVERY= REMOVE-EVERYQ
	  REMOVE1 REMOVE1-IF REMOVE1= REMOVE1Q REPEAT RESULT
	  RMV-IF ROUND2

	  S SAVE SELQ SERIES SPLICE
	  SRMCURRCOL SRMDISPLAY SRMLINELENGTH SRMLINEREAD SRMLINES
	  SRMMSG SRMNEWLINE SRMPEEKC SRMPRINLEV SRMPRINT SRMPRINTC SRMREAD
	  SRMREAD-LINE SRMREADC SRMSPACES SRMTAB 
	  STDCURRCOL STDDISPLAY STDLINELENGTH STDLINEREAD STDLINES
	  STDMSG STDNEWLINE STDPEEKC STDPRINLEV STDPRINT STDPRINTC STDREAD
	  STDREAD-LINE STDREADC STDSPACES STDTAB 
	  STDIN STDIN-SET STDOUT STDOUT-SET
	  STRING->LIST STRING->NUMBER STRING->SYMBOL STRING-CONCAT STRING-COPY
	  STRING-ELT STRING-LENGTH STRING-SUBSEQ STRING-UPCASE SUBST= SUBSTQ
	  SYMBOL->FUN SYMBOL->LIST SYMBOL->STRING SYMPLIST

	  TABLE-ENTRY TAKE TCONC TO TRUNCATE2 TTYIN* TTYOUT* TTYMSG

	  UNION= UNIONQ UNTIL

	  VECTOR->LIST VECTOR-CONCAT VECTOR-COPY VECTOR-ELT VECTOR-LENGTH
	  VECTOR-SUBSEQ VREF

	  WALK-TABLE WITH-INPUT-FROM-FILE WITH-OUTPUT-TO-FILE WHEN WHILE

	  Y YES)

	(FIND-PACKAGE "NISP"))

;;; ********************* HOST SYSTEM & PATHNAMES
;;; This will change with local site characteristics.

(DEFVAR NISP-FEATURES* (LIST 'NEW-DT))	;used by !Z read-macro (see base.l)
					;NEW-DT selects new implementation of discrimination
					;tree for DUCK.

(DEFCONSTANT HOST-SYS* 
  #+VMS        'VMS
  #+:TI        'TI
  #+:AEGIS     'AEGIS
  #+:CORAL     'MAC
  #-(or VMS :TI :AEGIS :CORAL)  'UNIX       ; default to UNIX
 "Current host operating system.")

(DEFVAR NISP-HOME-DIR* 
  "/cs/yale/src/lisp/nisp/"
 "Nisp directory.")

(DEFVAR NILS-HOME-DIR*
  (CONCATENATE 'STRING NISP-HOME-DIR* "nils/")
 "Nils source code directory.")

(DEFVAR DECL-HOME-DIR*
 (CONCATENATE 'STRING NISP-HOME-DIR* "decl/")
 "Decl source code directory.")

(DEFVAR DUCK-HOME-DIR*
  (CONCATENATE 'STRING NISP-HOME-DIR* "duck/")
 "Duck source code directory.")

(DEFVAR HOST-SRC-EXTN* "lisp"
 "Host Lisp filename extension for source code files.")

(DEFVAR OBJ-SUFFIX* "wfasl"
 "Host Lisp filename extension for object code files.")

(DEFVAR HOST-FILENAME-CASE* 'LOWER   ; UPPER for VMS, e.g.
 "Default case for filenames.")

;;; ********************* NISP & DUCK FILES
;;; These shouldn't require any adjustment.

(DEFVAR SOURCE-SUFFIX*
  (IF (EQ HOST-FILENAME-CASE* 'LOWER)
      "nsp"
      "NSP")
 "Nisp filename extension for source code files.")

(DEFVAR PRE-DSKLAP-NILS*
  (IF (EQ HOST-FILENAME-CASE* 'LOWER)
      '("base" "io" "control" "pathname" "files.nsp" "depnisp-lw.nsp")
      '("BASE" "IO" "CONTROL" "PATHNAME" "FILES.NSP" "DEPNISP-LW.NSP"))
 "Nils files loaded before DSKLAP is defined.")


;;; ********************* FUNCTIONS TO COMPILE & LOAD FILES
;;; This file, when loaded, prompts the user on the next appropriate step,
;;; which varies according to the system.
(DEFVAR DEPENDS-ON-RECURSIVELY-SKIP* NIL)

(CL:DEFUN LOAD-PRENILS ()
   (LET ((DEF (MAKE-PATHNAME :DIRECTORY
			     (PATHNAME-DIRECTORY
			        (PARSE-NAMESTRING NILS-HOME-DIR*))
			     :TYPE HOST-SRC-EXTN*))
	 (PATHNAMES '()))
      (DOLIST (FILENAME PRE-DSKLAP-NILS*)
         (LET ((SRC-PATH (MERGE-PATHNAMES FILENAME DEF)))
	    (LET ((OBJ-PATH (MERGE-PATHNAMES (MAKE-PATHNAME :TYPE OBJ-SUFFIX*)
					     SRC-PATH)))
	       (COND ((PROBE-FILE OBJ-PATH)
		      (LOAD OBJ-PATH))
		     (T
		      (LOAD SRC-PATH))   ))
	    (SETF PATHNAMES (CONS SRC-PATH PATHNAMES))   ))
      ; The following only works after files is loaded:
    (DOLIST (PN PATHNAMES)
      (RECORD-DEPENDS-ON-SKIP (PATHNAME-NO-SUFFIX PN))
      (LET ((TIME (OR (PATHNAME-WRITE-TIME PN) T))
	    (SUFFIXES (LIST HOST-SRC-EXTN* SOURCE-SUFFIX*)))
	(SET-PATHNAME-PROP 'LOADED PN TIME)
	(SETQ PN (GET-PATHNAME-WITH-SUFFIXES PN SUFFIXES))
	(IF PN (SET-PATHNAME-PROP 'SLURPED PN TIME))))))

(CL:DEFUN COMPILE-LOAD-PRENILS ()
   (LET ((DEF (MAKE-PATHNAME :DIRECTORY
			     (PATHNAME-DIRECTORY
			        (PARSE-NAMESTRING NILS-HOME-DIR*))
			     :TYPE HOST-SRC-EXTN*))
	 (PATHNAMES '()))
      (DOLIST (FILENAME PRE-DSKLAP-NILS*)
	 (LET ((SRC-PATH (MERGE-PATHNAMES FILENAME DEF)))
	    (LET ((OBJ-PATH (MERGE-PATHNAMES (MAKE-PATHNAME :TYPE OBJ-SUFFIX*)
					     SRC-PATH)))
	       (LOAD SRC-PATH)
	       (COMPILE-FILE SRC-PATH)
	       (SETF PATHNAMES (CONS (LIST SRC-PATH OBJ-PATH)
				     PATHNAMES))
	       (LOAD OBJ-PATH)   )))
      ;;--now that NILS/files is loaded
      (DOLIST (REC PATHNAMES)
	(LET ((SRC-PATH (CAR REC)) (OBJ-PATH (CADR REC)))
	   (RECORD-DEPENDS-ON-SKIP (PATHNAME-NO-SUFFIX SRC-PATH))
	   (SET-PATHNAME-PROP 'SLURPED OBJ-PATH
		 (OR (PATHNAME-WRITE-TIME SRC-PATH) T))
	   (SET-PATHNAME-PROP 'LOADED OBJ-PATH
		 (OR (PATHNAME-WRITE-TIME OBJ-PATH) T))   ))))
    

;;; ********************* SAVING EXECUTABLE NISP & DUCK SYSTEMS
;;; Some adjustments, e.g. for memory used, may be helpful.
;;; This requires local experimentation. Not all systems are covered.


;;; ********************* CUSTOMIZATIONS
;;; Change to taste.

(SETQ *PRINT-CIRCLE*  NIL  
      *PRINT-LEVEL*   12   ;nesting-level to stop at
      *PRINT-LENGTH*  15   ;number of elements to stop at
      *PRINT-ARRAY*    T
      )

#+:LUCID
(PROGN
 ;(LCL::LOAD-PATCHES :directory "/usr/licensed/sclisp-4.0/patches/" :verbose 't)
 (IMPORT '(SYSTEM::DISKSAVE SYSTEM::GC))
; (CL:DEFUN CL-USER::EXIT () (SYSTEM::QUIT)) ;HP QUIT = up one debugger level!
 (CL:DEFUN NISP::EXIT () (SYSTEM::QUIT))
 (CL:DEFUN NISP::BYE  () (SYSTEM::QUIT))
 (SETQ SYSTEM::*DEBUG-PRINT-LEVEL* 12)
 (SETQ *LOAD-VERBOSE* T)                ;prints a bit more
 (SETQ *REDEFINITION-ACTION* NIL)       ;don't warn about all the redefinitions
 (SETQ SYSTEM::*REDEFINITION-ACTION* NIL)
 #-(or :LCL3.0 :LCL4.0)
 (SYSTEM::COMPILER-OPTIONS :MESSAGES NIL	;no progress messages
			   ;; 68020 on other systems may require "lbin"->"2bin"
			   :TARGET #+:HP '68020/68881
			           #-:HP '68K
			  )
 #+(or :LCL3.0 :LCL4.0)
 (SYSTEM::COMPILER-OPTIONS :MESSAGES NIL :TAIL-MERGE 'T)
 #+(or :LCL3.0 :LCL4.0)
 (CL::PROCLAIM '(CL::OPTIMIZE (CL::COMPILATION-SPEED 3) (CL::SAFETY 3) (CL::SPEED 2)))
 (SYS::CHANGE-MEMORY-MANAGEMENT :GROWTH-LIMIT 350 :EXPAND 175)
)
 
(CL:DEFUN PRENILS ()
   (COND ((Y-OR-N-P "Compile? ")
	  (COMPILE-LOAD-PRENILS))
	 (T
	  (LOAD-PRENILS))   ))

(EXPORT '(GOTONISP LEAVENISP USE-NISP UNUSE-NISP
	  NISP-PENETRATE-PACKAGE NISP-WITHDRAW-FROM-PACKAGE
	  LOAD-PRENILS COMPILE-LOAD-PRENILS PRENILS))

(PRENILS)
