;;; -*- Mode:Common-Lisp; Package:NISP; Base:10 -*-
;;; Conversion from Nisp types to common-lisp types.
;;; Changed 9.2.88: moved (DATAFUN NISP->CLTYPE ...) to after any 
;;;   DEFTYPES to avoid overwriting of NISP->CL-TAB* entries.
;;; Copyright (C) 1988, Drew McDermott, Yale University (see "copyright" file).
(HERALD HOSTYPES (READ-TABLE NISP-READ-TABLE*) (SYNTAX-TABLE NISP-SYN*))
(IN-PACKAGE "NISP")

(DEPENDS-ON NILS)
(DEPENDS-ON DECL/ TYPES)

(NEEDED-BY-MACROS
(DEFVAR NISP->CL-TAB* (MAKE-EQ-HASH-TABLE))
)

(PROCLAIM '(SPECIAL OVERDRIVE*))

(DEFUN NISP->HOSTYPE (NISPTY) (NISP->CLTYPE NISPTY)   )

; Fixed 1991.2.8 to check for infinite recursions
(DEFVAR TYPES-BEING-COERCED* '())

(DEFUN NISP->CLTYPE (NISPTY)
   (!= NISPTY
       (COND ((AND (IS-SYMBOL NISPTY)
		   (EQ (PROP 'DEFINED NISPTY) 'FORWARD))
	      UNIV-TYPE*)
	     (T (COERCE-TO-NISPTYPE *-*))))
   (COND ((NOT (MEMQ NISPTY TYPES-BEING-COERCED*))
	  (BIND ((TYPES-BEING-COERCED*
		    (CONS NISPTY
			  TYPES-BEING-COERCED*)))
	     (LOOP FOR (TD)
	      WHILE NISPTY
		(!= TD (TYPE-DESIG NISPTY))
	      UNTIL (TYPE-FEATURE NISPTY 'SUPPRESS-DECLARATION)
	      RESULT 'T
	      UNTIL (AND (IS-SYMBOL TD)
			 (NOT (NULL (TABLE-ENTRY NISP->CL-TAB* TD))))
	      RESULT (FUNCALL (TABLE-ENTRY NISP->CL-TAB* TD)
		              NISPTY)
	      UNTIL (AND (CONSP TD)
			 (NOT (NULL (TABLE-ENTRY NISP->CL-TAB* 
						 (CAR TD)))))
	      RESULT (FUNCALL (TABLE-ENTRY NISP->CL-TAB* (CAR TD))
			      NISPTY)   
		(!= NISPTY (TYPE-SUPER *-*))   )))
	 (T 'T)   ))

(NEEDED-BY-MACROS
(DATAFUN ATTACH-DATAFUN NISP->CLTYPE
   (DEFUN (IND SYM FNAME)
      (IGNORE IND)
      (!= (TABLE-ENTRY NISP->CL-TAB* SYM)
	  (SYMBOL->FUN FNAME))   ))
)

;; Note: (function ...) can't be used in defstruct slot :type specs
(DEFUN TYPE-OK-FOR-SLOT (SPEC)
   (COND ((CAR-EQ SPEC 'FUNCTION) 'FUNCTION)
	 (T SPEC)   ))

(DATAFUN NISP->CLTYPE ARY
   (DEFUN (TY)
      `(SIMPLE-ARRAY ,(NISP->CLTYPE (TYPE-FEATURE TY 'ELTYPE))
		     ,(OR (TYPE-FEATURE TY 'ARRAY-DIMS)
			  (TYPE-FEATURE TY 'ARRAY-RANK)
			  '*))   ))

(DATAFUN NISP->CLTYPE LRCD
   (DEFUN (TY) (IGNORE TY) 'CONS   ))

(DATAFUN NISP->CLTYPE FUN
   (DEFUN (TY) (NISP-FUNTYPE->CL TY)  ))

(DEFUN NISP-FUNTYPE->CL (TY)
      (FLABELS ((NISP->CL-ARGTYPES (ATL)
		   (COND ((NULL ATL) NIL)
			 ((EQ (CAR ATL) 'DOT)
			  `(&REST ,(NISP->CLTYPE (CADR ATL))))
			 (T
			  `(,(NISP->CLTYPE (CAR ATL))
			    . ,(NISP->CL-ARGTYPES (CDR ATL))))   )))
	 `(FUNCTION ,(NISP->CL-ARGTYPES (TYPE-FEATURE TY 'ARGTYPES))
		    ,(NISP->CLTYPE (TYPE-FEATURE TY 'RESULTTYPE)))   ))

(DATAFUN NISP->CLTYPE HTB
   (DEFUN (TY) (IGNORE TY) 'HASH-TABLE   ))


;; Nov.4.87 modified
(DATAFUN NISP->CLTYPE LST
   (DEFUN (TY) (IGNORE TY) 'LIST   ))

(DATAFUN NISP->CLTYPE void
   (DEFUN (TY) (IGNORE TY) 'NIL   ))

(DATAFUN NISP->CLTYPE obj 
   (DEFUN (TY) (IGNORE TY) 'T   ))

(DATAFUN NISP->CLTYPE EITHER
   (DEFUN (TY)
      (LET ((ETL (TYPE-FEATURE TY 'EITHER-TYPES)))
         (LET ((CLTL (<# (\\ (ET) (SEDATE-HYSTERICAL-CL-TYPE (NISP->CLTYPE ET))   )
			 ETL)))
	    (COND ((MEMQ 'T CLTL) 'T)
		  (T `(OR . ,CLTL))   )))))


(DATAFUN NISP->CLTYPE ~
   (DEFUN (TY)
      (LET ((CLTY (SEDATE-HYSTERICAL-CL-TYPE (NISP->CLTYPE (TYPE-SUPER TY)))))
	 (COND ((EQ CLTY 'T) 'T)
	       (T `(OR ,CLTY NULL))   ))))


(DEFUN SEDATE-HYSTERICAL-CL-TYPE (TY)
   (COND ((CAR-EQ TY 'FUNCTION) 'T)
	 (T TY)   ))

(DATAFUN NISP->CLTYPE null !'TYPE-DESIG)
