(EVAL-WHEN (LOAD EVAL COMPILE)
	   (CHK-BASE-AND-PACKAGE 10 *PACKAGE*))


(DEFMACRO DEFEVENT (&REST X)

;   An apology for our user-level functions being macros.

;   We find it desirable to permit the theorem-prover to be invoked from a Lisp
;   read-eval-print loop rather than from some interface of our own design.
;   One reason for this attitude is that it allows the user of the system to
;   enjoy the benefits of his customary Lisp environment.

;   If the top level functions for events, such as DEFN and PROVE-LEMMA were
;   defined as EXPRS, then it would be necessary to quote the arguments, which
;   we find burdensome.  Common Lisp leaves us no alternative to EXPRS except
;   macros.  We therefore define each user-level function, say DOIT, as a macro
;   which, after checking for the right number of arguments calls another
;   function, DOIT-FN, which is an EXPR.

;   So that DEFN and PROVE-LEMMA can have optional "hint" arguments, permit
;   &OPTIONAL to occur in the arg list, though in fact it does not occur in the
;   arg list of either the MACRO or the EXPR we define.

;   Historical note:  In Interlisp we defined our user-level functions as
;   EXPRS, yet we were able to write:

;   DEFN(FOO (X) (BAR X))

;   which not only solved the quote problem but also permitted the optional
;   arguments to default to NIL.

;   Not all of the Lisps in which we run check macro arguments as carefully as
;   we would like, so we do it here for the user-level functions ourselves.

  (LET (NAME ARGS BODY REQUIRED-ARGS OPTIONAL-ARGS FN)
    (OR (MATCH X (CONS NAME (CONS ARGS BODY)))
	(ERROR "DEFEVENT needs at least 3 arguments"))
    (OR (NULL (CDR (OUR-LAST X)))
	(ERROR "DEFEVENT arg lists must end in NIL."))

;   In the spirit of Common Lisp, we permit ourselves optional arguments
;   in the user interface.

    (COND ((MEMBER-EQ (QUOTE &OPTIONAL) ARGS)
	   (SETQ REQUIRED-ARGS
		 (ITERATE FOR ARG IN ARGS UNTIL (EQ ARG (QUOTE &OPTIONAL))
			  COLLECT ARG))
	   (SETQ OPTIONAL-ARGS (CDR (MEMBER-EQ (QUOTE &OPTIONAL) ARGS))))
	  (T (SETQ REQUIRED-ARGS ARGS)
	     (SETQ OPTIONAL-ARGS NIL)))
    (SETQ FN (PACK (LIST NAME (QUOTE -FN))))
    `(PROGN (QUOTE COMPILE)
	    (DEFMACRO ,NAME (&REST X)
	      (DEFEVENT-APPLY X ',NAME ',FN ,(LENGTH REQUIRED-ARGS)
		,(+ (LENGTH OPTIONAL-ARGS) (LENGTH REQUIRED-ARGS))))
	    (DEFUN ,FN ,(APPEND REQUIRED-ARGS OPTIONAL-ARGS) ,@BODY))))

(DEFEVENT ADD-AXIOM (NAME TYPES TERM)
  (LET ((IN-ADD-AXIOM-FLG T))
    (COND ((NOT IN-REDO-UNDONE-EVENTS-FLG)
	   (CAR (REDO-UNDONE-EVENTS (LIST (LIST (QUOTE ADD-AXIOM)
						NAME TYPES TERM))
				    T
				    (QUOTE C)
				    T T)))
	  (T (LET (MAIN-EVENT-NAME)
	       (CHK-ACCEPTABLE-LEMMA NAME TYPES TERM)
	       (MAKE-EVENT NAME (LIST (QUOTE ADD-AXIOM) NAME TYPES TERM))
	       (ADD-FACT NIL (QUOTE NONCONSTRUCTIVE-AXIOM-NAMES)
			 NAME)
	       (ADD-LEMMA0 NAME TYPES TERM)
	       (DEPEND NAME (ALL-FNNAMES (TRANSLATE TERM)))
	       NAME)))))

(DEFEVENT ADD-SHELL
  (SHELL-NAME BTM-FN-SYMB RECOGNIZER DESTRUCTOR-TUPLES)
  (COND ((NOT IN-REDO-UNDONE-EVENTS-FLG)
	 (CAR (REDO-UNDONE-EVENTS (LIST (LIST (QUOTE ADD-SHELL)
					      SHELL-NAME BTM-FN-SYMB
					      RECOGNIZER
					      DESTRUCTOR-TUPLES))
				  T (QUOTE C) T T)))
	(T (LET (MAIN-EVENT-NAME)
	     (CHK-ACCEPTABLE-SHELL SHELL-NAME BTM-FN-SYMB RECOGNIZER
				   DESTRUCTOR-TUPLES)
	     (MAKE-EVENT SHELL-NAME
			 (LIST (QUOTE ADD-SHELL)
			       SHELL-NAME BTM-FN-SYMB RECOGNIZER
			       DESTRUCTOR-TUPLES))
	     (ADD-SHELL0 SHELL-NAME BTM-FN-SYMB RECOGNIZER
			 DESTRUCTOR-TUPLES)
	     (DEPEND SHELL-NAME
		     (SET-DIFF (UNION-EQ (ITERATE FOR X IN DESTRUCTOR-TUPLES
						  WITH ITERATE-ANS
						  DO (SETQ ITERATE-ANS
							   (UNION-EQ (CDR (CADR X))
								     ITERATE-ANS))
						  FINALLY (RETURN ITERATE-ANS))
					 (ITERATE FOR X IN DESTRUCTOR-TUPLES
						  WITH ITERATE-ANS
						  DO
						  (SETQ ITERATE-ANS
							(ADD-TO-SET (CADDR X)
								    ITERATE-ANS))
						  FINALLY (RETURN ITERATE-ANS)))
			       (COND (BTM-FN-SYMB (LIST BTM-FN-SYMB
							RECOGNIZER))
				     (T (LIST RECOGNIZER)))))

;   Make the shell depend on every fn used in the type restrictions and
;   defaults except the BTM-FN-SYMB and RECOGNIZER of this type.

	     SHELL-NAME))))

(DEFUN BOOT-STRAP ()
  (LET ((IN-BOOT-STRAP-FLG T))
    (COND ((NOT IN-REDO-UNDONE-EVENTS-FLG)
	   (CAR (REDO-UNDONE-EVENTS
		 (LIST (LIST (QUOTE BOOT-STRAP)))
		 T
		 (QUOTE C)
		 T
		 T)))
	  (T (LET (MAIN-EVENT-NAME
		   (ARITY-ALIST
		    (QUOTE ((NOT . 1) (AND . 2) (OR . 2) (IMPLIES . 2)
			    (LESSP . 2) (PLUS . 2)))))
	       (BOOT-STRAP0)
	       (MAKE-EVENT (QUOTE GROUND-ZERO) (LIST (QUOTE BOOT-STRAP)))
	       (ADD-FACT (QUOTE IF) (QUOTE LISP-CODE) (QUOTE *1*IF))
	       (GUARANTEE-CITIZENSHIP (QUOTE *1*IF))
	       (ADD-FACT (QUOTE EQUAL) (QUOTE LISP-CODE) (QUOTE *1*EQUAL))
	       (GUARANTEE-CITIZENSHIP (QUOTE *1*EQUAL))
	       (ADD-FACT (QUOTE IF)
			 (QUOTE TYPE-PRESCRIPTION-LST)
			 (CONS (QUOTE GROUND-ZERO)
			       (QUOTE (0 NIL T T))))
	       (ADD-FACT (QUOTE EQUAL)
			 (QUOTE TYPE-PRESCRIPTION-LST)
			 (CONS (QUOTE GROUND-ZERO)
			       (CONS TYPE-SET-BOOLEAN (QUOTE (NIL NIL)))))

;   The following hack declares NUMBERP to be Boolean so that the axiom
;   SUB1-TYPE-RESTRICTION is simpler.  The problem should have been fixed
;   in ADD-SHELL, where we should declare the type of the recognizer before
;   creating axioms about them.

	       (ADD-FACT (QUOTE NUMBERP)
			 (QUOTE TYPE-PRESCRIPTION-LST)
			 (CONS (QUOTE GROUND-ZERO)
			       (CONS TYPE-SET-BOOLEAN (QUOTE (NIL))))) 
	       (ADD-FACT (QUOTE COUNT) (QUOTE LISP-CODE) (QUOTE *1*COUNT))
	       (GUARANTEE-CITIZENSHIP (QUOTE *1*COUNT))
	       (ADD-FACT (QUOTE COUNT)
			 (QUOTE TYPE-PRESCRIPTION-LST)
			 (CONS (QUOTE GROUND-ZERO)
			       (CONS TYPE-SET-NUMBERS (QUOTE (NIL)))))
	       (ITERATE FOR INSTR IN BOOT-STRAP-INSTRS DO (APPLY (CAR INSTR)
								 (CDR INSTR)))
	       (QUOTE GROUND-ZERO))))))

(DEFEVENT DCL (NAME ARGS)
  (COND ((NOT IN-REDO-UNDONE-EVENTS-FLG)
	 (CAR (REDO-UNDONE-EVENTS (LIST (LIST (QUOTE DCL)
					      NAME ARGS))
				  T
				  (QUOTE C)
				  T T)))
	(T (LET (MAIN-EVENT-NAME)
	     (CHK-ACCEPTABLE-DCL NAME ARGS)
	     (MAKE-EVENT NAME (LIST (QUOTE DCL) NAME ARGS))
	     (DCL0 NAME ARGS)
	     NAME))))

(DEFEVENT DEFN (NAME ARGS BODY &OPTIONAL RELATION-MEASURE-LST)
  (COND ((NOT IN-REDO-UNDONE-EVENTS-FLG)
	 (CAR (REDO-UNDONE-EVENTS (LIST (LIST (QUOTE DEFN)
					      NAME ARGS BODY
					      RELATION-MEASURE-LST))
				  T
				  (QUOTE C)
				  T T)))
	(T
	 (LET (MAIN-EVENT-NAME)
	   (CHK-ACCEPTABLE-DEFN NAME ARGS BODY RELATION-MEASURE-LST)
	   (MAKE-EVENT NAME (COND (RELATION-MEASURE-LST
				   (LIST (QUOTE DEFN) NAME ARGS BODY
					 RELATION-MEASURE-LST))
				  (T (LIST (QUOTE DEFN) NAME ARGS BODY))))
	   (DEFN0 NAME ARGS BODY RELATION-MEASURE-LST NIL)
	   (DEPEND
	    NAME
	    (REMOVE
	     NAME
	     (UNION-EQ
	      (ALL-FNNAMES (TRANSLATE BODY))
	      (UNION-EQ
	       ALL-LEMMAS-USED
	       (ITERATE FOR TEMP IN (GET NAME (QUOTE JUSTIFICATIONS))
			WITH ITERATE-ANS
			DO (SETQ
			    ITERATE-ANS
			    (UNION-EQ (COND
				       ((NULL (ACCESS JUSTIFICATION RELATION TEMP))
					NIL)
				       (T (UNION-EQ (ALL-FNNAMES (ACCESS
								  JUSTIFICATION
								  MEASURE-TERM
								  TEMP))
						    (ADD-TO-SET (ACCESS JUSTIFICATION
									RELATION TEMP)
								(ACCESS JUSTIFICATION
									LEMMAS TEMP)))))
				      ITERATE-ANS))
			FINALLY (RETURN ITERATE-ANS))))))
	   (PRINT-DEFN-MSG NAME ARGS)
	   (DEFN-WRAPUP (TOTAL-FUNCTIONP NAME))
	   (COND ((TOTAL-FUNCTIONP NAME)
		  NAME)
		 (T NIL))))))

(DEFEVENT DISABLE (OLDNAME)
  (FUNCALL (FUNCTION TOGGLE-FN) (MAKE-NEW-NAME) OLDNAME T))

(DEFEVENT ENABLE (OLDNAME)
  (FUNCALL (FUNCTION TOGGLE-FN) (MAKE-NEW-NAME) OLDNAME NIL))

(DEFEVENT PROVE-LEMMA (NAME TYPES TERM &OPTIONAL HINTS)
  (LET ((IN-PROVE-LEMMA-FLG T))
    (COND ((NOT IN-REDO-UNDONE-EVENTS-FLG)
	   (CAR (REDO-UNDONE-EVENTS (LIST (LIST (QUOTE PROVE-LEMMA)
						NAME TYPES TERM HINTS))
				    T
				    (QUOTE C)
				    T T)))
	  (T
	   (LET (PROVE-ANS MAIN-EVENT-NAME)
	     (CHK-ACCEPTABLE-LEMMA NAME TYPES TERM)
	     (CHK-ACCEPTABLE-HINTS HINTS)
	     (UNWIND-PROTECT
		 (PROGN

;   Before calling PROVE we call APPLY-HINTS.  APPLY-HINTS sets some global
;   variables that affect the theorem-prover.  We enter an UNWIND-PROTECT here
;   so that we can set those variables to their standard default values no
;   matter how we exit PROVE.

		   (SETQ PROVE-ANS
			 (PROVE (APPLY-HINTS HINTS TERM)))
		   (COND (PROVE-ANS
			  (MAKE-EVENT NAME (COND (HINTS
						  (LIST (QUOTE PROVE-LEMMA)
							NAME TYPES TERM HINTS))
						 (T (LIST (QUOTE PROVE-LEMMA)
							  NAME TYPES TERM))))
			  (ADD-LEMMA0 NAME TYPES TERM)
			  (DEPEND NAME
				  (UNION-EQ ALL-LEMMAS-USED
					    (UNION-EQ (EXTRACT-DEPENDENCIES-FROM-HINTS
						       HINTS)
						      (ALL-FNNAMES
						       (TRANSLATE TERM)))))))
		   (COND (PROVE-ANS NAME)
			 (T NIL)))
	       (ITERATE FOR X IN HINT-VARIABLE-ALIST
			DO (SET (CADR X) (CADDDR X)))))))))

(DEFEVENT REFLECT (NAME SATISFACTION-LEMMA-NAME &OPTIONAL RELATION-MEASURE-LST)
  (COND
   ((NOT IN-REDO-UNDONE-EVENTS-FLG)
    (CAR (REDO-UNDONE-EVENTS (LIST (LIST (QUOTE REFLECT)
					 NAME
					 SATISFACTION-LEMMA-NAME
					 RELATION-MEASURE-LST))
			     T
			     (QUOTE C)
			     T T)))
   (T
    (LET (MAIN-EVENT-NAME)
      (DEFN-SETUP (LIST (QUOTE REFLECT)
			NAME SATISFACTION-LEMMA-NAME
			RELATION-MEASURE-LST))
      (CHK-ACCEPTABLE-REFLECT NAME SATISFACTION-LEMMA-NAME
			      RELATION-MEASURE-LST)
      (MAKE-EVENT NAME
		  (COND (RELATION-MEASURE-LST
			 (LIST (QUOTE REFLECT) NAME SATISFACTION-LEMMA-NAME
			       RELATION-MEASURE-LST))
			(T (LIST (QUOTE REFLECT) NAME
				 SATISFACTION-LEMMA-NAME))))
      (REFLECT0 NAME SATISFACTION-LEMMA-NAME
		RELATION-MEASURE-LST NIL)
      (DEPEND
       NAME
       (REMOVE
	NAME
	(ADD-TO-SET
	 SATISFACTION-LEMMA-NAME
	 (UNION-EQ
	  ALL-LEMMAS-USED
	  (ITERATE FOR TEMP IN (GET NAME (QUOTE JUSTIFICATIONS))
		   WITH ITERATE-ANS
		   DO (SETQ ITERATE-ANS
			    (UNION-EQ
			     (COND
			      ((NULL (ACCESS JUSTIFICATION RELATION TEMP))
			       NIL)
			      (T (UNION-EQ (ALL-FNNAMES (ACCESS
							 JUSTIFICATION
							 MEASURE-TERM
							 TEMP))
					   (ADD-TO-SET (ACCESS JUSTIFICATION
							       RELATION TEMP)
						       (ACCESS
							JUSTIFICATION
							LEMMAS TEMP)))))
			     ITERATE-ANS))
		   FINALLY (RETURN ITERATE-ANS))))))
      (PRINT-DEFN-MSG NAME (CADR (GET NAME (QUOTE SDEFN))))
      (DEFN-WRAPUP (TOTAL-FUNCTIONP NAME))
      (COND ((TOTAL-FUNCTIONP NAME)
	     NAME)
	    (T NIL))))))

(DEFEVENT TOGGLE (NAME OLDNAME FLG)
  (COND ((NOT IN-REDO-UNDONE-EVENTS-FLG)
	 (CAR (REDO-UNDONE-EVENTS (LIST (LIST (QUOTE TOGGLE)
					      NAME OLDNAME FLG))
				  T
				  (QUOTE C)
				  T T)))
	(T (LET (MAIN-EVENT-NAME)
	     (CHK-ACCEPTABLE-TOGGLE NAME OLDNAME FLG)
	     (MAKE-EVENT NAME (LIST (QUOTE TOGGLE) NAME OLDNAME FLG))
	     (ADD-FACT NIL (QUOTE DISABLED-LEMMAS)
		       (CONS OLDNAME (CONS NAME FLG)))
	     (DEPEND NAME (LIST (MAIN-EVENT-OF OLDNAME)))
	     NAME))))

(DEFEVENT TOGGLE-DEFINED-FUNCTIONS (NAME FLG)
  (COND ((NOT IN-REDO-UNDONE-EVENTS-FLG)
	 (CAR (REDO-UNDONE-EVENTS (LIST (LIST (QUOTE TOGGLE-DEFINED-FUNCTIONS)
					      NAME FLG))
				  T
				  (QUOTE C)
				  T T)))
	(T (LET (MAIN-EVENT-NAME)
	     (CHK-ACCEPTABLE-TOGGLE-DEFINED-FUNCTIONS NAME FLG)
	     (MAKE-EVENT NAME (LIST (QUOTE TOGGLE-DEFINED-FUNCTIONS) NAME FLG))
	     (ADD-FACT NIL (QUOTE DEFINED-FUNCTIONS-TOGGLED)
		       (CONS NAME FLG))
	     NAME))))

(DEFEVENT UBT (&OPTIONAL N)
  (LET (UNDONE-EVENTS)
    (COND ((NULL N) (SETQ N (CAR CHRONOLOGY)))
          ((NUMBERP N) (SETQ N (NTH N CHRONOLOGY))))
    (SETQ UNDONE-EVENTS (UNDO-BACK-THROUGH N))
    (PUSHU)
    N))

