(EVAL-WHEN (LOAD EVAL COMPILE)
	   (CHK-BASE-AND-PACKAGE 10 *PACKAGE*))

(DEFUN S (VAR VAL)

;   This function is intended to be used in conjunction with R. 
;   The idea is that one might type, to LISP, (S 'X (some hairy lisp expr))
;   to manufacture (or, more likely, recover from some other object) an
;   explicit value too big to type.  Then you could use X inside expressions
;   given to R.

  (COND ((NOT (ERROR1-SET (SETQ TEMP-TEMP (TRANSLATE VAR))))
	 NIL)
	((OR (NOT (EQ VAR TEMP-TEMP))
	     (NOT (VARIABLEP VAR)))
         (ERROR1 (PQUOTE (PROGN (!PPR VAR NIL) |is| |not| |a| |variable|
                                |symbol| |.|))
                 (BINDINGS (QUOTE VAR) VAR)
                 (QUOTE SOFT)))
	((NOT (ERROR1-SET (SETQ VAL (TRANSLATE VAL))))
	 NIL)
	((NOT (QUOTEP VAL))
         (ERROR1 (PQUOTE (PROGN |The| |second| |argument| |to| S |must|
                                |be| |an| |explicit| |value| |--| |i.e.,|
                                |composed| |entirely| |of| |shell|
                                |constructors| |and| |bottom| |objects| |--|
                                |and| (!PPR VAL NIL) |is| |not| |.|))
                 (BINDINGS (QUOTE VAL) VAL)
                 (QUOTE SOFT)))
	(T (SETQ TEMP-TEMP (OR (ASSOC-EQ VAR R-ALIST)
			       (CAR (SETQ R-ALIST
					  (CONS (CONS VAR VAL)
						R-ALIST)))))
	   (RPLACD TEMP-TEMP (CADR VAL))
	   VAR)))

(DEFUN SARGS (TERM)
  (COND ((NOT (EQ (CAR TERM) (QUOTE QUOTE)))
	 (CDR TERM))
	((SYMBOLP (CADR TERM))
	 (COND ((EQ (CADR TERM) *1*T)
		NIL)
	       ((EQ (CADR TERM) *1*F)
		NIL)
	       (T (LIST (LIST (QUOTE QUOTE)
			      (DTACK-0-ON-END (OUR-EXPLODEN (CADR TERM))))))))
	((INTEGERP (CADR TERM))
	 (COND ((< (CADR TERM) 0)
		(LIST (LIST (QUOTE QUOTE) (- (CADR TERM)))))
	       ((EQUAL (CADR TERM) 0)
		NIL)
	       (T (LIST (LIST (QUOTE QUOTE) (1- (CADR TERM)))))))
	((EQ (CAR (CADR TERM)) *1*SHELL-QUOTE-MARK)
	 (ITERATE FOR X IN (CDDR (CADR TERM)) COLLECT (LIST (QUOTE QUOTE) X)))
	(T (LIST (LIST (QUOTE QUOTE) (CAR (CADR TERM)))
		 (LIST (QUOTE QUOTE) (CDR (CADR TERM)))))))

(DEFUN SCONS-TERM (FN ARGS)
  (COND ((EQ FN (QUOTE EQUAL))
	 (COND ((EQUAL (CAR ARGS)
		       (CADR ARGS))
		TRUE)
	       ((AND (QUOTEP (CAR ARGS))
		     (QUOTEP (CADR ARGS)))
		FALSE)
	       (T (CONS (QUOTE EQUAL)
			ARGS))))
	(T (CONS-TERM FN ARGS))))

(DEFUN SCRUNCH (L)
  (ITERATE FOR TAIL ON L UNLESS (MEMBER-EQUAL (CAR TAIL)
					      (CDR TAIL))
	   COLLECT (CAR TAIL)))

(DEFUN SCRUNCH-CLAUSE (CL)
  (ITERATE FOR TAIL ON CL
	   UNLESS (OR (AND (FALSE-NONFALSEP (CAR TAIL))
			   DEFINITELY-FALSE)
		      (MEMBER-EQUAL (CAR TAIL)
				    (CDR TAIL)))
	   COLLECT (CAR TAIL)))

(DEFUN SCRUNCH-CLAUSE-SET (CLAUSES)
  (TRANSITIVE-CLOSURE (ITERATE FOR CL IN CLAUSES COLLECT (SCRUNCH-CLAUSE CL))
		      (FUNCTION (LAMBDA (CL1 CL2)
				  (COND ((SUBSETP-EQUAL CL1 CL2)
					 CL1)
					((SUBSETP-EQUAL CL2 CL1)
					 CL2)
					(T NIL))))))

(DEFUN SEARCH-GROUND-UNITS (HYP)

;   Like LOOKUP-HYP except looks through ground unit REWRITE lemmas.

  (PROG (TERM FN REWRITE-RULE)
	(COND ((MATCH HYP (NOT TERM))
	       (COND ((VARIABLEP TERM)
		      (RETURN NIL))
		     ((FQUOTEP TERM)
		      (RETURN (EQUAL TERM FALSE)))
		     (T (SETQ FN (FFN-SYMB TERM)))))
	      ((VARIABLEP HYP)
	       (RETURN NIL))
	      ((FQUOTEP HYP)
	       (RETURN (NOT (EQUAL HYP FALSE))))
	      (T (SETQ FN (FFN-SYMB HYP))))
	(COND
	 ((SETQ REWRITE-RULE
		(ITERATE FOR REWRITE-RULE IN (GET FN (QUOTE LEMMAS))
			 WHEN (AND (NOT (DISABLEDP (ACCESS REWRITE-RULE NAME
							   REWRITE-RULE)))
				   (NOT (META-LEMMAP REWRITE-RULE))
				   (NOT (ACCESS REWRITE-RULE HYPS REWRITE-RULE))
				   (NOT (FREE-VARSP (ACCESS REWRITE-RULE CONCL
							    REWRITE-RULE)
						    NIL))
				   (ONE-WAY-UNIFY1 HYP
						   (ACCESS REWRITE-RULE CONCL
							   REWRITE-RULE)))
			 DO (RETURN REWRITE-RULE)))
	  (PUSH-LEMMA (ACCESS REWRITE-RULE NAME REWRITE-RULE))
	  (RETURN T))
	 (T (RETURN NIL)))))

(DEFUN SEQUENTIAL-DIFFERENCE (SMALLER LARGER)
  (COND ((ATOM SMALLER)
	 LARGER)
	((ATOM LARGER)
	 (QUOTE NOT-RELATED))
	((EQUAL (CAR SMALLER)
		(CAR LARGER))
	 (SEQUENTIAL-DIFFERENCE (CDR SMALLER)
				(CDR LARGER)))
	(T (SETQ TEMP-TEMP (SEQUENTIAL-DIFFERENCE SMALLER (CDR LARGER)))
	   (COND ((EQ TEMP-TEMP (QUOTE NOT-RELATED))
		  (QUOTE NOT-RELATED))
		 (T (CONS (CAR LARGER)
			  TEMP-TEMP))))))

(DEFUN SET-DIFF (X Y)
  (ITERATE FOR ELE IN X UNLESS (MEMBER-EQUAL ELE Y) COLLECT ELE))

(DEFUN SET-DIFF-N (BIG LITTLE N)
  (COND ((ZEROP N)
	 NIL)
	((ATOM BIG)
	 (ERROR1 (PQUOTE (PROGN SET-DIFF-N |called| |with| |inappropriate|
				|arguments| |.|))
		 (BINDINGS)
		 (QUOTE HARD)))
	((MEMBER-EQ (CAR BIG)
		    LITTLE)
	 (SET-DIFF-N (CDR BIG)
		     LITTLE N))
	(T (CONS (CAR BIG)
		 (SET-DIFF-N (CDR BIG)
			     LITTLE
			     (1- N))))))

(DEFUN SET-SIMPLIFY-CLAUSE-POT-LST (CL HEURISTIC-TYPE-ALIST)

;   We use the same basic pot list for all the calls REWRITE for a given
;   clause.  However, to keep from biting our tail, we must know which literals
;   each poly descends from and avoid the polys descending from the negation of
;   our current lit.  In order to keep track of which literals are being used
;   we set TYPE-ALIST to NIL before setting up the pot list, and use the
;   special hacks LITS-THAT-MAY-BE-ASSUMED-FALSE and HEURISTIC-TYPE-ALIST.  The
;   pot list we thus construct is immediately tested against CONTRADICTION to
;   see if CL is a consequence of linear.  However, the failure to use
;   everything we know has burned us here.  In particular, the type alist might
;   contain an equality that could be used as a rewrite rule to help us
;   establish the hypothesis of some needed lemma.  Imagine for example that
;   the clause contains b=a and p (a) as hyps and we need to prove p (b) to get
;   some lemma.  We try to handle this as follows.  After setting up
;   SIMPLIFY-CLAUSE-POT-LST -- the pot list we will use subsequently and which
;   has all the dependencies carefully tracked -- we go at the pot list again
;   with the ALL-NEW-FLG of ADD-TERMS-TO-POT-LST set to T.  This causes us to
;   treat every addend in the pot list as new and reconsider the adding of all
;   the lemmas.  If this produces CONTRADICTION, we win.  If not, we pretend we
;   did not do it -- since the resulting pot list has hidden dependencies in
;   it.

  (LET ((LITS-THAT-MAY-BE-ASSUMED-FALSE CL)
	(TYPE-ALIST NIL))
    (SETQ SIMPLIFY-CLAUSE-POT-LST (ADD-TERMS-TO-POT-LST CL NIL
							NIL NIL))
    (COND ((NOT (EQ SIMPLIFY-CLAUSE-POT-LST (QUOTE CONTRADICTION)))
	   (SETQ TYPE-ALIST HEURISTIC-TYPE-ALIST)
	   (COND ((EQ (ADD-TERMS-TO-POT-LST NIL SIMPLIFY-CLAUSE-POT-LST
					    NIL T)
		      (QUOTE CONTRADICTION))
		  (SETQ SIMPLIFY-CLAUSE-POT-LST (QUOTE CONTRADICTION))))))
    NIL))

(DEFUN SETTLED-DOWN-CLAUSE (CL HIST)
  (COND ((ASSOC-EQ (QUOTE SETTLED-DOWN-CLAUSE)
		   HIST)
	 NIL)
	(T (SETQ PROCESS-HIST NIL)
	   (SETQ PROCESS-CLAUSES (LIST CL))
	   T)))

(DEFUN SETTLED-DOWN-SENT (CL HIST)
  (EXECUTE (QUOTE SETTLED-DOWN-CLAUSE)
	   CL HIST (QUOTE SIMPLIFY-SENT)
	   (QUOTE ELIMINATE-DESTRUCTORS-SENT)))

(DEFUN SETUP (FORM CLAUSES LEMMAS)
  (SETQ ORIGTHM FORM)
  (SETQ EXPAND-LST HINTED-EXPANSIONS)
  (SETQ TERMS-TO-BE-IGNORED-BY-REWRITE NIL)
  (SETQ INDUCTION-HYP-TERMS NIL)
  (SETQ INDUCTION-CONCL-TERMS NIL)
  (SETQ ALL-LEMMAS-USED LEMMAS)
  (SETQ STACK NIL)
  (SETQ FNSTACK NIL)
  (SETQ LAST-PRINT-CLAUSES NIL)
  (SETQ TYPE-ALIST NIL)
  (SETQ LITS-THAT-MAY-BE-ASSUMED-FALSE NIL)
  (SETQ CURRENT-LIT 0)
  (SETQ CURRENT-ATM 0)
  (SETQ ANCESTORS NIL)
  (INIT-LEMMA-STACK)
  (INIT-LINEARIZE-ASSUMPTIONS-STACK)
  (SETQ LAST-PRINEVAL-CHAR (QUOTE |.|))
  (RANDOM-INITIALIZATION ORIGTHM)
  (IO (QUOTE SETUP)
      (LIST ORIGTHM)
      NIL CLAUSES LEMMAS))

(DEFUN SETUP-META-NAMES NIL
  (ADD-FACT (QUOTE MEANING)
	    (QUOTE LEMMAS)
	    (MAKE REWRITE-RULE (QUOTE MEANING)
		  NIL
		  (QUOTE MEANING-SIMPLIFIER)
		  NIL))
  (ADD-FACT (QUOTE FORMP)
	    (QUOTE LEMMAS)
	    (MAKE REWRITE-RULE (QUOTE FORMP)
		  NIL
		  (QUOTE FORMP-SIMPLIFIER)
		  NIL)))

(DEFUN SHELL-CONSTRUCTORP (TERM)
  (COND ((VARIABLEP TERM)
	 NIL)
	(T (ASSOC-EQ (FN-SYMB TERM)
		     SHELL-ALIST))))

(DEFUN SHELL-DESTRUCTOR-NESTP (VAR TERM)
  (COND ((VARIABLEP TERM)
	 (EQ VAR TERM))
	((FQUOTEP TERM)
	 NIL)
	(T (AND (ITERATE FOR POCKET IN SHELL-POCKETS
			 THEREIS (MEMBER-EQ (FFN-SYMB TERM)
					    (CDR POCKET)))
		(SHELL-DESTRUCTOR-NESTP VAR (FARGN TERM 1))))))

(DEFUN SHELL-OCCUR (TERM1 TERM2)

;   Returns T if TERM1 properly occurs in a nest of shells TERM2.  That is
;   whether TERM1 occurs as an arg at some depth in the shell TERM2, and that
;   the chain of shells from the occurrence to TERM1 all the way up to the top
;   of TERM2 is properly typed.  See the comment in SHELL-OCCUR1.  Does not
;   bother to do anything if TERM1 is a SHELLP, because (assuming the terms are
;   coming from EQUAL expressions) the two shells would be either different and
;   we wouldn't be here, or the same, in which case they would be rewritten.
;   At the moment the only fn to call SHELL-OCCUR is NOT-IDENT and we only use
;   NOT-IDENT to decide EQUALs or else one of the two terms is FALSE.

  (LET (TYPE-SET-TERM1)
    (COND ((SHELLP TERM1)
	   NIL)
	  ((VARIABLEP TERM2)
	   NIL)
	  ((FQUOTEP TERM2)
	   NIL)
	  ((ASSOC-EQ (FFN-SYMB TERM2)
		     SHELL-ALIST)
	   (SETQ TYPE-SET-TERM1 (TYPE-SET TERM1))
	   (ITERATE FOR ARG IN (FARGS TERM2) AS TR
		    IN (GET (FFN-SYMB TERM2)
			    (QUOTE TYPE-RESTRICTIONS))
		    THEREIS (AND (SETQ TEMP-TEMP
				       (SHELL-OCCUR1 TERM1 ARG))
				 (LOGSUBSETP TEMP-TEMP
					     (ACCESS TYPE-RESTRICTION
						     TYPE-SET TR)))))
	  (T NIL))))

(DEFUN SHELL-OCCUR1 (TERM1 TERM2)

;   This function wants to see whether TERM1 occurs as an arg to a shell in
;   TERM2.  However, because of type restrictions, one must not be fooled into
;   thinking that, for example, (ADD1 0) occurs inside of (ADD1 (CONS (ADD1 0)
;   NIL)) despite the fact that it occurs as an arg to a shell.  The basic idea
;   is that TERM1 must either be TERM2 or else must shell-occur inside the
;   shell TERM2 -- in a spot of the right type.  Thus, one way to compute it
;   would be to see if TERM1 shell-occurred in an arg position of shell TERM2
;   and if so to then determine if the typeset of the arg was suitable.
;   However, that would involve either a general purpose call on typeset or
;   else looking ahead to see whether the arg in which TERM1 occurred was
;   itself a shell -- in which case its typeset is just on its
;   type-prescription -- or was a TERM1 occurrence itself -- in which case a
;   full blown typeset is necessary.  Rather than do it that way we have fixed
;   SHELL-OCCUR1 so that it returns the typeset of TERM2 if an occurrence was
;   found, and otherwise NIL.

  (COND ((EQUAL TERM1 TERM2)
	 TYPE-SET-TERM1)
	((VARIABLEP TERM2)
	 NIL)
	((FQUOTEP TERM2)
	 NIL)
	((AND (ASSOC-EQ (FFN-SYMB TERM2)
			SHELL-ALIST)
	      (ITERATE FOR ARG IN (FARGS TERM2) AS TR
		       IN (GET (FFN-SYMB TERM2)
			       (QUOTE TYPE-RESTRICTIONS))
		       THEREIS (AND (SETQ TEMP-TEMP (SHELL-OCCUR1 TERM1 ARG))
				    (LOGSUBSETP TEMP-TEMP
						(ACCESS
						 TYPE-RESTRICTION
						 TYPE-SET TR)))))
	 (CAR (TYPE-PRESCRIPTION (FFN-SYMB TERM2))))
	(T NIL)))

(DEFUN SHELLP (TERM)
  (COND ((VARIABLEP TERM)
	 NIL)
	((FQUOTEP TERM)
	 T)
	(T (OR (MEMBER-EQ (FFN-SYMB TERM)
			  *1*BTM-OBJECTS)
	       (ASSOC-EQ (FFN-SYMB TERM)
			 SHELL-ALIST)))))

(DEFUN SIMPLIFY-CLAUSE (CURRENT-SIMPLIFY-CL HIST)

;   If T is returned, then the conjunction of PROCESS-CLAUSES implies
;   CURRENT-SIMPLIFY-CL.  Equivalently, if T is returned, then under the
;   assumption that CURRENT-SIMPLIFY-CL is F, CURRENT-SIMPLIFY-CL is equivalent
;   to the conjunction of PROCESS-CLAUSES.

;   Note that PROCESS-CLAUSES may be the facetious answer F, i.e., false
;   generalization may and does happen.  We know such tail biting can occur
;   through use of linear arithmetic.  We are uncertain whether it can occur
;   without use of linear arithmetic.  To make it happen with linear we just
;   need two slightly different versions of the same inequality literal.  The
;   poly arising from the second is used to rewrite the first to false and the
;   poly arising from the first -- which is still in the pot list -- is used to
;   rewrite the second to false.  LITS-TO-BE-IGNORED-BY-LINEAR actually
;   prevents this direct example from working -- the poly arising from the
;   first is ignored after its literal has been rewritten to false.  To
;   overcome this minor obstacle, it is necessary to cause the first literal to
;   be rewritten to something that will prove to be false eventually but isn't
;   syntactically F.

  (LET (ANS (TERMS-TO-BE-IGNORED-BY-REWRITE
	     TERMS-TO-BE-IGNORED-BY-REWRITE)
	    (EXPAND-LST EXPAND-LST))
    (PROG NIL
	  (COND ((SETQ TEMP-TEMP (ASSOC-EQ (QUOTE SETTLED-DOWN-CLAUSE)
					   HIST))

;   The clause has settled down under rewriting with the INDUCTION-HYP-TERMS
;   ignored and the INDUCTION-CONCL-TERMS forcibly expanded.  In general then
;   we now want to stop treating these terms specially and continue
;   simplifying.  However, there is a special case that will save a little
;   time.  Suppose that the clause just settled down -- that is, the most
;   recent HIST entry is the settled mark.  And suppose that none of the
;   specially treated terms occurs in the clause we're to simplify.  Then we
;   needn't simplify it again.  The first supposition is important.  Imagine
;   that the clause settled down long ago and we have done much since then.

		 (COND ((AND (EQ TEMP-TEMP (CAR HIST))
			     (ITERATE FOR TERM IN INDUCTION-HYP-TERMS
				      NEVER (DUMB-OCCUR-LST
					     TERM CURRENT-SIMPLIFY-CL)))

;   Since we know the INDUCTION-CONCL-TERMS couldn't occur in the clause --
;   they would have been expanded -- it suffices to check for just the hyp
;   terms.  This test should speed up base cases and the preinduction
;   simplification at least.

			(RETURN NIL))))
		(T

;   The clause has not yet settled down, so arrange to ignore
;   INDUCTION-HYP-TERMS during rewriting and to expand without question
;   INDUCTION-CONCL-TERMS.

		 (SETQ TERMS-TO-BE-IGNORED-BY-REWRITE
		       (APPEND INDUCTION-HYP-TERMS
			       TERMS-TO-BE-IGNORED-BY-REWRITE))
		 (SETQ EXPAND-LST (APPEND INDUCTION-CONCL-TERMS
					  EXPAND-LST))))
	  (INIT-LEMMA-STACK)
	  (PUSH-LEMMA-FRAME)
	  (SETQ PROCESS-CLAUSES (SIMPLIFY-CLAUSE0 CURRENT-SIMPLIFY-CL
						  HIST))
	  (SETQ PROCESS-HIST (ITERATE FOR X IN (POP-LEMMA-FRAME)
				      UNLESS (AND (CONSP X)
						  (ATOM (CAR X)))
				      COLLECT X))

;   The lemmas ignored are really literals from LITS-THAT-MAY-BE-ASSUMED-FALSE
;   that get put in by REWRITE-SOLIDIFY.  The identifying test for these
;   literals is not a simple CONSP because PROCESS-EQUATIONAL-POLYS puts in
;   some CONSP elements to encode its additions to the clause and we must
;   preserve them.

	  (ITERATE FOR X IN PROCESS-HIST UNLESS (OR (CONSP X)
						    (MEMBER-EQ X ALL-LEMMAS-USED))
		   DO (SETQ ALL-LEMMAS-USED (CONS X ALL-LEMMAS-USED)))
	  (RETURN (NOT (AND (= (LENGTH PROCESS-CLAUSES) 1)
			    (EQUAL (CAR PROCESS-CLAUSES)
				   CURRENT-SIMPLIFY-CL)))))))

(DEFUN SIMPLIFY-CLAUSE-MAXIMALLY (CURRENT-CL)
  (LET (SIMPLIFY-CLAUSE-MAXIMALLY-CLAUSES
	SIMPLIFY-CLAUSE-MAXIMALLY-HIST)
    (SIMPLIFY-CLAUSE-MAXIMALLY1 CURRENT-CL)
    (SETQ PROCESS-HIST SIMPLIFY-CLAUSE-MAXIMALLY-HIST)
    (SETQ PROCESS-CLAUSES SIMPLIFY-CLAUSE-MAXIMALLY-CLAUSES)
    (NOT (EQUAL PROCESS-CLAUSES (LIST CURRENT-CL)))))

(DEFUN SIMPLIFY-CLAUSE-MAXIMALLY1 (CL)
  (COND ((SIMPLIFY-CLAUSE CL NIL)
	 (ITERATE FOR X IN PROCESS-HIST
		  UNLESS (OR (CONSP X)
			     (MEMBER-EQ X SIMPLIFY-CLAUSE-MAXIMALLY-HIST))
		  DO (SETQ SIMPLIFY-CLAUSE-MAXIMALLY-HIST
			   (CONS X SIMPLIFY-CLAUSE-MAXIMALLY-HIST)))
	 (ITERATE FOR CL IN PROCESS-CLAUSES DO (SIMPLIFY-CLAUSE-MAXIMALLY1
						CL)))
	(T (SETQ SIMPLIFY-CLAUSE-MAXIMALLY-CLAUSES
		 (CONS CL SIMPLIFY-CLAUSE-MAXIMALLY-CLAUSES)))))

(DEFUN SIMPLIFY-CLAUSE0 (CL HIST)
  (PROG (TYPE-ALIST SIMPLIFY-CLAUSE-POT-LST CLS NEG-HYPS)
	(SETQ CL (REMOVE-TRIVIAL-EQUATIONS CL))
	(SETQ TYPE-ALIST (TYPE-ALIST-CLAUSE CL))
	(COND ((EQ (QUOTE CONTRADICTION)
		   TYPE-ALIST)
	       (RETURN NIL)))
	(SET-SIMPLIFY-CLAUSE-POT-LST CL TYPE-ALIST)
	(COND ((EQ SIMPLIFY-CLAUSE-POT-LST (QUOTE CONTRADICTION))
	       (SETQ CLS NIL))
	      (T (SETQ CLS (LIST (PROCESS-EQUATIONAL-POLYS
				  CL HIST
				  SIMPLIFY-CLAUSE-POT-LST)))))
	(COND ((NOT (AND (= (LENGTH CLS) 1)
			 (EQUAL (CAR CLS)
				CL)))
	       (PUSH-LEMMA (QUOTE ZERO))
	       (ITERATE FOR X IN LEMMAS-USED-BY-LINEAR DO (PUSH-LEMMA X))
	       (SETQ LINEAR-ASSUMPTIONS
		     (ITERATE FOR HYP IN LINEAR-ASSUMPTIONS
			      UNLESS (ITERATE FOR LIT IN CL
					      THEREIS (COMPLEMENTARYP HYP LIT))
			      COLLECT HYP))
	       (SETQ NEG-HYPS (ITERATE FOR HYP IN LINEAR-ASSUMPTIONS
				       COLLECT (DUMB-NEGATE-LIT HYP)))
	       (SETQ CLS (ITERATE FOR CL IN CLS
				  COLLECT (DISJOIN-CLAUSES NEG-HYPS CL)))
	       (ITERATE FOR TERM IN LINEAR-ASSUMPTIONS
			DO (SETQ CLS (CONS (CONS TERM CL)
					   CLS)))
	       (RETURN CLS))
	      (T (RETURN (SIMPLIFY-CLAUSE1 CL NIL NIL 1))))))

(DEFUN SIMPLIFY-CLAUSE1
  (TAIL NEW-CLAUSE LITS-TO-BE-IGNORED-BY-LINEAR I)

;   Returns a list of clauses whose conjunction is equivalent to the clause CL
;   formed by appending TAIL to NEW-CLAUSE under the hypothesis of the polys in
;   SIMPLIFY-CLAUSE-POT-LST and under the hypothesis that CL is false.

  (PROG (VAL SEGS TYPE-ALIST NEG-HYPS CURRENT-LIT CURRENT-ATM
	     BRANCHES)
	(COND
	 ((NULL TAIL)
	  (RETURN (LIST NEW-CLAUSE)))
	 (T (PRINT-TO-DISPLAY (QUOTE SIMPLIFY-CLAUSE)
			      I NIL)
	    (SETQ CURRENT-LIT (SETQ CURRENT-ATM (CAR TAIL)))
	    (MATCH CURRENT-ATM (NOT CURRENT-ATM))
	    (SETQ LITS-TO-BE-IGNORED-BY-LINEAR
		  (CONS CURRENT-LIT LITS-TO-BE-IGNORED-BY-LINEAR))
	    (SETQ FNSTACK NIL)
	    (SETQ TYPE-ALIST (TYPE-ALIST-CLAUSE NEW-CLAUSE))
	    (COND ((EQ TYPE-ALIST (QUOTE CONTRADICTION))
		   (RETURN NIL)))
	    (SETQ TYPE-ALIST (TYPE-ALIST-CLAUSE (CDR TAIL)))
	    (COND ((EQ TYPE-ALIST (QUOTE CONTRADICTION))
		   (RETURN NIL)))
	    (INIT-LINEARIZE-ASSUMPTIONS-STACK)
	    (PUSH-LINEARIZE-ASSUMPTIONS-FRAME)
	    (SETQ VAL (REWRITE CURRENT-ATM NIL TYPE-ALIST
			       (QUOTE ?)
			       (QUOTE IFF)
			       NIL))
	    (COND ((NOT (EQ CURRENT-LIT CURRENT-ATM))
		   (SETQ VAL (NEGATE-LIT VAL))))
	    (SETQ LINEAR-ASSUMPTIONS (POP-LINEARIZE-ASSUMPTIONS-FRAME))
	    (SETQ NEG-HYPS (ITERATE FOR HYP IN LINEAR-ASSUMPTIONS
				    COLLECT (NEGATE-LIT HYP)))
	    (SETQ BRANCHES (CLAUSIFY VAL))
	    (SETQ SEGS
		  (CONJOIN-CLAUSE-SETS
		   (ITERATE FOR SEG IN BRANCHES
			    COLLECT (DISJOIN-CLAUSES NEG-HYPS SEG))
		   (ITERATE FOR HYP IN LINEAR-ASSUMPTIONS
			    WITH CL  = (ADD-LITERAL (PEGATE-LIT CURRENT-LIT)
						    NIL NIL)
			    COLLECT (ADD-LITERAL HYP CL NIL))))
	    (RETURN (ITERATE FOR SEG IN SEGS
			     NCONC
			     (SIMPLIFY-CLAUSE1
			      (CDR TAIL)
			      (APPEND NEW-CLAUSE SEG)
			      (COND ((EQUAL BRANCHES
					    (QUOTE (NIL)))
				     LITS-TO-BE-IGNORED-BY-LINEAR)
				    (T (CDR
					LITS-TO-BE-IGNORED-BY-LINEAR)))
			      (1+ I))))))))

(DEFUN SIMPLIFY-LOOP (CLAUSES)

;   This function just serves as a target for the RETFROM in STORE-SENT in the
;   event that we are working on the original input and find that we have split
;   it into more than one goal and want to back up and use induction on the
;   input term.

  (CATCH (QUOTE SIMPLIFY-LOOP)
    (ITERATE FOR CURRENT-CL IN CLAUSES DO
	     (SIMPLIFY-SENT CURRENT-CL NIL))))

(DEFUN SIMPLIFY-SENT (CL HIST)
  (EXECUTE (QUOTE SIMPLIFY-CLAUSE)
	   CL HIST (QUOTE SIMPLIFY-SENT)
	   (QUOTE SETTLED-DOWN-SENT)))

(DEFUN SINGLETON-CONSTRUCTOR-TO-RECOGNIZER (FNNAME)
  (COND ((SETQ TEMP-TEMP (ASSOC-EQ FNNAME SHELL-ALIST))
	 (SETQ TEMP-TEMP (ASH 1 (CDR TEMP-TEMP)))
	 (COND ((MEMBER-EQUAL TEMP-TEMP SINGLETON-TYPE-SETS)
		(CAR (ITERATE FOR PAIR IN RECOGNIZER-ALIST
			      WHEN (EQUAL TEMP-TEMP (CDR PAIR))
			      DO (RETURN PAIR))))
	       (T NIL)))
	(T NIL)))

(DEFUN SKO-DEST-NESTP (TERM DEEPFLG)
  (COND ((VARIABLEP TERM)
	 T)
	((FQUOTEP TERM)
	 NIL)
	((AND (SETQ TEMP-TEMP (GET (FFN-SYMB TERM)
				   (QUOTE ELIMINATE-DESTRUCTORS-SEQ)))
	      (NOT (DISABLEDP (ACCESS REWRITE-RULE NAME TEMP-TEMP))))
	 (COND (DEEPFLG (ITERATE FOR X IN (FARGS TERM)
				 ALWAYS (SKO-DEST-NESTP X DEEPFLG)))
	       (T (ITERATE FOR X IN (FARGS TERM) ALWAYS (VARIABLEP X)))))
	(T NIL)))

(DEFUN SMART-ASSUME-TRUE-FALSE (TERM)

;   The difference between this function and the primitive ASSUME-TRUE-FALSE
;   is that we here know about compound recognizers and push names onto
;   the lemma stack.  Don't use this function unless there is a PUSH-LEMMA-FRAME
;   provided during the running.

  (PROG (FN A TSA TPAIR FPAIR NEG-FLG)
	(ASSUME-TRUE-FALSE TERM)
	(COND ((AND (NULL TRUE-COMPOUND-RECOGNIZER-ALIST)
		    (NULL FALSE-COMPOUND-RECOGNIZER-ALIST))

;   If there are no compound recognizers yet, don't waste any further time.
;   Probably there will many many times when compound recognizers are not
;   around.

	       (RETURN NIL))
	      ((OR MUST-BE-TRUE MUST-BE-FALSE)

;   If the test is already decided, don't change the type alists.  There is
;   a question here.  Perhaps (BOOLP A) is known to be true by some mechanism
;   that didn't put (A . bool) on the type alist.  If so, we'll lose the chance
;   to add it.
	      
	       (RETURN NIL)))

;   We now strip off the NOT that may be present.  By so negating the
;   TERM we are considering we must also swap the roles of TRUE- and
;   FALSE-TYPE-ALIST, which were set up for the other parity.  Henceforth,
;   any exit from this fn must consider NEG-FLG.  We therefore always exit
;   through the label EXIT below.

	(COND ((MATCH TERM (NOT TERM))
	       (SWAP TRUE-TYPE-ALIST FALSE-TYPE-ALIST)
	       (SETQ NEG-FLG T)))

	(COND ((OR (VARIABLEP TERM)
		   (FQUOTEP TERM)
		   (NOT (MATCH TERM (LIST FN A)))
		   (PROGN (SETQ TPAIR (ASSOC-EQ FN TRUE-COMPOUND-RECOGNIZER-ALIST))
			  (SETQ FPAIR (ASSOC-EQ FN FALSE-COMPOUND-RECOGNIZER-ALIST))
			  (COND ((AND TPAIR (DISABLEDP (CDDR TPAIR)))
				 (SETQ TPAIR NIL)))
			  (COND ((AND FPAIR (DISABLEDP (CDDR FPAIR)))
				 (SETQ FPAIR NIL)))
			  (AND (NULL TPAIR) (NULL FPAIR))))

;   If TERM is not of the form (fn a), where fn is a compound recognizer of
;   one parity of the other, then leave the type alists alone.

	       (GO EXIT)))

;   If we get here one or both of TPAIR and FPAIR is set to the available
;   compound recognizer facts.  We will deal with the two type alists in
;   turn, augmenting either according to whether we have a compound recognizer
;   fact of the appropriate parity.  Conceivably, either may lead to a
;   contradiction, in which case we set the MUST-BE-TRUE or -FALSE flag
;   and NIL out the alists.  Here is how it can happen.  Suppose we know
;   about BOOLP as a compound recognizer but have it disabled.  Suppose we
;   are proving (IF (LISTP A) (IF (BOOLP A) F T) T).  Then when we assume
;   the BOOLP with the primitive ASSUME-TRUE-FALSE nothing inconsistent is
;   detected.  But with the smart one we are forced to conclude that the
;   type set of A is empty, which is a contradiction.

        (SETQ TSA (TYPE-SET A))

;   If either TPAIR or FPAIR lets us set MUST-BE-TRUE or -FALSE then
;   do it.  It would be prettier code to consider TPAIR (jumping to
;   EXIT if necessary) and then consider FPAIR.  But that may cause us
;   to PUSH-LEMMA the TPAIR name only to discover that the FPAIR lets
;   us decide the test.

	(COND ((AND TPAIR (= 0 (LOGAND TSA (CADR TPAIR))))
	       (SETQ MUST-BE-FALSE T)
	       (PUSH-LEMMA (CDDR TPAIR))
	       (GO EXIT))
	      ((AND FPAIR (= 0 (LOGAND TSA (CADR FPAIR))))
	       (SETQ MUST-BE-TRUE T)
	       (PUSH-LEMMA (CDDR FPAIR))
	       (GO EXIT)))

;   Now we augment TRUE-TYPE-ALIST if we have a TPAIR and do the symmetric
;   thing for FALSE-TYPE-ALIST.  We push the name of the compound recognizer
;   lemmas used.  Note that the type set information added may not actually
;   contribute anything to the proof.  But we won't be able to tell.

	(COND (TPAIR
	       (PUSH-LEMMA (CDDR TPAIR))
	       (SETQ TRUE-TYPE-ALIST
		     (CONS (CONS A (LOGAND TSA (CADR TPAIR)))
			   TRUE-TYPE-ALIST))))
	(COND (FPAIR
	       (PUSH-LEMMA (CDDR FPAIR)) 
	       (SETQ FALSE-TYPE-ALIST
		     (CONS (CONS A (LOGAND TSA (CADR FPAIR)))
			   FALSE-TYPE-ALIST))))
	EXIT
	(COND (NEG-FLG (SWAP MUST-BE-TRUE MUST-BE-FALSE)
		       (SWAP TRUE-TYPE-ALIST FALSE-TYPE-ALIST)))
	(RETURN NIL)))

(DEFUN SOME-SUBTERM-WORSE-THAN-OR-EQUAL (TERM1 TERM2)

;   Returns T if some subterm of TERM1 is WORSE-THAN or EQUAL to TERM2 itself.

  (COND
   ((VARIABLEP TERM1)
    (EQ TERM1 TERM2))
   ((OR (EQUAL TERM1 TERM2)
	(QUICK-WORSE-THAN TERM1 TERM2))
    T)
   ((FQUOTEP TERM1)
    NIL)
   (T (ITERATE FOR ARG IN (FARGS TERM1)
	       THEREIS (SOME-SUBTERM-WORSE-THAN-OR-EQUAL ARG TERM2)))))

(DEFUN SORT-DESTRUCTOR-CANDIDATES (LST)

;   Each element of LST is a list of NVARIABLEP nonQUOTEP terms.  We sort them
;   into descending order according to the sum of the level numbers of the fn
;   symbols of the terms in the CDR of each element.

  (UNSTABLE-SORT LST
		 (FUNCTION (LAMBDA (X Y)
			     (> (ITERATE FOR TERM IN (CDR X)
					 SUM (GET-LEVEL-NO (FFN-SYMB TERM)))
				(ITERATE FOR TERM IN (CDR Y)
					 SUM (GET-LEVEL-NO (FFN-SYMB TERM))))))))

(DEFUN SOUND-IND-PRIN-MASK
  (TERM JUSTIFICATION FORMALS QUICK-BLOCK-INFO)

;   TERM is a term we are considering doing induction for.  JUSTIFICATION is
;   one of the justifications associated with the function symbol of TERM.
;   FORMALS is the formals list of the fn and QUICK-BLOCK-INFO is the obvious.
;   JUSTIFICATION and the machine for fn describe an induction.  We wish to
;   determine, in the terminology of ACL, whether the induction applies to
;   TERM.  If so we return a mask indicating how to build the substitutions for
;   the induction from TERM and the machine for fn.  Otherwise we return NIL.

;   Let the changeables be those actuals of TERM that are in the measured
;   subset of JUSTIFICATION and that sometimes change in the recursion.  Let
;   the unchangeables be all of the variables occurring in measured actuals
;   that never change in recursion.  The induction applies if changeables is a
;   sequence of distinct variable names and has an empty intersection with
;   unchangeables.

;   If the induction is applicable then the substitutions should substitute for
;   the changeables just as the recursion would, and hold each unchangeable
;   fixed -- i.e., substitute each for itself.  With such substitutions it is
;   possible to prove the measure lemmas analogous to those proved in
;   JUSTIFICATION, except that the measure is obtained by instantiating the
;   measure term used in the justification by the measured actuals in
;   unchanging slots.  Actual variables that are neither among the changeables
;   or unchangeables may be substituted for arbitrarily.

;   If the induction is applicable we return a mask with as many elements as
;   there are actuals.  For each actual the mask contains either CHANGEABLE,
;   UNCHANGEABLE, or NIL.  CHANGEABLE means the actual should be instantiated
;   as specified in the recursion.  UNCHANGEABLE means each var in the actual
;   should be held fixed.  NIL means that the corresponding substitution pairs
;   in the machine for the function should be ignored.

;   Abstractly, this function builds the mask by first putting either
;   CHANGEABLE or UNCHANGEABLE in each measured slot.  It then fills in the
;   remaining slots from the left so as to permit the actual to be instantiated
;   or held fixed as desired by the recursion, provided that in so doing it
;   does not permit substitutions for previously allocated actuals.

  (PROG (UNCHANGEABLES SUBSET CHANGEABLES)
	(SETQ SUBSET (ACCESS JUSTIFICATION SUBSET JUSTIFICATION))
	(SETQ UNCHANGEABLES (ITERATE FOR ACTUAL IN (FARGS TERM) AS VAR
				     IN FORMALS AS Q IN QUICK-BLOCK-INFO
				     WITH ITERATE-ANS
				     WHEN (AND (MEMBER-EQ VAR SUBSET)
					       (EQ Q (QUOTE UNCHANGING)))
				     DO (SETQ ITERATE-ANS
					      (UNION-EQ (ALL-VARS ACTUAL)
							ITERATE-ANS))
				     FINALLY (RETURN ITERATE-ANS)))
	(SETQ CHANGEABLES (ITERATE FOR ACTUAL IN (FARGS TERM) AS VAR
				   IN FORMALS AS Q IN QUICK-BLOCK-INFO
				   WHEN (AND (MEMBER-EQ VAR SUBSET)
					     (NOT (EQ Q (QUOTE UNCHANGING))))
				   COLLECT ACTUAL))
	(COND ((OR (NOT (NO-DUPLICATESP CHANGEABLES))
		   (ITERATE FOR X IN CHANGEABLES THEREIS (NVARIABLEP X))
		   (INTERSECTP CHANGEABLES UNCHANGEABLES))
	       (RETURN NIL)))
	(RETURN (ITERATE FOR ACTUAL IN (FARGS TERM) AS Q
			 IN QUICK-BLOCK-INFO AS VAR IN FORMALS
			 COLLECT (COND ((MEMBER-EQ VAR SUBSET)
					(COND ((EQ Q (QUOTE UNCHANGING))
					       (QUOTE UNCHANGEABLE))
					      (T (QUOTE CHANGEABLE))))
				       ((AND (VARIABLEP ACTUAL)
					     (EQ Q (QUOTE UNCHANGING)))
					(COND ((MEMBER-EQ ACTUAL CHANGEABLES)
					       NIL)
					      (T (SETQ UNCHANGEABLES
						       (ADD-TO-SET ACTUAL
								   UNCHANGEABLES))
						 (QUOTE UNCHANGEABLE))))
				       ((AND (VARIABLEP ACTUAL)
					     (NOT (MEMBER-EQ ACTUAL CHANGEABLES))
					     (NOT (MEMBER-EQ ACTUAL UNCHANGEABLES)))
					(SETQ CHANGEABLES
					      (CONS ACTUAL CHANGEABLES))
					(QUOTE CHANGEABLE))
				       (T NIL))))))

(DEFUN STACK-DEPTH (STK)
  (ITERATE WHILE STK COUNT (SETQ STK (CADR STK))))

(DEFUN START-STATS NIL
  (SETQ PROVE-TIME 0)
  (SETQ ELAPSED-TIME (TIME-IN-60THS))
  (SETQ IO-TIME 0))

(DEFUN STOP-STATS NIL
  (LET (M-TIME P-TIME I-TIME)
    (SETQ M-TIME
	  (/
	   (- (- (TIME-IN-60THS)
		 ELAPSED-TIME)
	      (+ PROVE-TIME IO-TIME))
	   60.0))
    (SETQ P-TIME
	  (/ PROVE-TIME 60.0))
    (SETQ I-TIME
	  (/ IO-TIME 60.0))
    (PRINT-STATS M-TIME P-TIME I-TIME PROVE-FILE)
    (SETQ TOTAL-MISC-TIME (+ TOTAL-MISC-TIME M-TIME))
    (SETQ TOTAL-PROVE-TIME (+ TOTAL-PROVE-TIME P-TIME))
    (SETQ TOTAL-IO-TIME (+ TOTAL-IO-TIME I-TIME))))

(DEFUN STORE-SENT (CL HIST)
  (LET (CL-SET)
    (COND ((NULL CL)
	   (IO (QUOTE STORE-SENT)
	       CL HIST NIL (LIST (GET-STACK-NAME STACK)))
	   (WRAPUP NIL))
	  (DO-NOT-USE-INDUCTION-FLG
	   (IO (QUOTE STORE-SENT)
	       CL HIST NIL (LIST (GET-STACK-NAME STACK)
				 (QUOTE QUIT)))
	   (WRAPUP NIL))
	  ((AND
	    (NOT (AND IN-PROVE-LEMMA-FLG
		      (ASSOC-EQ (QUOTE INDUCT)
				HINTS)))
	    (OR
	     (AND
	      (NULL STACK)
	      (ITERATE FOR X IN HIST
		       THEREIS
		       (NOT
			(MEMBER-EQ (CAR X)
				   (QUOTE (SETTLED-DOWN-CLAUSE
					   SIMPLIFY-CLAUSE
					   SETUP))))))
	     (AND STACK (NOT (ASSOC-EQ (QUOTE BEING-PROVED)
				       STACK)))))

;   Abort and push the input clause to work on if (a) this is the first time
;   we've ever pushed anything and we've done anything to the input other than
;   simplify it, or (b) we have not yet gone into the first induction for the
;   original conjecture but have already pushed one simplified subgoal.

	   (SETQ STACK NIL)
	   (SETQ CL-SET (CNF-DNF THM (QUOTE C)))

;   Once upon a time we backed up to the output of PREPROCESS in PROVE.
;   However, PREPROCESS -- and CLAUSIFY-INPUT -- applies unconditional rewrite
;   rules and we want the ability as users to type in exactly what the system
;   inducts on.  The theorem that PREPROCESS screwed us on was HACK1 when it
;   distributed TIMES and GCD.

	   (IO (QUOTE STORE-SENT)
	       CL NIL NIL (LIST (GET-STACK-NAME STACK)
				CL-SET))
	   (PUSH-CLAUSE-SET CL-SET)
	   (THROW (QUOTE SIMPLIFY-LOOP)
		  NIL))
	  (T (SETQ CL-SET (LIST CL))
	     (IO (QUOTE STORE-SENT)
		 CL HIST NIL (LIST (GET-STACK-NAME STACK)))
	     (PUSH-CLAUSE-SET CL-SET)))))

(DEFUN STRIP-BRANCHES (TERM)
  (LET (CL)
    (ITERATE FOR PAIR
	     IN (COND ((MATCH TERM (NOT TERM))
		       (STRIP-BRANCHES1 TERM T T))
		      (T (STRIP-BRANCHES1 TERM T NIL)))
	     UNLESS (EQUAL (SETQ CL
				 (ADD-LITERAL
				  (PEGATE-LIT (CAR PAIR))
				  (CDR PAIR)
				  T))
			   TRUE-CLAUSE)
	     COLLECT CL)))

(DEFUN STRIP-BRANCHES1 (TERM TOPFLG NEGATE-FLG)
  (LET (ANS1 ANS2 ANS3 ANS LST NEW-CL)
    (COND ((VARIABLEP TERM)
	   (LIST (CONS (COND (NEGATE-FLG (NEGATE-LIT TERM))
			     (T TERM))
		       NIL)))
	  ((FQUOTEP TERM)
	   (COND (TOPFLG (COND ((EQUAL TERM FALSE)
				(COND (NEGATE-FLG NIL)
				      (T (LIST (CONS FALSE NIL)))))
			       (NEGATE-FLG (LIST (CONS FALSE NIL)))
			       (T NIL)))
		 (NEGATE-FLG (LIST (CONS (COND ((EQUAL TERM FALSE)
						TRUE)
					       (T FALSE))
					 NIL)))
		 (T (LIST (CONS TERM NIL)))))
	  ((EQ (FFN-SYMB TERM)
	       (QUOTE IF))
	   (COND ((AND TOPFLG (OR (AND (NOT NEGATE-FLG)
				       (EQUAL (FARGN TERM 3)
					      FALSE))
				  (AND NEGATE-FLG
				       (EQUAL (FARGN TERM 3)
					      TRUE))))
		  (APPEND
		   (ITERATE FOR PAIR IN (STRIP-BRANCHES1 (FARGN TERM 1)
							 TOPFLG NIL)
			    UNLESS (EQUAL (SETQ NEW-CL
						(ADD-LITERAL
						 (PEGATE-LIT (CAR PAIR))
						 (CDR PAIR)
						 T))
					  TRUE-CLAUSE)
			    COLLECT (CONS FALSE NEW-CL))
		   (STRIP-BRANCHES1 (FARGN TERM 2)
				    TOPFLG NEGATE-FLG)))
		 ((AND TOPFLG (OR (AND (NOT NEGATE-FLG)
				       (EQUAL (FARGN TERM 2)
					      FALSE))
				  (AND NEGATE-FLG
				       (EQUAL (FARGN TERM 2)
					      TRUE))))
		  (APPEND
		   (ITERATE FOR PAIR IN (STRIP-BRANCHES1 (FARGN TERM 1)
							 TOPFLG T)
			    UNLESS (EQUAL (SETQ NEW-CL
						(ADD-LITERAL
						 (PEGATE-LIT (CAR PAIR))
						 (CDR PAIR)
						 T))
					  TRUE-CLAUSE)
			    COLLECT (CONS FALSE NEW-CL))
		   (STRIP-BRANCHES1 (FARGN TERM 3)
				    TOPFLG NEGATE-FLG)))
		 (T
		  (SETQ ANS1 (STRIP-BRANCHES1 (FARGN TERM 1)
					      NIL NIL))
		  (SETQ ANS2 (STRIP-BRANCHES1 (FARGN TERM 2)
					      TOPFLG NEGATE-FLG))
		  (SETQ ANS3 (STRIP-BRANCHES1 (FARGN TERM 3)
					      TOPFLG NEGATE-FLG))
		  (ITERATE FOR PAIR IN ANS1
			   DO
			   (ITERATE FOR PAIR2 IN ANS2
				    UNLESS
				    (EQUAL
				     (CDR
				      (SETQ ANS
					    (CONS
					     (CAR PAIR2)
					     (DISJOIN-CLAUSES
					      (CDR PAIR)
					      (ADD-LITERAL
					       (NEGATE-LIT (CAR PAIR))
					       (CDR PAIR2)
					       NIL)))))
				     TRUE-CLAUSE)
				    DO (SETQ LST (CONS ANS LST)))
			   (ITERATE FOR PAIR3 IN ANS3
				    UNLESS
				    (EQUAL
				     (CDR
				      (SETQ ANS
					    (CONS
					     (CAR PAIR3)
					     (DISJOIN-CLAUSES
					      (CDR PAIR)
					      (ADD-LITERAL
					       (PEGATE-LIT (CAR PAIR))
					       (CDR PAIR3)
					       NIL)))))
				     TRUE-CLAUSE)
				    DO (SETQ LST (CONS ANS LST))))
		  LST)))
	  (T
	   (ITERATE FOR PICK
		    IN (ALL-PICKS (ITERATE FOR ARG IN (FARGS TERM)
					   COLLECT (STRIP-BRANCHES1 ARG NIL
								    NIL)))
		    COLLECT
		    (CONS (COND (NEGATE-FLG
				 (DUMB-NEGATE-LIT
				  (SCONS-TERM (FFN-SYMB TERM)
					      (ITERATE FOR PAIR IN PICK
						       COLLECT (CAR PAIR)))))
				(T (SCONS-TERM (FFN-SYMB TERM)
					       (ITERATE FOR PAIR IN PICK
							COLLECT (CAR PAIR)))))
			  (ITERATE FOR PAIR IN PICK
				   WITH ANS
				   UNTIL (EQUAL ANS TRUE-CLAUSE)
				   DO (SETQ ANS (DISJOIN-CLAUSES (CDR PAIR) ANS))
				   FINALLY (RETURN ANS))))))))

(DEFUN SUB-SEQUENCEP (SMALLER LARGER)
  (COND ((ATOM SMALLER)
	 T)
	((ATOM LARGER)
	 NIL)
	((EQUAL (CAR SMALLER)
		(CAR LARGER))
	 (SUB-SEQUENCEP (CDR SMALLER)
			(CDR LARGER)))
	(T (SUB-SEQUENCEP SMALLER (CDR LARGER)))))

(DEFUN SUBBAGP (BAG1 BAG2)
  (COND ((ATOM BAG1)
	 T)
	((ATOM BAG2)
	 NIL)
	((MEMBER-EQUAL (CAR BAG1)
		       BAG2)
	 (SUBBAGP (CDR BAG1)
		  (DELETE1 (CAR BAG1)
			   BAG2)))
	(T NIL)))

(DEFUN SUBLIS-EXPR (ALIST FORM)
  (ITERATE FOR PAIR IN ALIST DO (COND ((QUOTEP (CAR PAIR))
				       (SUBST-EXPR-ERROR1 (CAR PAIR)))))
  (SUBLIS-EXPR1 ALIST FORM))

(DEFUN SUBLIS-EXPR1 (ALIST FORM)
  (COND ((SETQ TEMP-TEMP (ASSOC-EQUAL FORM ALIST))
	 (CDR TEMP-TEMP))
	((VARIABLEP FORM)
	 FORM)
	((FQUOTEP FORM)
	 FORM)
	(T (CONS-TERM (FFN-SYMB FORM)
		      (ITERATE FOR ARG IN (FARGS FORM)
			       COLLECT (SUBLIS-EXPR1 ALIST ARG))))))

(DEFUN SUBLIS-VAR (ALIST FORM)

;   In REWRITE-WITH-LEMMAS we use this function with the NIL alist to put FORM
;   into quote normal form.  Do not optimize this function for the NIL alist.

  (COND ((VARIABLEP FORM)
	 (COND ((SETQ TEMP-TEMP (ASSOC-EQ FORM ALIST))
		(CDR TEMP-TEMP))
	       (T FORM)))
	((FQUOTEP FORM)
	 FORM)
	(T (CONS-TERM (FFN-SYMB FORM)
		      (ITERATE FOR ARG IN (FARGS FORM)
			       COLLECT (SUBLIS-VAR ALIST ARG))))))

(DEFUN SUBLIS-VAR-LST (ALIST TERMLST)
  (ITERATE FOR TERM IN TERMLST COLLECT (SUBLIS-VAR ALIST TERM)))

(DEFUN SUB-PAIR-EXPR (OLDLST NEWLST TERM)
  (ITERATE FOR X IN OLDLST DO (COND ((QUOTEP X)
				     (SUBST-EXPR-ERROR1 X))))
  (SUB-PAIR-EXPR1 OLDLST NEWLST TERM))

(DEFUN SUB-PAIR-EXPR-LST (OLDLST NEWLST LST)
  (ITERATE FOR X IN LST COLLECT (SUB-PAIR-EXPR OLDLST NEWLST X)))

(DEFUN SUB-PAIR-EXPR1 (OLDLST NEWLST TERM)
  (COND ((ITERATE FOR OLD1 IN OLDLST AS NEW1 IN NEWLST
		  THEREIS (COND ((EQUAL OLD1 TERM)
				 (SETQ TEMP-TEMP NEW1)
				 T)
				(T NIL)))
	 TEMP-TEMP)
	((VARIABLEP TERM)
	 TERM)
	((FQUOTEP TERM)
	 TERM)
	(T (CONS-TERM (FFN-SYMB TERM)
		      (ITERATE FOR ARG IN (FARGS TERM)
			       COLLECT (SUB-PAIR-EXPR1 OLDLST NEWLST ARG))))))

(DEFUN SUB-PAIR-VAR (OLDLST NEWLST TERM)
  (COND ((VARIABLEP TERM)
	 (COND ((ITERATE FOR OLD1 IN OLDLST AS NEW1 IN NEWLST
			 THEREIS (COND ((EQ OLD1 TERM)
					(SETQ TEMP-TEMP NEW1)
					T)
				       (T NIL)))
		TEMP-TEMP)
	       (T TERM)))
	((FQUOTEP TERM)
	 TERM)
	(T (CONS-TERM (FFN-SYMB TERM)
		      (ITERATE FOR ARG IN (FARGS TERM)
			       COLLECT (SUB-PAIR-VAR OLDLST NEWLST ARG))))))

(DEFUN SUB-PAIR-VAR-LST (OLDLST NEWLST LST)
  (ITERATE FOR X IN LST COLLECT (SUB-PAIR-VAR OLDLST NEWLST X)))

(DEFUN SUBSETP-EQ (X Y)
  (ITERATE FOR ELE IN X ALWAYS (MEMBER-EQ ELE Y)))

(DEFUN SUBSETP-EQUAL (X Y)
  (ITERATE FOR ELE IN X ALWAYS (MEMBER-EQUAL ELE Y)))

(DEFUN SUBST-EXPR (NEW OLD FORM)
  (COND ((VARIABLEP OLD)
	 (SUBST-VAR NEW OLD FORM))
	((FQUOTEP OLD)
	 (SUBST-EXPR-ERROR1 OLD))
	(T (SUBST-EXPR1 NEW OLD FORM))))

(DEFUN SUBST-EXPR-ERROR1 (OLD)
  (ERROR1 (PQUOTE (PROGN |Attempt| |to| |substitute| |for| |the| |explicit|
			 |constant| (!PPR OLD NIL)
			 |.| |the| |substitution| |functions| |were| |optimized|
			 |to| |disallow| |this| |.|))
	  (BINDINGS (QUOTE OLD)
		    OLD)
	  (QUOTE HARD)))

(DEFUN SUBST-EXPR-LST (NEW OLD LST)
  (ITERATE FOR X IN LST COLLECT (SUBST-EXPR NEW OLD X)))

(DEFUN SUBST-EXPR1 (NEW OLD FORM)
  (COND ((EQUAL OLD FORM)
	 NEW)
	((VARIABLEP FORM)
	 FORM)
	((FQUOTEP FORM)
	 FORM)
	(T (CONS-TERM (FFN-SYMB FORM)
		      (ITERATE FOR ARG IN (FARGS FORM)
			       COLLECT (SUBST-EXPR1 NEW OLD ARG))))))

(DEFUN SUBST-FN (NEW OLD TERM)

;   Replaces calls of OLD with calls of NEW.  Assumes both have same arity and
;   that neither is a shell constructor or bottom object.

  (COND ((VARIABLEP TERM)
	 TERM)
	((FQUOTEP TERM)
	 TERM)
	((EQ OLD (FFN-SYMB TERM))
	 (FCONS-TERM NEW (ITERATE FOR ARG IN (FARGS TERM)
				  COLLECT (SUBST-FN NEW OLD ARG))))
	(T (FCONS-TERM (FFN-SYMB TERM)
		       (ITERATE FOR ARG IN (FARGS TERM)
				COLLECT (SUBST-FN NEW OLD ARG))))))

(DEFUN SUBST-VAR (NEW OLD FORM)
  (COND ((VARIABLEP FORM)
	 (COND ((EQ FORM OLD)
		NEW)
	       (T FORM)))
	((FQUOTEP FORM)
	 FORM)
	(T (CONS-TERM (FFN-SYMB FORM)
		      (ITERATE FOR ARG IN (FARGS FORM)
			       COLLECT (SUBST-VAR NEW OLD ARG))))))

(DEFUN SUBST-VAR-LST (NEW OLD TERMLST)
  (ITERATE FOR TERM IN TERMLST COLLECT (SUBST-VAR NEW OLD TERM)))

(DEFUN SUBSTITUTE-EXPR (NEW OLD FORM)
  (COND ((VARIABLEP OLD)
	 (SUBST-VAR NEW OLD FORM))
	(T (SUBST-EXPR NEW OLD FORM))))

(DEFUN SUBSUMES (CL1 CL2)
  (LET (UNIFY-SUBST)
    (SUBSUMES1 CL1)))

(DEFUN SUBSUMES-REWRITE-RULE (REWRITE-RULE1 REWRITE-RULE2)
  (LET (UNIFY-SUBST (CL2 (ACCESS REWRITE-RULE HYPS REWRITE-RULE2)))
    (AND (ONE-WAY-UNIFY1 (ACCESS REWRITE-RULE CONCL
				 REWRITE-RULE1)
			 (ACCESS REWRITE-RULE CONCL
				 REWRITE-RULE2))
	 (SUBSUMES1 (ACCESS REWRITE-RULE HYPS REWRITE-RULE1)))))

(DEFUN SUBSUMES1 (CL1)

;   Also called by SUBSUMES-SEQ.

  (COND ((NULL CL1)
	 T)
	(T (ITERATE FOR LIT IN CL2 THEREIS (SUBSUMES11 LIT CL1 UNIFY-SUBST)))))

(DEFUN SUBSUMES11 (LIT CL1 UNIFY-SUBST)
  (AND (ONE-WAY-UNIFY1 (CAR CL1)
		       LIT)
       (SUBSUMES1 (CDR CL1))))

(DEFUN SUM-STATS-ALIST (ALIST)
  (ITERATE FOR X IN ALIST SUM (CADR X) INTO MISC
	   SUM (CADDR X) INTO PROVE
	   SUM (CADDDR X) INTO IO 
	   FINALLY (RETURN (LIST MISC PROVE IO))))

(DEFUN TABULATE (N FILE)
  (ISPACES (- N (IPOSITION FILE NIL NIL)) FILE))

(DEFUN TERM-ORDER (TERM1 TERM2)

;   A simple -- or complete or total -- ordering is a relation satisfying:
;   "antisymmetric" XrY & YrX -> X=Y, "transitive" XrY & Y&Z -> XrZ, and
;   "trichotomy" XrY v YrX.  A partial order weakens trichotomy to "reflexive"
;   XrX.

;   TERM-ORDER is a simple ordering on terms.  (TERM-ORDER TERM1 TERM2) if and
;   only if (a) the number of occurrences of variables in TERM1 is strictly
;   less than the number in TERM2, or (b) the numbers of variable occurrences
;   are equal and the FORM-COUNT of TERM1 is strictly less than that of TERM2,
;   or (c) the numbers of variable occurrences are equal, the FORM-COUNTS are
;   equal, and (LEXORDER TERM1 TERM2).

;   Let (STRICT-TERM-ORDER X Y) be the LISP function defined as (AND
;   (TERM-ORDER X Y) (NOT (EQUAL X Y))).  For a fixed, finite set of function
;   symbols and variable symbols STRICT-TERM-ORDER is well founded, as can be
;   proved with the following lemma.

;   Lemma.  Suppose that M is a function whose range is well ordered by r and
;   such that the inverse image of any member of the range is finite.  Suppose
;   that L is a total order.  Define (LESSP x y) = (OR (r (M x) (M y)) (AND
;   (EQUAL (M x) (M y)) (L x y) (NOT (EQUAL x y)))). < is a well-ordering.
;   Proof.  Suppose ... < t3 < t2 < t1 is an infinite descending sequence. ...,
;   (M t3), (M t2), (M t1) is weakly descending but not infinitely descending
;   and so has a least element.  WLOG assume ... = (M t3) = (M t2) = (M t1).
;   By the finiteness of the inverse image of (M t1), { ..., t3, t2, t1} is a
;   finite set, which has a least element under L, WLOG t27.  But t28 L t27 and
;   t28 /= t27 by t28 < t27, contradicting the minimality of t27.  QED

;   If (TERM-ORDER x y) and t2 results from replacing one occurrence of y with
;   x in t1, then (TERM-ORDER t2 t1).  Cases on why x is less than y.  1.0 If
;   the number of occurrences of variables in x is strictly smaller than in y,
;   then the number in t2 is strictly smaller than in t1.  2.0 If the number of
;   occurrences of variables in x is equal to the number in y but (FORM-COUNT
;   x) is smaller than (FORM-COUNT y), then the number of occurrences in t1 is
;   equal to the number in t2 but (FORM-COUNT t1) is less than (FORM-COUNT t2).
;   3.0 If the number of variable occurrences and parenthesis occurrences in x
;   and y are the same, then (LEXORDER x y).  (TERM-ORDER t2 t1) reduces to
;   (LEXORDER t2 t1) because the number of variable and parenthesis occurrences
;   in t2 and t1 are the same.  The lexicographic scan of t1 and t2 will be all
;   equals until x and y are hit.

  (LET (FORM-COUNT1 FORM-COUNT2 NUMBER-OF-VARIABLES1
		    NUMBER-OF-VARIABLES2)
    (SETQ FORM-COUNT1 (FORM-COUNT TERM1))
    (SETQ NUMBER-OF-VARIABLES1 NUMBER-OF-VARIABLES)
    (SETQ FORM-COUNT2 (FORM-COUNT TERM2))
    (SETQ NUMBER-OF-VARIABLES2 NUMBER-OF-VARIABLES)
    (COND ((< NUMBER-OF-VARIABLES1 NUMBER-OF-VARIABLES2)
	   T)
	  ((< NUMBER-OF-VARIABLES2 NUMBER-OF-VARIABLES1)
	   NIL)
	  ((< FORM-COUNT1 FORM-COUNT2)
	   T)
	  ((< FORM-COUNT2 FORM-COUNT1)
	   NIL)
	  (T (LEXORDER TERM1 TERM2)))))

(DEFUN TERMINATION-MACHINE (FNNAME TERM TESTS)

;   This function builds a list of TESTS-AND-CASE representing the function
;   FNNAME with body TERM.  For each call of FNNAME in body, a TESTS-AND-CASE
;   is returned whose TESTS are all the tests that "rule" the call and whose
;   CASE is the arglist of the call.  If a rules b, then a governs b but not
;   vice versa.  For example, in (if (g (if a b c)) d e), a governs b but does
;   not rule b.  The reason for taking this weaker notion of governance is that
;   we can show easily that the TESTS-AND-CASEs are together sufficient to
;   imply the TESTS-AND-CASES generated by INDUCTION-MACHINE.

  (COND ((OR (VARIABLEP TERM)
	     (FQUOTEP TERM))
	 NIL)
	((EQ (FFN-SYMB TERM)
	     (QUOTE IF))
	 (NCONC (ITERATE FOR ARGLIST IN (ALL-ARGLISTS FNNAME (FARGN TERM 1))
			 COLLECT (MAKE TESTS-AND-CASE TESTS ARGLIST))
		(TERMINATION-MACHINE FNNAME (FARGN TERM 2)
				     (APPEND TESTS (LIST (FARGN TERM 1))))
		(TERMINATION-MACHINE
		 FNNAME
		 (FARGN TERM 3)
		 (APPEND TESTS (LIST (NEGATE-LIT (FARGN TERM 1)))))))
	(T (ITERATE FOR ARGLIST IN (ALL-ARGLISTS FNNAME TERM)
		    COLLECT (MAKE TESTS-AND-CASE TESTS ARGLIST)))))

(DEFUN TO-BE-IGNOREDP (POLY)
  (LET (LEMMAS LITS)
    (SETQ LEMMAS (ACCESS POLY LEMMAS POLY))
    (SETQ LITS (ACCESS POLY LITERALS POLY))
    (ITERATE FOR LIT IN LITS-TO-BE-IGNORED-BY-LINEAR
	     THEREIS (OR (MEMBER-EQ LIT LEMMAS)
			 (MEMBER-EQ LIT LITS)))))

(DEFUN TOO-MANY-IFS (ARGS VAL)

;   Let ARGS be the list of actuals to a nonrec fn.  Let VAL be the rewritten
;   body.  We wish to determine whether the expansion of the fn call introduces
;   too many IFs all at once.  Our motivation comes from an example like (M2
;   (ZTAK & & &) (ZTAK & & &) (ZTAK & & &)) where the careless opening up of
;   everybody produces a formula with several hundred IFs in it because of M2's
;   duplication of the IFs coming from the simplification of the ZTAKs.  My
;   first thought was to never expand a nonrec fn -- at the top level of the
;   clause -- if it had some IFs in its args and to wait till CLAUSIFY has
;   cleaned things up.  That slowed a proveall down by a factor of 2 -- and by
;   a factor of 13 in PRIME-LIST-TIMES-LIST -- because of the ridiculously slow
;   expansion of such basic nonrec fns as AND, OR, NOT, and NLISTP.  I have
;   been thinking about the problem and have thought of the following ideas.
;   None except the final one have been implemented or tested.

;   I thought of permitting the expansion if VAL had fewer IFs than ARGS but
;   that is obviously bad because it does not permit the fn to introduce any
;   IFs of its own, e.g., as in AND.  So I have decided to just prohibit the
;   duplication of IF-containing-args in VAL.  That is, I do not want to expand
;   the fn if the expansion causes the duplication of some arg containing an
;   IF.  Of course, it could be that an IF-containing-arg does not occur in VAL
;   only because it has been rewritten by some rewrite rule to some other term,
;   possibly containing even more IFs, but I have decided to ignore that and
;   blame that problem on the process that permitted the introduction of those
;   IFs.  So when I say an arg is duplicated in VAL I really mean the arg
;   literally OCCURs twice.  Then it occurred to me that if arg1 and arg2 both
;   contained IFs and arg1 was duplicated in VAL but arg2 did not occur at all,
;   then perhaps one should permit the expansion if the number of IFs in the
;   arg1 occurrences are less than the number in the arg1 plus arg2.  So that
;   is what I have implemented.

;   This function computes (> (ITERATE FOR ARG IN ARGS SUM(* (COUNT-IFS
;   ARG) (OCCUR-CNT ARG VAL))) (ITERATE FOR ARG IN ARGS SUM (COUNT-IFS ARG))) but
;   does it slightly more efficiently by observing that if no IFs occur in any
;   arg then there is no point in doing the OCCUR-CNTs and that once the left
;   hand side has been pushed beyond the right there is no point in continuing.

  (LET (RHS LHS)
    (SETQ RHS (ITERATE FOR ARG IN ARGS SUM (COUNT-IFS ARG)))
    (SETQ LHS 0)
    (COND ((ZEROP RHS)
	   NIL)
	  (T (ITERATE FOR ARG IN ARGS
		      WHEN (NOT (ZEROP (SETQ TEMP-TEMP (COUNT-IFS ARG))))
		      THEREIS

;   The WHEN clause above just takes advantage of the fact that if X is 0 then
;   X*Y is 0 and Y need not be computed.

		      (>
		       (SETQ LHS
			     (+ (* TEMP-TEMP
				   (OCCUR-CNT ARG VAL))
				LHS))
		       RHS))))))

(DEFUN TOP-FNNAME (CONCL)
  (OR (MATCH CONCL (NOT CONCL))
      (MATCH CONCL (EQUAL CONCL &)))
  (COND ((VARIABLEP CONCL)
	 NIL)
	(T (FN-SYMB CONCL))))

(DEFUN TOTAL-FUNCTIONP (FNNAME)
  (LET (TEMP)
    (SETQ TEMP (GET FNNAME (QUOTE JUSTIFICATIONS)))
    (NOT (AND (= (LENGTH TEMP) 1)
	      (NULL (ACCESS JUSTIFICATION RELATION (CAR TEMP)))
	      (NOT (DISABLEDP FNNAME))))))

(DEFUN TRANSITIVE-CLOSURE (SET PRED)

;   Compares all pairs x,y of distinct occurrences of from the bag SET with
;   (PRED x y) and if PRED returns non-NIL, x and y are removed from SET and
;   the result of PRED is inserted.  This operation is repeated until no
;   changes occur.  CAUTION:  It must be the case that (PRED x y) = (PRED y x).

  (LET (ALIVE NEW RESULT)
    (SETQ ALIVE (ITERATE FOR X IN SET COLLECT (CONS X T)))
    (SETQ NEW (COPY-LIST ALIVE))
    (ITERATE WHILE NEW
	     UNLESS
	     (AND (CDR (CAR NEW))
		  (ITERATE FOR TAIL ON ALIVE
			   WHEN
			   (PROG NIL
				 LOOP (COND ((NULL (CDR (CAR TAIL)))
					     (COND ((NULL (CDR TAIL))
						    (RETURN NIL))
						   (T (RPLACA TAIL (CADR TAIL))
						      (RPLACD TAIL (CDDR TAIL))
						      (GO LOOP)))))
				 (RETURN (COND ((EQ (CAR TAIL) (CAR NEW)) NIL)
					       ((SETQ RESULT
						      (FUNCALL PRED
							       (CAR (CAR TAIL))
							       (CAR (CAR NEW))))
						(SETQ RESULT (CONS RESULT T))
						(RPLACD (CAR TAIL) NIL)
						(RPLACA TAIL RESULT)
						(RPLACD (CAR NEW) NIL)
						(RPLACA NEW RESULT)
						T)
					       (T NIL))))
			   DO (RETURN TAIL)))
	     DO (SETQ NEW (CDR NEW)))
    (ITERATE FOR PAIR IN ALIVE
	     WHEN (CDR PAIR) COLLECT (CAR PAIR))))

(DEFUN TRANSLATE (X)
  (COND
   ((ATOM X)
    (COND ((INTEGERP X)
	   (LIST (QUOTE QUOTE) X))
	  ((SYMBOLP X)
	   (COND ((EQ X T)
		  TRUE)
		 ((EQ X (QUOTE F))
		  FALSE)
		 ((EQ X NIL)
		  (QUOTE (QUOTE NIL)))
		 ((ILLEGAL-NAME X)
		  (ERROR1 (PQUOTE (PROGN (!PPR1 X NIL)
					 |is| |an| |illegal|
					 |variable| |name| |.|))
			  (BINDINGS (QUOTE X) X)
			  (QUOTE SOFT)))
		 (T X)))
	  (T (ERROR1 (PQUOTE (PROGN |unrecognized| |syntax:| (!PPR1 X NIL)))
		     (BINDINGS (QUOTE X)
			       X)
		     (QUOTE SOFT)))))
   ((NOT (CONSP X))
    (ERROR1 (PQUOTE (PROGN |No| |hunks| |please:| (!PPR1 X NIL)))
	    (BINDINGS (QUOTE X) X)
	    (QUOTE SOFT)))
   ((CDR (OUR-LAST X))
    (ERROR1 (PQUOTE (PROGN |contrary| |to| |the| |rules| |of|
			   |well-formedness|
			   |,| |the| |last| CDR |of| (!PPR1 X NIL)
			   |is| |non-NIL|))
	    (BINDINGS (QUOTE X)
		      X)
	    (QUOTE SOFT)))
   ((NOT (SYMBOLP (CAR X)))
    (ERROR1 (PQUOTE
	     (PROGN |function| |symbols| |must| |be| LISP
		    |literal| |atoms| |and| (!PPR1 (CAR X) NIL) |is| |not|
		    !))
	    (BINDINGS (QUOTE X)
		      X)
	    (QUOTE SOFT)))
   ((NOT (OK-SYMBOLP (CAR X)))
    (ERROR1 (PQUOTE
	     (PROGN (!PPR1 (CAR X) NIL) |is| |not| |interned| |in|
		    |the| |right| |places| !))
	    (BINDINGS (QUOTE X)
		      X)
	    (QUOTE SOFT)))
   ((PROPERTYLESS-SYMBOLP (CAR X))
    (COND ((EQ (CAR X)
	       (QUOTE QUOTE))
	   (COND ((NOT (= 1 (LENGTH (CDR X))))
		  (ERROR1 (PQUOTE (PROGN QUOTE |must| |be| |given|
					 |exactly| |one|
					 |argument| |.| |In| (!PPR1 X NIL)
					 |it| |is| |given| |the| |wrong|
					 |number| |of| |arguments| |.|))
			  (BINDINGS (QUOTE X) X)
			  (QUOTE SOFT)))
		 ((NOT (EVG (CADR X)))
		  (ERROR1 (PQUOTE (PROGN |the| |object| |QUOTEd| |in| |the|
					 |expression| (!PPR1 X NIL)
					 |does| |not| |represent| |an|
					 |explicit|
					 |value| |term|))
			  (BINDINGS (QUOTE X) X)
			  (QUOTE SOFT)))
		 (T X)))
	  ((MEMBER-EQ (CAR X) (QUOTE (NIL T F)))
	   (ERROR1 (PQUOTE (PROGN (!PPR1 (CAR X) NIL)
				  |is| |an| |illegal| |function|
				  |symbol| |.|))
		   (BINDINGS (QUOTE X) X)
		   (QUOTE SOFT)))
	  ((EQ (CAR X) (QUOTE LIST))
	   (COND ((NULL (CDR X)) (TRANSLATE NIL))
		 (T (XXXJOIN (QUOTE CONS)
			     (NCONC1 (ITERATE FOR ARG IN (CDR X)
					      COLLECT (TRANSLATE ARG))
				     (TRANSLATE NIL))))))
	  ((CAR-CDRP (CAR X))
	   (COND ((= (LENGTH (CDR X))
		     1)
		  (FIXCAR-CDR (LIST (CAR X)
				    (TRANSLATE (CADR X)))))
		 (T (ERROR1 (PQUOTE (PROGN (!PPR1 (CAR X) NIL)
					   |is| |a| |reserved|
					   |abbreviation|
					   |for|
					   |a| CAR-CDR |nest|
					   |and| |must| |be| |given| |exactly|
					   |one|
					   |argument| |.|))
			    (BINDINGS (QUOTE X)
				      X)
			    (QUOTE SOFT)))))
	  (T (ERROR1 (PQUOTE (PROGN PROPERTYLESS-SYMBOLP
				    |and| TRANSLATE |do| |not| |agree| |on|
				    (!PPR1 (CAR X) NIL)
				    |.|))
		     (BINDINGS (QUOTE X)
			       X)
		     (QUOTE HARD)))))
   ((NULL (ARITY (CAR X)))
    (COND (IN-BOOT-STRAP-FLG
	   (ERROR1 (PQUOTE (PROGN (!PPR1 (CAR X) NIL)
				  |has| |been| |encountered| |as| |an|
				  |undefined|
				  |function| |by| TRANSLATE |.| |You| |should|
				  |add| |it| |to| |the| |binding| |of|
				  ARITY-ALIST
				  |in| BOOT-STRAP |if| |you| |wish| |to|
				  |suppress| |this| |message| !))
		   (BINDINGS (QUOTE X)
			     X)
		   (QUOTE WARNING)))
	  (T (ERROR1 (PQUOTE (PROGN |the| |function| (!PPR1 (CAR X) NIL)
				    |is| |unknown| |.| |Please| |delete| |all|
				    |references| |to| |it| |,| |define| |it|
				    |or| |declare| |it| |as| |an| |undefined|
				    |function| |.|))
		     (BINDINGS (QUOTE X)
			       X)
		     (QUOTE SOFT)))))
   ((AND (MEMBER-EQ (CAR X)
		    (QUOTE (AND OR PLUS TIMES)))
	 (> (LENGTH (CDR X))
	    2))
    (XXXJOIN (CAR X)
	     (ITERATE FOR ARG IN (CDR X) COLLECT (TRANSLATE ARG))))
   ((NOT (= (LENGTH (CDR X))
	    (ARITY (CAR X))))
    (ERROR1 (PQUOTE (PROGN |the| |function| |symbol| (!PPR1 (CAR X) NIL)
			   |takes| |exactly| (@ N)
			   |arguments| |.| |In| (!PPR1 X NIL)
			   |it| |is| |given| |the| |wrong| |number| |of|
			   |arguments| |.|))
	    (BINDINGS (QUOTE X)
		      X
		      (QUOTE N)
		      (ARITY (CAR X)))
	    (QUOTE SOFT)))
   ((MEMBER-EQ (CAR X)
	       BOOT-STRAP-MACRO-FNS)
    (SUB-PAIR-VAR (CADR (GET (CAR X)
			     (QUOTE SDEFN)))
		  (ITERATE FOR ARG IN (CDR X) COLLECT (TRANSLATE ARG))
		  (CADDR (GET (CAR X)
			      (QUOTE SDEFN)))))
   (T (CONS-TERM (CAR X)
		 (ITERATE FOR ARG IN (CDR X) COLLECT (TRANSLATE ARG))))))

(DEFUN TRANSLATE-TO-LISP (X)
  (LET (ANS TIME)
    (SETQ TIME (TIME-IN-60THS))
    (SETQ ALL-LEMMAS-USED NIL)
    (SETQ ANS (PRETTYIFY-LISP (OPTIMIZE-COMMON-SUBTERMS
			       (ONEIFY X NIL))))
    (SETQ TRANSLATE-TO-LISP-TIME
	  (+ (- (TIME-IN-60THS)
		TIME)
	     TRANSLATE-TO-LISP-TIME))
    ANS))

(DEFUN TREE-DEPENDENTS (NAME)
  (CONS NAME (ITERATE FOR X IN (GET NAME (QUOTE IMMEDIATE-DEPENDENTS0))
		      WITH ITERATE-ANS
		      DO (SETQ ITERATE-ANS
			       (UNION-EQ (TREE-DEPENDENTS X)
					 ITERATE-ANS))
		      FINALLY (RETURN ITERATE-ANS))))

(DEFUN TRIVIAL-POLYP (POLY)
  (OR (TRIVIAL-POLYP1 POLY (QUOTE POSITIVE))
      (TRIVIAL-POLYP1 POLY (QUOTE NEGATIVE))))

(DEFUN TRIVIAL-POLYP1 (POLY PARITY)
  (PROG (WINNING-PAIR COEF)
	(COND ((EQ PARITY (QUOTE POSITIVE))
	       (COND ((AND (< (ACCESS POLY CONSTANT POLY)
			      1)
			   (= 1 (ITERATE FOR PAIR IN (ACCESS POLY ALIST POLY)
					 COUNT (> (CDR PAIR)
						  0))))
		      (SETQ WINNING-PAIR
			    (ITERATE FOR PAIR IN (ACCESS POLY ALIST POLY)
				     WHEN (> (CDR PAIR)
					     0)
				     DO (RETURN PAIR)))
		      (SETQ COEF (CDR WINNING-PAIR)))
		     (T (RETURN NIL))))
	      ((AND (> (ACCESS POLY CONSTANT POLY)
		       -1)
		    (= 1 (ITERATE FOR PAIR IN (ACCESS POLY ALIST POLY)
				  COUNT (< (CDR PAIR)
					   0))))
	       (SETQ WINNING-PAIR (ITERATE FOR PAIR IN (ACCESS POLY ALIST POLY)
					   WHEN (< (CDR PAIR)
						   0)
					   DO (RETURN PAIR)))
	       (SETQ COEF (- (CDR WINNING-PAIR))))
	      (T (RETURN NIL)))
	(COND ((AND (NOT (MATCH (ACCESS POLY LITERALS POLY)
				(LIST (NOT (EQUAL & &)))))
		    (EQUAL 0 (OUR-REMAINDER (ACCESS POLY CONSTANT POLY)
					COEF))
		    (ITERATE FOR PAIR IN (ACCESS POLY ALIST POLY)
			     ALWAYS (EQUAL 0 (OUR-REMAINDER (CDR PAIR)
							COEF))))

;   We know that the polys in this pot list were formed from the current CL
;   with the ADD-TERMS-TO-POT-LST FLG=NIL.  That is, the literals of the clause
;   were stored by LINEARIZE with their original parities, even though the poly
;   was generated from their negations.

	       (RETURN (CONS (CONS (CAR WINNING-PAIR)
				   (COND ((EQ PARITY (QUOTE POSITIVE))
					  1)
					 (T -1)))
			     (MAKE POLY (OUR-QUOTIENT (ACCESS POLY CONSTANT POLY)
						  COEF)
				   (ITERATE FOR PAIR IN (ACCESS POLY ALIST POLY)
					    COLLECT
					    (CONS (CAR PAIR)
						  (OUR-QUOTIENT (CDR PAIR)
							    COEF)))
				   (ACCESS POLY ASSUMPTIONS POLY)
				   (ACCESS POLY LITERALS POLY)
				   (ACCESS POLY LEMMAS POLY)))))
	      (T (RETURN NIL)))))

(DEFUN TRUE-POLYP (POLY)
  (AND (<= (ACCESS POLY CONSTANT POLY)
	   0)
       (ITERATE FOR PAIR IN (ACCESS POLY ALIST POLY) ALWAYS (<= (CDR PAIR)
								0))))

(DEFUN TYPE-ALIST-CLAUSE (CL)
  (LET ((TYPE-ALIST TYPE-ALIST))
    (ITERATE FOR LIT IN CL WHILE (NOT (EQ TYPE-ALIST (QUOTE CONTRADICTION)))
	     DO (SMART-ASSUME-TRUE-FALSE LIT)
	     (COND (MUST-BE-TRUE (SETQ TYPE-ALIST (QUOTE CONTRADICTION)))
		   (MUST-BE-FALSE NIL)
		   (T (SETQ TYPE-ALIST FALSE-TYPE-ALIST))))
    TYPE-ALIST))

(DEFUN TYPE-PRESCRIPTION-LEMMAP (NAME)
  (LET (ATM)
    (COND ((ITERATE FOR TUPLE IN (GET NAME (QUOTE LOCAL-UNDO-TUPLES))
		    THEREIS (MATCH TUPLE
				   (CONS (QUOTE TYPE-PRESCRIPTION-LST)
					 (CONS ATM &))))
	   ATM)
	  (T NIL))))

(DEFUN TYPE-SET (TERM)
  (LET (PAIR TYPE-ARG1 TYPE-ARG2 ARG1 ARG2)
    (COND ((SETQ TEMP-TEMP (ASSOC-EQUAL TERM TYPE-ALIST))
	   (CDR TEMP-TEMP))
	  ((VARIABLEP TERM)
	   TYPE-SET-UNKNOWN)
	  ((FQUOTEP TERM)
	   (CAR (TYPE-PRESCRIPTION (FN-SYMB0 (CADR TERM)))))
	  ((SETQ PAIR (ASSOC-EQ (FFN-SYMB TERM)
				RECOGNIZER-ALIST))
	   (SETQ TYPE-ARG1 (TYPE-SET (FARGN TERM 1)))
	   (COND ((= 0 (LOGAND TYPE-ARG1 (CDR PAIR)))
		  TYPE-SET-FALSE)
		 ((LOGSUBSETP TYPE-ARG1 (CDR PAIR))
		  TYPE-SET-TRUE)
		 (T TYPE-SET-BOOLEAN)))
	  ((MATCH TERM (EQUAL ARG1 ARG2))
	   (SETQ TYPE-ARG1 (TYPE-SET ARG1))
	   (SETQ TYPE-ARG2 (TYPE-SET ARG2))
	   (COND ((= 0 (LOGAND TYPE-ARG1 TYPE-ARG2))
		  TYPE-SET-FALSE)
		 ((AND (= TYPE-ARG1 TYPE-ARG2)
		       (MEMBER-EQUAL TYPE-ARG1 SINGLETON-TYPE-SETS))
		  TYPE-SET-TRUE)
		 (T TYPE-SET-BOOLEAN)))
	  ((MATCH TERM (NOT ARG1))
	   (SETQ TYPE-ARG1 (TYPE-SET ARG1))
	   (COND ((= TYPE-ARG1 TYPE-SET-FALSE)
		  TYPE-SET-TRUE)
		 ((NOT (LOGSUBSETP TYPE-SET-FALSE TYPE-ARG1))
		  TYPE-SET-FALSE)
		 (T TYPE-SET-BOOLEAN)))
	  ((EQ (FFN-SYMB TERM)
	       (QUOTE IF))
	   (ASSUME-TRUE-FALSE (FARGN TERM 1))
	   (COND (MUST-BE-TRUE (TYPE-SET (FARGN TERM 2)))
		 (MUST-BE-FALSE (TYPE-SET (FARGN TERM 3)))
		 (T (LOGIOR (TYPE-SET2 (FARGN TERM 2)
				       TRUE-TYPE-ALIST)
			    (TYPE-SET2 (FARGN TERM 3)
				       FALSE-TYPE-ALIST)))))
	  ((SETQ TEMP-TEMP (TYPE-PRESCRIPTION
			    (FFN-SYMB TERM)))
	   (LOGIOR (CAR TEMP-TEMP)
		   (ITERATE FOR ARG IN (FARGS TERM) AS FLG
			    IN (CDR TEMP-TEMP)
			    WITH ITERATE-ANS = 0
			    WHEN FLG
			    DO
			    (SETQ ITERATE-ANS
				  (LOGIOR ITERATE-ANS
					  (TYPE-SET ARG)))
			    FINALLY (RETURN ITERATE-ANS))))
	  (T TYPE-SET-UNKNOWN))))

(DEFUN TYPE-SET2 (TERM TYPE-ALIST)

;   This is like TYPE-SET, only it lets you specify the local TYPE-ALIST and
;   protects the FALSE-TYPE-ALIST for you.

  (LET (FALSE-TYPE-ALIST) (TYPE-SET TERM)))

(DEFUN TYPE-SET-TERMP (TERM)

;   A type set term is a term of the form (OR (r1 a) ... (rn a)) or
;   of the form (AND (NOT (r1 a)) ... (NOT (rn a))), where each ri is
;   a recognizer and a is any term.  If TERM is a type set term, we
;   return a pair <a, type-set>, where type-set is the bit mask
;   corresponding to the type set of a described by the term.  Otherwise,
;   we return NIL.

  (LET (LST) 
    (COND ((AND (ITERATE FOR X IN (SETQ LST (FLATTEN-TERM TERM (QUOTE OR)))
			 ALWAYS (RECOGNIZER-TERMP X))
		(ITERATE FOR X IN (CDR LST)
			 WITH A = (FARGN (CAR LST) 1)
			 ALWAYS (EQUAL A (FARGN X 1))))
	   (CONS (FARGN (CAR LST) 1)
		 (ITERATE FOR X IN LST WITH ITERATE-ANS = 0
			  DO 
			  (SETQ ITERATE-ANS (LOGIOR ITERATE-ANS
						    (RECOGNIZER-TERMP X)))
			  FINALLY (RETURN ITERATE-ANS))))
	  ((AND (ITERATE FOR X IN (SETQ LST (FLATTEN-TERM TERM (QUOTE AND)))
			 ALWAYS (AND (MATCH X (NOT X))
				     (RECOGNIZER-TERMP X)))
		(ITERATE FOR X IN (CDR LST)
			 WITH A = (FARGN (FARGN (CAR LST) 1) 1)
			 ALWAYS (EQUAL A (FARGN (FARGN X 1) 1))))
	   (CONS (FARGN (FARGN (CAR LST) 1) 1)
		 (ITERATE FOR X IN LST WITH ITERATE-ANS = -1
			  DO
			  (SETQ ITERATE-ANS (LOGAND ITERATE-ANS
						    (LOGNOT
						     (RECOGNIZER-TERMP
						      (FARGN X 1)))))
			  FINALLY (RETURN ITERATE-ANS))))
	  (T NIL))))

(DEFUN UGLYP (EVG)
 
;   Answers the question:  Does the representation of EVG have
;   *1*'s in it?
 
  (COND ((ATOM EVG)
	 (OR (EQ EVG *1*T)
	     (EQ EVG *1*F)))
	((EQ (CAR EVG) *1*SHELL-QUOTE-MARK)
	 T)
	(T (OR (UGLYP (CAR EVG))
	       (UGLYP (CDR EVG))))))
 
(DEFUN UNBREAK-LEMMA (NAME) ; ??
  (COND ((NULL NAME)
	 (SETQ BROKEN-LEMMAS NIL))
	(T (SETQ BROKEN-LEMMAS (REMOVE (ASSOC-EQ NAME BROKEN-LEMMAS)
				       BROKEN-LEMMAS :TEST #'EQUAL)))))

(DEFUN UNCHANGING-VARS (TERM)
  (LET (ANS)
    (UNCHANGING-VARS1 (EXPAND-NON-REC-FNS TERM))
    ANS))

(DEFUN UNCHANGING-VARS1 (TERM)
  (COND ((VARIABLEP TERM)
	 NIL)
	((FQUOTEP TERM)
	 NIL)
	(T (ITERATE FOR ARG IN (FARGS TERM) DO (UNCHANGING-VARS1 ARG))
	   (COND ((OR (MEMBER-EQ (FFN-SYMB TERM)
				 *1*BTM-OBJECTS)
		      (ASSOC-EQ (FFN-SYMB TERM)
				RECOGNIZER-ALIST)
		      (ITERATE FOR X IN SHELL-POCKETS
			       THEREIS (MEMBER-EQ (FFN-SYMB TERM)
						  X))
		      (MEMBER-EQ (FFN-SYMB TERM)
				 (QUOTE (IF EQUAL))))
		  NIL)
		 ((AND (GET (FFN-SYMB TERM)
			    (QUOTE SDEFN))
		       (NOT (DISABLEDP (FFN-SYMB TERM))))
		  NIL)
		 (T (ITERATE FOR ARG IN (FARGS TERM) WHEN (VARIABLEP ARG)
			     DO (SETQ ANS (ADD-TO-SET ARG ANS))))))))

(DEFUN UNDO-BACK-THROUGH (NAME)
  (COND ((OR (NOT (SYMBOLP NAME)) (NOT (GET NAME (QUOTE EVENT))))
	 (ERROR1 (PQUOTE (PROGN |Attempt| |to| |undo| |a| |nonevent| |,|
				(!PPR NAME NIL)
				|.|))
		 (BINDINGS (QUOTE NAME)
			   NAME)
		 (QUOTE SOFT)))
	(T (NREVERSE (ITERATE WHILE (AND (BOUNDP (QUOTE CHRONOLOGY))
					 (MEMBER-EQ NAME CHRONOLOGY))
			      APPEND (UNDO-NAME (CAR CHRONOLOGY)))))))

(DEFUN UNDO-NAME (NAME)
  (LET (EVENTS)
    (COND ((OR (NOT (SYMBOLP NAME)) (NOT (GET NAME (QUOTE EVENT))))
	   (ERROR1 (PQUOTE (PROGN |Attempt| |to| |undo| |a| |nonevent| |,|
				  (!PPR NAME NIL)
				  |.|))
		   (BINDINGS (QUOTE NAME) NAME)
		   (QUOTE SOFT)))
	  ((EQ NAME (QUOTE GROUND-ZERO))
	   (SETQ EVENTS (NREVERSE (ITERATE FOR X IN CHRONOLOGY
					   COLLECT (GET X (QUOTE EVENT)))))
	   (KILL-LIB)
	   EVENTS)
	  (T (SETQ EVENTS (REVERSE (DEPENDENTS-OF NAME)))
	     (COND ((NOT (EQ NAME (CAR CHRONOLOGY)))
		    (ERROR1
		     (PQUOTE
		      (PROGN |In| |general| |,| |undoing| |events|
			     |except| |in| |reverse| 
			     |order| |,| |i.e.,| |most| |recent| |first| |,|
			     |should| |be|
			     |avoided| |because| |not| |all|
			     |dependencies| |are| |correctly| |tracked| |.|
			     |in| |fact| |,| |it| |is| |possible| |to|
			     |derive| |inconsistencies| |using|
			     |UNDO-NAME| |randomly| |.|
			     |use| |it| |at| |your| |own| |risk| |.|))
		     NIL
		     (QUOTE WARNING))))
	     (NREVERSE (ITERATE FOR X IN EVENTS COLLECT
				(PROG1 (GET X (QUOTE EVENT))
				  (KILL-EVENT X))))))))

(DEFUN UNION-EQUAL (X Y)

;   When we moved to the 3600 we replaced calls of INTERLISP's UNION -- which
;   uses EQUAL -- with our own UNION-EQUAL because Zetalisp's UNION uses EQ.
;   Some calls of INTERLISP's UNION were allowed to remain UNIONs because we
;   could convince ourselves that only atoms were involved.  However, on
;   questionable cases we went ahead and used UNION-EQUAL.  Thus, some calls of
;   UNION-EQUAL could be replaced by UNION.  The main place is when dealing
;   with lemmas used, where inside the simpblock we permit listp names.  Seeing
;   a call of UNION-EQUAL in such a situation is not to be taken as a claim
;   that listp names are present; we just didn't trace it out.

  (NCONC (ITERATE FOR Z IN X UNLESS (MEMBER-EQUAL Z Y) COLLECT Z)
	 Y))

(DEFUN UNPRETTYIFY (TERM)

;   This function returns a list of pairs (hyps . concl) such that the
;   conjunction of all (IMPLIES hyps concl) is equivalent to TERM.  hyps is a
;   list of hypotheses, implicitly conjoined.  concl does not begin with an AND
;   or IMPLIES.

  (LET (C1 C2 HYP CONCL)
    (COND ((MATCH TERM (AND C1 C2))
	   (APPEND (UNPRETTYIFY C1)
		   (UNPRETTYIFY C2)))
	  ((MATCH TERM (IMPLIES HYP CONCL))
	   (SETQ HYP (FLATTEN-ANDS-IN-LIT HYP))
	   (ITERATE FOR PAIR IN (UNPRETTYIFY CONCL)
		    COLLECT (CONS (APPEND HYP (CAR PAIR))
				  (CDR PAIR))))
	  (T (LIST (CONS NIL TERM))))))

(DEFUN VARIANTP (TERM1 TERM2)
  (AND (ONE-WAY-UNIFY TERM1 TERM2)
       (ITERATE FOR PAIR IN UNIFY-SUBST ALWAYS (VARIABLEP (CDR PAIR)))
       (NO-DUPLICATESP (ITERATE FOR PAIR IN UNIFY-SUBST COLLECT (CDR PAIR)))))

(DEFUN WHY ()
  (ITERATE FOR C IN PROCESS-CLAUSES DO
	   (PROGN (ITERPRI NIL)
		  (PPC C)))
  (ITERPRI NIL))

(DEFUN WORSE-THAN (TERM1 TERM2)
  (COND ((QUICK-WORSE-THAN TERM1 TERM2)
	 T)
	((VARIABLEP TERM1)
	 NIL)
	((FQUOTEP TERM1)
	 NIL)
	(T (ITERATE FOR ARG IN (FARGS TERM1)
		    THEREIS (SOME-SUBTERM-WORSE-THAN-OR-EQUAL ARG TERM2)))))

(DEFUN WORSE-THAN-OR-EQUAL (TERM1 TERM2)
  (OR (EQUAL TERM1 TERM2)
      (WORSE-THAN TERM1 TERM2)))

(DEFUN WRAPUP (WON-FLG)
  (COND ((NOT (EQ LEMMA-STACK ORIG-LEMMA-STACK))
	 (ITERPRI T)
	 (ERROR1 (PQUOTE (PROGN WRAPUP |found| |a| |non-trivial|
				LEMMA-STACK !))
		 (BINDINGS)
		 (QUOTE HARD))))
  (COND ((NOT (EQ LINEARIZE-ASSUMPTIONS-STACK
		  ORIG-LINEARIZE-ASSUMPTIONS-STACK))
	 (ITERPRI T)
	 (ERROR1 (PQUOTE (PROGN WRAPUP |found| |a| |non-trivial|
				LINEARIZE-ASSUMPTIONS-STACK
				!))
		 (BINDINGS)
		 (QUOTE HARD))))
  (IO (QUOTE FINISHED)
      NIL NIL NIL (LIST WON-FLG))
  (THROW (QUOTE PROVE)
	 (COND (WON-FLG (QUOTE PROVED))
	       (T NIL))))

(DEFUN XXXJOIN (FN X)
  (COND ((OR (ATOM X)
	     (ATOM (CDR X)))
	 (ERROR1 (PQUOTE (PROGN XXXJOIN |must| |not| |be|
				|called| |on| |a| |list|
				|with| |less| |than| 2 |elements| |.|))
		 NIL
		 (QUOTE HARD)))
	((ATOM (CDDR X))
	 (CONS-TERM FN X))
	(T (CONS-TERM FN (LIST (CAR X)
			       (XXXJOIN FN (CDR X)))))))

(DEFUN ZERO-POLY (LIT)
  (MAKE POLY 0 NIL NIL (LIST LIT)
	NIL))
