(EVAL-WHEN (LOAD EVAL COMPILE)
	   (CHK-BASE-AND-PACKAGE 10 *PACKAGE*))

(DEFUN NEGATE (TERM)
  (COND ((FALSE-NONFALSEP TERM)
	 (COND (DEFINITELY-FALSE TRUE) (T FALSE)))
	((VARIABLEP TERM)
	 (LIST (QUOTE NOT) TERM))
	(T (CASE (FFN-SYMB TERM)
		 (NOT (COND ((BOOLEAN (FARGN TERM 1))
			     (FARGN TERM 1))
			    (T (FCONS-TERM* (QUOTE IF) (FARGN TERM 1)
					    TRUE FALSE))))
		 (AND (DISJOIN2 (NEGATE (FARGN TERM 1))
				(NEGATE (FARGN TERM 2))
				NIL))
		 (OR (CONJOIN2 (NEGATE (FARGN TERM 1))
			       (NEGATE (FARGN TERM 2)) NIL))
		 (OTHERWISE
		  (FCONS-TERM* (QUOTE NOT) TERM))))))

(DEFUN NEGATE-LIT (TERM)
  (COND ((FALSE-NONFALSEP TERM)
	 (COND (DEFINITELY-FALSE TRUE) (T FALSE)))
	((VARIABLEP TERM)
	 (FCONS-TERM* (QUOTE NOT) TERM))
	((EQ (FFN-SYMB TERM) (QUOTE NOT))
	 (FARGN TERM 1))
	(T (FCONS-TERM* (QUOTE NOT) TERM))))

(DEFUN NEXT-AVAILABLE-TYPE-NO NIL
  (LET (TYPE-NO)
    (SETQ TYPE-NO
	  (ITERATE FOR I FROM 0
		   WHEN (NOT (ITERATE FOR PAIR IN SHELL-ALIST
				      THEREIS (EQUAL (CDR PAIR) I)))
		   DO (RETURN I)))
    (COND ((> TYPE-NO 30)
	   (ERROR1 (PQUOTE (PROGN |Too| |many| |shells| ! |Because| |of| |our|
				  |use| |of| |32-bit| |words| |to| |represent|
				  |sets| |of| |shell| |types| |,| |the| |need|
				  |to| |reserve| |one| |bit| |for| |internal|
				  |use| |,| |and| |the| |existence| |of| 31
				  |previously| |defined| |shells| |,| |we|
				  |cannot| |accept| |further| ADD-SHELL
				  |commands| |.|))
		   (BINDINGS)
		   (QUOTE HARD))))
    TYPE-NO))

(DEFUN NO-CROWDINGP (HOLES PRED PICKS)
  (COND ((NULL HOLES) T)
	((ITERATE FOR X IN (CAR HOLES)
		  THEREIS (AND (ITERATE FOR Y IN PICKS NEVER (FUNCALL PRED X Y))
			       (NO-CROWDINGP (CDR HOLES) PRED (CONS X PICKS))))
	 T)
	(T NIL)))

(DEFUN NO-DUPLICATESP (L)
  (ITERATE FOR TAIL ON L NEVER (MEMBER-EQ (CAR TAIL) (CDR TAIL))))

(DEFUN NO-OP NIL NIL)

(DEFUN NON-RECURSIVE-DEFNP (FNNAME)

;   We use the fact that this AND returns the SDEFN!

  (AND (NOT (DISABLEDP FNNAME))
       (NOT (GET FNNAME (QUOTE INDUCTION-MACHINE)))
       (GET FNNAME (QUOTE SDEFN))))

(DEFUN NORMALIZE-IFS (TERM TRUE-TERMS FALSE-TERMS IFF-FLG)
  (LET (T1 T2 T3 T11 T12 T13 BAD-ARG)
    (COND ((VARIABLEP TERM)
	   (COND ((MEMBER-EQ TERM FALSE-TERMS) FALSE)
		 ((AND IFF-FLG (MEMBER-EQ TERM TRUE-TERMS)) TRUE)
		 (T TERM)))
	  ((FQUOTEP TERM) (COND ((AND IFF-FLG (NOT (EQ (CADR TERM) *1*F))) TRUE)
				(T TERM)))
	  ((MATCH TERM (IF T1 T2 T3))
	   (SETQ T1 (NORMALIZE-IFS T1 TRUE-TERMS FALSE-TERMS T))
	   (COND ((EQUAL T1 TRUE)
		  (NORMALIZE-IFS T2 TRUE-TERMS FALSE-TERMS IFF-FLG))
		 ((OR (EQUAL T1 FALSE) (MEMBER-EQUAL T1 FALSE-TERMS))
		  (NORMALIZE-IFS T3 TRUE-TERMS FALSE-TERMS IFF-FLG))
		 ((MATCH T1 (IF T11 T12 T13))
		  (NORMALIZE-IFS
		   (FCONS-TERM* (QUOTE IF)
				T11
				(FCONS-TERM* (QUOTE IF) T12 T2 T3)
				(FCONS-TERM* (QUOTE IF) T13 T2 T3))
		   TRUE-TERMS FALSE-TERMS IFF-FLG))
		 (T (SETQ T2 (NORMALIZE-IFS T2
					    (CONS T1 TRUE-TERMS)
					    FALSE-TERMS IFF-FLG))
		    (SETQ T3 (NORMALIZE-IFS T3 TRUE-TERMS
					    (CONS T1 FALSE-TERMS) IFF-FLG))
		    (COND ((EQUAL T2 T3) T2)
			  ((AND (BOOLEAN T1)
				(EQUAL T2 TRUE)
				(AND (FALSE-NONFALSEP T3)
				     DEFINITELY-FALSE))
			   T1)
			  (T (FCONS-TERM* (QUOTE IF) T1 T2 T3))))))
	  (T (SETQ TERM
		   (CONS-TERM (CAR TERM)
			      (ITERATE FOR ARG IN (FARGS TERM)
				       COLLECT (NORMALIZE-IFS ARG
							      TRUE-TERMS
							      FALSE-TERMS
							      NIL))))
	     (COND ((MATCH TERM (EQUAL T1 T2))
		    (COND ((EQUAL T1 T2) (SETQ TERM TRUE))
			  ((NOT-IDENT T1 T2) (SETQ TERM FALSE)))))
	     (COND ((FQUOTEP TERM) TERM)
		   ((SETQ BAD-ARG (ITERATE FOR ARG IN (FARGS TERM)
					   WHEN (MATCH ARG
						       (IF T1 T2 T3))
					   DO (RETURN ARG)))

;   The NIL IFF-FLGs in the two recursive calls below could be replaced
;   by the incoming IFF-FLG.  The code below is sound but could be more
;   powerful.  This was just an oversight.

		    (FCONS-TERM* (QUOTE IF)
				 T1
				 (NORMALIZE-IFS
				  (SUBST-EXPR T2 BAD-ARG TERM)
				  (CONS T1 TRUE-TERMS)
				  FALSE-TERMS
				  NIL)
				 (NORMALIZE-IFS
				  (SUBST-EXPR T3 BAD-ARG TERM)
				  TRUE-TERMS
				  (CONS T1 FALSE-TERMS)
				  NIL)))
		   ((MEMBER-EQUAL TERM FALSE-TERMS) FALSE)
		   ((AND (MEMBER-EQUAL TERM TRUE-TERMS) (BOOLEAN TERM)) TRUE)
		   (T TERM))))))

(DEFUN NOT-EQUAL-0? (TERM)
  (PROG (X Y TEMP EQUALITY)
	(COND ((MATCH TERM (DIFFERENCE X Y))
	       (RETURN (NEGATE (NOT-LESSP? Y X))))
	      ((OR (MATCH TERM (ADD1 &))
		   (AND (QUOTEP TERM) (NOT (EQUAL (CADR TERM) 0))))
	       (RETURN TRUE)))
	(SETQ EQUALITY (FCONS-TERM* (QUOTE EQUAL) TERM ZERO))
	(SETQ TEMP (TYPE-SET EQUALITY))
	(COND ((= TEMP TYPE-SET-TRUE) (RETURN FALSE))
	      ((= TEMP TYPE-SET-FALSE)
	       (RETURN TRUE))
	      (T (RETURN (FCONS-TERM* (QUOTE NOT) EQUALITY))))))

(DEFUN NOT-IDENT (TERM1 TERM2)
  (COND ((AND (VALUEP TERM1) (VALUEP TERM2) (NOT (EQUAL TERM1 TERM2)))
	 T)
	((OR (AND (BTM-OBJECTP TERM1) (SHELL-CONSTRUCTORP TERM2))
	     (AND (BTM-OBJECTP TERM2) (SHELL-CONSTRUCTORP TERM1)))

;   Note, we do not even bother to check that they are of the same type, since
;   if they weren't they'd be unequal on type considerations alone.

	 T)
	((= 0 (LOGAND (TYPE-SET TERM1) (TYPE-SET TERM2))) T)
	((SHELL-OCCUR TERM1 TERM2) T)
	((SHELL-OCCUR TERM2 TERM1) T)
	(T NIL)))

(DEFUN NOT-LESSP? (X Y)
  (PROG (TEMP TERM)
	(COND ((AND (EQUAL Y (QUOTE (QUOTE 1)))
		    (= (TYPE-SET X) TYPE-SET-NUMBERS))
	       (RETURN (NOT-EQUAL-0? X))))
	(SETQ TEMP (TYPE-SET (SETQ TERM (FCONS-TERM* (QUOTE LESSP) X Y))))
	(RETURN (COND ((= TEMP TYPE-SET-FALSE) TRUE)
		      ((= TEMP TYPE-SET-TRUE)
		       FALSE)
		      (T (NEGATE TERM))))))

(DEFUN NOT-TO-BE-REWRITTENP (TERM ALIST)

;   We assume TERM is a nonvariable nonQUOTEP and that
;   TERMS-TO-BE-IGNORED-BY-REWRITE contains no vars or QUOTEPs.  Let term' be
;   (SUBLIS-VAR ALIST TERM).  If term' is a member of
;   TERMS-TO-BE-IGNORED-BY-REWRITE we return term' else NIL.  We would like to
;   do the membership test without doing the substitution, but the maintenance
;   of QUOTE-normal form by SUBLIS-VAR complicates matters.  We first ask
;   whether the FFN-SYMB of TERM is the FFN-SYMB of any term to be ignored.  If
;   not, we return NIL.  Else we do the substitution and member check.

;   The correctness of this function is obvious in the case that we do the
;   substitution.  So suppose we return NIL without doing the substitution.
;   Suppose, contrary to correctness that term' is a member of the to be
;   ignored list.  Then term' is not a QUOTEP.  But in that case the FFN-SYMB
;   of term' is that of TERM and must have passed our initial test.

  (COND ((AND (ITERATE FOR X IN TERMS-TO-BE-IGNORED-BY-REWRITE
		       THEREIS (EQ (FFN-SYMB TERM) (FFN-SYMB X)))
	      (MEMBER-EQUAL (SETQ TEMP-TEMP (SUBLIS-VAR ALIST TERM))
			    TERMS-TO-BE-IGNORED-BY-REWRITE))
	 TEMP-TEMP)
	(T NIL)))

(DEFUN NUMBERP? (TERM)
  (LET (TEMP)
    (SETQ TEMP (TYPE-SET TERM))
    (COND ((= TEMP TYPE-SET-NUMBERS)
	   TRUE)
	  ((NOT (LOGSUBSETP TYPE-SET-NUMBERS TEMP))
	   FALSE)
	  (T (FCONS-TERM*(QUOTE NUMBERP)
			 TERM)))))

(DEFUN OBJ-TABLE (TYPE-SET OBJECTIVE ID-IFF)
  (CASE OBJECTIVE
	(TRUE (COND ((= TYPE-SET TYPE-SET-TRUE) TRUE)
		    ((EQ ID-IFF (QUOTE ID)) NIL)
		    ((LOGSUBSETP TYPE-SET-FALSE TYPE-SET) NIL)
		    (T TRUE)))
	(FALSE (COND ((= TYPE-SET TYPE-SET-FALSE) FALSE)
		     (T NIL)))
	(? (COND ((= TYPE-SET TYPE-SET-FALSE) FALSE)
		 ((= TYPE-SET TYPE-SET-TRUE) TRUE)
		 ((EQ ID-IFF (QUOTE ID)) NIL)
		 ((LOGSUBSETP TYPE-SET-FALSE TYPE-SET) NIL)
		 (T TRUE)))
	(OTHERWISE
	 (ERROR1 (PQUOTE (PROGN |Unrecognized| REWRITE OBJECTIVE |,|
				(!PPR OBJECTIVE NIL) |.|))
		 (BINDINGS (QUOTE OBJECTIVE)
			   OBJECTIVE)
		 (QUOTE HARD)))))

(DEFUN OCCUR (TERM1 TERM2)
  (COND ((VARIABLEP TERM2)
	 (EQ TERM1 TERM2))
	((FQUOTEP TERM2)
	 (COND ((QUOTEP TERM1)
		(COND ((INTEGERP (CADR TERM1))
		       (EVG-OCCUR-NUMBER (CADR TERM1) (CADR TERM2)))
		      ((AND (LEGAL-CHAR-CODE-SEQ (CADR TERM1))
			    (EQUAL (CDR (OUR-LAST (CADR TERM1))) 0))
		       (EVG-OCCUR-LEGAL-CHAR-CODE-SEQ (CADR TERM1)
						      (CADR TERM2)))
		      (T (EVG-OCCUR-OTHER (CADR TERM1)
					  (CADR TERM2)))))
	       (T NIL)))
	((EQUAL TERM1 TERM2) T)
	(T (ITERATE FOR ARG IN (FARGS TERM2) THEREIS (OCCUR TERM1 ARG)))))

(DEFUN OCCUR-CNT (TERM1 TERM2)

;   Return a lower bound on the number of times TERM1 occurs in TERM2.  We do
;   not go inside of QUOTEs in TERM2.

  (COND ((EQUAL TERM1 TERM2) 1)
	((VARIABLEP TERM2) 0)
	((FQUOTEP TERM2) 0)
	(T (ITERATE FOR ARG IN (FARGS TERM2) SUM (OCCUR-CNT TERM1 ARG)))))

(DEFUN OCCUR-LST (X LST) (ITERATE FOR Y IN LST THEREIS (OCCUR X Y)))

(DEFUN ODDS (L)
  (COND ((OR (ATOM L)
	     (ATOM (CDR L)))
	 L)
	(T (CONS (CAR L)
		 (ODDS (CDDR L))))))

(DEFUN ONE-WAY-UNIFY (TERM1 TERM2)
  (SETQ UNIFY-SUBST NIL)
  (ONE-WAY-UNIFY1 TERM1 TERM2))

(DEFUN ONE-WAY-UNIFY-LIST (TERM1-LIST TERM2-LIST)

;   Like ONE-WAY-UNIFY except operates on lists of terms.

  (SETQ UNIFY-SUBST NIL)
  (ITERATE FOR TERM1 IN TERM1-LIST AS TERM2 IN TERM2-LIST
	   ALWAYS (ONE-WAY-UNIFY1 TERM1 TERM2)))

(DEFUN ONE-WAY-UNIFY1 (TERM1 TERM2)
  (LET (OLD-ALIST)
    (SETQ COMMUTED-EQUALITY-FLG NIL)
    (SETQ OLD-ALIST UNIFY-SUBST)
    (COND ((ONE-WAY-UNIFY11 TERM1 TERM2) T)
	  (T (SETQ UNIFY-SUBST OLD-ALIST) NIL))))

(DEFUN ONE-WAY-UNIFY11 (TERM1 TERM2)
  (COND ((VARIABLEP TERM1)
	 (COND ((SETQ TEMP-TEMP (ASSOC-EQ TERM1 UNIFY-SUBST))
		(EQUAL (CDR TEMP-TEMP) TERM2))
	       (T (SETQ UNIFY-SUBST (CONS (CONS TERM1 TERM2)
					  UNIFY-SUBST)))))
	((FQUOTEP TERM1)

;   Since TERM1 is the only one whose variables we instantiate, and is
;   constant, and all terms are in the QUOTE-normal form discussed in
;   CONS-TERM, these two terms unify iff they are EQUAL.

	 (EQUAL TERM1 TERM2))
	((VARIABLEP TERM2) NIL)
	((EQ (FFN-SYMB TERM1) (FN-SYMB TERM2))
	 (COND ((EQ (FFN-SYMB TERM1) (QUOTE EQUAL))
		(LET ((SAVED-UNIFY-SUBST UNIFY-SUBST))
		  (COND ((AND (ONE-WAY-UNIFY11 (FARGN TERM1 1) (FARGN TERM2 1))
			      (ONE-WAY-UNIFY11 (FARGN TERM1 2)
					       (FARGN TERM2 2)))
			 T)
			(T (SETQ UNIFY-SUBST SAVED-UNIFY-SUBST)
			   (AND (ONE-WAY-UNIFY11 (FARGN TERM1 2)
						 (FARGN TERM2 1))
				(ONE-WAY-UNIFY11 (FARGN TERM1 1)
						 (FARGN TERM2 2))
				(SETQ COMMUTED-EQUALITY-FLG T))))))
	       (T (ITERATE FOR ARG1 IN (FARGS TERM1) AS ARG2 IN (SARGS TERM2)
			   ALWAYS (ONE-WAY-UNIFY11 ARG1 ARG2)))))
	(T NIL)))

(DEFUN ONEIFY (TERM TESTS)
  (COND ((VARIABLEP TERM) TERM)
	((FQUOTEP TERM) TERM)
	(T (CASE (FFN-SYMB TERM)
		 (IF (LIST (QUOTE *2*IF)
			   (ONEIFY-TEST (FARGN TERM 1) TESTS)
			   (ONEIFY (FARGN TERM 2)
				   (ONEIFY-ASSUME-TRUE (FARGN TERM 1) TESTS))
			   (ONEIFY (FARGN TERM 3)
				   (ONEIFY-ASSUME-FALSE (FARGN TERM 1) TESTS))))
		 (CONS (LIST (QUOTE CONS)
			     (ONEIFY (FARGN TERM 1) TESTS)
			     (ONEIFY (FARGN TERM 2) TESTS)))
		 (CAR (COND ((IMPLIES? TESTS (FCONS-TERM*(QUOTE LISTP)
							 (FARGN TERM 1)))
			     (LIST (QUOTE CAR)
				   (ONEIFY (FARGN TERM 1) TESTS)))
			    (T (LIST (QUOTE *1*CAR)
				     (ONEIFY (FARGN TERM 1) TESTS)))))
		 (CDR (COND ((IMPLIES? TESTS (FCONS-TERM*(QUOTE LISTP)
							 (FARGN TERM 1)))
			     (LIST (QUOTE CDR)
				   (ONEIFY (FARGN TERM 1) TESTS)))
			    (T (LIST (QUOTE *1*CDR)
				     (ONEIFY (FARGN TERM 1) TESTS)))))
		 ((LISTP EQUAL)
		  (LIST (QUOTE *2*IF)
			(ONEIFY-TEST TERM TESTS)
			(KWOTE *1*T)
			(KWOTE *1*F)))
		 (OTHERWISE
		  (CONS (PACK (LIST STRING-WEIRD (FFN-SYMB TERM)))
			(ITERATE FOR ARG IN (FARGS TERM)
				 COLLECT (ONEIFY ARG TESTS))))))))

(DEFUN ONEIFY-ASSUME-FALSE (TEST TESTS)
  (CONS (NEGATE-LIT TEST)
	TESTS))

(DEFUN ONEIFY-ASSUME-TRUE (TEST TESTS)
  (COND ((ATOM TEST)
	 (CONS TEST TESTS))
	((FQUOTEP TEST)
	 (CONS TEST TESTS))
	((AND (EQ (FFN-SYMB TEST)
		  (QUOTE IF))
	      (EQUAL (FARGN TEST 3)
		     FALSE))
	 (ONEIFY-ASSUME-TRUE (FARGN TEST 1)
			     (ONEIFY-ASSUME-TRUE (FARGN TEST 2)
						 TESTS)))
	(T (CONS TEST TESTS))))

(DEFUN ONEIFY-TEST (TERM TESTS)
  (COND ((VARIABLEP TERM)
	 (LIST (QUOTE NOT)
	       (LIST (QUOTE EQ)
		     TERM
		     (QUOTE *1*F))))
	((FQUOTEP TERM)
	 (NOT (EQ (CADR TERM) *1*F)))
	(T (CASE (FFN-SYMB TERM)
		 (IF (LIST (QUOTE *2*IF)
			   (ONEIFY-TEST (FARGN TERM 1)
					TESTS)
			   (ONEIFY-TEST (FARGN TERM 2)
					(ONEIFY-ASSUME-TRUE
					 (FARGN TERM 1)
					 TESTS))
			   (ONEIFY-TEST (FARGN TERM 3)
					(ONEIFY-ASSUME-FALSE
					 (FARGN TERM 1)
					 TESTS))))
		 (LISTP

;   We have to COPY-TREE the result of this SUB-PAIR so we do not have two EQ
;   occurrences of the arg in the X positions.

		  (COPY-TREE (SUB-PAIR (QUOTE (X *1*SHELL-QUOTE-MARK))
				       (LIST (ONEIFY (FARGN TERM 1) TESTS)
					     (KWOTE *1*SHELL-QUOTE-MARK))
				       (QUOTE (*2*IF (CONSP X)
						     (NOT (EQ (CAR X) *1*SHELL-QUOTE-MARK))
						     NIL)))))
		 (EQUAL (COND ((AND (QUOTEP (FARGN TERM 1))
				    (SYMBOLP (CADR (FARGN TERM 1))))
			       (LIST (QUOTE EQ)
				     (ONEIFY (FARGN TERM 2)
					     TESTS)
				     (FARGN TERM 1)))
			      ((AND (QUOTEP (FARGN TERM 2))
				    (SYMBOLP (CADR (FARGN TERM 2))))
			       (LIST (QUOTE EQ)
				     (ONEIFY (FARGN TERM 1)
					     TESTS)
				     (FARGN TERM 2)))
			      (T (LIST (QUOTE EQUAL)
				       (ONEIFY (FARGN TERM 1)
					       TESTS)
				       (ONEIFY (FARGN TERM 2)
					       TESTS)))))
		 (OTHERWISE
		  (LIST (QUOTE NOT)
			(LIST (QUOTE EQ)
			      (ONEIFY TERM TESTS)
			      (QUOTE *1*F))))))))

(DEFUN OPTIMIZE-COMMON-SUBTERMS (FORM)
  (PROG (SUBTERMS COMMONSUBTERMS PATHS DECISIONS OCC OCC1 OCC2
		  VAR-ALIST PARTI DOUBLE-TERMS NEW-FORM
		  ISOLATED-CNT FIRST-CNT SECOND-CNT)

;   We are interested in evaluating certain LISP FORMs that are constructed out
;   of variables (i.e., SYMBOLPS (none of which begin with 2)), objects of the
;   form (QUOTE x) and FORMs which are proper lists beginning with SYMBOLPs
;   which are either *2*IF or which have LAMBDA spread definitions.  *2*IF
;   behaves as though it had the MACRO ((X Y Z) (COND (X Y) (T Z))).  We assume
;   that no function associated with any function symbol has any effect on the
;   LISP state.  We assume that no variable is bound to the SYMBOLP *1*X.  We
;   assume that there is no structure sharing among the non-QUOTE
;   subexpressions of FORM.

;   Under these hypotheses, we generate and return a LISP form which when
;   evaluated returns the the same value as would be returned by evaluating
;   FORM.  We intentionally ignore the fact that in LISP, if a variable is
;   bound to NOBIND, the evaluation of that variable causes an error.  This
;   does not happened in compiled code.

	(SETQ SUBTERMS (INTERESTING-SUBTERMS FORM))
	(SETQ COMMONSUBTERMS (ITERATE FOR TERM IN SUBTERMS
				      WHEN (ITERATE FOR TERM2 IN SUBTERMS
						    THEREIS (AND (NOT (EQ TERM2 TERM))
								 (EQUAL TERM2 TERM)))
				      COLLECT TERM))
	(COND ((NULL COMMONSUBTERMS)
	       (RETURN FORM)))
	(SETQ PARTI (PARTITION COMMONSUBTERMS))
	(SETQ COMMONSUBTERMS
	      (ITERATE FOR PART IN PARTI
		       UNLESS (ITERATE FOR PART2 IN PARTI
				       THEREIS (PATH-POT-SUBSUMES PART2 PART))
		       APPEND PART))
	(SETQ PATHS (ITERATE FOR P IN (ALL-PATHS FORM)
			     COLLECT (REVERSE (CDR P))))

;   For each term that occurs more than once in FORM, we calculate just how
;   that occurrence occurs on the paths through the FORM.  Given a path, we say
;   the term occurs ISOLATED if no other EQUAL term occurs on the path.  We say
;   the term appears FIRST on the path if some EQUAL term follows it but no
;   EQUAL term precedes it.  We say the term appears SECOND on the path if it
;   occurs on the path but the occurrence is not ISOLATED and is not FIRST,
;   i.e., there is some EQUAL term that has a preceding occurrence on the path.

	(ITERATE FOR TERM IN COMMONSUBTERMS
		 DO (SETQ ISOLATED-CNT 0)
		 (SETQ FIRST-CNT 0)
		 (SETQ SECOND-CNT 0)
		 (ITERATE FOR PATH IN PATHS WHEN (SETQ OCC (MEMBER-EQ TERM PATH))
			  DO (SETQ OCC1 (MEMBER-EQUAL TERM PATH))
			  (SETQ OCC2 (MEMBER-EQUAL TERM (CDR OCC)))
			  (COND ((AND (EQ OCC OCC1) (NULL OCC2))
				 (SETQ ISOLATED-CNT (1+ ISOLATED-CNT)))
				((EQ OCC OCC1) (SETQ FIRST-CNT (1+ FIRST-CNT)))
				(T (SETQ SECOND-CNT (1+ SECOND-CNT)))))

;   For each common subterm, we now decide what to replace the term with.
;   There are 5 alternatives.

;   1.  (SET) Replace the term with (SETQ (v term) term) where (v term) is a
;   SYMBOLP beginning with 2 and such that for all non-EQUAL common subterms s
;   and t of FORM, (v t) is not (v s).

;   2.  (VAR) Replace term with (v term).

;   3.  (TEST) Replace term with (*2*IF (EQ (v term) *1*X) term (v term)).

;   4.  (TEST-AND-SET) Replace term with (*2*if (EQ (v term) *1*x) (SETQ (v
;   term) term) (v term)).

;   5.  Do nothing.

		 (COND ((> FIRST-CNT 0)
			(COND ((> SECOND-CNT 0)
			       (SETQ DECISIONS (CONS (CONS TERM
							   (QUOTE TEST-AND-SET))
						     DECISIONS)))
			      (T (SETQ DECISIONS (CONS (CONS TERM (QUOTE SET))
						       DECISIONS)))))
		       ((> SECOND-CNT 0)
			(COND ((> ISOLATED-CNT 0)
			       (SETQ DECISIONS (CONS (CONS TERM (QUOTE TEST))
						     DECISIONS)))
			      (T

;   This is the only decision that deserves serious consideration.  All of the
;   other decisions obviously result in correct behavior.  Here, we know that
;   the term always occurs second.  Thus we are guaranteed that on every path
;   to term, an equal term will have previously been evaluated.  For each such
;   path, some EQUAL term will have a FIRST occurrence and every term that is
;   ever first is always SET or TEST-AND-SET.

			       (SETQ DECISIONS (CONS (CONS TERM (QUOTE VAR))
						     DECISIONS)))))
		       (T NIL)))

;   We now construct a list of the common subterms, omitting EQUAL
;   duplications.  We wish to associate a unique variable *2*TEMPi, for some i,
;   with all EQUAL common subterms.

	(SETQ DOUBLE-TERMS (ITERATE FOR D IN DECISIONS WITH ITERATE-ANS DO
				    (SETQ ITERATE-ANS
					  (ADD-TO-SET (CAR D) ITERATE-ANS))
				    FINALLY (RETURN ITERATE-ANS)))
	(SETQ VAR-ALIST
	      (ITERATE FOR D IN DOUBLE-TERMS AS I FROM 1
		       COLLECT (CONS D (PACK (LIST STRING-WEIRD2
						   (QUOTE TEMP)
						   I)))))

;   Using DOUBLE-TERMS and VAR-ALIST, COMMON-SWEEP now carries out the
;   DECISIONS.

	(SETQ NEW-FORM (COMMON-SWEEP FORM))
	(RETURN (LIST (QUOTE LET)
		      (ITERATE FOR PAIR IN VAR-ALIST
			       COLLECT (LIST (CDR PAIR) (QUOTE (QUOTE *1*X))))
		      NEW-FORM))))

(DEFUN OUR-EXPLODEN (SYM)
  (LET ((S (SYMBOL-NAME SYM)))
    (ITERATE FOR I FROM 0 TO (1- (LENGTH S))
	     COLLECT (CHAR-CODE (CHAR S I)))))

(DEFUN OUR-FLATC (X)
  (COND ((STRINGP X) (LENGTH X))
	((SYMBOLP X) (LENGTH (SYMBOL-NAME X)))
	((INTEGERP X) (OUR-FLATC-NUMBER X))
	(T (LENGTH (FORMAT NIL "~A" X)))))

(DEFUN OUR-FLATC-NUMBER (N)
  (COND ((< N 0) (1+ (OUR-FLATC-NUMBER (- N))))
	((< N 10) 1)
	(T (1+ (OUR-FLATC-NUMBER (FLOOR (/ N 10)))))))

(DEFUN OUR-GETCHARN (X N)
  (CHAR-CODE (CHAR (SYMBOL-NAME X) (1- N))))

(DEFUN PARTITION (L)

;   Returns a list of lists.  Each member of L is a MEMBer of exactly one the
;   of list of lists.  Each MEMBer of each list is a MEMBer of L.

  (LET (POT TEMP)
    (ITERATE FOR L1 IN L DO (SETQ TEMP (ASSOC-EQUAL L1 POT))
	     (COND ((NULL TEMP)
		    (SETQ POT (CONS (LIST L1)
				    POT)))
		   (T (NCONC1 TEMP L1))))
    POT))

(DEFUN PARTITION-CLAUSES (LST)
  (LET (ALIST FLG POCKETS N)
    (SETQ LST (ITERATE FOR CL IN LST COLLECT (CONS NIL CL)))
    (ITERATE FOR PAIR IN LST
	     DO (ITERATE FOR LIT IN (CDR PAIR)
			 DO
			 (PROGN
			   (SETQ FLG (MATCH LIT (NOT LIT)))
			   (SETQ TEMP-TEMP (ASSOC-EQUAL LIT ALIST))
			   (COND ((NULL TEMP-TEMP)
				  (SETQ TEMP-TEMP (LIST LIT FLG PAIR))
				  (SETQ ALIST (CONS TEMP-TEMP ALIST)))
				 ((EQUAL (CADR TEMP-TEMP)
					 0)
				  NIL)
				 ((NOT (EQ FLG (CADR TEMP-TEMP)))
				  (RPLACA (CDR TEMP-TEMP)
					  0))
				 (T (RPLACD (CDR TEMP-TEMP)
					    (CONS PAIR (CDDR TEMP-TEMP))))))))
    (SETQ N (LENGTH LST))
    (ITERATE FOR PAIR IN ALIST WHEN (AND (NOT (EQUAL (CADR PAIR)
						     0))
					 (NOT (= (LENGTH (CDDR PAIR))
						 N)))
	     DO (SETQ POCKETS (CONS (ITERATE FOR PAIR IN (CDDR PAIR)
					     UNLESS (CAR PAIR)
					     COLLECT (PROGN (RPLACA PAIR T)
							    (CDR PAIR)))
				    POCKETS)))
    (COND ((SETQ TEMP-TEMP (ITERATE FOR PAIR IN LST
				    UNLESS (CAR PAIR)
				    COLLECT (CDR PAIR)))
	   (SETQ POCKETS (CONS TEMP-TEMP POCKETS))))
    POCKETS))

(DEFUN PATH-ADD-TO-SET (X Y)
  (COND ((ITERATE FOR Y1 IN Y THEREIS (PATH-EQ X Y1))
	 Y)
	(T (CONS X Y))))

(DEFUN PATH-EQ (X Y)
  (AND (= (LENGTH X) (LENGTH Y))
       (ITERATE FOR X1 IN X AS Y1 IN Y ALWAYS (EQ X1 Y1))))

(DEFUN PATH-POT-SUBSUMES (LARGER SMALLER)
  (ITERATE FOR I FROM 1 TO (1- (LENGTH (CAR LARGER)))
	   THEREIS (ITERATE FOR S IN SMALLER ALWAYS
			    (ITERATE FOR L IN LARGER
				     THEREIS (EQ S (FARGN L I))))))

(DEFUN PATH-UNION (X Y)
  (NCONC (ITERATE FOR X1 IN X
		  UNLESS
		  (ITERATE FOR Y1 IN Y THEREIS (PATH-EQ X1 Y1))
		  COLLECT X1)
	 Y))

(DEFUN PEGATE-LIT (TERM)
  (COND ((FALSE-NONFALSEP TERM)
	 (COND (DEFINITELY-FALSE FALSE)
	       (T TRUE)))
	(T TERM)))

(DEFUN PETITIO-PRINCIPII (EVENTS ALL-FLG FAILURE-ACTION
				 DO-NOT-PRINT-FIRST-EVENT-FLG
				 DO-NOT-PRINT-DATE-LINE-FLG)
  (REDO-UNDONE-EVENTS (ITERATE FOR X IN EVENTS
			       COLLECT (COND ((EQ (CAR X)
						  (QUOTE PROVE-LEMMA))
					      (LIST (QUOTE ADD-AXIOM)
						    (CADR X)
						    (CADDR X)
						    (CADDDR X)))
					     (T X)))
		      ALL-FLG FAILURE-ACTION
		      DO-NOT-PRINT-FIRST-EVENT-FLG
		      DO-NOT-PRINT-DATE-LINE-FLG))

(DEFUN PICK-HIGH-SCORES (CANDLST)

;   Returns the list of elements of CAND-LIST tied for the highest CAR.

  (MAXIMAL-ELEMENTS CANDLST (FUNCTION (LAMBDA (CAND)
					(ACCESS CANDIDATE SCORE CAND)))))

(DEFUN PIGEON-HOLE
  (PIGEONS HOLES FN DO-NOT-CROWD-FLG DO-NOT-SMASH-FLG)
  (LET (PAIRLST)
    (SETQ PAIRLST (ITERATE FOR X IN HOLES COLLECT (CONS NIL X)))
    (COND ((PIGEON-HOLE1 PIGEONS PAIRLST FN DO-NOT-CROWD-FLG
			 DO-NOT-SMASH-FLG)
	   (COND (DO-NOT-SMASH-FLG HOLES)
		 (T (ITERATE FOR PAIR IN PAIRLST COLLECT (CDR PAIR)))))
	  (T NIL))))

(DEFUN PIGEON-HOLE-IN-ALL-POSSIBLE-WAYS
  (PIGEONS HOLES FN DO-NOT-CROWD-FLG)
  (LET (ANS POT X)
    (COND ((ITERATE FOR PIGEON IN PIGEONS
		    ALWAYS
		    (PROGN
		      (SETQ POT
			    (ITERATE FOR HOLE IN HOLES
				     WHEN (SETQ X
						(FUNCALL FN PIGEON HOLE))
				     COLLECT (CONS HOLE X)))
		      (COND (POT (SETQ ANS (NCONC1 ANS POT)))
			    (T NIL))))
	   (COND ((AND DO-NOT-CROWD-FLG
		       (NOT (NO-CROWDINGP
			     ANS
			     (FUNCTION (LAMBDA (X Y)
					 (EQ (CAR X)
					     (CAR Y))))
			     NIL)))
		  NIL)
		 (T (UNION-EQUAL (ITERATE FOR X IN ANS
					  NCONC (ITERATE FOR Y IN X
							 COLLECT (CDR Y)))
				 (ITERATE FOR HOLE IN HOLES
					  UNLESS (ITERATE FOR X IN ANS
							  THEREIS (ASSOC-EQ HOLE X))
					  COLLECT HOLE)))))
	  (T NIL))))

(DEFUN PIGEON-HOLE1
  (PIGEONS PAIRLST FN DO-NOT-CROWD-FLG DO-NOT-SMASH-FLG)
  (LET (TEMP OLD-FLG OLD-HOLE)
    (COND ((NULL PIGEONS)
	   T)
	  ((ITERATE FOR PAIR IN PAIRLST
		    UNLESS (AND DO-NOT-CROWD-FLG (CAR PAIR))
		    THEREIS (COND ((SETQ TEMP (FUNCALL FN (CAR PIGEONS)
						       (CDR PAIR)))
				   (SETQ OLD-FLG (CAR PAIR))
				   (SETQ OLD-HOLE (CDR PAIR))
				   (OR DO-NOT-SMASH-FLG
				       (RPLACD PAIR TEMP))
				   (RPLACA PAIR T)
				   (COND ((PIGEON-HOLE1 (CDR PIGEONS)
							PAIRLST FN
							DO-NOT-CROWD-FLG
							DO-NOT-SMASH-FLG)
					  T)
					 (T (RPLACD PAIR OLD-HOLE)
					    (RPLACA PAIR OLD-FLG)
					    NIL)))
				  (T NIL)))
	   T)
	  (T NIL))))

(DEFUN PLUSJOIN (LST)
  (COND ((NULL LST)
	 (QUOTE (ZERO)))
	((NULL (CDR LST))
	 (CAR LST))
	(T (FCONS-TERM* (QUOTE PLUS)
			(CAR LST)
			(PLUSJOIN (CDR LST))))))

(DEFUN POLY-MEMBER (POLY LST)
  (ITERATE FOR POLY2 IN LST THEREIS (AND (EQUAL (ACCESS POLY CONSTANT POLY)
						(ACCESS POLY CONSTANT POLY2))
					 (EQUAL (ACCESS POLY ALIST POLY)
						(ACCESS POLY ALIST POLY2)))))

(DEFUN POP-CLAUSE-SET NIL
  (PROG (CL-SET TEMP)
	TOP (COND ((NULL STACK)
		   (WRAPUP T))
		  ((EQ (CAAR STACK)
		       (QUOTE BEING-PROVED))
		   (SETQ TEMP (CADR (CAR STACK)))
		   (SETQ STACK (CDR STACK))
		   (IO (QUOTE POP)
		       TEMP NIL NIL (LIST (GET-STACK-NAME STACK)))
		   (GO TOP))
		  (T (SETQ CL-SET (CADR (CAR STACK)))
		     (SETQ STACK (CDR STACK))))
	(COND
	 ((CATCH (QUOTE SUBSUMED-BELOW)
	    (ITERATE FOR STACK-TAIL ON STACK
		     DO (COND ((ITERATE FOR CL2 IN CL-SET
					ALWAYS (ITERATE FOR CL1
							IN (CADR (CAR STACK-TAIL))
							THEREIS (SUBSUMES CL1 CL2)))
			       (COND ((EQ (CAR (CAR STACK-TAIL))
					  (QUOTE BEING-PROVED))
				      (IO (QUOTE SUBSUMED-BY-PARENT)
					  CL-SET NIL NIL
					  (LIST (GET-STACK-NAME STACK)
						(GET-STACK-NAME (CDR STACK-TAIL))
						(CADR (CAR STACK-TAIL))))
				      (WRAPUP NIL))
				     (T (IO (QUOTE SUBSUMED-BELOW)
					    CL-SET NIL NIL
					    (LIST (GET-STACK-NAME STACK)
						  (GET-STACK-NAME
						   (CDR STACK-TAIL))
						  (CADR (CAR STACK-TAIL))))
					(THROW (QUOTE SUBSUMED-BELOW) T)))))))
	  (GO TOP)))
	(SETQ STACK (CONS (LIST (QUOTE BEING-PROVED)
				CL-SET)
			  STACK))
	(RETURN CL-SET)))

(DEFUN POP-LEMMA-FRAME NIL
  (PROG1 (CAR LEMMA-STACK)
    (RPLACA (PROG1 LEMMA-STACK
	      (OR (SETQ LEMMA-STACK (CADR LEMMA-STACK))
		  (ERROR1 (PQUOTE (PROGN LEMMA-STACK |is| |too|
					 |pooped| |to| |pop| !))
			  NIL
			  (QUOTE HARD))))
	    NIL)))

(DEFUN POP-LINEARIZE-ASSUMPTIONS-FRAME NIL
  (PROG1 (CAR LINEARIZE-ASSUMPTIONS-STACK)
    (RPLACA (PROG1 LINEARIZE-ASSUMPTIONS-STACK
	      (OR (SETQ LINEARIZE-ASSUMPTIONS-STACK
			(CADR LINEARIZE-ASSUMPTIONS-STACK))
		  (ERROR1 (PQUOTE (PROGN
				    LINEARIZE-ASSUMPTIONS-STACK |is|
				    |too| |pooped| |to| |pop|
				    !))
			  NIL
			  (QUOTE HARD))))
	    NIL)))

(DEFUN POPU NIL
  (SETQ UNDONE-EVENTS (CAR UNDONE-EVENTS-STACK))
  (SETQ UNDONE-EVENTS-STACK (CDR UNDONE-EVENTS-STACK))
  UNDONE-EVENTS)

(DEFUN POSSIBLE-IND-PRINCIPLES (TERM)

;   TERM is a non-QUOTE fn call and this fn returns all the induction
;   principles suggested by it.  See FLESH-OUT-IND-PRIN for the form of an
;   induction prin.

  (LET (MACHINE FORMALS QUICK-BLOCK-INFO MASK)
    (SETQ FORMALS (CADR (GET (FFN-SYMB TERM)
			     (QUOTE SDEFN))))
    (SETQ QUICK-BLOCK-INFO (GET (FFN-SYMB TERM)
				(QUOTE QUICK-BLOCK-INFO)))
    (SETQ MACHINE (GET (FFN-SYMB TERM)
		       (QUOTE INDUCTION-MACHINE)))
    (COND ((DISABLEDP (FFN-SYMB TERM))
	   NIL)
	  (T (ITERATE FOR J IN (GET (FFN-SYMB TERM)
				    (QUOTE JUSTIFICATIONS))
		      WHEN (SETQ MASK
				 (SOUND-IND-PRIN-MASK TERM J FORMALS
						      QUICK-BLOCK-INFO))
		      COLLECT (FLESH-OUT-IND-PRIN TERM FORMALS
						  MACHINE J MASK
						  QUICK-BLOCK-INFO))))))

(DEFUN POSSIBLY-NUMERIC (TERM)
  (LET ((TYPE-ALIST (OR HEURISTIC-TYPE-ALIST TYPE-ALIST)))
    (= (TYPE-SET TERM)
       TYPE-SET-NUMBERS)))

(DEFUN POWER-EVAL (L B)
  (IF (ATOM L)
      0
      (+ (CAR L) (* B (POWER-EVAL (CDR L) B)))))

(DEFUN POWER-REP (N B)
  (IF (< N B)
      (LIST N)
      (CONS (OUR-REMAINDER N B)
	    (POWER-REP (OUR-QUOTIENT N B) B))))

(DEFUN PPC (CL)
  (PPR (PRETTYIFY-CLAUSE CL) NIL)
  NIL)

(DEFUN PPE (X) (PPE-LST (LIST X)))

(DEFUN PPE-LST (X)
  (ITERATE FOR NAME IN X
	   DO
	   (ITERPRI NIL)
	   (PPR (OR (AND (SYMBOLP NAME) (GET NAME (QUOTE EVENT)))
		    (AND (SYMBOLP NAME)
			 (GET NAME (QUOTE MAIN-EVENT))
			 (LIST (QUOTE *****) NAME (QUOTE |is|)
			       (QUOTE |a|) (QUOTE |satellite|) (QUOTE |of|)
			       (GET (GET NAME (QUOTE MAIN-EVENT))
				    (QUOTE EVENT))))
		    (CONS (QUOTE *****)
			  (CONS NAME
				(QUOTE (|is| |neither| |an| |event| |nor|
					     |satellite|)))))
		NIL)
	   (ITERPRI NIL)))

(DEFUN PPR (FMLA PPRFILE)
  (LET (LEFTMARGINCHAR)
    (PPRIND FMLA 0 0 PPR-MACRO-LST PPRFILE)
    NIL))

(DEFUN PPRINDENT (TERM LEFTMARGIN RPARCNT FILE)
  (COND ((> (IPOSITION FILE NIL NIL)
	    LEFTMARGIN)
	 (ITERPRISPACES LEFTMARGIN FILE))
	(T (TABULATE LEFTMARGIN FILE)))
  (PPRIND TERM LEFTMARGIN (OR RPARCNT 0)
	  PPR-MACRO-LST FILE))

(DEFUN PPSD (X) (PPSD-LST (LIST X)))

(DEFUN PPSD-LST (X)
  (ITERATE FOR FNNAME IN X DO (PPR (LIST FNNAME (OR (GET FNNAME
							 (QUOTE SDEFN))
						    (QUOTE |undefined|)))
				   NIL)
	   (ITERPRI NIL)
	   (ITERPRI NIL)))

(DEFUN PREPROCESS (TERM)

;   Returns a set of clauses whose conjunction is equivalent to TERM and sets
;   ABBREVIATIONS-USED to the list of fn symbols and rewrite rules applied.

  (LET (TYPE-ALIST)
    (SETQ ABBREVIATIONS-USED NIL)
    (CLAUSIFY-INPUT (EXPAND-ABBREVIATIONS TERM NIL))))

(DEFUN PREPROCESS-HYPS (HYPS)

;   Expand NLISTP and NOT ZEROP hyps.

  (ITERATE FOR HYP IN HYPS WITH X
	   NCONC (COND ((MATCH HYP (NOT (ZEROP X)))
			(LIST (FCONS-TERM* (QUOTE NUMBERP)
					   X)
			      (FCONS-TERM* (QUOTE NOT)
					   (FCONS-TERM* (QUOTE EQUAL)
							X ZERO))))
		       ((MATCH HYP (NLISTP X))
			(LIST (FCONS-TERM* (QUOTE NOT)
					   (FCONS-TERM* (QUOTE LISTP)
							X))))
		       (T (LIST HYP)))))

(DEFUN PRETTYIFY-CLAUSE (CL)
  (COND ((NULL CL)
	 FALSE)
	((NULL (CDR CL))
	 (CAR CL))
	((NULL (CDDR CL))
	 (LIST (QUOTE IMPLIES)
	       (DUMB-NEGATE-LIT (CAR CL))
	       (CADR CL)))
	(T (LIST (QUOTE IMPLIES)
		 (CONS (QUOTE AND)
		       (ITERATE FOR TAIL ON CL UNLESS (NULL (CDR TAIL))
				COLLECT (DUMB-NEGATE-LIT (CAR TAIL))))
		 (CAR (OUR-LAST CL))))))

(DEFUN PRETTYIFY-LISP (X)
  (REMOVE-*2*IFS (INTRODUCE-ANDS (INTRODUCE-LISTS X))))

(DEFUN PRIMITIVE-RECURSIVEP (FNNAME)
  (LET (FORMALS)
    (SETQ FORMALS (CADR (GET FNNAME (QUOTE SDEFN))))
    (COND ((DISABLEDP FNNAME)
	   T)
	  (T (ITERATE FOR X IN (GET FNNAME (QUOTE INDUCTION-MACHINE))
		      ALWAYS (ITERATE FOR CASE IN (ACCESS TESTS-AND-CASES CASES X)
				      ALWAYS
				      (ITERATE FOR VAR IN FORMALS AS TERM IN CASE
					       ALWAYS (SHELL-DESTRUCTOR-NESTP
						       VAR
						       TERM))))))))

(DEFUN PRIMITIVEP (TERM)
  (OR (VARIABLEP TERM)
      (FQUOTEP TERM)
      (AND (OR (NULL (GET (FFN-SYMB TERM)
			  (QUOTE SDEFN)))
	       (DISABLEDP (FFN-SYMB TERM))
	       (EQ (FFN-SYMB TERM)
		   (QUOTE NOT)))
	   (ITERATE FOR ARG IN (FARGS TERM) ALWAYS (PRIMITIVEP ARG)))))

(DEFUN PRINT-IDATE (N FILE)
  (LET (SEC MIN HRS DAY MO YR (*PRINT-BASE* 10) (*READ-BASE* 10))
    (MATCH (DECODE-IDATE N) (LIST SEC MIN HRS DAY MO YR))
    (IPRINC (NTH (1- MO)
		 (QUOTE (|January| |February| |March| |April| |May|
				   |June| |July| |August| |September|
				   |October| |November| |December|)))
	    FILE)
    (ISPACES 1 FILE)
    (IPRINC DAY FILE)
    (IPRINC (QUOTE |,|) FILE)
    (ISPACES 1 FILE)
    (IPRINC (+ 1900 YR) FILE)
    (ISPACES 2 FILE)
    (IPRINC HRS FILE)
    (IPRINC (QUOTE |:|) FILE)
    (IPRINC MIN FILE)
    (IPRINC (QUOTE |:|) FILE)
    (IPRINC SEC FILE)
    N))

(DEFUN PRINT-STACK (Y)
  (ITERATE FOR X ON Y BY (QUOTE CADR) DO (PRINT (CAR X) T)))

(DEFUN PRINT-STATS (ELAPSED PROVE IO FILE)
  (ITERPRI FILE)
  (IPRINC (QUOTE |[|) FILE)
  (ISPACES 1 FILE)
  (PRINC-TRUNC-TO-1 ELAPSED FILE)
  (ISPACES 1 FILE)
  (PRINC-TRUNC-TO-1 PROVE FILE)
  (ISPACES 1 FILE)
  (PRINC-TRUNC-TO-1 IO FILE)
  (ISPACES 1 FILE)
  (IPRINC (QUOTE  |]|) FILE)
  (ITERPRI FILE))

(DEFUN PRINC-TRUNC-TO-1 (X FILE)
  (IPRINC (FLOOR X) FILE)
  (IPRINC (QUOTE |.|) FILE)
  (IPRINC (FLOOR (* 10 (- X (FLOOR X)))) FILE))
 
(DEFUN PRINT-TO-DISPLAY (MSG1 MSG2 MSG3)
  (COND ((NULL LEMMA-DISPLAY-FLG))
	((EQ LEMMA-DISPLAY-FLG (QUOTE MODEL33))
	 (ITERATE FOR I FROM 1 TO (1- (STACK-DEPTH LEMMA-STACK))
		  DO

;   STACK-DEPTH starts at 1 and we want 0 leading chars at first.  In
;   LEMMA-DISPLAY mode T we use STACK-DEPTH because lines on the screen are
;   numbered from 1.

;   The CONSTANT below is just vertical bar, but if typed explicitly it is
;   brought up from emacs incorrectly.

		  (IPRINC (QUOTE \|) T))
	 (IPRINC (QUOTE *) T)
	 (IPRINC MSG1 T)
	 (COND (MSG2 (ISPACES 1 T)
		     (IPRINC MSG2 T)))
	 (COND (MSG3 (IPRINC MSG3 T)))
	 (ITERPRI T))

	(T #| (PUT-CURSOR 1 (STACK-DEPTH LEMMA-STACK))
	   (ERASE-EOP)
	   (IPRINC MSG1 T)
	   (COND (MSG2 (ISPACES 1 T)
		       (IPRINC MSG2 T)))
	   (COND (MSG3 (IPRINC MSG3 T))) |#
	   (ERROR (PQUOTE (PROGN |LEMMA-DISPLAY-FLG| |must| |be| |NIL| |or| MODEL33 |.|))
		  NIL
		  (QUOTE HARD)))))

(DEFUN PROCESS-EQUATIONAL-POLYS (CL HIST POT-LST)

;   Deduce from POT-LST all the interesting equations in it and add them to CL
;   unless they have already been generated and recorded in HIST.  This
;   function has no effect on the lemma and assumptions stacks but sets the
;   globals LEMMAS-USED-BY-LINEAR and LINEAR-ASSUMPTIONS if it changes CL.
;   When it adds an equation to CL it adds an entry to LEMMAS-USED-BY-LINEAR
;   that will ultimately be copied into the new hist for the clause.  The entry
;   is of the form ((FIND-EQUATIONAL-POLYS lhs . rhs)) -- the apparently
;   redundant level of parens is there to insure that the element cannot be
;   confused with a term.  Thus, when it is thrown into the list PROCESS-HIST
;   with lemma names and literals used, we can filter out the literals.
;   SIMPLIFY-CLAUSE handles this filtering above us.  FIND-EQUATIONAL-POLY is
;   the function that adds such entries to LEMMAS-USED-BY-LINEAR and that looks
;   for them in the HIST.

  (SETQ LEMMAS-USED-BY-LINEAR NIL)
  (SETQ LINEAR-ASSUMPTIONS NIL)
  (ITERATE FOR POT IN POT-LST WITH PAIR
	   WHEN (SETQ PAIR (FIND-EQUATIONAL-POLY HIST POT))
	   DO

;   When FIND-EQUATIONAL-POLY returns nonNIL it side-effects the two global
;   collection sites above.

	   (SETQ CL (COND ((AND (VARIABLEP (CAR PAIR))
				(NOT (OCCUR (CAR PAIR)
					    (CDR PAIR))))
			   (SUBST-VAR-LST (CDR PAIR)
					  (CAR PAIR)
					  CL))
			  ((AND (VARIABLEP (CDR PAIR))
				(NOT (OCCUR (CDR PAIR)
					    (CAR PAIR))))
			   (SUBST-VAR-LST (CAR PAIR)
					  (CDR PAIR)
					  CL))
			  (T (CONS (FCONS-TERM* (QUOTE NOT)
						(FCONS-TERM* (QUOTE EQUAL)
							     (CAR PAIR)
							     (CDR PAIR)))
				   (SUBST-EXPR-LST (CDR PAIR)
						   (CAR PAIR)
						   CL))))))
  CL)

(DEFUN PROPERTYLESS-SYMBOLP (X)
  (OR (CAR-CDRP X)
      (MEMBER-EQ X (QUOTE (NIL QUOTE LIST T F)))))

(DEFUN PROVE (FORM)
  (LET ((TIME (TIME-IN-60THS)))
    (PROG1
	(CATCH (QUOTE PROVE)
	  (PROG (THM CLAUSES VARS)
		(CHK-INIT)
		(SETQ THM (TRANSLATE FORM))
		(SETQ CLAUSES (PREPROCESS THM))
		(SETUP FORM CLAUSES ABBREVIATIONS-USED)
		LOOP(SETQ VARS (ITERATE FOR CL IN CLAUSES WITH ITERATE-ANS
					DO (SETQ ITERATE-ANS
						 (UNION-EQ (ALL-VARS-LST CL)
							   ITERATE-ANS))
					FINALLY (RETURN ITERATE-ANS)))
		(SETQ ELIM-VARIABLE-NAMES1 (SET-DIFF ELIM-VARIABLE-NAMES VARS))
		(SETQ GEN-VARIABLE-NAMES1 (SET-DIFF GEN-VARIABLE-NAMES VARS))
		(SIMPLIFY-LOOP CLAUSES)
		(SETQ CLAUSES (INDUCT (POP-CLAUSE-SET)))
		(GO LOOP)))
      (SETQ PROVE-TIME (- (- (TIME-IN-60THS) TIME)
			  IO-TIME)))))

(DEFUN PROVE-TERMINATION (FORMALS RM MACHINE)
  (LET ((TIME (TIME-IN-60THS)))
    (SETQ PROVE-TERMINATION-LEMMAS-USED NIL)
    (PROG1 
	(ITERATE FOR X IN MACHINE
		 ALWAYS
		 (COND ((AND (SIMPLIFY-CLAUSE-MAXIMALLY
			      (NCONC1 (ITERATE FOR H IN (ACCESS TESTS-AND-CASE TESTS X)
					       COLLECT (NEGATE-LIT H))
				      (CONS-TERM (CAR RM)
						 (LIST (SUB-PAIR-VAR FORMALS
								     (ACCESS
								      TESTS-AND-CASE
								      CASE X)
								     (CADR RM))
						       (CADR RM)))))
			     (NULL PROCESS-CLAUSES))
			(SETQ PROVE-TERMINATION-LEMMAS-USED
			      (UNION-EQUAL PROCESS-HIST PROVE-TERMINATION-LEMMAS-USED))
			T)
		       (T NIL)))
      (SETQ PROVE-TIME (+ PROVE-TIME
			  (- (TIME-IN-60THS) TIME))))))

(DEFUN PROVEALL (EVENT-LST FILENAME)
  (SETQ FAILED-EVENTS NIL)
  (SETQ MASTER-ROOT-NAME (OR FILENAME (QUOTE PROVEALL)))
  (SETQ PROVE-FILE (OPEN (EXTEND-FILE-NAME MASTER-ROOT-NAME
					   (QUOTE PROOFS))
			 :DIRECTION :OUTPUT))
  (OUR-LINEL PROVE-FILE LINEL-VALUE)
  (SETQ TTY-FILE (OPEN (EXTEND-FILE-NAME MASTER-ROOT-NAME
					 (QUOTE TTY))
		       :DIRECTION :OUTPUT))
  (OUR-LINEL TTY-FILE LINEL-VALUE)
  (REDO-UNDONE-EVENTS EVENT-LST T (QUOTE A)
		      NIL NIL)
  (MAKE-LIB MASTER-ROOT-NAME))

(DEFUN PUSH-CLAUSE-SET (CL-SET)
  (SETQ STACK (CONS (LIST (QUOTE TO-BE-PROVED)
			  CL-SET)
		    STACK)))

(DEFUN PUSH-LEMMA (ELE)
  (COND ((MEMBER-EQ ELE (CAR LEMMA-STACK))
	 NIL)
	(T (RPLACA LEMMA-STACK (CONS ELE (CAR LEMMA-STACK)))
	   NIL)))

(DEFUN PUSH-LEMMA-FRAME NIL
  (COND ((ATOM (CDDR LEMMA-STACK))
	 (RPLACD (CDR LEMMA-STACK)
		 (CREATE-STACK1 10))
	 (RPLACA (CDDDR LEMMA-STACK)
		 LEMMA-STACK)))
  (SETQ LEMMA-STACK (CDDR LEMMA-STACK))
  (RPLACA LEMMA-STACK NIL)
  NIL)

(DEFUN PUSH-LINEARIZE-ASSUMPTION (ELE)
  (RPLACA LINEARIZE-ASSUMPTIONS-STACK
	  (ADD-TO-SET ELE (CAR LINEARIZE-ASSUMPTIONS-STACK)))
  NIL)

(DEFUN PUSH-LINEARIZE-ASSUMPTIONS-FRAME NIL
  (COND ((ATOM (CDDR LINEARIZE-ASSUMPTIONS-STACK))
	 (RPLACD (CDR LINEARIZE-ASSUMPTIONS-STACK)
		 (CREATE-STACK1 10))
	 (RPLACA (CDDDR LINEARIZE-ASSUMPTIONS-STACK)
		 LINEARIZE-ASSUMPTIONS-STACK)))
  (SETQ LINEARIZE-ASSUMPTIONS-STACK
	(CDDR LINEARIZE-ASSUMPTIONS-STACK))
  (RPLACA LINEARIZE-ASSUMPTIONS-STACK NIL)
  NIL)

(DEFUN PUSHU NIL
  (SETQ UNDONE-EVENTS-STACK (CONS UNDONE-EVENTS UNDONE-EVENTS-STACK))
  (SETQ UNDONE-EVENTS NIL))

(DEFUN PUT-INDUCTION-INFO
  (FNNAME FORMALS BODY RELATION-MEASURE-LST TAK0)

;   If FNNAME is recursive we store JUSTIFICATIONS, INDUCTION-MACHINE, and
;   QUICK-BLOCK-INFO properties.  If only one JUSTIFICATION is stored and in it
;   the RELATION is NIL then we did not establish termination.  ALL-LEMMAS-USED
;   is side-effected to contain lemma names used to clean up the
;   INDUCTION-MACHINE.

;   If TAK0 is nonNIL, then we are considering a reflexive definition. (tak0 .
;   args) = body is allegedly the justifying lemma for the definition (fnname .
;   args) = body', where body' results from replacing all calls of tak0 with
;   fnname.

  (PROG (T-MACHINE I-MACHINE)
	(SETQ T-MACHINE (TERMINATION-MACHINE (OR TAK0 FNNAME) BODY NIL))
	(COND ((NULL T-MACHINE)
	       (SETQ ALL-LEMMAS-USED NIL)
	       (RETURN NIL)))
	(OR RELATION-MEASURE-LST
	    (SETQ RELATION-MEASURE-LST
		  (GUESS-RELATION-MEASURE-LST FORMALS T-MACHINE)))
	(ADD-FACT FNNAME (QUOTE JUSTIFICATIONS)
		  (OR (ITERATE FOR RM IN RELATION-MEASURE-LST
			       WHEN (PROVE-TERMINATION FORMALS RM
						       T-MACHINE)
			       COLLECT (MAKE JUSTIFICATION
					     (ALL-VARS (CADR RM))
					     (CADR RM)
					     (CAR RM)
					     PROVE-TERMINATION-LEMMAS-USED))
		      (LIST (MAKE JUSTIFICATION FORMALS NIL NIL NIL))))
	(SETQ ALL-LEMMAS-USED NIL)

;   We set ALL-LEMMAS-USED to NIL to forget the lemmas put there by PROVE so we
;   can now accumulate the lemmas used by REMOVE-REDUNDANT-TESTS in
;   INDUCTION-MACHINE.

	(SETQ I-MACHINE
	      (INDUCTION-MACHINE FNNAME
				 (COND (TAK0 (SUBST-FN FNNAME TAK0 BODY))
				       (T BODY))
				 NIL))
	(ADD-FACT FNNAME (QUOTE INDUCTION-MACHINE) I-MACHINE)
	(ADD-FACT FNNAME (QUOTE QUICK-BLOCK-INFO)
		  (QUICK-BLOCK-INFO FORMALS I-MACHINE))
	(RETURN NIL)))

(DEFUN PUT-LEVEL-NO (FNNAME)
  (LET (BODY MAX)
    (SETQ BODY (CADDR (GET FNNAME (QUOTE SDEFN))))
    (SETQ MAX (COND (BODY (OR (ITERATE FOR FN IN (ALL-FNNAMES BODY)
				       WHEN (NOT (EQ FN FNNAME))
				       MAXIMIZE (GET-LEVEL-NO FN))
			      0))
		    (T 0)))
    (ADD-FACT FNNAME (QUOTE LEVEL-NO)
	      (COND ((FNNAMEP FNNAME BODY)
		     (1+ MAX))
		    (T MAX)))))

(DEFUN PUT-TYPE-PRESCRIPTION (NAME)

;   *************************************************************
;   THIS FUNCTION WILL BE COMPLETELY UNSOUND IF TYPE-SET
;   IS EVER REACHABLE FROM WITHIN IT.
;   IN PARTICULAR, BOTH THE TYPE-ALIST AND THE
;   TYPE-PRESCRIPTION FOR THE FN BEING PROCESSED ARE SET
;   TO ONLY PARTIALLY ACCURATE VALUES AS THIS FN
;   COMPUTES THE REAL TYPE-SET.
;   *************************************************************

  (PROG (OLD-TYPE-PRESCRIPTION NEW-TYPE-PRESCRIPTION BODY FORMALS
			       TYPE-ALIST ANS TEMP)
	(SETQ BODY (GET NAME (QUOTE SDEFN)))
	(SETQ FORMALS (CADR BODY))
	(SETQ BODY (CADDR BODY))
	(SETQ TYPE-ALIST (ITERATE FOR ARG IN FORMALS
				  COLLECT (CONS ARG (CONS 0 (LIST ARG)))))
	(SETQ OLD-TYPE-PRESCRIPTION
	      (CONS 0 (ITERATE FOR ARG IN FORMALS
			       COLLECT NIL)))
	(ADD-FACT NAME (QUOTE TYPE-PRESCRIPTION-LST)
		  (CONS NAME OLD-TYPE-PRESCRIPTION))
	LOOP
	(RPLACD (CAR (SETQ TEMP (GET NAME (QUOTE TYPE-PRESCRIPTION-LST))))
		OLD-TYPE-PRESCRIPTION)

;   It is very unusual to be mucking about with RPLACDs on data that is part
;   of the event level abstraction.  But by virtue of the fact that we know
;   what the abstraction is and how it works -- i.e., by violating the
;   abstraction! -- we know what we're doing here.  The TYPE-PRESCRIPTION-LST
;   at this moment is a singleton list containing just the CONS added above.
;   The CAR of that CONS is the name of the event that gave rise to the
;   type prescription and the CDR is the type prescription.  The
;   RPLACD above smashes the type prescription in the CDR to a new "guess"
;   that includes all the information contained in the current guess.  The
;   fundamental difficulty with destructively changing event level data
;   arises because the ADD-SUB-FACT mechanism stores certain undo information
;   about each added fact, and if you change the data without being aware of
;   that, you might make the data inconsistent with the undoing information
;   about it.  But we know that all ADD-SUB-FACT stores in this case is the
;   name of the lemma, that is, the CAR of the TYPE-PRESCRIPTION-NAME-AND-PAIR,
;   and so by smashing the CDR we're consistently fooling it.

	(SETF (GET NAME (QUOTE TYPE-PRESCRIPTION-LST)) TEMP)

;   Why do we both RPLACD the structure on the property list AND do the
;   SETF?  The answer is that we are afraid that someday perhaps we will
;   permit a SWAPOUT to occur anytime.  Note that if that happened after
;   we did the GET but before the RPLACD happened we would lose.

	(SETQ ANS (DEFN-TYPE-SET BODY))
	(SETQ NEW-TYPE-PRESCRIPTION
	      (CONS (CAR ANS)
		    (ITERATE FOR ARG IN FORMALS
			     COLLECT (COND ((MEMBER-EQ ARG (CDR ANS))
					    T)
					   (T NIL)))))
	(COND ((EQUAL OLD-TYPE-PRESCRIPTION NEW-TYPE-PRESCRIPTION)
	       (RETURN NIL))
	      ((AND (LOGSUBSETP (CAR NEW-TYPE-PRESCRIPTION)
				(CAR OLD-TYPE-PRESCRIPTION))
		    (ITERATE FOR FLG1 IN (CDR NEW-TYPE-PRESCRIPTION) AS FLG2
			     IN (CDR OLD-TYPE-PRESCRIPTION)
			     ALWAYS (OR (NOT FLG1)
					FLG2)))
	       (ERROR1 (PQUOTE (PROGN |An| |unexpected| |situation| |has|
				      |arisen| ! |The| DEFN-TYPE-SET
				      |iteration| |stopped| |because| |of| |a|
				      |proper| |subset| |check| |rather|
				      |than| |the| |equality| |of| |the| |old|
				      |and| |new| |type| |sets| |.|))
		       NIL
		       (QUOTE WARNING))
	       (RETURN NIL)))
	(SETQ OLD-TYPE-PRESCRIPTION
	      (CONS (LOGIOR (CAR OLD-TYPE-PRESCRIPTION)
			    (CAR NEW-TYPE-PRESCRIPTION))
		    (ITERATE FOR FLG1 IN (CDR OLD-TYPE-PRESCRIPTION) AS FLG2
			     IN (CDR NEW-TYPE-PRESCRIPTION)
			     COLLECT (OR FLG1 FLG2))))
	(GO LOOP)))

(DEFUN PUT0 (ATM PROP VAL HIGHER-PROPS)

;   This function is conceptually hidden from the user of the lib file package.
;   It may be called internally provided ATM is known to be in the
;   PROP-HASH-ARRAY already.  HIGHER-PROPS is the list of properties with
;   higher priority than this one.  If it is NIL this function assumes that it
;   hasn't been computed by the caller and computes it.  If the computation
;   returns NIL, then PROP is not a member of LIB-PROPS and an error is caused.
;   The reason this function does not just have three args and always compute
;   HIGHER-PROPS -- rather than allowing the caller to do it but not believing
;   the caller when he says NIL -- is that the main use of PUT0 is from PUT1,
;   who must decide whether PROP is a member of LIB-PROPS before updating the
;   hash array for ATM.  So this implementation allows PUT1 to pass its answer
;   down rather than require PUT0 to do the work again.  At the moment, the
;   only other calls of PUT0 do not bother to compute HIGHER-PROPS and just let
;   PUT0 do it.  But even if they did, and computed NIL, and did not check it
;   but forced PUT0 to compute the NIL again, the time wasted is not important
;   since we're going to then cause an error anyway.

  (OR HIGHER-PROPS (SETQ HIGHER-PROPS (MEMBER-EQ PROP LIB-PROPS))
      (ERROR1 (PQUOTE (PROGN |Attempt| |to| PUT1 |the| |non-LIB-PROPS|
			     |property| (!PPR PROP NIL)
			     |.|))
	      (BINDINGS (QUOTE PROP)
			PROP)
	      (QUOTE HARD)))
  (SETF (SYMBOL-PLIST ATM)
	(PUT00 (SYMBOL-PLIST ATM)
	       PROP VAL))
  VAL)

(DEFUN PUT00 (TAIL PROP VAL)
  (COND ((NULL TAIL)
	 (LIST PROP VAL))
	((EQ PROP (CAR TAIL))
	 (RPLACA (CDR TAIL)
		 VAL)
	 TAIL)
	((MEMBER-EQ (CAR TAIL)
		    HIGHER-PROPS)
	 (COND ((CDDR TAIL)
		(RPLACD (CDR TAIL)
			(PUT00 (CDDR TAIL)
			       PROP VAL))
		TAIL)
	       (T (NCONC TAIL (LIST PROP VAL)))))
	(T (CONS PROP (CONS VAL TAIL)))))

(DEFUN PUT1 (ATM VAL PROP)

;   Like PUTPROP except keeps the properties in the order specified by
;   LIB-PROPS, causing an error if PROP is not on LIB-PROPS, and insures that
;   ATM is a memb of LIB-ATOMS-WITH-PROPS

  (LET (HIGHER-PROPS)
    (COND ((NOT (SYMBOLP ATM))
	   (ERROR1 (PQUOTE (PROGN |Attempt| |to| |use| |PUT1| |on|
				  |the| |nonsymbolp| (!PPR ATM (QUOTE |.|))))
		   (BINDINGS (QUOTE ATM) ATM)
		   (QUOTE HARD)))	   
	  ((NOT (BOUNDP (QUOTE LIB-PROPS)))
	   (ERROR1 (PQUOTE (PROGN |theorem| |prover| |not| |initialized| |.|))
		   NIL
		   (QUOTE HARD)))
	  ((NULL (SETQ HIGHER-PROPS (MEMBER-EQ PROP LIB-PROPS)))
	   (ERROR1 (PQUOTE (PROGN |Attempt| |to| |use| PUT1 |to| |store| |the|
				  |non-LIB-PROPS| |property|
				  (!PPR PROP NIL) |.|))
		   (BINDINGS (QUOTE PROP) PROP)
		   (QUOTE HARD)))
	  ((NOT (MEMBER-EQ ATM LIB-ATOMS-WITH-PROPS))
	   (SETQ LIB-ATOMS-WITH-PROPS (CONS ATM LIB-ATOMS-WITH-PROPS))))
    (PUT0 ATM PROP VAL HIGHER-PROPS)))

(DEFUN PUT1-LST (ATM PROPS)

;   PROPS is a list of the form (prop1 val1 prop2 val2 ...).  This function is
;   equivalent to doing (PUT1 ATM vali propi) for each i, but is faster.

  (SETF (SYMBOL-PLIST ATM) (APPEND PROPS (SYMBOL-PLIST ATM))))

(DEFUN PUTD1 (ATM EXPR)

;   If EXPR is NIL, remove ATM from LIB-ATOMS-WITH-DEFS and erase its function
;   definition and EXPR property.  If EXPR is non-NIL, add ATM to
;   LIB-ATOMS-WITH-DEFS, make the compiled version of EXPR be the definition of
;   ATM, and store EXPR under the EXPR prop.

  (COND ((NULL EXPR)
	 (SETQ LIB-ATOMS-WITH-DEFS (DELETE ATM LIB-ATOMS-WITH-DEFS))
	 (KILL-DEFINITION ATM))
	(T (SETQ LIB-ATOMS-WITH-DEFS (CONS ATM LIB-ATOMS-WITH-DEFS))
	   (STORE-DEFINITION ATM EXPR))))

(DEFUN QUICK-BLOCK-INFO (FORMALS TESTS-AND-CASES-LST)

;   Return a list of "block-types", each being one of the words UNCHANGING,
;   SELF-REFLEXIVE, or QUESTIONABLE, indicating how the corresponding arg
;   position is changed in the calls enumerated.  This is used to help quickly
;   decide if a blocked formal can be tolerated in induction.

  (LET (BLOCK-TYPES)
    (SETQ BLOCK-TYPES (ITERATE FOR VAR IN FORMALS
			       COLLECT
			       (QUOTE UN-INITIALIZED)))
    (ITERATE FOR TESTS-AND-CASES IN TESTS-AND-CASES-LST
	     DO
	     (ITERATE FOR CASE IN (ACCESS TESTS-AND-CASES CASES TESTS-AND-CASES)
		      DO
		      (ITERATE FOR VAR IN FORMALS AS ARG IN CASE AS TAIL
			       ON BLOCK-TYPES
			       DO (CASE
				   (CAR TAIL)
				   (QUESTIONABLE NIL)
				   (UN-INITIALIZED
				    (RPLACA TAIL (QUICK-BLOCK-INFO1 VAR ARG)))
				   (OTHERWISE
				    (OR (EQ (CAR TAIL)
					    (QUICK-BLOCK-INFO1 VAR ARG))
					(RPLACA TAIL (QUOTE QUESTIONABLE))))))))
    BLOCK-TYPES))

(DEFUN QUICK-BLOCK-INFO1 (VAR TERM)
  (COND ((EQ VAR TERM)
	 (QUOTE UNCHANGING))
	((OCCUR VAR TERM)
	 (QUOTE SELF-REFLEXIVE))
	(T (QUOTE QUESTIONABLE))))

(DEFUN QUICK-WORSE-THAN (TERM1 TERM2)
  (COND ((VARIABLEP TERM2)
	 (COND ((EQ TERM1 TERM2)
		NIL)
	       (T (OCCUR TERM2 TERM1))))
	((FQUOTEP TERM2)
	 (COND ((VARIABLEP TERM1)
		T)
	       ((FQUOTEP TERM1)
		(> (FORM-COUNT-EVG (CADR TERM1))
		   (FORM-COUNT-EVG (CADR TERM2))))
	       (T T)))
	((VARIABLEP TERM1)
	 NIL)
	((FQUOTEP TERM1)
	 NIL)
	((EQ (FFN-SYMB TERM1)
	     (FFN-SYMB TERM2))
	 (COND ((EQUAL TERM1 TERM2)
		NIL)
	       ((ITERATE FOR ARG1 IN (FARGS TERM1) AS ARG2 IN (FARGS TERM2)
			 THEREIS (OR (AND (OR (VARIABLEP ARG1)
					      (VALUEP ARG1))
					  (NOT (OR (VARIABLEP ARG2)
						   (VALUEP ARG2))))
				     (WORSE-THAN ARG2 ARG1)))
		NIL)
	       (T (ITERATE FOR ARG1 IN (FARGS TERM1) AS ARG2 IN (FARGS TERM2)
			   THEREIS (WORSE-THAN ARG1 ARG2)))))
	(T NIL)))

(DEFUN OUR-QUOTIENT (X Y)
  (COND ((OR (NOT (INTEGERP X))
	     (NOT (INTEGERP Y))
	     (= Y 0))
	 (ERROR "In appropriate args to OUR-QUOTIENT: ~A ~A." X Y))
	(T (TRUNCATE X Y))))

(DEFUN R (FORM)
  (CHK-INIT)
  (COND ((NOT (ERROR1-SET (SETQ FORM (TRANSLATE FORM))))
	 (QUOTE (NOT REDUCIBLE)))
	((EQ (SETQ TEMP-TEMP (REDUCE-TERM FORM R-ALIST)) (QUOTE *1*FAILED))
	 (QUOTE (NOT REDUCIBLE)))
	(T (EXPAND-PPR-MACROS TEMP-TEMP))))

(DEFUN R-LOOP NIL
  (PROG (VAR FORM ANS)
	(CHK-INIT)
	LOOP 
	(ITERPRI NIL)
	(IPRINC (QUOTE *) NIL)
	(SETQ FORM (READ NIL))
	(SETQ VAR NIL)
	(MATCH FORM (SETQ VAR FORM))
	(COND ((EQ FORM (QUOTE EXIT))
	       (RETURN NIL))
	      ((NULL (ERROR1-SET (SETQ FORM (TRANSLATE FORM)))))
	      ((EQ (SETQ ANS (REDUCE-TERM FORM R-ALIST))
		   (QUOTE *1*FAILED))
	       (ERROR1-SET
		(ERROR1 (PQUOTE (PROGN |irreducible| |.|)) NIL (QUOTE SOFT))))
	      (T (COND (VAR (RPLACD (OR (ASSOC-EQ VAR R-ALIST)
					(CAR (SETQ R-ALIST
						   (CONS (CONS VAR (CADR ANS))
							 R-ALIST))))
				    (CADR ANS))))
		 (PPR ANS NIL)
		 (ITERPRI NIL))) 
	(GO LOOP)))

(DEFUN RANDOM-INITIALIZATION (EVENT)
  (SETQ *RANDOM-SEED* (CONS-COUNT EVENT)))

(DEFUN RANDOM-NUMBER (N)

;  We only use random numbers to vary the English phrases in the
;  output.  We define our own random number generator to maintain
;  uniformity across all the Lisps we use.

  (LET ((LINEAR 267) (MULTIPLIER 317) (MODULUS 4096))
    (OUR-REMAINDER (SETQ *RANDOM-SEED*
                     (OUR-REMAINDER (+ LINEAR (* MULTIPLIER
					     *RANDOM-SEED*))
                                MODULUS))
               N)))

(DEFUN RECOGNIZER-TERMP (X)
  (COND ((VARIABLEP X) NIL)
	((FQUOTEP X) NIL)
	((SETQ TEMP-TEMP (ASSOC-EQ (FFN-SYMB X) RECOGNIZER-ALIST))
	 (CDR TEMP-TEMP))
	(T NIL)))

(DEFUN REDO! (NAME)
  (REDO-UNDONE-EVENTS (UNDO-NAME NAME)
		      T
		      (QUOTE C)
		      T T))

(DEFUN REDO-UNDONE-EVENTS
  (EVENTS ALL-FLG FAILURE-ACTION
	  DO-NOT-PRINT-FIRST-EVENT-FLG DO-NOT-PRINT-DATE-LINE-FLG)
  (OR (AND (CONSP EVENTS)
           (AND (CONSP (CAR EVENTS))
                (MEMBER-EQ (CAAR EVENTS) (QUOTE (BOOT-STRAP NOTE-LIB)))))
      (CHK-INIT))
  (COND (IN-REDO-UNDONE-EVENTS-FLG
	 (ERROR1 (PQUOTE (PROGN |It| |is| |illegal| |to| |enter| |a| |theorem|
				|prover| |function| |while| |you| |are|
				|recursively| |under| |another|
				|theorem| |prover| |function| |.|))
		 NIL
		 (QUOTE HARD))))
  (LET (ANS ANSLST FORM
	    (IN-REDO-UNDONE-EVENTS-FLG T))
    (PROG NIL
	  (SETQ TOTAL-MISC-TIME 0.0)
	  (SETQ TOTAL-PROVE-TIME 0.0)
	  (SETQ TOTAL-IO-TIME 0.0)
	  (OR FAILURE-ACTION (SETQ FAILURE-ACTION (QUOTE Q)))
	  (SETQ UNDONE-EVENTS EVENTS)
	  (COND ((NOT DO-NOT-PRINT-DATE-LINE-FLG) (PRINT-DATE-LINE)))
	  LOOP
	  (COND ((NULL UNDONE-EVENTS) (GO EXIT)))
	  (SETQ FORM (CAR UNDONE-EVENTS))
	  (COND ((OR (NOT DO-NOT-PRINT-FIRST-EVENT-FLG)
		     (NOT (EQ FORM (CAR EVENTS)))
		     (NOT (EQ PROVE-FILE NIL)))
		 (ITERPRIN 1 PROVE-FILE)
		 (IPRINC EVENT-SEPARATOR-STRING PROVE-FILE)
		 (ITERPRIN 2 PROVE-FILE)
		 (COND (BOOK-SYNTAX-FLG (DUMP (LIST FORM)
					      PROVE-FILE 5 (OUR-LINEL PROVE-FILE)
					      NIL T))
		       (T (PPRIND FORM 0 0 PPR-MACRO-LST PROVE-FILE)))
		 (ITERPRI PROVE-FILE)
		 (COND ((NOT (EQ PROVE-FILE NIL))
			(IPRINC (CADR FORM) T)))))
	  (COND ((OR (MEMBER-EQ (CAR FORM)
				(QUOTE (DEFN REFLECT)))
		     ALL-FLG
		     (EQ FORM (CAR EVENTS))
		     (Y-OR-N-P "Do you want to redo this event?"))
		 (START-STATS)
                 (SETQ FAILED-EVENTS (CONS FORM FAILED-EVENTS))
		 (SETQ ANS (LET (UNDONE-EVENTS)
			     (REDO-UNDONE-EVENTS-EVAL FORM)))
		 (STOP-STATS)
		 (COND ((NULL ANS)

;   A SOFT ERROR1 occurred during the evaluation.  Perhaps we should
;   let the user edit the form, but we have no standard editor in the
;   system.

			(ERROR "")))
                 (SETQ ANS (CAR ANS))

;   Recover the actual value from the CONS produced by the ERROR1-SET
;   protection

	         (COND ((OR (NOT DO-NOT-PRINT-FIRST-EVENT-FLG)
			    (NOT (EQ FORM (CAR EVENTS)))
			    (NOT (EQ PROVE-FILE NIL)))
			(ITERPRI PROVE-FILE)
			(IPRINC ANS PROVE-FILE)
			(COND ((NOT (EQ PROVE-FILE NIL))
			       (COND ((EQ ANS NIL) (ITERPRI T)
				      (IPRINC FAILURE-MSG T)
				      (ITERPRI T))
				     (T (IPRINC (QUOTE |,|) T)
					(COND ((< (OUR-LINEL T)
						  (IPOSITION T NIL NIL))
					       (ITERPRI T)))))))))
		 (SETQ ANSLST (NCONC1 ANSLST ANS))
		 (COND ((EQ ANS NIL)
			(COND ((AND (EQ FAILURE-ACTION (QUOTE A))
				    (EQ (CAR FORM) (QUOTE PROVE-LEMMA)))
			       (ITERPRIN 2 PROVE-FILE)
			       (PPR (LIST (QUOTE COMMENT)
					  (LIST (QUOTE ADD-AXIOM)
						(NTH 1 FORM)
						(NTH 2 FORM)
						(NTH 3 FORM)))
				    PROVE-FILE)
			       (ITERPRI PROVE-FILE)
			       (ITERPRI PROVE-FILE)
			       (IPRINC (EVAL `(ADD-AXIOM
					       ,(NTH 1 FORM)
					       ,(NTH 2 FORM)
					       ,(NTH 3 FORM)))
				       PROVE-FILE))
			      ((OR (EQ FAILURE-ACTION (QUOTE Q))
				   (MEMBER-EQ (CAR FORM)
					      (QUOTE (ADD-AXIOM ADD-SHELL DCL))))
			       (GO EXIT))))
                       (T (SETQ FAILED-EVENTS (REMOVE FORM FAILED-EVENTS :TEST #'EQUAL))))))
	  (SETQ UNDONE-EVENTS (CDR UNDONE-EVENTS))
	  (SETQ EVENTS NIL)
	  (GO LOOP)
	  EXIT(COND ((NOT (EQUAL PROVE-FILE NIL))
		     (ITERPRIN 1 PROVE-FILE)
		     (IPRINC EVENT-SEPARATOR-STRING PROVE-FILE)
		     (ITERPRIN 2 PROVE-FILE)
		     (IPRINC
		      (QUOTE
		       |REDO-UNDONE-EVENTS completed.  Here is FAILED-EVENTS:|)
		      PROVE-FILE)
		     (ITERPRI PROVE-FILE)
		     (PPR FAILED-EVENTS PROVE-FILE)
		     (ITERPRIN 2 PROVE-FILE)
		     (IPRINC (QUOTE |Total Statistics:|) PROVE-FILE)
		     (PRINT-STATS TOTAL-MISC-TIME TOTAL-PROVE-TIME TOTAL-IO-TIME
				  PROVE-FILE)
		     (ITERPRI PROVE-FILE)
		     (CLOSE PROVE-FILE)
		     (SETQ PROVE-FILE NIL)))
	  (COND ((NOT (EQUAL TTY-FILE NIL))
		 (CLOSE TTY-FILE)
		 (SETQ TTY-FILE NIL)))
	  (RETURN ANSLST))))

(DEFUN REDO-UNDONE-EVENTS-EVAL (FORM)
  (ERROR1-SET (EVAL (COPY-LIST FORM))))

(DEFUN REDUCE-TERM (TERM ALIST)

;   TERM is a term.  ALIST is an alist dotting variable names to EVGs.  Reduce
;   TERM under the assumptions that each var is equal to the corresponding
;   constant.  Return the resulting term or *1*FAILED if TERM is not reducible.
;   REDUCE-TERM is just serving as a name from which REDUCE-TERM1 sometimes RETFROMs.

  (CATCH (QUOTE REDUCE-TERM)
    (LIST (QUOTE QUOTE)
	  (REDUCE-TERM1 TERM ALIST))))

(DEFUN REDUCE-TERM1 (TERM ALIST)
  (COND ((VARIABLEP TERM)
	 (COND ((SETQ TEMP-TEMP (ASSOC-EQ TERM ALIST))
		(CDR TEMP-TEMP))
	       (T (THROW (QUOTE REDUCE-TERM)
			 (QUOTE *1*FAILED)))))
	((FQUOTEP TERM)
	 (CADR TERM))
	((EQ (FFN-SYMB TERM)
	     (QUOTE IF))
	 (COND ((EQ (REDUCE-TERM1 (FARGN TERM 1)
				  ALIST)
		    *1*F)
		(REDUCE-TERM1 (FARGN TERM 3)
			      ALIST))
	       (T (REDUCE-TERM1 (FARGN TERM 2)
				ALIST))))
	((SETQ TEMP-TEMP (GET (FFN-SYMB TERM)
			      (QUOTE LISP-CODE)))

;   We special case the fns of arity 0, 1, 2, and 3 to avoid consing up the arg
;   list.

	 (CASE (LENGTH TERM)
	       (1 (FUNCALL TEMP-TEMP))
	       (2 (FUNCALL TEMP-TEMP (REDUCE-TERM1 (FARGN TERM 1)
						   ALIST)))
	       (3 (FUNCALL TEMP-TEMP (REDUCE-TERM1 (FARGN TERM 1)
						   ALIST)
			   (REDUCE-TERM1 (FARGN TERM 2)
					 ALIST)))
	       (4 (FUNCALL TEMP-TEMP (REDUCE-TERM1 (FARGN TERM 1)
						   ALIST)
			   (REDUCE-TERM1 (FARGN TERM 2)
					 ALIST)
			   (REDUCE-TERM1 (FARGN TERM 3)
					 ALIST)))
	       (OTHERWISE
		(APPLY TEMP-TEMP (ITERATE FOR ARG IN (FARGS TERM)
					  COLLECT (REDUCE-TERM1 ARG ALIST))))))
	(T (THROW (QUOTE REDUCE-TERM) (QUOTE *1*FAILED)))))

(DEFUN REFLECT0
  (NAME SATISFACTION-LEMMA-NAME RELATION-MEASURE-LST FLG)
  (LET (TRANSLATED-BODY CONTROL-VARS FN ARGS BODY
			(META-NAMES (CONS NAME META-NAMES)))
    (MATCH (FORMULA-OF SATISFACTION-LEMMA-NAME)
	   (EQUAL (CONS FN ARGS)
		  BODY))
    (SETQ TRANSLATED-BODY (TRANSLATE BODY))
    (SETQ RELATION-MEASURE-LST
	  (ITERATE FOR TEMP IN RELATION-MEASURE-LST
		   COLLECT (LIST (CAR TEMP)
				 (TRANSLATE (CADR TEMP)))))
    (PUT-INDUCTION-INFO NAME ARGS TRANSLATED-BODY
			RELATION-MEASURE-LST FN)
    (ADD-FACT NAME (QUOTE SDEFN)
	      (LIST (QUOTE LAMBDA)
		    ARGS
		    (SUBST-FN NAME FN TRANSLATED-BODY)))
    (ADD-FACT NAME (QUOTE TYPE-PRESCRIPTION-LST)
	      (CAR (GET FN (QUOTE TYPE-PRESCRIPTION-LST))))
    (PUT-LEVEL-NO NAME)
    (AND (GET NAME (QUOTE JUSTIFICATIONS))
	 (ADD-FACT NAME (QUOTE CONTROLLER-POCKETS)
		   (SCRUNCH (ITERATE FOR TEMP
				     IN (GET NAME
					     (QUOTE JUSTIFICATIONS))
				     COLLECT
				     (PROGN
				       (SETQ CONTROL-VARS
					     (ACCESS JUSTIFICATION SUBSET
						     TEMP))
				       (ITERATE FOR FORMAL IN ARGS
						AS I FROM 0
						WITH ITERATE-ANS = 0
						WHEN (MEMBER-EQ FORMAL
								CONTROL-VARS)
						DO
						(SETQ ITERATE-ANS
						      (LOGIOR ITERATE-ANS
							      (ASH 1 I)))
						FINALLY (RETURN ITERATE-ANS)))))))
    (COND (FLG (ADD-FACT NAME (QUOTE LISP-CODE)
			 (PACK (LIST STRING-WEIRD NAME)))
               (GUARANTEE-CITIZENSHIP (PACK (LIST STRING-WEIRD NAME))))
	  ((ITERATE FOR FN IN (ALL-FNNAMES TRANSLATED-BODY)
		    ALWAYS (OR (EQ FN NAME)
			       (GET FN (QUOTE LISP-CODE))))
	   (ADD-DCELL NAME (PACK (LIST STRING-WEIRD NAME))
		      (LIST (QUOTE LAMBDA)
			    (SETQ TEMP-TEMP
				  (ITERATE FOR ARG IN ARGS
					   COLLECT (PACK (LIST STRING-WEIRD3
							       ARG))))
			    (TRANSLATE-TO-LISP
			     (SUB-PAIR-VAR ARGS TEMP-TEMP
					   (SUBST-FN NAME
						     FN
						     TRANSLATED-BODY)))))))
    (COND ((NOT (TOTAL-FUNCTIONP NAME))
	   (ERROR1 (PQUOTE (PROGN |The| |recursion| |in| (!PPR NAME NIL)
				  |is| |unjustified| |.|))
		   (BINDINGS (QUOTE NAME)
			     NAME)
		   (QUOTE WARNING))))
    NIL))

(DEFUN RELIEVE-HYPS (HYPS LEMMA-NAME)
  (PUSH-LEMMA-FRAME)
  (PUSH-LINEARIZE-ASSUMPTIONS-FRAME)
  (COND ((RELIEVE-HYPS1 HYPS LEMMA-NAME)
	 (ITERATE FOR X IN (POP-LEMMA-FRAME) DO (PUSH-LEMMA X))
	 (ITERATE FOR X IN (POP-LINEARIZE-ASSUMPTIONS-FRAME)
		  DO (PUSH-LINEARIZE-ASSUMPTION X))
	 T)
	(T (POP-LEMMA-FRAME)
	   (POP-LINEARIZE-ASSUMPTIONS-FRAME)
	   NIL)))

(DEFUN RELIEVE-HYPS-NOT-OK (LIT)
  (LET (LIT-ATOM ANS-ATOM)
    (SETQ LIT-ATOM LIT)
    (MATCH LIT (NOT LIT-ATOM))
    (ITERATE FOR ANS IN ANCESTORS
	     THEREIS
	     (PROGN
	       (SETQ ANS-ATOM ANS)
	       (MATCH ANS (NOT ANS-ATOM))
	       (COND ((EQUAL LIT ANS)
		      (SETQ RELIEVE-HYPS-NOT-OK-ANS T)
		      T)
		     ((AND (>= (FORM-COUNT LIT-ATOM)
			       (FORM-COUNT ANS-ATOM))
			   (WORSE-THAN-OR-EQUAL LIT-ATOM
						ANS-ATOM))
		      (SETQ RELIEVE-HYPS-NOT-OK-ANS NIL)
		      T)
		     (T NIL))))))

(DEFUN RELIEVE-HYPS1 (HYPS LEMMA-NAME)
  (COND ((ITERATE FOR HYP IN HYPS AS I FROM 1 WITH (LHS RHS)
		  ALWAYS
		  (PROGN
		    (PRINT-TO-DISPLAY LEMMA-NAME I (QUOTE ?))
		    (COND ((LOOKUP-HYP HYP) T)
			  ((FREE-VARSP HYP UNIFY-SUBST)
			   (COND ((AND (MATCH HYP (EQUAL LHS RHS))
				       (VARIABLEP LHS)
				       (NOT (ASSOC-EQ LHS UNIFY-SUBST))
				       (NOT (FREE-VARSP RHS UNIFY-SUBST)))
				  (SETQ UNIFY-SUBST
					(CONS (CONS LHS (REWRITE RHS UNIFY-SUBST
								 TYPE-ALIST
								 (QUOTE ?)
								 (QUOTE ID) NIL))
					      UNIFY-SUBST)))
				 ((SEARCH-GROUND-UNITS HYP) T)
				 (T (SETQ LAST-EXIT (QUOTE FREE-VARSP))
				    (SETQ LAST-HYP HYP)
				    NIL)))
			  ((RELIEVE-HYPS-NOT-OK (SETQ INST-HYP
						      (SUBLIS-VAR UNIFY-SUBST HYP)))
			   (SETQ LAST-EXIT (QUOTE RELIEVE-HYPS-NOT-OK))
			   (SETQ LAST-HYP HYP)
			   RELIEVE-HYPS-NOT-OK-ANS)
			  ((FALSE-NONFALSEP INST-HYP)
			   (SETQ LAST-EXIT (QUOTE FALSE-NONFALSEP))
			   (SETQ LAST-HYP HYP)
			   (NOT DEFINITELY-FALSE))
			  ((MEMBER-EQUAL INST-HYP LITS-THAT-MAY-BE-ASSUMED-FALSE)
			   (SETQ LAST-EXIT
				 (QUOTE LITS-THAT-MAY-BE-ASSUMED-FALSE))
			   (SETQ LAST-HYP HYP)
			   NIL)
			  ((MATCH HYP (NOT HYP))
			   (LET ((ANCESTORS (CONS (DUMB-NEGATE-LIT INST-HYP)
						  ANCESTORS)))
			     (SETQ LAST-EXIT
				   (REWRITE HYP UNIFY-SUBST TYPE-ALIST
					    (QUOTE FALSE)
					    (QUOTE IFF)
					    NIL))
			     (SETQ LAST-HYP HYP)
			     (EQUAL LAST-EXIT FALSE)))
			  (T (LET ((ANCESTORS (CONS (DUMB-NEGATE-LIT INST-HYP)
						    ANCESTORS)))
			       (SETQ LAST-EXIT
				     (NORMALIZE-IFS
				      (REWRITE HYP UNIFY-SUBST TYPE-ALIST
					       (QUOTE TRUE)
					       (QUOTE IFF)
					       NIL)
				      NIL
				      NIL
				      T))
			       (SETQ LAST-HYP HYP)

;   Could be NOT-IDENT FALSE but LAST-EXIT was just rewritten with IFF.

			       (EQUAL LAST-EXIT TRUE))))))
	 (PRINT-TO-DISPLAY LEMMA-NAME NIL (QUOTE !))
	 T)
	(T NIL)))

(DEFUN OUR-REMAINDER (X Y)
  (COND ((OR (NOT (INTEGERP X))
	     (NOT (INTEGERP Y))
	     (= Y 0))
	 (ERROR "Inappropriate args to OUR-REMAINDER: ~A ~A." X Y))
	(T (REM X Y))))

(DEFUN REMOVE-*2*IFS (X)
  (LET (REST)
    (COND ((ATOM X)
	   X)
	  ((EQ (CAR X)
	       (QUOTE QUOTE))
	   X)
	  ((EQ (CAR X)
	       (QUOTE *2*IF))
	   (SETQ REST (REMOVE-*2*IFS (CADDDR X)))
	   (CONS (QUOTE COND)
		 (CONS (LIST (REMOVE-*2*IFS (CADR X))
			     (REMOVE-*2*IFS (CADDR X)))
		       (COND ((AND (CONSP REST)
				   (EQ (CAR REST)
				       (QUOTE COND)))
			      (CDR REST))
			     (T (LIST (LIST T REST)))))))
	  (T (CONS (CAR X)
		   (ITERATE FOR ARG IN (CDR X) COLLECT (REMOVE-*2*IFS ARG)))))))

(DEFUN REMOVE-NEGATIVE (LIT CL)
  (COND ((ATOM CL) NIL)
	((COMPLEMENTARYP LIT (CAR CL)) (CDR CL))
	(T (CONS (CAR CL) (REMOVE-NEGATIVE LIT (CDR CL))))))

(DEFUN REMOVE-REDUNDANT-TESTS (TO-DO DONE)

;   When this function was conceived, we used to run the following code.
;   However, we have trivialized the effect because we found that it sometimes
;   hurt.  In particular, if the tests were (LISTP X) and (EQUAL (CAAR X)
;   (QUOTE FOO)), the LISTP could get removed.  But then the LISTP has to be
;   rederived when it comes up during a proof.  It is speculated that the
;   original motivation for this function was messy base cases, which was
;   altered if not fixed by carrying around the base cases in the
;   INDUCTION-MACHINE.  The following code is left in case a real removal of
;   tests is deemed necessary. 

;       (COND ((NULL TO-DO) DONE)
;	      ((AND (SIMPLIFY-CLAUSE-MAXIMALLY
;		      (CONS (CAR TO-DO)
;			    (APPEND (ITERATE FOR X IN (CDR TO-DO)
;					  COLLECT (NEGATE-LIT X))
;				    (ITERATE FOR X IN DONE
;					  COLLECT (NEGATE-LIT X)))))
;		    (NULL PROCESS-CLAUSES))

;   The lemmas on PROCESS-HIST will have been added to ALL-LEMMAS-USED by
;   SIMPLIFY-CLAUSE under SIMPLIFY-CLAUSE-MAXIMALLY and ALL-LEMMAS-USED is
;   correctly initialized and processed by DEFN-SETUP and the post processing
;   in DEFN.

;	       (REMOVE-REDUNDANT-TESTS (CDR TO-DO) DONE))
;	      (T (REMOVE-REDUNDANT-TESTS
;		   (CDR TO-DO)
;		   (CONS (CAR TO-DO) DONE)))).

  (APPEND TO-DO DONE))

(DEFUN REMOVE1 (X LST)
  (COND ((ATOM LST) NIL)
	((EQ X (CAR LST)) (CDR LST))
	(T (CONS (CAR LST) (REMOVE1 X (CDR LST))))))

(DEFUN REMOVE-TRIVIAL-EQUATIONS (CL)
  (ITERATE WITH (LHS RHS)
	   WHILE
	   (ITERATE FOR LIT IN CL
		    THEREIS
		    (AND (OR (AND (MATCH LIT (NOT (EQUAL LHS RHS)))
				  (OR (AND (VARIABLEP LHS)
					   (NOT (OCCUR LHS RHS)))
				      (AND (PROG2 (SWAP LHS RHS)
						  T)
					   (VARIABLEP LHS)
					   (NOT (OCCUR LHS RHS)))))
			     (AND (VARIABLEP LIT)
				  (PROGN (SETQ LHS LIT)
					 (SETQ RHS FALSE)
					 T)))
			 (PROGN (SETQ CL (ITERATE FOR LIT2 IN CL
						  UNLESS (EQ LIT LIT2)
						  COLLECT (SUBST-VAR RHS LHS LIT2)))
				T))))
  (ITERATE WITH (LHS RHS)
	   WHILE
	   (ITERATE FOR LIT IN CL
		    THEREIS (AND (MATCH LIT (NOT (EQUAL LHS RHS)))
				 (OR (AND (NOT (QUOTEP LHS))
					  (QUOTEP RHS))
				     (AND (PROG2 (SWAP LHS RHS)
						 T)
					  (NOT (QUOTEP LHS))
					  (QUOTEP RHS)))
				 (ITERATE FOR LIT2 IN CL WHEN (NOT (EQ LIT LIT2))
					  THEREIS (OCCUR LHS LIT2))
				 (SETQ CL
				       (ITERATE FOR LIT2 IN CL
						COLLECT
						(COND
						 ((OR (EQ LIT LIT2)
						      (NOT (OCCUR LHS LIT2)))
						  LIT2)
						 (T (SUBST-EXPR RHS LHS LIT2))))))))
  CL)

(DEFUN REMOVE-UNCHANGING-VARS (CAND-LST CL-SET)
  (LET (NOT-CHANGING-VARS)
    (SETQ NOT-CHANGING-VARS
	  (ITERATE FOR CL IN CL-SET
		   WITH ITERATE-ANS
		   DO (SETQ ITERATE-ANS
			    (UNION-EQ (ITERATE FOR LIT IN CL
					       WITH ITERATE-ANS
					       DO (SETQ ITERATE-ANS
							(UNION-EQ (UNCHANGING-VARS LIT)
								  ITERATE-ANS))
					       FINALLY (RETURN ITERATE-ANS))
				      ITERATE-ANS))
		   FINALLY (RETURN ITERATE-ANS)))
    (OR (ITERATE FOR CAND IN CAND-LST
		 UNLESS (INTERSECTP (ACCESS CANDIDATE CHANGED-VARS
					    CAND)
				    NOT-CHANGING-VARS)
		 COLLECT CAND)
	CAND-LST)))

(DEFUN REMPROP1 (AT PROP)
  AT PROP
  (ERROR1 (PQUOTE (PROGN |It| |is| |not| |permitted| |to| |use| REMPROP1 |on|
			 |properties| |maintained| |by| PUT1 |and| GET !))
	  (BINDINGS)
	  (QUOTE HARD)))

(DEFUN RESTART (X)
  (REDO-UNDONE-EVENTS (OR X UNDONE-EVENTS)
		      T
		      (QUOTE Q)
		      NIL NIL))

(DEFUN RESTART-BATCH (LST)
  (PROG NIL
	(SETQ UNDONE-BATCH-COMMANDS LST)
	TOP (COND ((NULL UNDONE-BATCH-COMMANDS)
		   (RETURN NIL)))
	(EVAL (CAR UNDONE-BATCH-COMMANDS))
	(SETQ UNDONE-BATCH-COMMANDS (CDR UNDONE-BATCH-COMMANDS))
	(GO TOP)))

(DEFUN REWRITE (TERM ALIST TYPE-ALIST OBJECTIVE ID-IFF DEFN-FLG)

;   Returns a term that is equal (modulo ID-IFF) to the result of substituting
;   ALIST into TERM under the hypotheses of (a) TYPE-ALIST, (b) the conjunction
;   of the top frame of LINEARIZE-ASSUMPTIONS-STACK, (c) and (d) some subset S
;   of SIMPLIFY-CLAUSE-POT-LST such that if x = (LIST 'MARK) is MEMBER-EQ the LEMMAS
;   field of some poly in S, then x is a member of the top frame of the
;   LEMMA-STACK.

  (COND ((VARIABLEP TERM)
	 (REWRITE-SOLIDIFY (COND ((SETQ TEMP-TEMP (ASSOC-EQ TERM ALIST))
				  (CDR TEMP-TEMP))
				 (T TERM))))
	((FQUOTEP TERM)
	 TERM)
	((EQ (FFN-SYMB TERM)
	     (QUOTE IF))
	 (REWRITE-IF (REWRITE (FARGN TERM 1)
			      ALIST TYPE-ALIST (QUOTE ?)
			      (QUOTE IFF)
			      NIL)
		     (FARGN TERM 2)
		     (FARGN TERM 3)
		     TYPE-ALIST))
	((SETQ TEMP-TEMP (NOT-TO-BE-REWRITTENP TERM ALIST))
	 (REWRITE-SOLIDIFY TEMP-TEMP))
	(T
	 (LET (ARGS FN TEMP)

;   If we are inside of a defn, rewrite the args and then simplify the
;   resulting term with lemmas etc.  If we are not in a definition, we wish to
;   avoid introducing too many IFs all at once and swamping CLAUSIFY.  So
;   rewrite the args until one of them gets an IF in it.  After the first such
;   IF, rewrite the args but if an IF shows up do not use the expansion -- use
;   the result of just substituting alist into the arg.

	   (SETQ ARGS (ITERATE FOR ARG IN (FARGS TERM)
			       COLLECT (REWRITE ARG ALIST TYPE-ALIST
						(QUOTE ?)
						(QUOTE ID)
						NIL)))
	   (COND ((AND (ITERATE FOR ARG IN ARGS ALWAYS (QUOTEP ARG))
		       (SETQ FN (GET (FFN-SYMB TERM) (QUOTE LISP-CODE)))
                       (NOT (DISABLEDP FN))
		       (OR (NULL (GET (FFN-SYMB TERM) (QUOTE EVENT)))
			   (NULL (CDAR DEFINED-FUNCTIONS-TOGGLED))) ;(CDAR NIL) = NIL!
		       (NOT (EQ (QUOTE *1*FAILED)
				(SETQ TEMP (CATCH (QUOTE REDUCE-TERM)
					     (APPLY FN (ITERATE FOR ARG IN ARGS
								COLLECT
								(CADR ARG))))))))
		  (PUSH-LEMMA (FFN-SYMB TERM))
		  (LIST (QUOTE QUOTE) TEMP))
		 (T

;   The use of FCONS-TERM below instead of CONS-TERM is justified by
;   the check above and the knowledge that shell constructors and
;   bottom objects cannot be disabled.

		  (SETQ TEMP (REWRITE-TYPE-PRED
			      (FCONS-TERM (FFN-SYMB TERM) ARGS)))
		  (REWRITE-WITH-LEMMAS TEMP)))))))

(DEFUN REWRITE-FNCALL (*FNNAME* *ARGLIST*)
  (CATCH
      (QUOTE REWRITE-FNCALL)
    (LET (VALUE SDEFN (FNSTACK FNSTACK)
		*CONTROLLER-COMPLEXITIES*
		(LEMMA-STACK LEMMA-STACK)
		(LINEARIZE-ASSUMPTIONS-STACK
		 LINEARIZE-ASSUMPTIONS-STACK)
		(*TYPE-ALIST* TYPE-ALIST))
      (SETQ SDEFN (GET *FNNAME* (QUOTE SDEFN)))
      (COND ((NULL SDEFN)
	     (REWRITE-SOLIDIFY (CONS-TERM *FNNAME* *ARGLIST*)))
	    ((OR (MEMBER-EQ *FNNAME* FNSTACK)
		 (DISABLEDP *FNNAME*))
	     (REWRITE-SOLIDIFY (CONS-TERM *FNNAME* *ARGLIST*)))
	    (T (SETQ *CONTROLLER-COMPLEXITIES*
		     (ITERATE FOR MASK IN (GET *FNNAME*
					       (QUOTE CONTROLLER-POCKETS))
			      COLLECT (ITERATE FOR ARG IN *ARGLIST*
					       WHEN (PROG1 (NOT (= (LOGAND MASK 1)
								   0))
						      (SETQ MASK (ASH MASK -1)))
					       SUM
					       (PROGN
						 (OR (QUOTEP ARG)
						     (SETQ VALUE NIL))
						 (MAX-FORM-COUNT ARG)))))
	       (SETQ FNSTACK (CONS *FNNAME* FNSTACK))

;   Add the name of the current fn to the FNSTACK so that when we see recursive
;   calls in the body we won't be tempted to go into them.  There is an odd
;   aspect to the use of FNSTACK by this function.  Suppose that in the
;   rewriting of the body of fn we apply a lemma and backwards chain to some
;   hyp.  Suppose the hyp contains a call of fn.  Then when we try to rewrite
;   fn in the hyp we will think it is a recursive call and quit due to the
;   (MEMBER-EQ *FNNAME* FNSTACK) above.  Once upon a time, when we did not
;   preprocess the hyps of lemmas at all and did not
;   EXPAND-BOOT-STRAP-NON-REC-FNS in defns this problem burned us on (ZEROP
;   expr) because inside the defn of ZEROP we saw (EQUAL expr 0) and we
;   backward chained to something with a ZEROP hyp and shied away from it.
;   This occurred while trying to use LITTLE-STEP under PRIME-KEY under
;   QUOTIENT-DIVIDES in the proof of PRIME-LIST-TIMES-LIST -- the ZEROP we were
;   expanding was that in the DIVIDES hyp of PRIME-KEY and the ZEROP we shied
;   away from was that in PRIME in LITTLE-STEP.  We implemented makeshift fix
;   to that by not putting nonrec fns onto FNSTACK here.  But that does not
;   prevent us from shying away from calls to recursive fns encountered in
;   lemmas while somehow under the body of the fn.  Worse, it turns out to be
;   very expensive.  Suppose we eliminate ZEROP by expanding it in
;   preprocessing.  Then PRIME-LIST-TIMES-LIST is proved whether we put nonrec
;   fns onto the stack or not.  But if we do not, it takes 248K conses while if
;   we do it takes 140K.  So we have gone back to putting everything on the
;   stack and await the day that shying away from a spurious "recursive call"
;   gets us.

	       (PUSH-LEMMA-FRAME)
	       (PRINT-TO-DISPLAY *FNNAME* (QUOTE ?)
				 NIL)
	       (PUSH-LINEARIZE-ASSUMPTIONS-FRAME)
	       (SETQ VALUE (REWRITE (CADDR SDEFN)
				    (ITERATE FOR VAR IN (CADR SDEFN)
					     AS VAL IN *ARGLIST*
					     COLLECT (CONS VAR VAL))
				    TYPE-ALIST OBJECTIVE ID-IFF T))
	       (COND ((NULL (GET *FNNAME* (QUOTE INDUCTION-MACHINE)))

;   We are dealing with a nonrec fn.  If we are at the top level of the clause
;   but the expanded body has too many IFs in it compared to the number of IFs
;   in the args, we do not use the expanded body.  Because we know the IFs in
;   the args will be classified out soon and we do not want to swamp CLAUSIFY
;   by giving it too many at once.  Otherwise we use the expanded body.

		      (COND ((AND (ITERATE FOR X IN (CDR FNSTACK)
					   NEVER (GET X
						      (QUOTE INDUCTION-MACHINE)))
				  (TOO-MANY-IFS *ARGLIST* VALUE))
			     (POP-LEMMA-FRAME)
			     (POP-LINEARIZE-ASSUMPTIONS-FRAME)
			     (REWRITE-SOLIDIFY (FCONS-TERM *FNNAME*
							   *ARGLIST*)))
			    (T (ITERATE FOR X IN (POP-LINEARIZE-ASSUMPTIONS-FRAME)
					DO (PUSH-LINEARIZE-ASSUMPTION X))
			       (PRINT-TO-DISPLAY *FNNAME* (QUOTE !)
						 NIL)
			       (ITERATE FOR X IN (POP-LEMMA-FRAME)
					DO (PUSH-LEMMA X))
			       (PUSH-LEMMA *FNNAME*)
			       VALUE)))
		     ((REWRITE-FNCALLP *FNNAME* VALUE)
		      (ITERATE FOR X IN (POP-LINEARIZE-ASSUMPTIONS-FRAME)
			       DO (PUSH-LINEARIZE-ASSUMPTION X))
		      (PRINT-TO-DISPLAY *FNNAME* (QUOTE !)
					NIL)
		      (ITERATE FOR X IN (POP-LEMMA-FRAME) DO (PUSH-LEMMA X))
		      (PUSH-LEMMA *FNNAME*)
		      VALUE)
		     (T (POP-LEMMA-FRAME)
			(POP-LINEARIZE-ASSUMPTIONS-FRAME)
			(REWRITE-SOLIDIFY
			 (CONS-TERM *FNNAME* *ARGLIST*)))))))))

(DEFUN REWRITE-FNCALLP (FNNAME VALUE)
  (COND ((VARIABLEP VALUE)
	 T)
	((FQUOTEP VALUE)
	 T)
	((EQ (FFN-SYMB VALUE)
	     FNNAME)
	 (AND
	  (OR (ITERATE FOR ARG IN (FARGS VALUE)
		       ALWAYS (ITERATE FOR LIT IN CURRENT-CL
				       THEREIS (DUMB-OCCUR ARG LIT)))
	      (ITERATE FOR LIT IN CURRENT-SIMPLIFY-CL
		       THEREIS (DUMB-OCCUR VALUE LIT))
	      (ITERATE FOR N IN *CONTROLLER-COMPLEXITIES* AS MASK
		       IN (GET FNNAME (QUOTE CONTROLLER-POCKETS))
		       THEREIS (< (ITERATE FOR ARG IN (FARGS VALUE)
					   WHEN (PROG1
						    (NOT (= (LOGAND MASK 1)
							    0))
						  (SETQ MASK (ASH MASK -1)))
					   SUM (MAX-FORM-COUNT ARG))
				  N))
	      (ITERATE FOR MASK IN (GET FNNAME (QUOTE CONTROLLER-POCKETS))
		       WITH TEMP
		       THEREIS
		       (PROGN
			 (SETQ TEMP MASK)
		       
;   Is there a controller pocket such that all the controllers are constant and
;   some non controller is symbolically simpler now than before?
		       
			 (AND (ITERATE FOR ARG IN (FARGS VALUE)
				       WHEN (PROG1 (NOT (= (LOGAND TEMP 1)
							   0))
					      (SETQ TEMP (ASH TEMP -1)))
				       ALWAYS (QUOTEP ARG))
			      (ITERATE FOR ARG1 IN *ARGLIST*
				       AS ARG2 IN (FARGS VALUE)
				       THEREIS
				       (AND (PROG1 (= (LOGAND MASK 1)
						      0)
					      (SETQ MASK (ASH MASK -1)))
					    (< (MAX-FORM-COUNT ARG2)
					       (MAX-FORM-COUNT ARG1))))))))
	  (ITERATE FOR ARG IN (FARGS VALUE)
		   ALWAYS (REWRITE-FNCALLP FNNAME ARG))))
	(T (ITERATE FOR ARG IN (FARGS VALUE)
		    ALWAYS (REWRITE-FNCALLP FNNAME ARG)))))

(DEFUN REWRITE-IF (TEST LEFT RIGHT TYPE-ALIST)
  (COND ((AND (NVARIABLEP TEST)
              (NOT (FQUOTEP TEST))
              (EQ (FFN-SYMB TEST)
                  (QUOTE IF))
              (EQUAL (FARGN TEST 2)
                     FALSE)
              (FALSE-NONFALSEP (FARGN TEST 3))
              (NOT DEFINITELY-FALSE))
         (SWAP LEFT RIGHT)
         (SETQ TEST (FARGN TEST 1))))
  (SMART-ASSUME-TRUE-FALSE TEST)
  (COND (MUST-BE-TRUE (JUMPOUTP LEFT
                                (REWRITE LEFT ALIST TYPE-ALIST OBJECTIVE
                                         ID-IFF DEFN-FLG)))
        (MUST-BE-FALSE (JUMPOUTP RIGHT
                                 (REWRITE RIGHT ALIST TYPE-ALIST
                                          OBJECTIVE ID-IFF DEFN-FLG)))
        (T (REWRITE-IF1 TEST
                        (JUMPOUTP LEFT
                                  (LET (FALSE-TYPE-ALIST)
				    (REWRITE LEFT ALIST
					     TRUE-TYPE-ALIST
					     OBJECTIVE ID-IFF
					     DEFN-FLG)))
                        (JUMPOUTP RIGHT
                                  (REWRITE RIGHT ALIST FALSE-TYPE-ALIST
                                           OBJECTIVE ID-IFF DEFN-FLG))))))
 
(DEFUN REWRITE-IF1 (TEST LEFT RIGHT)
  (COND ((EQUAL LEFT RIGHT)
	 LEFT)
	((AND (EQUAL TEST LEFT)
	      (FALSE-NONFALSEP RIGHT)
	      DEFINITELY-FALSE)
	 TEST)
	((AND (EQUAL TRUE LEFT)
	      (FALSE-NONFALSEP RIGHT)
	      DEFINITELY-FALSE
	      (BOOLEAN TEST))
	 TEST)
	(T (FCONS-TERM* (QUOTE IF)
			TEST LEFT RIGHT))))

(DEFUN REWRITE-LINEAR-CONCL (CONCL)

;   We desire to rewrite the instantiated conclusion of linear lemmas before
;   adding them to the linear pot.  However, because all of the literals of the
;   clause being proved are on the TYPE-ALIST as false, it is possible -- say
;   when proving an instance of an already proved linear lemma -- to rewrite
;   the conclusion to F!  We could avoid this by either not putting the
;   linear-like literals on the type alist in the first place, or by not
;   rewriting the entire conclusion, just the args.  We took the latter
;   approach because it was simplest.  It does suffer from the possibility that
;   the whole (LESSP lhs rhs) of the conclusion might rewrite to something
;   else, possibly a better LESSP.

  (LET (LHS RHS)
    (COND ((MATCH CONCL (LESSP LHS RHS))
	   (FCONS-TERM* (QUOTE LESSP)
			(REWRITE LHS UNIFY-SUBST TYPE-ALIST
				 (QUOTE ?)
				 (QUOTE ID)
				 NIL)
			(REWRITE RHS UNIFY-SUBST TYPE-ALIST
				 (QUOTE ?)
				 (QUOTE ID)
				 NIL)))
	  ((MATCH CONCL (NOT (LESSP LHS RHS)))
	   (FCONS-TERM* (QUOTE NOT)
			(FCONS-TERM* (QUOTE LESSP)
				     (REWRITE LHS
					      UNIFY-SUBST
					      TYPE-ALIST
					      (QUOTE ?)
					      (QUOTE ID)
					      NIL)
				     (REWRITE RHS
					      UNIFY-SUBST
					      TYPE-ALIST
					      (QUOTE ?)
					      (QUOTE ID)
					      NIL))))
	  (T (ERROR1 (PQUOTE (PROGN REWRITE-LINEAR-CONCL
				    |thought| |that| |all| |linear|
				    |lemmas| |had| |conclusions|
				    |with| |atom| LESSP !))
		     NIL
		     (QUOTE HARD))))))

(DEFUN REWRITE-SOLIDIFY (TERM)
  (LET (LIT TEMP LHS RHS)
    (COND ((QUOTEP TERM)
	   TERM)
	  ((AND (NVARIABLEP TERM)
		(EQ (FFN-SYMB TERM)
		    (QUOTE IF)))

;   See the proof in JUMPOUTP.

	   TERM)
	  ((ITERATE FOR PAIR IN TYPE-ALIST
		    THEREIS (AND (= (CDR PAIR)
				    TYPE-SET-TRUE)
				 (MATCH (CAR PAIR)
					(EQUAL LHS RHS))
				 (EQUAL LHS TERM)))
	   RHS)
	  ((AND (SETQ TEMP-TEMP (ASSOC-EQUAL TERM TYPE-ALIST))
		(OBJ-TABLE (CDR TEMP-TEMP)
			   OBJECTIVE ID-IFF)))
	  ((SETQ LIT (ITERATE FOR LIT IN LITS-THAT-MAY-BE-ASSUMED-FALSE
			      WHEN (COND ((EQUAL LIT TERM)
					  (SETQ TEMP FALSE))
					 ((COMPLEMENTARYP LIT TERM)
					  (SETQ TEMP TRUE))
					 (T NIL))
			      DO (RETURN LIT)))
	   (COND ((OR (EQ ID-IFF (QUOTE IFF))
		      (EQ TEMP FALSE)
		      (BOOLEAN TERM))
		  (PUSH-LEMMA LIT)
		  TEMP)
		 (T TERM)))
	  (T TERM))))

(DEFUN REWRITE-TYPE-PRED (TERM)
  (LET (LHS RHS PAIR TYPE-SET)
    (COND ((OR (VARIABLEP TERM)
	       (FQUOTEP TERM))
	   TERM)
	  ((MATCH TERM (EQUAL LHS RHS))
	   (COND ((EQUAL LHS RHS)
		  TRUE)
		 ((NOT-IDENT LHS RHS)
		  FALSE)
		 ((AND (BOOLEAN LHS)
		       (EQUAL TRUE RHS))
		  LHS)
		 ((AND (BOOLEAN RHS)
		       (EQUAL TRUE LHS))
		  RHS)
		 ((MATCH RHS (EQUAL & &))
		  (FCONS-TERM* (QUOTE IF)
			       RHS
			       (FCONS-TERM* (QUOTE EQUAL)
					    LHS TRUE)
			       (FCONS-TERM* (QUOTE IF)
					    LHS FALSE TRUE)))
		 ((EQUAL LHS FALSE)
		  (FCONS-TERM* (QUOTE IF)
			       RHS FALSE TRUE))
		 ((EQUAL RHS FALSE)
		  (FCONS-TERM* (QUOTE IF)
			       LHS FALSE TRUE))
		 ((MATCH LHS (EQUAL & &))
		  (FCONS-TERM* (QUOTE IF)
			       LHS
			       (FCONS-TERM* (QUOTE EQUAL)
					    RHS TRUE)
			       (FCONS-TERM* (QUOTE IF)
					    RHS FALSE TRUE)))
		 ((AND (SETQ TYPE-SET (TYPE-SET LHS))
		       (ITERATE FOR X IN RECOGNIZER-ALIST
				THEREIS (= TYPE-SET (CDR X)))
		       (= TYPE-SET (TYPE-SET RHS))
		       (NOT (BTM-OBJECT-OF-TYPE-SET TYPE-SET)))

;   This piece of code was hacked together to test the idea that if you have an
;   (EQUAL lhs rhs) in which lhs and rhs have the same type -- and that type
;   does not contain a btm object -- that you should rewrite it to T or F
;   provided you can appropriately decide the equalities of the components.
;   Before attempting to add complete equality we did not do anything like this
;   and relied solely on elim to do it for us.  In the first attempt to add it
;   to rewrite we just rewrote all such (EQUAL lhs rhs) to the conjunction of
;   the equalities of the components.  That was unsatisfactory because it
;   caused such equalities as (EQUAL (ADDTOLIST X L) B) to be torn up all the
;   time.  That caused us to fail to prove thms like
;   SORT-OF-ORDERED-NUMBER-LIST because weak subgoals are pushed -- subgoals
;   about (CAR (ADDTOLIST X L)) and (CDR (ADDTOLIST X L)) instead about
;   (ADDTOLIST X L) itself.

;   If this piece of code survives it should be cleaned up.  Two problems.  We
;   repeatedly cons up the constant (EQUAL (CAR LHS) (CAR RHS)) and we (RETURN
;   TERM) which works only because we know this clause is the second to last
;   one in the parent COND.

		  (ITERATE FOR DEST
			   IN
			   (CDR
			    (ASSOC-EQ (CAR (ITERATE FOR X IN SHELL-ALIST
						    WHEN
						    (= TYPE-SET
						       (LOGBIT (CDR X)))
						    DO (RETURN X)))
				      SHELL-POCKETS))
			   DO (SETQ TEMP-TEMP
				    (REWRITE (FCONS-TERM*
					      (QUOTE EQUAL)
					      (FCONS-TERM* DEST (QUOTE LHS))
					      (FCONS-TERM* DEST (QUOTE RHS)))
					     (LIST (CONS (QUOTE LHS)
							 LHS)
						   (CONS (QUOTE RHS)
							 RHS))
					     TYPE-ALIST
					     (QUOTE ?)
					     (QUOTE ID)
					     NIL))
			   (COND ((EQUAL TEMP-TEMP FALSE)
				  (RETURN FALSE))
				 ((NOT (EQUAL TEMP-TEMP TRUE))
				  (RETURN TERM)))
			   FINALLY (RETURN TRUE)))
		 (T TERM)))
	  ((SETQ PAIR (ASSOC-EQ (FFN-SYMB TERM)
				RECOGNIZER-ALIST))
	   (SETQ TYPE-SET (TYPE-SET (FARGN TERM 1)))
	   (COND ((LOGSUBSETP TYPE-SET (CDR PAIR))
		  TRUE)
		 ((= 0 (LOGAND TYPE-SET (CDR PAIR)))
		  FALSE)
		 (T TERM)))
	  (T TERM))))

(DEFUN REWRITE-WITH-LEMMAS (TERM)
  (LET (REWRITTEN-TERM UNIFY-SUBST TEMP INST-HYP)
    (COND ((VARIABLEP TERM)
	   (REWRITE-SOLIDIFY TERM))
	  ((FQUOTEP TERM)
	   TERM)
	  ((MEMBER-EQ  (FFN-SYMB TERM) FNS-TO-BE-IGNORED-BY-REWRITE) TERM)
	  ((AND (OR (NOT (EQ (FFN-SYMB TERM)
			     (QUOTE LESSP)))
		    (NOT (MEMBER-EQ (QUOTE LESSP)
				    FNSTACK)))
		(REWRITE-WITH-LINEAR TERM)))
	  ((ITERATE FOR LEMMA IN (GET (FFN-SYMB TERM)
				      (QUOTE LEMMAS))
		    UNLESS (DISABLEDP (ACCESS REWRITE-RULE NAME LEMMA))
		    THEREIS
		    (COND ((META-LEMMAP LEMMA)

;   The conclusion is the name of a LISP fn to apply to the term being
;   rewritten.  To add such lemma it must be the case that the LISP function
;   return a TERMP such that in the current history (EQUAL TERM val) can be
;   proved.

			   (SETQ REWRITTEN-TERM
				 (FUNCALL (ACCESS REWRITE-RULE CONCL LEMMA)
					  TERM))
			   (COND ((EQUAL REWRITTEN-TERM TERM)
				  NIL)
				 (T

;   Because of the FORMP part of the correctness proof for user defined
;   metafunctions we know REWRITTEN-TERM is a TERMP.  However, we want all
;   terms inside the theorem prover to be in quote normal form -- all explicit
;   values be represented with QUOTE.  We normalize REWRITTEN-TERM by applying
;   the empty substitution to it.  When we wrote the metapaper we were
;   uncertain whether it was essential to the soundness of the theorem-prover
;   that terms be in quote normal form -- however the theorem-prover could
;   certainly be implemented so that it was not crucial so we left this issue
;   out of the paper.  We attempted to verify that the soundness of the current
;   implementation did not depend upon terms being in quote normal form, but we
;   got very weary, particularly because one of us could never remember what it
;   was that we were trying to prove.  We did learn that some parts of the
;   theorem prover that used functions such as OCCUR would be heuristically
;   inaccurate if terms were not in normal form.  We never discovered any
;   situation in which terms not being in normal form would cause unsoundness;
;   but we did not get past the C's in an alphabetical scan.  Instead, we gave
;   up the search and decided to require that terms be in normal form
;   throughout the theorem-prover.  We still have not yet completed a pass
;   through the theorem-prover checking that normalcy is preserved, but we
;   believe that we were thorough in the initial *1*-reformulation of the
;   theorem-prover -- never constructing a term except through CONS-TERM
;   (unless we really knew what we were doing, such as consing up an IF term in
;   rewrite).  Our confidence that we were thorough during the
;   *1*-reformulation is based upon the existence of a comment in CONS-TERM
;   claiming that every term had to be in normal form.

				  (PUSH-LEMMA (ACCESS REWRITE-RULE NAME LEMMA))
				  (SETQ REWRITTEN-TERM
					(REWRITE (SUBLIS-VAR NIL REWRITTEN-TERM)
						 NIL TYPE-ALIST OBJECTIVE ID-IFF
						 DEFN-FLG))
				  T)))
			  ((EQ (FFN-SYMB (ACCESS REWRITE-RULE CONCL LEMMA))
			       (QUOTE NOT))
			   (COND ((AND (OR (NULL (ACCESS REWRITE-RULE HYPS LEMMA))
					   (NOT (EQ OBJECTIVE (QUOTE TRUE))))
				       (ONE-WAY-UNIFY
					(FARGN (ACCESS REWRITE-RULE
						       CONCL LEMMA)
					       1)
					TERM)
				       (RELIEVE-HYPS
					(ACCESS REWRITE-RULE HYPS LEMMA)
					(ACCESS REWRITE-RULE NAME LEMMA)))
				  (PUSH-LEMMA (ACCESS REWRITE-RULE NAME LEMMA))
				  (SETQ REWRITTEN-TERM FALSE)
				  T)
				 (T NIL)))
			  ((EQ (FFN-SYMB (ACCESS REWRITE-RULE CONCL LEMMA))
			       (QUOTE EQUAL))
			   (COND ((AND
				   (OR (NULL (ACCESS REWRITE-RULE HYPS LEMMA))
				       (NOT (EQ OBJECTIVE (QUOTE TRUE)))
				       (NOT (EQUAL (FARGN (ACCESS REWRITE-RULE
								  CONCL LEMMA)
							  2)
						   FALSE)))
				   (OR (NOT (MEMBER-EQ (FFN-SYMB TERM) FNSTACK))
				       (NOT (FNNAMEP (FFN-SYMB TERM)
						     (FARGN (ACCESS REWRITE-RULE
								    CONCL LEMMA)
							    2))))
				   (ONE-WAY-UNIFY
				    (FARGN (ACCESS
					    REWRITE-RULE CONCL LEMMA)
					   1)
				    TERM)
				   (PROGN (SETQ TEMP COMMUTED-EQUALITY-FLG) T)
				   (ITERATE FOR PAIR
					    IN (ACCESS REWRITE-RULE
						       LOOP-STOPPER LEMMA)
					    NEVER (TERM-ORDER
						   (CDR (ASSOC-EQ (CAR PAIR)
								  UNIFY-SUBST))
						   (CDR (ASSOC-EQ (CDR PAIR)
								  UNIFY-SUBST))))
				   (RELIEVE-HYPS (ACCESS REWRITE-RULE HYPS LEMMA)
						 (ACCESS
						  REWRITE-RULE NAME LEMMA)))
				  (SETQ REWRITTEN-TERM
					(REWRITE
					 (COND (TEMP (COMMUTE-EQUALITIES
						      (FARGN
						       (ACCESS REWRITE-RULE
							       CONCL
							       LEMMA)
						       2)))
					       (T (FARGN (ACCESS REWRITE-RULE
								 CONCL LEMMA)
							 2)))
					 UNIFY-SUBST TYPE-ALIST OBJECTIVE ID-IFF
					 DEFN-FLG))
				  (PUSH-LEMMA (ACCESS REWRITE-RULE NAME LEMMA))
				  T)
				 ((AND (OR (NULL (ACCESS REWRITE-RULE HYPS LEMMA))
					   (NOT (EQ OBJECTIVE (QUOTE FALSE))))
				       (EQ (FFN-SYMB TERM)
					   (QUOTE EQUAL))
				       (ONE-WAY-UNIFY (ACCESS REWRITE-RULE CONCL
							      LEMMA)
						      TERM)
				       (RELIEVE-HYPS (ACCESS
						      REWRITE-RULE HYPS LEMMA)
						     (ACCESS
						      REWRITE-RULE NAME LEMMA)))
				  (PUSH-LEMMA (ACCESS REWRITE-RULE NAME LEMMA))
				  (SETQ REWRITTEN-TERM TRUE)
				  T)
				 (T NIL)))
			  ((AND (OR (NULL (ACCESS REWRITE-RULE HYPS LEMMA))
				    (NOT (EQ OBJECTIVE (QUOTE FALSE))))
				(OR (EQ ID-IFF (QUOTE IFF))
				    (BOOLEAN TERM))
				(ONE-WAY-UNIFY (ACCESS REWRITE-RULE CONCL LEMMA)
					       TERM))
			   (COND ((RELIEVE-HYPS (ACCESS REWRITE-RULE HYPS LEMMA)
						(ACCESS REWRITE-RULE NAME LEMMA))
				  (PUSH-LEMMA (ACCESS REWRITE-RULE NAME LEMMA))
				  (SETQ REWRITTEN-TERM TRUE)
				  T)
				 (T NIL)))
			  (T NIL)))
	   REWRITTEN-TERM)
	  ((MEMBER-EQUAL TERM EXPAND-LST)

;   If we have been told to expand this term, do it.  We used to do this inside
;   of REWRITE-FNCALL, but there to avoid jumping out when we hit unapproved
;   recursive calls we just substituted the actuals into the body and returned
;   that.  This seems neater.

	   (SETQ TEMP (GET (FFN-SYMB TERM)
			   (QUOTE SDEFN)))
	   (PUSH-LEMMA (FFN-SYMB TERM))
	   (REWRITE (CADDR TEMP)
		    (ITERATE FOR V IN (CADR TEMP) AS X IN (FARGS TERM)
			     COLLECT (CONS V X))
		    TYPE-ALIST OBJECTIVE ID-IFF DEFN-FLG))
	  (T (SETQ TEMP (REWRITE-FNCALL (FFN-SYMB TERM)
					(FARGS TERM)))
	     (COND ((EQUAL TEMP TERM)
		    TERM)
		   ((CONTAINS-REWRITEABLE-CALLP (FFN-SYMB TERM)
						TEMP)
		    (REWRITE TEMP NIL TYPE-ALIST OBJECTIVE ID-IFF
			     DEFN-FLG))
		   (T TEMP))))))

(DEFUN REWRITE-WITH-LINEAR (TERM)
  (PROG (ANS TEMP)
	(SETQ TEMP TERM)
	(MATCH TEMP (NOT TEMP))

;   TEMP is the atom of TERM.

	(COND ((AND (NOT (MATCH TEMP (LESSP & &)))
		    (NOT (MATCH TEMP (EQUAL & &))))
	       NIL)
	      ((EQ OBJECTIVE (QUOTE ?))

;   We tried rewriting with linear under the objective ?, and it cost us 4
;   million conses over a proveall, so we stopped rewriting with linear under
;   the objective ?.  We found that too restrictive, and experimented with the
;   idea of only rewriting with linear under ? when ANCESTORS is nonNIL, i.e.,
;   when we are working on a term that may appear as part of the simplification
;   of the theorem as opposed to a term that appears while rewriting the
;   hypothesis of a rewrite rule.  That cost us 5 times more conses on the
;   theorem it was designed to prove!  So we have abandoned linear under ?
;   altogether, again.  Here, however is the most recent experimental code:

;   (COND ((AND (NULL ANCESTORS)
;	        (EQ (ADD-TERM-TO-POT-LST TERM
;		         		 SIMPLIFY-CLAUSE-POT-LST NIL NIL)
;		    (QUOTE CONTRADICTION)))
;      	   (SETQ ANS TRUE)
;	   (GO WIN)))
   
;   (COND ((AND (NULL ANCESTORS)
;	        (EQ (ADD-TERM-TO-POT-LST TERM SIMPLIFY-CLAUSE-POT-LST T NIL)
;		    (QUOTE CONTRADICTION)))
;	   (SETQ ANS FALSE)
;	   (GO WIN)))

	       NIL)
	      ((EQ OBJECTIVE (QUOTE TRUE))
	       (COND ((EQ (ADD-TERM-TO-POT-LST TERM SIMPLIFY-CLAUSE-POT-LST
					       NIL NIL)
			  (QUOTE CONTRADICTION))
		      (SETQ ANS TRUE)
		      (GO WIN))))
	      (T (COND ((EQ (ADD-TERM-TO-POT-LST TERM SIMPLIFY-CLAUSE-POT-LST
						 T NIL)
			    (QUOTE CONTRADICTION))
			(SETQ ANS FALSE)
			(GO WIN)))))
	(RETURN NIL)
	WIN
	(ITERATE FOR X IN LEMMAS-USED-BY-LINEAR DO (PUSH-LEMMA X))
	(PUSH-LEMMA (QUOTE ZERO))
	(ITERATE FOR X IN LINEAR-ASSUMPTIONS
		 DO (PUSH-LINEARIZE-ASSUMPTION X))
	(RETURN ANS)))

(DEFUN RPLACAI (LIST I X)
  (COND ((= I 1)
	 (RPLACA (OR LIST (CONS NIL NIL))
		 X))
	(T (RPLACD (OR LIST (CONS NIL NIL))
		   (RPLACAI (CDR LIST)
			    (1- I)
			    X)))))
