(EVAL-WHEN (LOAD EVAL COMPILE)
	   (CHK-BASE-AND-PACKAGE 10 *PACKAGE*))

(DEFUN ELIMINABLE-VAR-CANDS (CL HIST)
  HIST
  (SET-DIFF (ALL-VARS-LST CL)
	    ELIM-VARIABLE-NAMES1))

(DEFUN ELIMINABLEP (SET)
  (OR (ITERATE FOR LIT IN SET ALWAYS (PRIMITIVEP LIT))
      (AND (= (LENGTH SET) 1)
	   (OR (AND (ITERATE FOR ARG IN (SARGS (CAR SET))
			     ALWAYS (VARIABLEP ARG))
		    (NO-DUPLICATESP (SARGS (CAR SET))))
	       (AND (EQ (FN-SYMB (CAR SET))
			(QUOTE NOT))
		    (ITERATE FOR ARG IN (SARGS (ARGN (CAR SET) 1))
			     ALWAYS (VARIABLEP ARG))
		    (NO-DUPLICATESP (SARGS (ARGN (CAR SET) 1))))))))

(DEFUN ELIMINATE-DESTRUCTORS-CANDIDATEP (TERM)

;   Recognizes candidates for destructor elimination.  It is assumed the input
;   term is NVARIABLEP and not QUOTEP.  To be a candidate the term must have an
;   enabled destructor elim lemma.  Furthermore, the crucial argument position
;   of the term must be occupied by a variable or must itself be a candidate
;   for elimination.  Finally, if occupied by a variable, that variable must
;   occur nowhere else in the arguments.  Note that if the crucial arg is an
;   eliminable term then the process of eliminating it will introduce a
;   suitable distinct var.  The answer returned is either NIL or else is the
;   innermost term to be eliminated -- possibly TERM itself.

  (PROG (LEMMA VAR)
	(SETQ LEMMA (GET (FFN-SYMB TERM) (QUOTE ELIMINATE-DESTRUCTORS-SEQ)))
	(COND ((OR (NULL LEMMA) (DISABLEDP (ACCESS REWRITE-RULE NAME LEMMA)))
	       (RETURN NIL)))

;   We now identify the crucial arg.

	(SETQ VAR
	      (ITERATE FOR ARG IN (FARGS TERM)
		       AS V IN (FARGS
				(CAR (GET (FFN-SYMB TERM)
					  (QUOTE ELIMINATE-DESTRUCTORS-DESTS))))
		       WHEN (EQ V (FARGN (ACCESS REWRITE-RULE CONCL LEMMA) 2))
		       DO (RETURN ARG)))
	(RETURN (COND ((VARIABLEP VAR)

;   If it is a variable, we make sure it occurs nowhere else.

		       (COND
			((ITERATE FOR ARG IN (FARGS TERM) AS V
				  IN (FARGS
				      (CAR (GET
					    (FFN-SYMB TERM)
					    (QUOTE ELIMINATE-DESTRUCTORS-DESTS))))
				  UNLESS (EQ V
					     (FARGN
					      (ACCESS REWRITE-RULE CONCL LEMMA) 2))
				  NEVER (OCCUR VAR ARG))
			 TERM)
			(T NIL)))
		      (T (ELIMINATE-DESTRUCTORS-CANDIDATEP VAR))))))

(DEFUN ELIMINATE-DESTRUCTORS-CANDIDATES (CL)

;   Returns a list of pockets.  The CAR of each pocket is an eliminable
;   destructor term.  The CDR of each pocket is a list of all destructor terms
;   that will in turn be eliminated as a result of eliminating the CAR.

  (LET (ANS)
    (ITERATE FOR LIT IN CL DO (ELIMINATE-DESTRUCTORS-CANDIDATES1 LIT))
    (MERGE-DESTRUCTOR-CANDIDATES ANS)))

(DEFUN ELIMINATE-DESTRUCTORS-CANDIDATES1 (TERM)

;   This function adds some lists to ANS.  Each list has two elements.  The
;   first is a term that can be eliminated.  The second is a term containing
;   the first which will be eliminated in the same round as the first is
;   eliminated.

  (COND ((OR (VARIABLEP TERM) (FQUOTEP TERM))
	 NIL)
	(T (ITERATE FOR ARG IN (FARGS TERM)
		    DO (ELIMINATE-DESTRUCTORS-CANDIDATES1 ARG))
	   (COND ((SETQ TEMP-TEMP (ELIMINATE-DESTRUCTORS-CANDIDATEP TERM))
		  (SETQ ANS (ADD-TO-SET (LIST TEMP-TEMP TERM) ANS)))))))

(DEFUN ELIMINATE-DESTRUCTORS-CLAUSE (CL HIST)
  (LET (ELIMINABLES NEW-CL TO-DO CANDS REWRITE-RULE HYPS LHS RHS
		    DESTS ALIST INST-DESTS INST-RHS INST-LHS
		    INST-HYPS)

;   TO-DO is a list that controls the elimination.  The invariant maintained is
;   that the all the clauses in PROCESS-CLAUSES and all the clauses in TO-DO
;   are theorems then so is the initial CL.  When a clause is removed from
;   TO-DO either it is added to PROCESS-CLAUSES or else an elimination is
;   performed on it and the resulting cases are all added to TO-DO for any
;   additional elims required on the new variables introduced.

;   TO-DO is a list of pockets.  Each pocket contains a clause, the list of all
;   variables in the clause not introduced by an elim, and some candidate
;   destructor pockets.  The candidate destructor pockets each contain in their
;   CAR a term that might be eliminated and in their CDR all of the terms that
;   could recursively be eliminated should the CAR be eliminated.  These
;   pockets are ordered from most desirable elim to least desirable elim.  At
;   the moment the ordering is determined by the sum of the level numbers of
;   the terms in the CDRs.

    (SETQ TO-DO
	  (LIST (LIST CL (ELIMINABLE-VAR-CANDS CL HIST)
		      (SORT-DESTRUCTOR-CANDIDATES
		       (ELIMINATE-DESTRUCTORS-CANDIDATES CL)))))
    (SETQ PROCESS-CLAUSES NIL)
    (SETQ PROCESS-HIST NIL)
    (ITERATE
     WHILE TO-DO
     DO
     (PROGN
       (SETQ CL (CAAR TO-DO))
       (SETQ ELIMINABLES (CADAR TO-DO))
       (SETQ CANDS (CADDAR TO-DO))
       (SETQ TO-DO (CDR TO-DO))
       (COND
	((OR (NULL ELIMINABLES)
	     (NULL CANDS))
	 (SETQ PROCESS-CLAUSES (CONS CL PROCESS-CLAUSES)))
	((ITERATE FOR CAND-TAIL ON CANDS WITH CAND
		  THEREIS
		  (PROGN
		   
;   CAND is the candidate destructor term to be eliminated.
		   
		    (SETQ CAND (CAR (CAR CAND-TAIL)))
		    (SETQ REWRITE-RULE
			  (GET (FFN-SYMB CAND)
			       (QUOTE ELIMINATE-DESTRUCTORS-SEQ)))
		   
;   We know this rule is not disabled because ELIMINATE-DESTRUCTORS-CANDIDATES
;   checks DISABLED-LEMMAS before saying a term is a candidate.
		   
		    (SETQ HYPS (ACCESS REWRITE-RULE HYPS REWRITE-RULE))
		    (SETQ LHS
			  (FARGN (ACCESS REWRITE-RULE CONCL REWRITE-RULE) 1))
		    (SETQ RHS
			  (FARGN (ACCESS REWRITE-RULE CONCL REWRITE-RULE) 2))
		    (SETQ DESTS
			  (GET (FFN-SYMB CAND)
			       (QUOTE ELIMINATE-DESTRUCTORS-DESTS)))
		    (SETQ ALIST (ITERATE FOR VAR IN (FARGS (CAR DESTS))
					 AS VAL IN (FARGS CAND)
					 COLLECT (CONS VAR VAL)))
		    (SETQ INST-RHS (SUBLIS-VAR ALIST RHS))
		    (COND
		     ((AND (MEMBER-EQ INST-RHS ELIMINABLES)
			   (ITERATE FOR HYP IN HYPS
				    NEVER (MEMBER-EQUAL (SUBLIS-VAR ALIST HYP)
							CL)))
		      (SETQ INST-DESTS (SUBLIS-VAR-LST ALIST DESTS))
		      (SETQ INST-HYPS (SUBLIS-VAR-LST ALIST HYPS))
		      (SETQ INST-LHS (SUBLIS-VAR ALIST LHS))
		      (SETQ
		       TO-DO
		       (APPEND
			(ITERATE FOR HYP IN INST-HYPS
				 UNLESS (EQUAL
					 TRUE-CLAUSE
					 (SETQ
					  NEW-CL
					  (ADD-LITERAL HYP CL NIL)))
				 COLLECT
				 (LIST
				  NEW-CL ELIMINABLES
				  (COND
				   (PROCESS-HIST
				    (ITERATE FOR POCKET
					     IN (CDR CAND-TAIL)
					     UNLESS (MEMBER-EQUAL (CAR POCKET)
								  INST-DESTS)
					     COLLECT POCKET))
				   (T NIL))))
			TO-DO))
		      (SETQ NEW-CL
			    (ELIMINATE-DESTRUCTORS-CLAUSE1 CL INST-HYPS
							   INST-LHS
							   INST-RHS
							   INST-DESTS))
		      (COND ((NOT (EQUAL TRUE-CLAUSE NEW-CL))
			     (SETQ
			      TO-DO
			      (CONS
			       (LIST
				NEW-CL
				(UNION-EQ GENERALIZING-SKOS
					  (REMOVE INST-RHS ELIMINABLES :TEST #'EQUAL))
				(SORT-DESTRUCTOR-CANDIDATES
				 (MERGE-DESTRUCTOR-CANDIDATES
				  (UNION-EQUAL
				   (COND (PROCESS-HIST
					  (ITERATE FOR POCKET
						   IN (CDR CAND-TAIL)
						   WHEN
						   (OCCUR-LST
						    (CAR POCKET)
						    NEW-CL)
						   COLLECT POCKET))
					 (T NIL))
				   (ITERATE
				    FOR POCKET
				    IN
				    (ELIMINATE-DESTRUCTORS-CANDIDATES
				     NEW-CL)
				    WHEN
				    (ITERATE FOR VAR
					     IN (FARGS (CAR POCKET))
					     THEREIS
					     (MEMBER-EQ VAR
							GENERALIZING-SKOS))
				    COLLECT POCKET)))))
			       TO-DO))))
		      (SETQ PROCESS-HIST
			    (CONS (LIST (ACCESS REWRITE-RULE NAME
						REWRITE-RULE)
					INST-DESTS OBVIOUS-RESTRICTIONS
					GENERALIZE-LEMMA-NAMES INST-RHS
					(SUB-PAIR-EXPR INST-DESTS
						       GENERALIZING-SKOS
						       INST-LHS))
				  PROCESS-HIST))
		      T)
		     (T NIL)))))
	(T (SETQ PROCESS-CLAUSES (CONS CL PROCESS-CLAUSES))))))
    (ITERATE FOR PAIR IN PROCESS-HIST
	     DO (SETQ ALL-LEMMAS-USED (UNION-EQUAL (CADDDR PAIR)
						   (ADD-TO-SET (CAR PAIR)
							       ALL-LEMMAS-USED))))
    (SETQ PROCESS-CLAUSES (SCRUNCH-CLAUSE-SET PROCESS-CLAUSES))
    (NOT (NULL PROCESS-HIST))))

(DEFUN ELIMINATE-DESTRUCTORS-CLAUSE1 (CL HYPS LHS RHS DESTS)
  (LET (GEN-CL GEN-LHS CL1)
    (SETQ CL1 CL)

;   We preserve the order of the hyps just for the hell of it.

    (ITERATE FOR HYP IN (REVERSE HYPS)
	     DO (SETQ CL1 (ADD-LITERAL (NEGATE-LIT HYP) CL1 NIL)))
    (SETQ GEN-CL (GENERALIZE1 CL1 DESTS ELIM-VARIABLE-NAMES1))
    (SETQ GEN-LHS (SUB-PAIR-EXPR DESTS GENERALIZING-SKOS LHS))
    (SUBST-VAR-LST GEN-LHS RHS GEN-CL)))

(DEFUN ELIMINATE-DESTRUCTORS-SENT (CL HIST)
  (EXECUTE (QUOTE ELIMINATE-DESTRUCTORS-CLAUSE)
	   CL HIST (QUOTE SIMPLIFY-SENT)
	   (QUOTE FERTILIZE-SENT)))

(DEFUN ELIMINATE-IRRELEVANCE-CLAUSE (CL HIST)
  HIST
  (PROG (PARTITION ELIMINABLES)
	(COND ((NOT (ASSOC-EQ (QUOTE BEING-PROVED) STACK))
	       (RETURN NIL)))
	(SETQ PARTITION
	      (TRANSITIVE-CLOSURE
	       (ITERATE FOR LIT IN CL
			COLLECT (CONS (ALL-VARS LIT) (LIST LIT)))
	       (FUNCTION (LAMBDA (X Y)
			   (COND ((INTERSECTP (CAR X) (CAR Y))
				  (CONS (UNION-EQUAL (CAR X) (CAR Y))
					(UNION-EQUAL (CDR X) (CDR Y))))
				 (T NIL))))))
	(SETQ ELIMINABLES (ITERATE FOR PAIR IN PARTITION
				   WHEN (ELIMINABLEP (CDR PAIR))
				   NCONC (CDR PAIR)))
	(COND ((NULL ELIMINABLES)
	       (RETURN NIL))
	      (T (SETQ PROCESS-CLAUSES
		       (LIST (ITERATE FOR LIT IN CL
				      UNLESS (MEMBER-EQ LIT ELIMINABLES)
				      COLLECT LIT)))
		 (SETQ PROCESS-HIST NIL)
		 (RETURN T)))))

(DEFUN ELIMINATE-IRRELEVANCE-SENT (CL HIST)
  (EXECUTE (QUOTE ELIMINATE-IRRELEVANCE-CLAUSE)
	   CL HIST (QUOTE STORE-SENT)
	   (QUOTE STORE-SENT)))

(DEFUN EQUATIONAL-PAIR-FOR (WINNING-PAIR POLY)
  (CONS (CAR WINNING-PAIR)
	(CONS-PLUS (LIST (QUOTE QUOTE)
			 (ABS (ACCESS POLY CONSTANT POLY)))
		   (BUILD-SUM WINNING-PAIR (ACCESS POLY ALIST POLY)))))

(DEFUN ERROR1 (SENTENCE ALIST HARDNESS)
  (SETQ ALIST (CONS (CONS (QUOTE SENTENCE)
			  SENTENCE)
		    (CONS (CONS (QUOTE HARDNESS) HARDNESS) ALIST)))
  (COND ((NULL HARDNESS)
	 (SETQ HARDNESS (QUOTE HARD))))
  (PRINEVAL (PQUOTE (PROGN / (COND ((EQ HARDNESS (QUOTE WARNING)) WARNING)
				   ((EQ HARDNESS (QUOTE HARD))
				    FATAL ERROR)
				   (T ERROR)) |:| (@ SENTENCE) / /))
	    ALIST 0 PROVE-FILE)
  (COND ((NOT (EQ TTY-FILE PROVE-FILE))
	 (PRINEVAL (PQUOTE (PROGN / (COND ((EQ HARDNESS (QUOTE WARNING))
					   WARNING)
					  ((EQ HARDNESS (QUOTE HARD))
					   FATAL ERROR)
					  (T ERROR)) |:| (@ SENTENCE) / /))
		   ALIST 0 TTY-FILE)))
  (COND ((EQ HARDNESS (QUOTE WARNING)) NIL)
	((AND (EQ HARDNESS (QUOTE SOFT))
	      ERROR1-SET-FLG)
	 (THROW (QUOTE ERROR1-SET) NIL))
	(T (ERROR ""))))

(DEFUN EVENT-FORM (X)
  (AND (SYMBOLP X)
       (OR (GET X (QUOTE EVENT))
	   (AND (GET X (QUOTE MAIN-EVENT))
		(GET (GET X (QUOTE MAIN-EVENT))
		     (QUOTE EVENT))))))

(DEFUN EVENT1-OCCURRED-BEFORE-EVENT2 (EVENT1 EVENT2 EVENT-LST)
  (COND ((MEMBER-EQ EVENT1 (CDR (MEMBER-EQ EVENT2 EVENT-LST))) T)
	(T NIL)))

(DEFUN EVENTS-SINCE (EVENT)
  (COND ((MEMBER-EQ EVENT CHRONOLOGY)
	 (CONS (GET EVENT (QUOTE EVENT))
	       (NREVERSE (ITERATE FOR E IN CHRONOLOGY UNTIL (EQ E EVENT)
				  COLLECT (GET E (QUOTE EVENT))))))))

(DEFUN EVG (Y)
  (COND
   ((ATOM Y)
    (COND ((INTEGERP Y)
	   (COND ((>= Y 0)
		  TYPE-SET-NUMBERS)
		 (T TYPE-SET-NEGATIVES)))
	  ((EQ Y *1*T) TYPE-SET-TRUE)
	  ((EQ Y *1*F) TYPE-SET-FALSE)
	  ((ILLEGAL-NAME Y) NIL)
	  (T TYPE-SET-LITATOMS)))
   ((EQ (CAR Y) *1*SHELL-QUOTE-MARK)
    (COND
     ((AND (CONSP (CDR Y))
	   (EQ (CDR (OUR-LAST Y)) NIL)
	   (= (LENGTH (CDDR Y)) (ARITY (CADR Y)))
	   (OR (MEMBER-EQ (CADR Y) *1*BTM-OBJECTS)
	       (AND (ASSOC-EQ (CADR Y) SHELL-ALIST)
		    (ITERATE FOR RESTRICTION
			     IN (GET (CADR Y) (QUOTE TYPE-RESTRICTIONS))
			     AS ARG IN (CDDR Y)
			     ALWAYS (AND (SETQ TEMP-TEMP (EVG ARG))
					 (LOGSUBSETP TEMP-TEMP
						     (ACCESS TYPE-RESTRICTION
							     TYPE-SET
							     RESTRICTION))))))
	   (COND ((EQ (CADR Y)
		      (QUOTE PACK))
		  (NOT (LEGAL-CHAR-CODE-SEQ (CADDR Y))))
		 ((EQ (CADR Y)
		      (QUOTE MINUS))
		  (EQUAL (CADDR Y)
			 0))
		 (T (NOT (MEMBER-EQ (CADR Y)
				    (QUOTE (ADD1 ZERO CONS)))))))
      (CAR (TYPE-PRESCRIPTION (CADR Y))))
     (T NIL)))
   ((AND (EVG (CAR Y))
	 (EVG (CDR Y)))
    TYPE-SET-CONS)
   (T NIL)))

(DEFUN EVG-OCCUR-LEGAL-CHAR-CODE-SEQ (L EVG)
  (COND ((ATOM EVG)
	 (COND ((EQ EVG *1*T) NIL)
	       ((EQ EVG *1*F) NIL)
	       ((INTEGERP EVG) NIL)
	       ((< (LENGTH (SYMBOL-NAME EVG))
		   (LENGTH-TO-ATOM L))
		NIL)
	       (T (ITERATE FOR TAIL ON L UNTIL (ATOM TAIL)
			   AS J FROM (1+
				      (- (LENGTH (SYMBOL-NAME EVG))
					 (LENGTH-TO-ATOM L)))
			   ALWAYS (= (CAR TAIL) (OUR-GETCHARN EVG J))))))
	((EQ (CAR EVG)
	     *1*SHELL-QUOTE-MARK)
	 (ITERATE FOR ARG IN (CDDR EVG) THEREIS (EVG-OCCUR-LEGAL-CHAR-CODE-SEQ
						 L ARG)))
	((EQUAL L EVG) T)
	(T (OR (EVG-OCCUR-LEGAL-CHAR-CODE-SEQ L (CAR EVG))
	       (EVG-OCCUR-LEGAL-CHAR-CODE-SEQ L (CDR EVG))))))

(DEFUN EVG-OCCUR-NUMBER (N EVG)
  (COND ((ATOM EVG)
	 (COND ((EQ EVG *1*T) NIL)
	       ((EQ EVG *1*F) NIL)
	       ((INTEGERP EVG)
		(COND ((< N 0) (EQUAL N EVG))
		      (T (<= N (ABS EVG)))))
	       ((< N 0) NIL)
	       ((> N (CHAR-CODE #\Z)) NIL)
	       ((<= N (CHAR-CODE #\-)) T)
	       (T (ITERATE FOR I FROM 1 TO (LENGTH (SYMBOL-NAME EVG))
			   THEREIS (<= N (OUR-GETCHARN EVG I))))))
	((EQ (CAR EVG) *1*SHELL-QUOTE-MARK)
	 (ITERATE FOR ARG IN (CDDR EVG) THEREIS (EVG-OCCUR-NUMBER N ARG)))
	(T (OR (EVG-OCCUR-NUMBER N (CAR EVG))
	       (EVG-OCCUR-NUMBER N (CDR EVG))))))

(DEFUN EVG-OCCUR-OTHER (X EVG)

;   X must be an evg other than a INTEGERP or a LEGAL-CHAR-CODE-SEQ with 0 final
;   CDR.

  (COND ((EQUAL X EVG) T)
	((ATOM EVG) NIL)
	((EQ (CAR EVG) *1*SHELL-QUOTE-MARK)
	 (ITERATE FOR ARG IN (CDDR EVG) THEREIS (EVG-OCCUR-OTHER X ARG)))
	(T (OR (EVG-OCCUR-OTHER X (CAR EVG))
	       (EVG-OCCUR-OTHER X (CDR EVG))))))

(DEFUN EXECUTE (PROCESS CL HIST NORMAL-EXIT NO-CHANGE-EXIT)
  (LET (NEW-HIST)
    (COND ((FUNCALL PROCESS CL HIST)
	   (SETQ NEW-HIST
		 (ADD-PROCESS-HIST PROCESS CL HIST
				   PROCESS-CLAUSES PROCESS-HIST))
	   (ITERATE FOR CL1 IN PROCESS-CLAUSES
		    DO (FUNCALL NORMAL-EXIT CL1 NEW-HIST)))
	  (T (FUNCALL NO-CHANGE-EXIT CL HIST)))))

(DEFUN EXPAND-ABBREVIATIONS (TERM ALIST)

;   Apply all unconditional rewrite rules and nonrec defns that are
;   ABBREVIATIONPs.  Adds to ABBREVIATIONS-USED the names of the lemmas and fns
;   applied.

  (LET (TEMP LEMMA RHS LHS)
    (COND ((VARIABLEP TERM)
	   (COND ((SETQ TEMP (ASSOC-EQ TERM ALIST)) (CDR TEMP))
		 (T TERM)))
	  ((FQUOTEP TERM) TERM)
	  ((MEMBER-EQ (FFN-SYMB TERM) FNS-TO-BE-IGNORED-BY-REWRITE)
	   (CONS-TERM
	    (FFN-SYMB TERM)
	    (ITERATE FOR ARG IN (FARGS TERM)
		     COLLECT (EXPAND-ABBREVIATIONS ARG ALIST))))
	  ((AND (SETQ TEMP (NON-RECURSIVE-DEFNP (FFN-SYMB TERM)))
		(ABBREVIATIONP (CADR TEMP) (CADDR TEMP)))
	   (SETQ ABBREVIATIONS-USED (ADD-TO-SET (FFN-SYMB TERM)
						ABBREVIATIONS-USED))
	   (EXPAND-ABBREVIATIONS
	    (CADDR TEMP)
	    (ITERATE FOR V IN (CADR TEMP) AS ARG IN (FARGS TERM)
		     COLLECT (CONS V (EXPAND-ABBREVIATIONS ARG ALIST)))))
	  (T (SETQ TERM (CONS-TERM
			 (FFN-SYMB TERM)
			 (ITERATE FOR ARG IN (FARGS TERM)
				  COLLECT (EXPAND-ABBREVIATIONS ARG ALIST))))
	     (COND
	      ((FQUOTEP TERM) TERM)
	      ((SETQ LEMMA
		     (ITERATE FOR LEMMA IN (GET (FFN-SYMB TERM) (QUOTE LEMMAS))
			      WHEN (AND (NOT (DISABLEDP (ACCESS REWRITE-RULE
								NAME LEMMA)))
					(NOT (META-LEMMAP LEMMA))
					(NULL (ACCESS REWRITE-RULE HYPS LEMMA))
					(NULL (ACCESS REWRITE-RULE
						      LOOP-STOPPER LEMMA))
					(MATCH (ACCESS REWRITE-RULE CONCL LEMMA)
					       (EQUAL LHS RHS))
					(ABBREVIATIONP (ALL-VARS-BAG LHS) RHS)
					(ONE-WAY-UNIFY LHS TERM))
			      DO (RETURN LEMMA)))
	       (SETQ ABBREVIATIONS-USED
		     (ADD-TO-SET (ACCESS REWRITE-RULE NAME LEMMA)
				 ABBREVIATIONS-USED))
	       (EXPAND-ABBREVIATIONS RHS UNIFY-SUBST))
	      (T TERM))))))

(DEFUN EXPAND-AND-ORS (TERM BOOL)

;   Expands the top-level fn symbol of TERM provided the expansion produces an
;   AND -- when BOOL is FALSE -- or OR -- when BOOL is TRUE -- or returns NIL
;   if no expansion is appropriate.  Side-effects ABBREVIATIONS-USED.

  (LET (TEMP LEMMA RHS LHS C2 C3)
    (COND ((VARIABLEP TERM) NIL)
	  ((FQUOTEP TERM) NIL)
	  ((AND (SETQ TEMP (NON-RECURSIVE-DEFNP (FFN-SYMB TERM)))
		(OR (AND (MATCH (CADDR TEMP) (IF & C2 C3))
			 (OR (EQUAL C2 BOOL)
			     (EQUAL C3 BOOL)))
		    (COND ((EQUAL BOOL FALSE)
			   (MATCH (CADDR TEMP) (AND & &)))
			  (T (MATCH (CADDR TEMP) (OR & &))))))
	   (SETQ ABBREVIATIONS-USED
		 (ADD-TO-SET (FFN-SYMB TERM) ABBREVIATIONS-USED))
	   (EXPAND-ABBREVIATIONS (SUB-PAIR-VAR (CADR TEMP)
					       (FARGS TERM)
					       (CADDR TEMP))
				 NIL))
	  ((SETQ LEMMA
		 (ITERATE FOR LEMMA IN (GET (FFN-SYMB TERM) (QUOTE LEMMAS))
			  WHEN (AND (NOT (DISABLEDP (ACCESS REWRITE-RULE
							    NAME LEMMA)))
				    (NOT (META-LEMMAP LEMMA))
				    (NULL (ACCESS REWRITE-RULE HYPS LEMMA))
				    (NULL (ACCESS REWRITE-RULE
						  LOOP-STOPPER LEMMA))
				    (MATCH (ACCESS REWRITE-RULE CONCL LEMMA)
					   (EQUAL LHS RHS))
				    (MATCH RHS (IF & C2 C3))
				    (OR (EQUAL C2 BOOL)
					(EQUAL C3 BOOL))
				    (ONE-WAY-UNIFY LHS TERM))
			  DO (RETURN LEMMA)))
	   (SETQ ABBREVIATIONS-USED
		 (ADD-TO-SET (ACCESS REWRITE-RULE NAME LEMMA)
			     ABBREVIATIONS-USED))
	   (EXPAND-ABBREVIATIONS (SUBLIS-VAR UNIFY-SUBST RHS)
				 NIL))
	  (T NIL))))

(DEFUN EXPAND-BOOT-STRAP-NON-REC-FNS (TERM)
  (COND ((VARIABLEP TERM) TERM)
	((FQUOTEP TERM) TERM)
	((MEMBER-EQ (FFN-SYMB TERM)
		    (QUOTE (AND OR NOT IMPLIES FIX ZEROP NLISTP)))
	 (EXPAND-BOOT-STRAP-NON-REC-FNS
	  (SUB-PAIR-VAR (CADR (GET (FFN-SYMB TERM)
				   (QUOTE SDEFN)))
			(FARGS TERM)
			(CADDR (GET (FFN-SYMB TERM) (QUOTE SDEFN))))))
	(T (CONS-TERM (FFN-SYMB TERM)
		      (ITERATE FOR ARG IN (FARGS TERM)
			       COLLECT (EXPAND-BOOT-STRAP-NON-REC-FNS ARG))))))

(DEFUN EXPAND-NON-REC-FNS (TERM)
  (COND ((VARIABLEP TERM) TERM)
	((FQUOTEP TERM) TERM)
	((NON-RECURSIVE-DEFNP (FFN-SYMB TERM))
	 (EXPAND-NON-REC-FNS (SUB-PAIR-VAR (CADR (GET (FFN-SYMB TERM)
						      (QUOTE SDEFN)))
					   (FARGS TERM)
					   (CADDR (GET (FFN-SYMB TERM)
						       (QUOTE SDEFN))))))
	(T (CONS-TERM (FFN-SYMB TERM)
		      (ITERATE FOR ARG IN (FARGS TERM)
			       COLLECT (EXPAND-NON-REC-FNS ARG))))))

(DEFUN EXPAND-PPR-MACROS (TERM)

;   This comment is out of date and the handling of PPR-MACRO-LST is a
;   good subject for an archeological dig.

;   As currently defined and used, this fn is a crock.  It binds PPR-MACRO-LST
;   apparently so that the macro defns on PPR-MACRO-LST can smash the list so
;   that while processing the value delivered by a macro macros are not
;   expanded.  This appears to be used by CONVERT-QUOTE so that after (QUOTE
;   evg) has been processed at the top level -- possibly changing into
;   something like a number or NIL or TRUE but possibly being unchanged -- the
;   recursive processing of evg does not cause macro expansion -- e.g., (QUOTE
;   (CAR (CAR X))) is otherwise changed into (QUOTE (CAAR X))!  The original
;   intent of this fn was that it would return the same s-expression printed by
;   PPRIND when PPR-MACRO-LST is used.  However, until a recent fix, if one
;   applied this fn to (QUOTE (1 . 2)) you got (QUOTE (1)) as the result,
;   because after (QUOTE (1 . 2)) was not changed by CONVERT-QUOTE, we recursed
;   into (1 . 2) as though it were a term and changed it to (1).  It should be
;   noted that PPRIND prints this term properly.  The fix mentioned was that if
;   the result delivered by a macro is a QUOTEd form, we do not recurse into
;   it.

;   We would prefer to eliminate PPR macros and to give PPR the s-expression
;   produced by this fn whenever we want to print a prettyified formula.  We
;   could then write this fn to operate only on terms and to be an inverse of
;   Translate.  Rename this fn UNTRANSLATE.  Then it should be the case that if
;   t is a term, (TRANSLATE (UNTRANSLATE t)) is a term that is provably EQUAL.
;   After doing this we would have to make sure that UNTRANSLATE is only called
;   on terms.  There are some places -- e.g., !PPR -- where this fn is applied
;   to arbitrary s-exprs -- e.g., REWRITE-RULEs in error messages.

  (COND ((ATOM TERM) TERM)
	((SETQ TEMP-TEMP (ASSOC-EQ (CAR TERM) PPR-MACRO-LST))
	 (SETQ TEMP-TEMP
	       (LET ((PPR-MACRO-LST PPR-MACRO-LST))
		 (FUNCALL (CDR TEMP-TEMP) TERM)))
	 (COND ((ATOM TEMP-TEMP) TEMP-TEMP)
	       ((EQ (CAR TEMP-TEMP) (QUOTE QUOTE)) TEMP-TEMP)
	       (T (CONS (CAR TEMP-TEMP)
			(ITERATE FOR ARG IN (CDR TEMP-TEMP)
				 COLLECT (EXPAND-PPR-MACROS ARG))))))
	(T (CONS (CAR TERM)
		 (ITERATE FOR ARG IN (CDR TERM)
			  COLLECT (EXPAND-PPR-MACROS ARG))))))

(DEFUN EXTEND-ALIST (ALIST1 ALIST2)

;   Extend ALIST2 by adding to it every pair from ALIST1 that does not conflict
;   with an existing pair in ALIST2.

  (APPEND ALIST2 (ITERATE FOR X IN ALIST1
			  UNLESS (ASSOC-EQ (CAR X) ALIST2)
			  COLLECT X)))

(DEFUN EXTERNAL-LINEARIZE (TERM FLG)
  (LET (HEURISTIC-TYPE-ALIST LITS-THAT-MAY-BE-ASSUMED-FALSE)
    (LINEARIZE TERM FLG)))

(DEFUN EXTRACT-DEPENDENCIES-FROM-HINTS (HINTS)
  (ITERATE FOR HINT IN HINTS
	   WITH ITERATE-ANS
	   DO (SETQ ITERATE-ANS
		    (UNION-EQ (CASE (CAR HINT)
				    (USE (ITERATE FOR X IN (CDR HINT) COLLECT (CAR X)))
				    (INDUCT (LIST (FFN-SYMB (TRANSLATE (CADR HINT)))))
				    (OTHERWISE NIL))
			      ITERATE-ANS))
	   FINALLY (RETURN ITERATE-ANS)))

(DEFUN FALSE-NONFALSEP (TERM)
  (LET (TEMP)
    (COND ((VALUEP TERM)
	   (SETQ DEFINITELY-FALSE (EQUAL TERM FALSE))
	   T)
	  (T (SETQ TEMP (TYPE-SET TERM))
	     (COND ((= TEMP TYPE-SET-FALSE)
		    (SETQ DEFINITELY-FALSE T)
		    T)
		   ((= 0 (LOGAND TEMP TYPE-SET-FALSE))
		    (SETQ DEFINITELY-FALSE NIL)
		    T)
		   (T NIL))))))

(DEFUN FAVOR-COMPLICATED-CANDIDATES (CANDLST)
  (MAXIMAL-ELEMENTS
   CANDLST
   (FUNCTION (LAMBDA (CAND)
	       (ITERATE FOR TERM
			IN (CONS (ACCESS CANDIDATE INDUCTION-TERM CAND)
				 (ACCESS CANDIDATE OTHER-TERMS CAND))
			COUNT (NOT (PRIMITIVE-RECURSIVEP
				    (FN-SYMB TERM))))))))

(DEFUN FERTILIZE-CLAUSE (CL HIST)
  (PROG (LIT LHS1 RHS1 LHS2 RHS2 DONT-DELETE-LIT-FLG MASS-SUBST-FLG
	     CROSS-FERT-FLG DIRECTION)
	(SETQ LIT (ITERATE FOR LIT IN CL
			   WHEN (AND (MATCH LIT (NOT (EQUAL LHS1 RHS1)))
				     (SETQ DIRECTION
					   (FERTILIZE1 LIT CL LHS1 RHS1 HIST)))
			   DO (RETURN LIT)))
	(COND ((NULL LIT) (RETURN NIL)))
	(SETQ MASS-SUBST-FLG (OR (VALUEP LHS1) (VALUEP RHS1)))
	(SETQ DONT-DELETE-LIT-FLG
	      (OR (VALUEP LHS1)
		  (VALUEP RHS1)
		  (AND (NOT (AND IN-PROVE-LEMMA-FLG
				 (ASSOC-EQ (QUOTE INDUCT) HINTS)))
		       (NOT (ASSOC-EQ (QUOTE BEING-PROVED) STACK)))))
	(SETQ CROSS-FERT-FLG
	      (AND (ASSOC-EQ (QUOTE BEING-PROVED) STACK)
		   (ITERATE FOR LIT2 IN CL
			    THEREIS
			    (AND (MATCH LIT2 (EQUAL LHS2 RHS2))
				 (COND ((EQ DIRECTION (QUOTE LEFT-FOR-RIGHT))
					(OCCUR RHS1 RHS2))
				       (T (OCCUR LHS1 LHS2)))))
		   (ITERATE FOR LIT2 IN CL
			    THEREIS
			    (AND (MATCH LIT2 (EQUAL LHS2 RHS2))
				 (COND ((EQ DIRECTION (QUOTE LEFT-FOR-RIGHT))
					(OCCUR RHS1 LHS2))
				       (T (OCCUR LHS1 RHS2)))))))
	(SETQ PROCESS-CLAUSES
	      (LIST (ITERATE FOR LIT2 IN CL WHEN (OR DONT-DELETE-LIT-FLG
						     (NOT (EQ LIT LIT2)))
			     COLLECT (COND ((EQ LIT LIT2) LIT)
					   ((OR MASS-SUBST-FLG
						(NOT CROSS-FERT-FLG)
						(MATCH LIT2 (NOT (EQUAL & &))))
					    (COND ((EQ DIRECTION
						       (QUOTE LEFT-FOR-RIGHT))
						   (SUBSTITUTE-EXPR LHS1 RHS1 LIT2))
						  (T (SUBSTITUTE-EXPR
						      RHS1 LHS1 LIT2))))
					   ((MATCH LIT2 (EQUAL LHS2 RHS2))
					    (COND ((EQ DIRECTION
						       (QUOTE LEFT-FOR-RIGHT))
						   (FCONS-TERM*
						    (QUOTE EQUAL)
						    LHS2
						    (SUBSTITUTE-EXPR LHS1 RHS1 RHS2)))
						  (T (FCONS-TERM*
						      (QUOTE EQUAL)
						      (SUBSTITUTE-EXPR RHS1 LHS1 LHS2)
						      RHS2))))
					   (T LIT2)))))
	(SETQ PROCESS-HIST (LIST MASS-SUBST-FLG CROSS-FERT-FLG
				 DIRECTION LHS1 RHS1
				 DONT-DELETE-LIT-FLG))
	(RETURN T)))

(DEFUN FERTILIZE-FEASIBLE (LIT CL TERM HIST)
  (AND (NOT (ALMOST-VALUEP TERM))
       (OR (VARIABLEP TERM) (NOT (SKO-DEST-NESTP TERM NIL)))
       (ITERATE FOR LIT2 IN CL WHEN (NOT (EQ LIT2 LIT)) THEREIS (OCCUR TERM LIT2))
       (NOT (ITERATE FOR ENTRY IN HIST WITH (LHS RHS)
		     THEREIS (AND (MATCH ENTRY (FERTILIZE-CLAUSE & & & & LHS
								 RHS &))
				  (EQUAL (FARGN (FARGN LIT 1) 1) LHS)
				  (EQUAL (FARGN (FARGN LIT 1) 2) RHS))))))

(DEFUN FERTILIZE-SENT (CL HIST)
  (EXECUTE (QUOTE FERTILIZE-CLAUSE)
	   CL HIST
	   (QUOTE SIMPLIFY-SENT)
	   (QUOTE GENERALIZE-SENT)))

(DEFUN FERTILIZE1 (LIT CL LHS RHS HIST)
  (COND ((FERTILIZE-FEASIBLE LIT CL LHS HIST)
	 (COND ((FERTILIZE-FEASIBLE LIT CL RHS HIST)
		(COND ((< (COMPLEXITY LHS) (COMPLEXITY RHS))
		       (QUOTE LEFT-FOR-RIGHT))
		      (T (QUOTE RIGHT-FOR-LEFT))))
	       (T (QUOTE RIGHT-FOR-LEFT))))
	((FERTILIZE-FEASIBLE LIT CL RHS HIST)
	 (QUOTE LEFT-FOR-RIGHT))
	(T NIL)))

(DEFUN FILTER-ARGS (SUBSET FORMALS ARGS)
  (ITERATE FOR VAR IN SUBSET
	   COLLECT (ITERATE FOR TERM IN ARGS AS FORMAL IN FORMALS
			    WHEN (EQ FORMAL VAR)
			    DO (RETURN TERM))))

(DEFUN FIND-EQUATIONAL-POLY (HIST POT)

;   Look for an equation to be derived from this pot.  If one is found, add to
;   LEMMAS-USED-BY-LINEAR and LINEAR-ASSUMPTIONS the appropriate entries from
;   the two polys involved.  In addition, add an extra entry to
;   LEMMAS-USED-BY-LINEAR to store the fact that this equation has been
;   deduced.  Finally, do not do any of this if HIST records that the deduced
;   equation has been previously deduced.  See the comment in
;   PROCESS-EQUATIONAL-POLYS for details.

  (ITERATE FOR POLY1 IN (ACCESS LINEAR-POT POSITIVES POT)
	   WITH (WINNING-PAIR POLY2 PAIR HYP1 HYP2)
	   WHEN (SETQ TEMP-TEMP (TRIVIAL-POLYP POLY1))
	   DO
	   (SETQ WINNING-PAIR (CAR TEMP-TEMP))
	   (SETQ POLY1 (CDR TEMP-TEMP))

;   POLY1 is in lowest form now.

	   (COND ((SETQ POLY2 (ITERATE FOR POLY2
				       IN (ACCESS LINEAR-POT NEGATIVES POT)
				       WHEN (COMPLEMENTARY-MULTIPLEP WINNING-PAIR
								     POLY1 POLY2)
				       DO (RETURN POLY2)))
		  (SETQ PAIR (EQUATIONAL-PAIR-FOR WINNING-PAIR POLY1))
		  (SETQ HYP1 (NUMBERP? (CAR PAIR)))
		  (SETQ HYP2 (NUMBERP? (CDR PAIR)))
		  (COND ((AND
			  (NOT (EQUAL HYP1 FALSE))
			  (NOT (EQUAL HYP2 FALSE))
			  (ITERATE FOR HIST-ENTRY IN HIST
				   NEVER
				   (AND
				    (EQ (CAR HIST-ENTRY)
					(QUOTE SIMPLIFY-CLAUSE))
				    (ITERATE FOR X IN (CDDR HIST-ENTRY)
					     THEREIS
					     (AND
					      (CONSP X)
					      (CONSP (CAR X))
					      (EQ (CAR (CAR X))
						  (QUOTE FIND-EQUATIONAL-POLY))
					      (OR (EQUAL PAIR (CDR (CAR X)))
						  (AND
						   (EQUAL (CDR PAIR)
							  (CAR (CDR (CAR X))))
						   (EQUAL
						    (CAR PAIR)
						    (CDR (CDR (CAR X)))))))))))
			 (SETQ LINEAR-ASSUMPTIONS
			       (UNION-EQUAL (UNION-EQUAL
					     (ACCESS POLY ASSUMPTIONS POLY1)
					     (ACCESS POLY ASSUMPTIONS POLY2))
					    LINEAR-ASSUMPTIONS))
			 (OR (EQUAL TRUE HYP1)
			     (SETQ LINEAR-ASSUMPTIONS
				   (ADD-TO-SET HYP1 LINEAR-ASSUMPTIONS)))
			 (OR (EQUAL TRUE HYP2)
			     (SETQ LINEAR-ASSUMPTIONS
				   (ADD-TO-SET HYP2 LINEAR-ASSUMPTIONS)))
			 (SETQ LEMMAS-USED-BY-LINEAR
			       (CONS (LIST (CONS (QUOTE FIND-EQUATIONAL-POLY)
						 PAIR))
				     (UNION-EQ (UNION-EQ (ACCESS POLY LEMMAS POLY1)
							 (ACCESS POLY LEMMAS POLY2))
					       LEMMAS-USED-BY-LINEAR)))
			 (RETURN PAIR)))))))

(DEFUN FIRST-COEFFICIENT (EQUATION)
  (CDAR (ACCESS POLY ALIST EQUATION)))

(DEFUN FIRST-VAR (EQUATION)
  (CAAR (ACCESS POLY ALIST EQUATION)))

(DEFUN FITS (ALIST1 ALIST2 VARS)

;   Return T iff the two alists agree on every var in VARS.

  (ITERATE FOR VAR IN VARS ALWAYS (EQUAL (COND ((SETQ TEMP-TEMP (ASSOC-EQ VAR ALIST1))
						(CDR TEMP-TEMP))
					       (T VAR))
					 (COND ((SETQ TEMP-TEMP (ASSOC-EQ VAR ALIST2))
						(CDR TEMP-TEMP))
					       (T VAR)))))

(DEFUN FIXCAR-CDR (TERM)
  (LET (TEMP)
    (COND ((SETQ TEMP (CAR-CDRP (CAR TERM)))
	   (SETQ TERM (CADR TERM))
	   (ITERATE FOR A-D IN TEMP
		    DO (SETQ TERM (LIST (COND ((EQL A-D #\A) (QUOTE CAR))
					      (T (QUOTE CDR))) TERM)))))
    TERM))

(DEFUN FLATTEN-TERM (TERM FN)
  (COND ((VARIABLEP TERM) (LIST TERM))
	((FQUOTEP TERM) (LIST TERM))
	((EQ FN (FFN-SYMB TERM))
	 (ITERATE FOR ARG IN (FARGS TERM) NCONC (FLATTEN-TERM ARG FN)))
	(T (LIST TERM))))

(DEFUN FLATTEN-ANDS-IN-LIT (TERM)
  (LET (C1 C2 C3)
    (COND ((EQUAL TERM TRUE) NIL)
	  ((MATCH TERM (IF C1 C2 C3))
	   (COND ((EQUAL C2 FALSE)
		  (APPEND (FLATTEN-ANDS-IN-LIT (DUMB-NEGATE-LIT C1))
			  (FLATTEN-ANDS-IN-LIT C3)))
		 ((EQUAL C3 FALSE)
		  (APPEND (FLATTEN-ANDS-IN-LIT C1) (FLATTEN-ANDS-IN-LIT C2)))
		 (T (LIST TERM))))
	  ((MATCH TERM (AND C1 C2))
	   (APPEND (FLATTEN-ANDS-IN-LIT C1) (FLATTEN-ANDS-IN-LIT C2)))
	  (T (LIST TERM)))))

(DEFUN FLESH-OUT-IND-PRIN
  (TERM FORMALS MACHINE JUSTIFICATION MASK QUICK-BLOCK-INFO)
  QUICK-BLOCK-INFO

;   Constructs a CANDIDATE record for TERM given, for the fn symbol of TERM,
;   the FORMALS, the INDUCTION-MACHINE property, a JUSTIFICATION, a sound
;   induction principle MASK, and the QUICK-BLOCK-INFO.

  (MAKE
   CANDIDATE
   (/ (FLOAT (ITERATE FOR FLG IN MASK COUNT FLG))
      (LENGTH FORMALS))
   (ITERATE FOR A IN (FARGS TERM) AS V IN FORMALS
	    WITH ITERATE-ANS
	    WHEN (MEMBER-EQ V (ACCESS JUSTIFICATION SUBSET JUSTIFICATION))
	    DO (SETQ ITERATE-ANS
		     (UNION-EQ (ALL-VARS A)
			       ITERATE-ANS))
	    FINALLY (RETURN ITERATE-ANS))
   (ITERATE FOR ACTUAL IN (SARGS TERM) AS FLG IN MASK
	    WHEN (EQ FLG (QUOTE CHANGEABLE))
	    COLLECT ACTUAL)
   (ITERATE FOR ACTUAL IN (SARGS TERM) AS FLG IN MASK
	    WITH ITERATE-ANS
	    WHEN (EQ FLG (QUOTE UNCHANGEABLE))
	    DO (SETQ ITERATE-ANS
		     (UNION-EQ (ALL-VARS ACTUAL)
			       ITERATE-ANS))
	    FINALLY (RETURN ITERATE-ANS))
   (ITERATE FOR X IN MACHINE
	    COLLECT
	    (MAKE
	     TESTS-AND-ALISTS
	     (SUB-PAIR-VAR-LST FORMALS (SARGS TERM)
			       (ACCESS TESTS-AND-CASES TESTS X))
	     (ITERATE FOR ARGLIST IN (ACCESS TESTS-AND-CASES CASES X)
		      COLLECT
		      (ITERATE FOR ACTUAL IN (SARGS TERM) AS FLG IN MASK AS ARG
			       IN ARGLIST
			       WITH ITERATE-ANS
			       DO (SETQ
				   ITERATE-ANS
				   (UNION-EQUAL
				    (COND ((NULL FLG)
					   NIL)
					  ((EQ FLG (QUOTE CHANGEABLE))
					   (LIST (CONS ACTUAL
						       (SUB-PAIR-VAR FORMALS
								     (SARGS TERM)
								     ARG))))
					  (T (ITERATE FOR VAR IN (ALL-VARS ACTUAL)
						      COLLECT (CONS VAR VAR))))
				    ITERATE-ANS))
			       FINALLY (RETURN ITERATE-ANS)))))
   JUSTIFICATION TERM NIL))

(DEFUN FLUSH-CAND1-DOWN-CAND2 (CAND1 CAND2)
  (LET (SCORE1 CONTROLLERS1 CHANGED-VARS1 UNCHANGEABLES1
	       TESTS-AND-ALISTS-LST1 JUSTIFICATION1 TERM1 OTHER-TERMS1
	       SCORE2 CONTROLLERS2 CHANGED-VARS2 UNCHANGEABLES2
	       TESTS-AND-ALISTS-LST2 JUSTIFICATION2 TERM2 OTHER-TERMS2)
    (MATCH CAND1 (CANDIDATE SCORE1 CONTROLLERS1 CHANGED-VARS1
			    UNCHANGEABLES1 TESTS-AND-ALISTS-LST1
			    JUSTIFICATION1 TERM1 OTHER-TERMS1))
    (MATCH CAND2 (CANDIDATE SCORE2 CONTROLLERS2 CHANGED-VARS2
			    UNCHANGEABLES2 TESTS-AND-ALISTS-LST2
			    JUSTIFICATION2 TERM2 OTHER-TERMS2))
    (COND ((AND
	    (SUBSETP-EQ CHANGED-VARS1 CHANGED-VARS2)
	    (SUBSETP-EQ UNCHANGEABLES1 UNCHANGEABLES2)
	    (PIGEON-HOLE
	     TESTS-AND-ALISTS-LST1 TESTS-AND-ALISTS-LST2
	     (FUNCTION
	      (LAMBDA (TA1 TA2)
		(AND
		 (SUBSETP-EQUAL (ACCESS TESTS-AND-ALISTS TESTS TA1)
				(ACCESS TESTS-AND-ALISTS TESTS TA2))
		 (OR
		  (AND (NULL (ACCESS TESTS-AND-ALISTS ALISTS TA1))
		       (NULL (ACCESS TESTS-AND-ALISTS ALISTS TA2)))
		  (PIGEON-HOLE
		   (ACCESS TESTS-AND-ALISTS ALISTS TA1)
		   (ACCESS TESTS-AND-ALISTS ALISTS TA2)
		   (FUNCTION (LAMBDA (ALIST1 ALIST2)
			       (PIGEON-HOLE
				ALIST1 ALIST2
				(FUNCTION (LAMBDA (PAIR1 PAIR2)
					    (AND (EQ (CAR PAIR1)
						     (CAR PAIR2))
						 (OCCUR (CDR PAIR1)
							(CDR PAIR2)))))
				T T)))
		   T T)))))
	     T T))
	   (MAKE CANDIDATE (+ SCORE1 SCORE2)
		 (UNION-EQ CONTROLLERS1 CONTROLLERS2)
		 CHANGED-VARS2 UNCHANGEABLES2 TESTS-AND-ALISTS-LST2
		 JUSTIFICATION2 TERM2
		 (ADD-TO-SET TERM1
			     (UNION-EQUAL OTHER-TERMS1 OTHER-TERMS2))))
	  (T NIL))))

(DEFUN FN-SYMB0 (X)
  (COND ((SYMBOLP X)
	 (COND ((EQ X *1*T) (QUOTE TRUE))
	       ((EQ X *1*F) (QUOTE FALSE))
	       (T (QUOTE PACK))))
	((INTEGERP X)
	 (COND ((< X 0) (QUOTE MINUS))
	       ((EQUAL X 0) (QUOTE ZERO))
	       (T (QUOTE ADD1))))
	((EQ (CAR X) *1*SHELL-QUOTE-MARK)
	 (CADR X))
	(T (QUOTE CONS))))

(DEFUN FNNAMEP (FN TERM)
  (COND ((VARIABLEP TERM) NIL)
	((FQUOTEP TERM)
	 (COND ((OR (MEMBER-EQ FN *1*BTM-OBJECTS) (ASSOC-EQ FN SHELL-ALIST))
		(MEMBER-EQ FN (ALL-FNNAMES TERM)))
	       (T NIL)))
	((EQ FN (FFN-SYMB TERM)) T)
	(T (ITERATE FOR X IN (FARGS TERM) THEREIS (FNNAMEP FN X)))))

(DEFUN FNNAMEP-IF (TERM)
  (COND ((VARIABLEP TERM) NIL)
	((FQUOTEP TERM) NIL)
	((EQ (FFN-SYMB TERM) (QUOTE IF)) T)
	(T (ITERATE FOR X IN (FARGS TERM) THEREIS (FNNAMEP-IF X)))))

(DEFUN FORM-COUNT (TERM)

;   Returns the number of open parentheses in the unabbreviated presentation of
;   TERM.  Also sets NUMBER-OF-VARIABLES to the number of variables in TERM.

  (SETQ NUMBER-OF-VARIABLES 0)
  (FORM-COUNT1 TERM))

(DEFUN FORM-COUNT-EVG (EVG)
  (COND
   ((ATOM EVG)
    (COND
     ((EQ EVG *1*T) 1)
     ((EQ EVG *1*F) 1)
     ((INTEGERP EVG)
      (COND ((< EVG 0) (+ 2 (- EVG)))
	    (T (1+ EVG))))
     (T (SETQ TEMP-TEMP (ASSOC-EQ EVG LITATOM-FORM-COUNT-ALIST))
	(COND (TEMP-TEMP (CDR TEMP-TEMP))
	      (T (CDAR (SETQ LITATOM-FORM-COUNT-ALIST
			     (CONS (CONS EVG
					 (+ 2 (* 2
						 (LENGTH
						  (SYMBOL-NAME EVG)))
					    (ITERATE FOR I NUMBER FROM 1
						     TO (LENGTH
							 (SYMBOL-NAME EVG))
						     SUM (OUR-GETCHARN
							  EVG I))))
				   LITATOM-FORM-COUNT-ALIST))))))))
   ((EQ (CAR EVG)
	*1*SHELL-QUOTE-MARK)
    (1+ (ITERATE FOR X IN (CDDR EVG) SUM (FORM-COUNT-EVG X))))
   (T (+ 1 (FORM-COUNT-EVG (CAR EVG))
	 (FORM-COUNT-EVG (CDR EVG))))))

(DEFUN FORM-COUNT1 (TERM)
  (COND ((VARIABLEP TERM)
	 (SETQ NUMBER-OF-VARIABLES (1+ NUMBER-OF-VARIABLES))
	 0)
	((FQUOTEP TERM)
	 (FORM-COUNT-EVG (CADR TERM)))
	(T
	 (1+ (ITERATE FOR T1 IN (FARGS TERM) SUM (FORM-COUNT1 T1))))))

(DEFUN FORM-INDUCTION-CLAUSE (TESTS HYPS CONCL TERMS)
  TERMS

;   We once implemented the idea of "homographication" in which we combined
;   both induction, opening up of the recursive fns in the conclusion, and
;   generalizing away some recursive calls.  This function did the expansion
;   and generalization.  If the idea is reconsidered the following theorems are
;   worthy of consideration:

;       (ORDERED (SORT X)),
;       (IMPLIES (ORDERED X)
;	         (ORDERED (ADDTOLIST I X))),
;       (IMPLIES (AND (NUMBER-LISTP X) 
;                     (ORDERED X)
;                     (NUMBERP I)
;                     (NOT (LESSP (CAR X) I)))
;                (EQUAL (ADDTOLIST I X) (CONS I X))), and
;       (IMPLIES (AND (NUMBER-LISTP X) (ORDERED X)) (EQUAL (SORT X) X)).

  (APPEND TESTS HYPS CONCL))

(DEFUN FORMP-SIMPLIFIER (TERM)
  (LET (X FN TL)
    (MATCH! TERM (FORMP X))
    (COND ((VARIABLEP X) TERM)
	  ((SHELLP X)
	   (COND ((NOT (EQ (FN-SYMB X) (QUOTE CONS)))
		  (CONS-TERM (QUOTE SYMBOLP) (FARGS TERM)))
		 (T (SETQ FN (ARGN X 1))
		    (SETQ TL (ARGN X 2))
		    (COND ((AND (QUOTEP FN) (SYMBOLP (CADR FN)))
			   (COND ((EQ (CADR FN) (QUOTE QUOTE))
				  (SUBSTITUTE-EXPR TL (QUOTE TL)
						   (QUOTE
						    (IF (LISTP TL)
							(EQUAL (CDR TL)
							       (QUOTE NIL))
							(QUOTE *1*FALSE)))))
				 ((AND (GET (CADR FN)
					    (QUOTE TYPE-PRESCRIPTION-LST))
				       (NOT (MEMBER-EQ (CADR FN) META-NAMES)))
				  (SUBLIS-VAR
				   (LIST (CONS (QUOTE TL) TL)
					 (CONS (QUOTE A)
					       (LIST (QUOTE QUOTE)
						     (ARITY (CADR FN)))))
				   (QUOTE (IF (EQUAL A (LENGTH TL))
					      (FORM-LSTP TL)
					      (QUOTE *1*FALSE)))))
				 (T TERM)))
			  (T TERM)))))
	  (T TERM))))

(DEFUN FORMULA-OF (NAME)
  (LET (TEMP)
    (SETQ TEMP (GET NAME (QUOTE EVENT)))
    (CASE (CAR TEMP)
	  ((ADD-AXIOM PROVE-LEMMA) (CADDDR TEMP))
	  (OTHERWISE NIL))))

(DEFUN FREE-VAR-CHK (NAME ARGS FORM)
  (LET (TEMP)
    (SETQ FORM (ALL-VARS FORM))
    (SETQ TEMP (SET-DIFF FORM ARGS))
    (COND (TEMP (ERROR1 (PQUOTE (PROGN |Illegal| |free|
				       (PLURAL? TEMP |variables|
						|variable|) |,|
				       (!PPR-LIST TEMP (QUOTE |,|))
				       |in| |the| |definition| |of|
				       (!PPR NAME NIL) !))
			(BINDINGS (QUOTE NAME) NAME
				  (QUOTE TEMP) TEMP)
			(QUOTE SOFT))))
    (SETQ TEMP (SET-DIFF ARGS FORM))
    (COND (TEMP (ERROR1 (PQUOTE (PROGN (!LIST TEMP)
				       (PLURAL? TEMP |are| |is|)
				       |in| |the| |arglist| |but| |not| |in|
				       |the| |body| |of| |the| |definition|
				       |of| (!PPR NAME NIL)  !))
			(BINDINGS (QUOTE NAME) NAME
				  (QUOTE TEMP) TEMP)
			(QUOTE WARNING))))
    NIL))

(DEFUN FREE-VARSP (TERM ALIST)
  (COND ((VARIABLEP TERM) (NOT (ASSOC-EQ TERM ALIST)))
	((FQUOTEP TERM) NIL)
	(T (ITERATE FOR ARG IN (FARGS TERM) THEREIS (FREE-VARSP ARG ALIST)))))

(DEFUN GEN-VARS (CL N VARIABLE-NAMES)

;   Generates N skolem constants not occurring in clause CL.

  (SET-DIFF-N VARIABLE-NAMES (ITERATE FOR LIT IN CL WITH ITERATE-ANS
				      DO (SETQ ITERATE-ANS
					       (UNION-EQ (ALL-VARS LIT) ITERATE-ANS))
				      FINALLY (RETURN ITERATE-ANS))
	      N))

(DEFUN GENERALIZE-CLAUSE (CL HIST)
  HIST

;   Generalize the smallest common subterms in CL -- as defined by COMSUBTERMS
;   -- using the lemmas on GENERALIZE-LEMMAS to supply typing info.

  (PROG (COMMONSUBTERMS)
	(COND ((OR (NOT (ASSOC-EQ (QUOTE BEING-PROVED) STACK))
	           DO-NOT-GENERALIZE-FLG)
               (RETURN NIL)))
	(SETQ COMMONSUBTERMS (GENRLTERMS CL))
	(COND ((NULL COMMONSUBTERMS) (RETURN NIL))
	      (T (SETQ PROCESS-CLAUSES
		       (LIST (GENERALIZE1 CL COMMONSUBTERMS
					  GEN-VARIABLE-NAMES1)))
		 (SETQ PROCESS-HIST (LIST GENERALIZING-SKOS
					  COMMONSUBTERMS
					  OBVIOUS-RESTRICTIONS
					  GENERALIZE-LEMMA-NAMES))
		 (SETQ ALL-LEMMAS-USED
		       (UNION-EQ GENERALIZE-LEMMA-NAMES ALL-LEMMAS-USED))
		 (RETURN T)))))

(DEFUN GENERALIZE-SENT (CL HIST)
  (EXECUTE (QUOTE GENERALIZE-CLAUSE)
	   CL HIST (QUOTE SIMPLIFY-SENT)
	   (QUOTE ELIMINATE-IRRELEVANCE-SENT)))

(DEFUN GENERALIZE1 (CL SUBTERMLST VARIABLE-NAMES)

;   Replaces all occurrences of the subterms in SUBTERMLST in CL by new vars,
;   and qualifies each var with all the information known to GET-TYPES.

  (SETQ GENERALIZING-SKOS (GEN-VARS CL (LENGTH SUBTERMLST)
				    VARIABLE-NAMES))
  (SETQ OBVIOUS-RESTRICTIONS NIL)
  (SETQ GENERALIZE-LEMMA-NAMES NIL)
  (GENERALIZE2 SUBTERMLST GENERALIZING-SKOS CL))

(DEFUN GENERALIZE2 (TERMLST VARLST CL)
  (ITERATE FOR LIT IN (SCRUNCH (NCONC (ITERATE FOR SUBTERM IN TERMLST
					       NCONC (ITERATE FOR HYP
							      IN (GET-TYPES SUBTERM CL)
							      COLLECT
							      (DUMB-NEGATE-LIT HYP)))
				      CL))
	   COLLECT (SUB-PAIR-EXPR TERMLST VARLST LIT)))

(DEFUN GENRLT1 (CL)
  (LET (LHS RHS)
    (ITERATE FOR LIT IN CL WHEN (OR (MATCH LIT (EQUAL LHS RHS))
				    (MATCH LIT (NOT (EQUAL LHS RHS))))
	     DO (COMSUBTERMS LHS RHS))
    (ITERATE FOR TAIL ON CL DO (ITERATE FOR LIT2 IN (CDR TAIL)
					DO (COMSUBTERMS (CAR TAIL)
							LIT2)))
    NIL))

(DEFUN GENRLTERMS (CL) (LET (GENRLTLIST) (GENRLT1 CL) GENRLTLIST))

(DEFUN GET-CANDS (TERM)

;   Returns all of the induction principles -- see POSSIBLE-IND-PRINCIPLES --
;   connected to terms in TERM, which is the conjecture to be proved.

  (COND ((VARIABLEP TERM) NIL)
	((QUOTEP TERM) NIL)
	(T (NCONC (POSSIBLE-IND-PRINCIPLES TERM)
		  (ITERATE FOR ARG IN (FARGS TERM) NCONC (GET-CANDS ARG))))))

(DEFUN GET-LISP-SEXPR (FN)
  (LET (SEXPR)
    (COND ((NULL (GET FN (QUOTE LISP-CODE)))
	   (ERROR1 (PQUOTE (PROGN (!PPR FN NIL)
				  |does| |not| |have| |a| |runnable| LISP
				  |definition| |.|))
		   (BINDINGS (QUOTE FN) FN)
		   (QUOTE SOFT))))
    (SETQ SEXPR (GET (GET FN (QUOTE LISP-CODE)) (QUOTE SEXPR)))
    (COND ((NULL SEXPR)
	   (ERROR1 (PQUOTE (PROGN (!PPR FN NIL)
				  |is| |part| |of| |the| |basic| |system|
				  |and| |has| |a| |hand-coded| LISP
				  |definition| |.|))
		   (BINDINGS (QUOTE FN)
			     FN)
		   (QUOTE SOFT)))
	  (T SEXPR))))

(DEFUN GET-LEVEL-NO (FNNAME)
  (OR (GET FNNAME (QUOTE LEVEL-NO)) 0))

(DEFUN GET-STACK-NAME (STACKV)
  (PACK (CONS (QUOTE *)
	      (CDR (ITERATE FOR I IN (NREVERSE (GET-STACK-NAME1 STACKV))
			    NCONC (LIST (QUOTE |.|) I))))))

(DEFUN GET-STACK-NAME1 (STACKV)
  (LET (ANS)
    (COND ((NULL STACKV) (LIST 1))
	  ((EQ (CAAR STACKV) (QUOTE TO-BE-PROVED))
	   (SETQ ANS (GET-STACK-NAME1 (CDR STACKV)))
	   (RPLACA ANS (1+ (CAR ANS))))
	  (T (CONS 1 (GET-STACK-NAME1 (CDR STACKV)))))))

(DEFUN GET-TYPES (TERM CL)
  (LET (TYPE-RESTRICTION LEMMA-RESTRICTIONS TYPE PAIR INST-LEMMA)
    CL
    (SETQ TYPE (TYPE-SET TERM))
    (SETQ TYPE-RESTRICTION
	  (COND ((SETQ PAIR (ITERATE FOR PAIR IN RECOGNIZER-ALIST
				     WHEN (= TYPE (CDR PAIR))
				     DO (RETURN PAIR)))
		 (FCONS-TERM* (CAR PAIR) TERM))
		(T NIL)))
    (COND (TYPE-RESTRICTION (SETQ OBVIOUS-RESTRICTIONS
				  (ADD-TO-SET TYPE-RESTRICTION
					      OBVIOUS-RESTRICTIONS))))
    (SETQ LEMMA-RESTRICTIONS
	  (ITERATE FOR LEMMA IN GENERALIZE-LEMMAS
		   UNLESS (DISABLEDP (ACCESS GENERALIZE-LEMMA NAME LEMMA))
		   WHEN (AND (ARG1-IN-ARG2-UNIFY-SUBST TERM
						       (ACCESS GENERALIZE-LEMMA
							       TERM LEMMA))
			     (NOT (FREE-VARSP (ACCESS GENERALIZE-LEMMA TERM
						      LEMMA)
					      UNIFY-SUBST))
			     (NOT (FNNAMEP (FN-SYMB TERM)
					   (SUBST-EXPR
					    (QUOTE X)
					    TERM
					    (SETQ INST-LEMMA
						  (SUBLIS-VAR
						   UNIFY-SUBST
						   (ACCESS
						    GENERALIZE-LEMMA
						    TERM LEMMA)))))))
		   COLLECT
		   (PROGN (SETQ GENERALIZE-LEMMA-NAMES
				(CONS (ACCESS GENERALIZE-LEMMA NAME LEMMA)
				      GENERALIZE-LEMMA-NAMES))
			  INST-LEMMA)))
    (COND (TYPE-RESTRICTION (CONS TYPE-RESTRICTION
				  LEMMA-RESTRICTIONS))
	  (T LEMMA-RESTRICTIONS))))

(DEFUN GUARANTEE-CITIZENSHIP (NAME)
  (COND ((AND (NOT (GET NAME (QUOTE EVENT)))
	      (NOT (GET NAME (QUOTE MAIN-EVENT))))
	 (PUT1 MAIN-EVENT-NAME (CONS NAME (GET MAIN-EVENT-NAME
					       (QUOTE SATELLITES)))
	       (QUOTE SATELLITES))
	 (PUT1 NAME MAIN-EVENT-NAME
	       (QUOTE MAIN-EVENT)))))

(DEFUN GUESS-RELATION-MEASURE-LST (FORMALS MACHINE)

;   We assume MACHINE is a list of TESTS-AND-CASE.  We will guess that the
;   COUNT goes down with LESSP on formal tested and changed in every line of
;   the machine.

  (ITERATE FOR VAR IN FORMALS AS I FROM 0
	   WHEN (ITERATE FOR X IN MACHINE
			 ALWAYS (AND (OCCUR-LST VAR (ACCESS TESTS-AND-CASE TESTS X))
				     (NOT (EQ VAR (NTH I (ACCESS TESTS-AND-CASE
								 CASE X))))))
	   COLLECT (LIST (QUOTE LESSP)
			 (LIST (QUOTE COUNT)
			       VAR))))

(DEFUN HAS-LIB-PROPS (ATM)
  (ITERATE FOR TAIL ON (SYMBOL-PLIST ATM) BY (QUOTE CDDR)
	   THEREIS (OR (EQ (CAR TAIL) (QUOTE LIB-LOC))
		       (AND (MEMBER-EQ (CAR TAIL)
				       LIB-PROPS)
			    (CADR TAIL)))))

(DEFUN ILLEGAL-CALL NIL
  (ERROR1 (PQUOTE (PROGN |Some| |function| |was| |called| |with|
			 |inappropriate| |arguments| |.|))
	  NIL
	  (QUOTE HARD)))

(DEFUN ILLEGAL-NAME (NAME)
  (NOT (AND (SYMBOLP NAME)
	    (OK-SYMBOLP NAME)
	    (LEGAL-CHAR-CODE-SEQ (OUR-EXPLODEN NAME)))))

(DEFUN IMMEDIATE-DEPENDENTS-OF (NAME)
  (LET (ATM)
    (COND ((EQ NAME (QUOTE GROUND-ZERO))
	   (REMOVE1 (QUOTE GROUND-ZERO) CHRONOLOGY))
	  ((OR (NOT (SYMBOLP NAME))
	       (NOT (GET NAME (QUOTE EVENT))))
	   (ERROR1 (PQUOTE (PROGN IMMEDIATE-DEPENDENTS-OF |was|
				  |called| |on| |a| |nonevent| |,|
				  (!PPR NAME NIL) |.|))
		   (BINDINGS (QUOTE NAME) NAME)
		   (QUOTE HARD)))
	  ((SETQ ATM (TYPE-PRESCRIPTION-LEMMAP NAME))

;   NAME is a type prescription lemma hung under ATM.  In this case, we must
;   include in the dependents of NAME all events dependent upon ATM that
;   occurred after NAME was introduced.

;   This clause in the UNDO mechanism is the source of doubt that the mechanism
;   correctly identifies all of the dependents of an event.  The problem starts
;   with the fact that the use of type set lemmas is not tracked like other
;   lemmas.  In fact, no code in the theorem prover actually notes when or how
;   a particular type set lemma is used.  How then can we hope to determine
;   which proofs (or other events) depend upon a type set lemma?  We have tried
;   several approaches to the question.  Some have turned out incorrect.  We
;   believe the current one to be correct.  Our hand-waving proof of its
;   correctness is this.  If a type set lemma about the function FN is used in
;   the proof of THM, then either (1) THM mentions FN, (2) some lemma used in
;   the proof of THM (other than a type set lemma) mentions FN, (3) some lemma
;   used in the proof of THM mentions a function whose definition mentions FN,
;   (3.a) some lemma used in the proof of THM uses a function whose definition
;   mentions a function that either (3.b) mentions FN or (3.c) mentions a
;   function whose definition mentions FN, or ... But we believe that any such
;   lemma introducing FN into the proof is in ALL-LEMMAS-USED when the proof is
;   done and thus has THM as one of its IMMEDIATE-DEPENDENTS0.  To put it in
;   terms of the following code, we believe that there is a "tree-path", i.e.
;   an IMMEDIATE-DEPENDENTS0 path, from FN to THM.  Given that hypothesis, we
;   then correctly identify a superset of the dependents of a type set lemma by
;   the draconian strategy of claiming as a dependent event any event on a
;   tree-path that took place later than the type set lemma.  Note that this
;   computation is not trying to get all of the theorems dependent (somehow)
;   upon the type set lemma in question but only those immediately dependent --
;   i.e., whose proofs might have actually appealed to this type set lemma.  It
;   is assumed that any function using IMMEDIATE-DEPENDENTS-OF to explore the
;   logical graph of events will recurse on each of the dependent events, and
;   thus catch things like THMs dependent upon type set lemmas dependent upon
;   the type set lemma in question.

	   (UNION-EQUAL (ITERATE FOR X
				 IN (TREE-DEPENDENTS (MAIN-EVENT-OF ATM))
				 WHEN (EVENT1-OCCURRED-BEFORE-EVENT2
				       NAME X CHRONOLOGY)
				 COLLECT X)
			(ITERATE FOR X IN
				 (GET NAME (QUOTE IMMEDIATE-DEPENDENTS0))
				 COLLECT X)))
	  (T (ITERATE FOR X IN (GET NAME (QUOTE IMMEDIATE-DEPENDENTS0))
		      COLLECT X)))))

(DEFUN IMPLIES? (TESTS TERM)
  (MEMBER-EQUAL TERM TESTS))

(DEFUN IMPOSSIBLE-POLYP (POLY)
  (AND (> (ACCESS POLY CONSTANT POLY)
	  0)
       (ITERATE FOR PAIR IN (ACCESS POLY ALIST POLY)
		ALWAYS (>= (CDR PAIR) 0))))

(DEFUN IND-FORMULA (TESTS-AND-ALISTS-LST TERMS CL-SET)

;   TESTS-AND-ALISTS-LST is a such a list that the disjunction of the
;   conjunctions of the TESTS components of the members is T.  Furthermore,
;   there exists a measure M, a well-founded relation R, and a sequence of
;   variables x1, ..., xn such that for each T&Ai in TESTS-AND-ALISTS-LST, for
;   each alist alst in the ALISTS component of T&Ai, the conjunction of the
;   TESTS component, say qi, implies that (R (M x1 ... xn) /alst (M x1 ...
;   xn)).

;   To prove thm, the conjunction of the disjunctions of the members of CL-SET,
;   it is sufficient, by the principle of induction, to prove instead the
;   conjunction of the terms qi & thm' & thm'' ...  -> thm, where the primed
;   terms are the results of substituting the alists in the ALISTS field of the
;   ith member of TESTS-AND-ALISTS-LST into thm.

;   If thm1, thm2, ..., thmn are the disjunctions of the members of CL-SET,
;   then it is sufficient to prove all of the formulas qi & thm' & thm'' ...
;   -> thmj.  This is a trivial proposition fact, to prove (IMPLIES A (AND B
;   C)) it is sufficient to prove (IMPLIES A B) and (IMPLIES A C)

;   The (ITERATE FOR PICK ...) expression below returns a list of clauses whose
;   conjunction propositionally implies qi & thm' & thm'' ...  -> thmj, where
;   TA is the ith member of TESTS-AND-ALISTS-LST and CL is the jth member of
;   CL-SET.  Proof:  Let THM have the form:
;   
;        (AND (OR a1 ...)
;             (OR b1 ...)
;	      ...
;	      (OR z1 ...)). 

;   Then qi & thm' & thm'' ... -> thmj has the form:
   
;       (IMPLIES (AND qi
;		      (AND (OR a1 ... )
;			   (OR b1 ... )
;			   ...
;			   (OR z1 ... ))'
;		      (AND (OR a1 ... )
;			   (OR b1 ... )
;			   ...
;			   (OR z1 ... ))''
;		      ...
;		      (AND (OR a1 ... )
;			   (OR b1 ... )
;			   ...
;			   (OR z1 ... )))'''...'
;		 thmj).
;   
;   Suppose this formula is false for some values of the free variables.  Then
;   under those values, each disjunction in the hypothesis is true.  Thus there
;   exists a way of choosing one literal from each of the disjunctions, all of
;   which are true.  This choice is one of the PICKs below.  But we prove that
;   (IMPLIES (AND qi PICK) thmj).

  (DELETE-TAUTOLOGIES
   (SCRUNCH-CLAUSE-SET
    (ITERATE FOR CL IN CL-SET
	     NCONC
	     (ITERATE FOR TA IN TESTS-AND-ALISTS-LST
		      NCONC
		      (ITERATE FOR PICK
			       IN
			       (ALL-PICKS
				(ITERATE FOR CL1 IN CL-SET
					 NCONC
					 (ITERATE FOR ALIST
						  IN (ACCESS TESTS-AND-ALISTS ALISTS TA)
						  COLLECT
						  (ITERATE FOR LIT IN CL1
							   COLLECT (NEGATE-LIT
								    (SUBLIS-VAR ALIST
										LIT))))))
			       COLLECT (FORM-INDUCTION-CLAUSE
					(ITERATE FOR TEST
						 IN (ACCESS TESTS-AND-ALISTS TESTS TA)
						 COLLECT (NEGATE-LIT TEST))
					PICK CL TERMS)))))))

(DEFUN INDUCT (CL-SET)
  (LET (GET-CANDS-ANS MERGED-CANDS-ANS PICK-HIGH-SCORES-ANS
		      WINNING-CAND INDUCT-ANS COMPUTE-VETOES-ANS
		      FAVOR-COMPLICATED-CANDIDATES-ANS)
    (SETQ
     WINNING-CAND
     (CAR
      (SETQ
       PICK-HIGH-SCORES-ANS
       (PICK-HIGH-SCORES
	(SETQ FAVOR-COMPLICATED-CANDIDATES-ANS
	      (FAVOR-COMPLICATED-CANDIDATES
	       (SETQ COMPUTE-VETOES-ANS
		     (COMPUTE-VETOES
		      (SETQ MERGED-CANDS-ANS
			    (TRANSITIVE-CLOSURE
			     (SETQ GET-CANDS-ANS
				   (REMOVE-UNCHANGING-VARS
				    (ITERATE FOR CL IN CL-SET
					     NCONC (ITERATE FOR LIT IN CL
							    NCONC
							    (GET-CANDS LIT)))
				    CL-SET))
			     (FUNCTION MERGE-CANDS)))))))))))
    (COND (WINNING-CAND (SETQ INDUCT-ANS
			      (IND-FORMULA (ACCESS CANDIDATE
						   TESTS-AND-ALISTS-LST
						   WINNING-CAND)
					   (CONS (ACCESS CANDIDATE
							 INDUCTION-TERM
							 WINNING-CAND)
						 (ACCESS CANDIDATE OTHER-TERMS
							 WINNING-CAND))
					   CL-SET))
			(INFORM-SIMPLIFY (ACCESS CANDIDATE
						 TESTS-AND-ALISTS-LST
						 WINNING-CAND)
					 (CONS (ACCESS CANDIDATE
						       INDUCTION-TERM
						       WINNING-CAND)
					       (ACCESS CANDIDATE
						       OTHER-TERMS
						       WINNING-CAND))))
	  (T (IO (QUOTE INDUCT)
		 CL-SET NIL (LIST NIL)
		 (LIST (GET-STACK-NAME (CDR STACK)) NIL 0 0 0 0 0))
	     (WRAPUP NIL)))
    (SETQ ALL-LEMMAS-USED
	  (UNION-EQ (ACCESS JUSTIFICATION LEMMAS
			    (ACCESS CANDIDATE JUSTIFICATION WINNING-CAND))
		    ALL-LEMMAS-USED))
    (IO (QUOTE INDUCT)
	CL-SET NIL INDUCT-ANS
	(LIST (GET-STACK-NAME (CDR STACK))
	      WINNING-CAND
	      (LENGTH GET-CANDS-ANS)
	      (LENGTH MERGED-CANDS-ANS)
	      (COND ((EQ COMPUTE-VETOES-ANS MERGED-CANDS-ANS) 0)
		    (T (LENGTH COMPUTE-VETOES-ANS)))
	      (LENGTH PICK-HIGH-SCORES-ANS)
	      (LENGTH FAVOR-COMPLICATED-CANDIDATES-ANS)))
    INDUCT-ANS))

(DEFUN INDUCT-VARS (CAND)

;   Get all skos occupying controller slots in any of the terms associated with
;   this candidate.

  (ITERATE FOR TERM IN (CONS (ACCESS CANDIDATE INDUCTION-TERM CAND)
			     (ACCESS CANDIDATE OTHER-TERMS CAND))
	   WITH ITERATE-ANS
	   DO (SETQ ITERATE-ANS
		    (UNION-EQ (ITERATE FOR ARG IN (FARGS TERM) AS I FROM 0
				       WHEN (AND (VARIABLEP ARG)
						 (ITERATE FOR MASK
							  IN
							  (GET (FFN-SYMB TERM)
							       (QUOTE CONTROLLER-POCKETS))
							  THEREIS
							  (NOT
							   (= 0
							      (LOGAND 1
								      (ASH MASK
									   (- I)))))))
				       COLLECT ARG)
			      ITERATE-ANS))
	   FINALLY (RETURN ITERATE-ANS)))

(DEFUN INDUCTION-MACHINE (FNNAME TERM TESTS)

;   See the comment for TERMINATION-MACHINE.

  (COND ((OR (VARIABLEP TERM)
	     (FQUOTEP TERM)
	     (NOT (EQ (FFN-SYMB TERM)
		      (QUOTE IF))))
	 (LIST (MAKE TESTS-AND-CASES (REMOVE-REDUNDANT-TESTS TESTS NIL)
		     (UNION-EQUAL (ITERATE FOR TEST IN TESTS
					   WITH ITERATE-ANS
					   DO (SETQ ITERATE-ANS
						    (UNION-EQUAL
						     (ALL-ARGLISTS FNNAME TEST)
						     ITERATE-ANS))
					   FINALLY (RETURN ITERATE-ANS))
				  (ALL-ARGLISTS FNNAME TERM)))))
	(T (NCONC (INDUCTION-MACHINE FNNAME (FARGN TERM 2)
				     (APPEND TESTS (LIST (FARGN TERM 1))))
		  (INDUCTION-MACHINE
		   FNNAME
		   (FARGN TERM 3)
		   (APPEND TESTS (LIST (NEGATE-LIT (FARGN TERM 1)))))))))

(DEFUN INFORM-SIMPLIFY (TESTS-AND-ALISTS-LST TERMS)

;   Two of the variables effecting REWRITE are TERMS-TO-BE-IGNORED-BY-REWRITE
;   and EXPAND-LST.  When any term on the former is encountered REWRITE returns
;   it without rewriting it.  Terms on the latter must be calls of defined fns
;   and when encountered are replaced by the rewritten body.

;   We believe that the theorem prover will perform significantly faster on
;   many theorems if, after an induction, it does not waste time (a) trying to
;   simplify the recursive calls introduced in the induction hypotheses and (b)
;   trying to decide whether to expand the terms inducted for in the induction
;   conclusion.  This suspicion is due to some testing done with the idea of
;   "homographication" which was just a jokingly suggested name for the idea of
;   generalizing the recursive calls away at INDUCT time after expanding the
;   induction terms in the conclusion.  Homographication speeded the
;   theorem-prover on many theorems but lost on several others because of the
;   premature generalization.  See the comment in FORM-INDUCTION-CLAUSE.

;   To avoid the generalization at INDUCT time we are going to try using
;   TERMS-TO-BE-IGNORED-BY-REWRITE.  The idea is this, during the initial
;   simplification of a clause produced by INDUCT we will have the recursive
;   terms on TERMS-TO-BE-IGNORED-BY-REWRITE.  When the clause settles down --
;   hopefully it will often be proved first -- we will restore
;   TERMS-TO-BE-IGNORED-BY-REWRITE to its pre-INDUCT value.  Note however that
;   we have to mess with TERMS-TO-BE-IGNORED-BY-REWRITE on a clause by clause
;   basis, not just once in INDUCT.

;   So here is the plan.  INDUCT will set INDUCTION-HYP-TERMS to the list of
;   instances of the induction terms, and will set INDUCTION-CONCL-TERMS to the
;   induction terms themselves.  SIMPLIFY-CLAUSE will look at the history of
;   the clause to determine whether it has settled down since induction.  If
;   not it will bind TERMS-TO-BE-IGNORED-BY-REWRITE to the concatenation of
;   INDUCTION-HYP-TERMS and its old value and will analogously bind EXPAND-LST.
;   A new process, called SETTLED-DOWN-SENT, will be used to mark when in the
;   history the clause settled down.

  (SETQ INDUCTION-CONCL-TERMS TERMS)
  (SETQ INDUCTION-HYP-TERMS
	(ITERATE FOR TA IN TESTS-AND-ALISTS-LST
		 NCONC (ITERATE FOR ALIST IN (ACCESS TESTS-AND-ALISTS ALISTS TA)
				NCONC (SUBLIS-VAR-LST ALIST TERMS)))))

(DEFUN INIT-LEMMA-STACK NIL (SETQ LEMMA-STACK ORIG-LEMMA-STACK) NIL)

(DEFUN INIT-LIB (PROPS VARS)

;   Initialize the variables used to keep track of what is on the lib file.

  (KILL-LIB)
  (SETQ LIB-PROPS PROPS)
  (SETQ LIB-VARS VARS)
  (ITERATE FOR VAR IN LIB-VARS DO (SET VAR NIL))
  (SETQ LIB-ATOMS-WITH-PROPS NIL)
  (SETQ LIB-ATOMS-WITH-DEFS NIL)
  (SETQ LIB-FILE NIL))

(DEFUN INIT-LINEARIZE-ASSUMPTIONS-STACK NIL
  (SETQ LINEARIZE-ASSUMPTIONS-STACK ORIG-LINEARIZE-ASSUMPTIONS-STACK)
  NIL)

(DEFUN INTERESTING-SUBTERMS (FORM)

;   Returns a list of all of the subterms of FORM that are not variables or
;   quotes or terms whose function symbol is CAR CDR LISTP EQ NOT.  Returns
;   the EQ subterms.  This fact is used to catch and optimize common
;   subexpression evaluation.

  (COND ((VARIABLEP FORM) NIL)
	((FQUOTEP FORM) NIL)
	((MEMBER-EQ (FFN-SYMB FORM)
		    (QUOTE (CAR CDR LISTP EQ NOT)))
	 (ITERATE FOR ARG IN (FARGS FORM) APPEND (INTERESTING-SUBTERMS ARG)))
	(T (CONS FORM (ITERATE FOR ARG IN (FARGS FORM)
			       APPEND (INTERESTING-SUBTERMS ARG))))))

(DEFUN INTERSECTP (X Y) (ITERATE FOR E IN X THEREIS (MEMBER-EQUAL E Y)))

(DEFUN INTRODUCE-ANDS (X)
  (LET (REST1 REST2)
    (COND ((ATOM X) X)
	  ((EQ (CAR X) (QUOTE QUOTE))
	   X)
	  ((MATCH X (*2*IF & & (QUOTE NIL)))
	   (SETQ REST1 (INTRODUCE-ANDS (CADR X)))
	   (SETQ REST2 (INTRODUCE-ANDS (CADDR X)))
	   (COND ((AND (CONSP REST1) (EQ (CAR REST1) (QUOTE AND)))
		  (COND ((AND (CONSP REST2) (EQ (CAR REST2) (QUOTE AND)))
			 (APPEND REST1 (CDR REST2)))
			(T (APPEND REST1 (CONS REST2 NIL)))))
		 ((AND (CONSP REST2) (EQ (CAR REST2) (QUOTE AND)))
		  (CONS (QUOTE AND) (CONS REST1 (CDR REST2))))
		 (T (LIST (QUOTE AND) REST1 REST2))))
	  (T (CONS (CAR X)
		   (ITERATE FOR ARG IN (CDR X)
			    COLLECT (INTRODUCE-ANDS ARG)))))))

(DEFUN INTRODUCE-LISTS (X)
  (LET (REST)
    (COND ((ATOM X) X)
	  ((EQ (CAR X) (QUOTE QUOTE))
	   (KWOTE (CADR X)))
	  ((EQ (CAR X) (QUOTE CONS))
	   (SETQ REST (INTRODUCE-LISTS (CADDR X)))
	   (COND ((NULL REST)
		  (LIST (QUOTE LIST) (INTRODUCE-LISTS (CADR X))))
		 ((AND (CONSP REST) (EQ (CAR REST) (QUOTE LIST)))
		  (CONS (QUOTE LIST)
			(CONS (INTRODUCE-LISTS (CADR X)) (CDR REST))))
		 (T (LIST (QUOTE CONS)
			  (INTRODUCE-LISTS (CADR X))
			  REST))))
	  (T (CONS (CAR X)
		   (ITERATE FOR ARG IN (CDR X)
			    COLLECT (INTRODUCE-LISTS ARG)))))))

(DEFUN JUMPOUTP (OLD NEW)

;   It is claimed that JUMPOUTP is a mere optimization of the book version of
;   the rewriter.  The proof rests on two observations.  The first is that if
;   any subterm of the rewritten function body fails to satisfy REWRITE-FNCALLP
;   then the entire body fails -- i.e., it does not matter if other parts are
;   super-good.  This means that as soon as we lay our hands on a subterm that
;   is GUARANTEED to survive future rewriting and be returned as part of the
;   value of the REWRITE call in REWRITE-FNCALL we can check that it satisfies
;   REWRITE-FNCALLP and if not, abort then and there.  The second lemma is that
;   if the DEFN-FLG of REWRITE is T then the value of that rewrite will survive
;   to be part of the value computed by the REWRITE call in REWRITE-FNCALL.
;   Proof of this is by inspection of the places REWRITE is called.  In
;   particular, if REWRITE's value is that of a recursive call, the call may be
;   passed the same value of the DEFN-FLG, the DEFN-FLG may be turned on only
;   by REWRITE-FNCALL, and must be NIL in rewriting arguments to non-IFs (which
;   might disappear as a result of higher level rewrites), tests to IF's even
;   on the main path through a defn (because the tests may be eliminated by (IF
;   x y y)) and in rewrite calls to relieve hyps (which do not have any
;   relation to what is seen by the REWRITE-FNCALLP check in REWRITE-FNCALL);
;   the most subtle part of the proof is that if you are simplifying an (IF
;   test left right) that is guaranteed to participate in the value returned to
;   REWRITE-FNCALL, then both the values of left and right will be -- at least,
;   they will be when they are non-trivial values that might possible offend
;   REWRITE-FNCALLP.  The proof of this is by inspection of REWRITE-IF1 which
;   either returns the newly consed up IF of the values, which is perfect, or
;   else returns pieces (i.e., test, or left, or right's value alone) under
;   conditions that guarantee that nothing is lost.  Thus, if the DEFN-FLG is
;   on, JUMPOUTP can call REWRITE-FNCALLP and jump out of the lowest
;   REWRITE-FNCALL if the newly computed value offends it.  Since JUMPOUTP is
;   only called on the branches of IFs there must still be a call of
;   REWRITE-FNCALLP on the final answer in REWRITE-FNCALL since tests (which
;   could have been eliminated by (IF x y y)) might still offend.  Finally, to
;   avoid calling REWRITE-FNCALLP exponentially while backing out of an
;   IF-tree, we do not even bother to call it if the old value of the term was
;   itself an IF, since JUMPOUTP okay'd its branches -- but not its test --
;   earlier.

  (COND ((AND DEFN-FLG (NVARIABLEP OLD)
	      (NOT (EQ (FN-SYMB OLD) (QUOTE IF)))
	      (NOT (REWRITE-FNCALLP (CAR FNSTACK) NEW)))
	 (POP-LEMMA-FRAME)
	 (THROW (QUOTE REWRITE-FNCALL)
		(LET ((TYPE-ALIST *TYPE-ALIST*))
		  (REWRITE-SOLIDIFY (CONS-TERM *FNNAME* *ARGLIST*)))))
	(T NEW)))

(DEFUN KILL-EVENT (NAME)
  (COND ((EQ NAME (QUOTE GROUND-ZERO)) (KILL-LIB))
	(T (ITERATE FOR TUPLE IN (GET NAME (QUOTE LOCAL-UNDO-TUPLES))
		    DO (ADD-SUB-FACT NIL NIL NIL TUPLE NIL))
	   (ITERATE FOR SATELLITE IN (GET NAME (QUOTE SATELLITES))
		    DO (KILLPROPLIST1 SATELLITE))
	   (KILLPROPLIST1 NAME)
	   (SETQ CHRONOLOGY (REMOVE1 NAME CHRONOLOGY))
	   NAME)))

(DEFUN KILL-LIB NIL

;   Erase all trace of the lib file.

  (COND ((BOUNDP (QUOTE LIB-PROPS))
	 (ITERATE FOR ATM IN LIB-ATOMS-WITH-PROPS DO
		  (KILLPROPLIST1 ATM))
	 (ITERATE FOR FN IN LIB-ATOMS-WITH-DEFS DO
		  (KILL-DEFINITION FN))
	 (ITERATE FOR VAR IN LIB-VARS DO (MAKUNBOUND VAR))
	 (MAKUNBOUND (QUOTE LIB-VARS))
	 (MAKUNBOUND (QUOTE LIB-ATOMS-WITH-PROPS))
	 (MAKUNBOUND (QUOTE LIB-ATOMS-WITH-DEFS))
	 (MAKUNBOUND (QUOTE LIB-PROPS))
	 (MAKUNBOUND (QUOTE LIB-FILE)))))

(DEFUN KILLPROPLIST1 (ATM)

;   Kill all properties of ATM that are maintained by the lib file.

  (ITERATE FOR PROP IN LIB-PROPS DO (REMPROP ATM PROP))
  (REMPROP ATM (QUOTE LIB-LOC))
  (SETQ LIB-ATOMS-WITH-PROPS (REMOVE ATM LIB-ATOMS-WITH-PROPS)))

(DEFUN LEGAL-CHAR-CODE-SEQ (LST)

;   WARNING The EVG-OCCUR functions make delicate use of the ascii codes
;   permitted in litatoms in evgs.

  (AND
   (CONSP LST)
   (ITERATE FOR TAIL ON LST WITH C UNTIL (ATOM TAIL)
	    ALWAYS
	    (PROGN
	      (SETQ C (CAR TAIL))
	      (AND (INTEGERP C)
		   (OR (AND (<= (CHAR-CODE #\A) C)
			    (<= C (CHAR-CODE #\Z)))
		       (AND (<= (CHAR-CODE #\0) C)
			    (<= C (CHAR-CODE #\9)))
		       (EQUAL C (CHAR-CODE #\-))))))
   (NOT (EQUAL (CAR LST) (CHAR-CODE #\-)))
   (NOT (AND (<=  (CHAR-CODE #\0) (CAR LST))
	     (<= (CAR LST) (CHAR-CODE #\9))))))

(DEFUN LENGTH-TO-ATOM (L)
  (ITERATE FOR TAIL ON L UNTIL (ATOM TAIL) COUNT T))

(DEFUN LEXORDER (X Y)

;   LEXORDER is a total ordering on LISP objects constructed from numbers,
;   litatoms, and conses.  See the comment in TERM-ORDER for the definitions of
;   "partial" and "total" orderings.

  (COND ((ATOM X)
	 (COND ((ATOM Y)

;   From the VM one can conclude that ALPHORDER is a total ordering when
;   restricted to ATOMs.

		(ALPHORDER X Y))
	       (T T)))
	((ATOM Y) NIL)
	((EQUAL (CAR X) (CAR Y))
	 (LEXORDER (CDR X) (CDR Y)))
	(T (LEXORDER (CAR X) (CAR Y)))))

(DEFUN LINEARIZE (TERM FLG)

;   If FLG is T linearize TERM, else linearize the negation of TERM.  We store
;   TERM in the LITERALS field regardless of FLG.  ADD-EQUATIONS looks in the
;   LITERALS field to see if the CURRENT-LIT is a father of a POLY and if so
;   does not use it in cancellation.  Similarly ADD-EQUATIONS looks in the
;   LEMMAS field for members of the original clause, i.e.,
;   LITS-THAT-MAY-BE-ASSUMED-FALSE.

  (LET (LHS RHS LST CONTRA)
    (SETQ LST
	  (COND ((COND (FLG (MATCH TERM (LESSP LHS RHS)))
		       (T (MATCH TERM (NOT (LESSP LHS RHS)))))
		 (LIST
		  (LIST (COMPRESS-POLY
			 (ADD-LINEAR-TERM
			  (CONS-TERM (QUOTE ADD1) (LIST LHS))
			  (QUOTE POSITIVE)
			  (ADD-LINEAR-TERM RHS (QUOTE NEGATIVE)
					   (ZERO-POLY TERM)))))))
		((COND (FLG (MATCH TERM (EQUAL LHS RHS)))
		       (T (MATCH TERM (NOT (EQUAL LHS RHS)))))
		 (COND ((OR (POSSIBLY-NUMERIC LHS)
			    (POSSIBLY-NUMERIC RHS))
			(LIST
			 (LIST (COMPRESS-POLY
				(ADD-LINEAR-TERM
				 LHS
				 (QUOTE POSITIVE)
				 (ADD-LINEAR-TERM RHS (QUOTE NEGATIVE)
						  (ZERO-POLY TERM))))
			       (COMPRESS-POLY
				(ADD-LINEAR-TERM
				 RHS
				 (QUOTE POSITIVE)
				 (ADD-LINEAR-TERM LHS (QUOTE NEGATIVE)
						  (ZERO-POLY TERM)))))))
		       (T NIL)))
		((COND (FLG (MATCH TERM (NOT (LESSP LHS RHS))))
		       (T (MATCH TERM (LESSP LHS RHS))))
		 (LIST
		  (LIST (COMPRESS-POLY
			 (ADD-LINEAR-TERM
			  RHS
			  (QUOTE POSITIVE)
			  (ADD-LINEAR-TERM LHS (QUOTE NEGATIVE)
					   (ZERO-POLY TERM)))))))
		((COND (FLG (MATCH TERM (NOT (EQUAL LHS RHS))))
		       (T (MATCH TERM (EQUAL LHS RHS))))
		 (COND ((OR (POSSIBLY-NUMERIC LHS)
			    (POSSIBLY-NUMERIC RHS))
			(LIST
			 (LIST
			  (ADD-NUMBERP-ASSUMPTION-TO-POLY
			   LHS
			   (ADD-NUMBERP-ASSUMPTION-TO-POLY
			    RHS
			    (COMPRESS-POLY
			     (ADD-LINEAR-TERM
			      (CONS-TERM (QUOTE ADD1)
					 (LIST LHS))
			      (QUOTE POSITIVE)
			      (ADD-LINEAR-TERM RHS (QUOTE NEGATIVE)
					       (ZERO-POLY TERM)))))))
			 (LIST
			  (ADD-NUMBERP-ASSUMPTION-TO-POLY
			   LHS
			   (ADD-NUMBERP-ASSUMPTION-TO-POLY
			    RHS
			    (COMPRESS-POLY
			     (ADD-LINEAR-TERM
			      (CONS-TERM (QUOTE ADD1)
					 (LIST RHS))
			      (QUOTE POSITIVE)
			      (ADD-LINEAR-TERM LHS (QUOTE NEGATIVE)
					       (ZERO-POLY TERM)))))))))
		       (T NIL)))
		(T NIL)))
    (SETQ LST (ITERATE FOR L IN LST
		       COLLECT (ITERATE FOR POLY IN L
					UNLESS (MEMBER-EQUAL FALSE
							     (ACCESS POLY ASSUMPTIONS
								     POLY))
					COLLECT POLY)))
    (COND ((= (LENGTH LST) 2)

;   If either member of LST contains a contradiction, we delete that member
;   from LST after moving into each member of the other member of LST the
;   assumptions and lemmas upon which the contradiction depends.

	   (COND ((SETQ CONTRA (ITERATE FOR POLY IN (CAR LST)
					WHEN (IMPOSSIBLE-POLYP POLY)
					DO (RETURN POLY)))
		  (ITERATE FOR POLY IN (CADR LST)
			   DO (CHANGE
			       POLY ASSUMPTIONS POLY
			       (UNION-EQUAL (ACCESS POLY ASSUMPTIONS CONTRA)
					    (ACCESS POLY ASSUMPTIONS POLY)))
			   (CHANGE POLY LEMMAS POLY
				   (UNION-EQ (ACCESS POLY LEMMAS CONTRA)
					     (ACCESS POLY LEMMAS POLY))))
		  (SETQ LST (LIST (CADR LST))))
		 ((SETQ CONTRA (ITERATE FOR POLY IN (CADR LST)
					WHEN (IMPOSSIBLE-POLYP POLY)
					DO (RETURN POLY)))
		  (ITERATE FOR POLY IN (CAR LST)
			   DO (CHANGE POLY ASSUMPTIONS POLY
				      (UNION-EQUAL
				       (ACCESS POLY ASSUMPTIONS CONTRA)
				       (ACCESS POLY ASSUMPTIONS POLY)))
			   (CHANGE POLY LEMMAS POLY
				   (UNION-EQ (ACCESS POLY LEMMAS CONTRA)
					     (ACCESS POLY LEMMAS POLY))))
		  (SETQ LST (LIST (CAR LST)))))))
    LST))

(DEFUN LISTABLE (X)
  (LET (LHS RHS)
    (COND ((VARIABLEP X) NIL)
	  ((FQUOTEP X) NIL)
	  ((MATCH X (LIST (QUOTE CONS) LHS RHS))
	   (COND ((EQUAL RHS (QUOTE (QUOTE NIL))) (LIST LHS))
		 ((SETQ TEMP-TEMP (LISTABLE RHS)) (CONS LHS TEMP-TEMP))
		 (T NIL)))
	  (T NIL))))

(DEFUN LISTABLE-EVG-PAIRS (EVG)
  (COND ((ATOM EVG) NIL)
        ((EQ (CAR EVG) *1*SHELL-QUOTE-MARK) NIL)
        ((NULL (CDR EVG)) (LIST (CAR EVG)))
        ((SETQ TEMP-TEMP (LISTABLE-EVG-PAIRS (CDR EVG)))
         (CONS (CAR EVG) TEMP-TEMP))
        (T NIL)))
 
(DEFUN LOGSUBSETP (X Y) (= (LOGAND X Y) X))

(DEFUN LOOKUP-HYP (HYP)

;   See if HYP is true by type alist or LITS-THAT-MAY-BE-ASSUMED-FALSE
;   considerations -- possibly extending the UNIFY-SUBST if necessary.  If
;   successful return T and side-effect UNIFY-SUBST and the current lemma frame
;   appropriately.  If unsuccessful, return NIL and side-effect nothing.

  (PROG (TERM NOT-FLG TYPE NEG-HYP LIT)
	(COND ((MATCH HYP (NOT TERM))
	       (SETQ NOT-FLG T))
	      (T (SETQ NOT-FLG NIL)
		 (SETQ TERM HYP)))
	(COND ((AND (NVARIABLEP TERM)
		    (NOT (FQUOTEP TERM))
		    (SETQ TEMP-TEMP (ASSOC-EQ (FFN-SYMB TERM) RECOGNIZER-ALIST)))
	       (SETQ TYPE (CDR TEMP-TEMP))
	       (SETQ TERM (FARGN TERM 1)))
	      (T (SETQ TYPE (LOGNOT TYPE-SET-FALSE))))
	(COND (NOT-FLG (COND ((ITERATE FOR PAIR IN TYPE-ALIST
				       THEREIS (AND
						(= 0 (LOGAND TYPE (CDR PAIR)))
						(ONE-WAY-UNIFY1
						 TERM (CAR PAIR))))
			      (RETURN T))))
	      (T (COND ((ITERATE FOR PAIR IN TYPE-ALIST
				 THEREIS (AND (LOGSUBSETP (CDR PAIR) TYPE)
					      (ONE-WAY-UNIFY1 TERM (CAR PAIR))))
			(RETURN T)))))

;   Having failed to find HYP on the type alist, we now try
;   LITS-THAT-MAY-BE-ASSUMED-FALSE.

	(COND (LITS-THAT-MAY-BE-ASSUMED-FALSE
	       (SETQ NEG-HYP (DUMB-NEGATE-LIT HYP))
	       (COND ((SETQ LIT (ITERATE FOR LIT IN LITS-THAT-MAY-BE-ASSUMED-FALSE
					 WHEN (ONE-WAY-UNIFY1 NEG-HYP LIT)
					 DO (RETURN LIT)))
		      (PUSH-LEMMA LIT)
		      (RETURN T))
		     (T (RETURN NIL))))
	      (T (RETURN NIL)))))

(DEFUN LOOP-STOPPER (TERM)
  (LET (LHS RHS ALL-VARS)
    (COND ((AND (MATCH TERM (EQUAL LHS RHS))
		(VARIANTP LHS RHS))
	   (SETQ ALL-VARS (ALL-VARS LHS))
	   (ITERATE FOR PAIR IN UNIFY-SUBST
		    WHEN (MEMBER-EQ (CAR PAIR)
				    (CDR (MEMBER-EQ (CDR PAIR) ALL-VARS)))
		    COLLECT PAIR))
	  (T NIL))))

(DEFUN MAIN-EVENT-OF (NAME)
  (COND ((AND (SYMBOLP NAME) (GET NAME (QUOTE EVENT)))
	 NAME)
	((AND (SYMBOLP NAME) (GET NAME (QUOTE MAIN-EVENT))))
	(T (ERROR1 (PQUOTE (PROGN MAIN-EVENT-OF |has| |been| |called| |on| |an|
				  |object| |,| |namely| (!PPR NAME NIL)
				  |,| |that| |is| |neither| |an| |event| |nor|
				  |a| |satellite| |of| |another| |event| !))
		   (BINDINGS (QUOTE NAME)
			     NAME)
		   (QUOTE HARD)))))

(DEFUN MAKE-EVENT (NAME EVENT)
  (PUT1 NAME EVENT (QUOTE EVENT))
  (PUT1 NAME (IDATE) (QUOTE IDATE))
  (SETQ CHRONOLOGY (CONS NAME CHRONOLOGY))
  (SETQ MAIN-EVENT-NAME NAME))

(DEFUN MAKE-FLATTENED-MACHINE (FNNAME TERM TESTS)

;   This function builds a list of TESTS-AND-CASE representing the function
;   FNNAME with body TERM.  For each call of FNNAME in body, a TESTS-AND-CASE
;   is returned whose TESTS are all the tests that govern the call and whose
;   CASE is the arglist of the call.  This code is a vast change from the
;   previous version, which did not consider terms with or within calls of
;   FNNAME as governors.

  (COND ((OR (VARIABLEP TERM) (FQUOTEP TERM))
	 NIL)
	((EQ (FFN-SYMB TERM)
	     (QUOTE IF))
	 (NCONC (MAKE-FLATTENED-MACHINE FNNAME (FARGN TERM 1) TESTS)
		(MAKE-FLATTENED-MACHINE FNNAME (FARGN TERM 2)
					(APPEND TESTS
						(LIST (FARGN TERM 1))))
		(MAKE-FLATTENED-MACHINE
		 FNNAME (FARGN TERM 3)
		 (APPEND TESTS (LIST (NEGATE-LIT (FARGN TERM 1)))))))
	((EQ FNNAME (FFN-SYMB TERM))
	 (CONS (MAKE TESTS-AND-CASE TESTS (FARGS TERM))
	       (ITERATE FOR ARG IN (FARGS TERM)
			NCONC (MAKE-FLATTENED-MACHINE FNNAME ARG TESTS))))
	(T (ITERATE FOR ARG IN (FARGS TERM)
		    NCONC (MAKE-FLATTENED-MACHINE FNNAME ARG TESTS)))))

(DEFUN MAKE-NEW-NAME NIL
  (LET (TEMP)
    (ITERATE WHILE (NULL (CHK-NEW-NAME (SETQ TEMP (GENTEMP "G" (FIND-PACKAGE 'USER)))
				       T))
	     DO NIL)
    TEMP))

(DEFUN MAKE-REWRITE-RULES (NAME HYPS CONCL)

;   This fn once entertained the idea of returning as many rewrite rules as
;   there were paths through the IF structure of HYPS.  That blew us out of the
;   water on a thm whose hyp was (AND (NOT (EQUAL X Y)) (NOT (LESSP X Y)))
;   because it generated 75 paths!  So the fn now returns just one rewrite rule
;   -- or none if CONCL is an explicit value.  The rule is LISTed so that the
;   higher level functions still allow the possibility of it someday returning
;   more than one -- BUT they are all hung under the same fn symbol so this
;   probably is not a useful feature.

  (PROG (LHS RHS)
	(COND ((QUOTEP CONCL)
	       (RETURN NIL))
	      ((MATCH CONCL (EQUAL LHS RHS))
	       (SETQ CONCL (LIST (QUOTE EQUAL)
				 LHS
				 (NORMALIZE-IFS
				  (EXPAND-BOOT-STRAP-NON-REC-FNS RHS)
				  NIL NIL NIL)))))
	(RETURN (LIST (CREATE-REWRITE-RULE NAME HYPS CONCL NIL)))))

(DEFUN MAKE-TYPE-RESTRICTION (TR DV RECOGNIZER TYPE-NO)
  (LET (TYPE-SET)
    (SETQ TYPE-SET
	  (ITERATE FOR R IN (CDR TR)
		   WITH ITERATE-ANS = 0
		   DO
		   (SETQ ITERATE-ANS
			 (LOGIOR ITERATE-ANS
				 (CDR (ASSOC-EQ R (CONS (CONS RECOGNIZER
							      (LOGBIT TYPE-NO))
							RECOGNIZER-ALIST)))))
		   FINALLY (RETURN ITERATE-ANS)))
    (COND ((EQ (CAR TR)
	       (QUOTE NONE-OF))
	   (SETQ TYPE-SET (LOGNOT TYPE-SET))))
    (MAKE
     TYPE-RESTRICTION
     (COND ((EQ (CAR TR)
		(QUOTE ONE-OF))
	    (DISJOIN (ITERATE FOR R IN (CDR TR)
			      COLLECT (FCONS-TERM* R (QUOTE X)))
		     NIL))
	   (T (CONJOIN (ITERATE FOR R IN (CDR TR)
				COLLECT
				(DUMB-NEGATE-LIT
				 (FCONS-TERM* R (QUOTE X))))
		       NIL)))
     TYPE-SET
     (CONS-TERM DV NIL))))

(DEFUN MAX-FORM-COUNT (X)
  (COND ((VARIABLEP X) 0)
	((FQUOTEP X)

;   MAX-FORM-COUNT once used FORM-COUNT-EVG to compute the size of an evg.  But
;   that function computed MAX-FORM-COUNT for 1000 that was bigger than for 999
;   and so the REWRITE package believed it was making progress and would open
;   up something like (LESSP X 1000).  We have decided to try just measuring
;   the LISP size of the evg, as a better estimation of whether we are making
;   progress.

	 (CONS-COUNT (CADR X)))
	((EQ (FFN-SYMB X) (QUOTE IF))
	 (MAX (MAX-FORM-COUNT (FARGN X 2))
	      (MAX-FORM-COUNT (FARGN X 3))))
	(T (1+ (ITERATE FOR ARG IN (FARGS X) SUM (MAX-FORM-COUNT ARG))))))

(DEFUN MAXIMAL-ELEMENTS (LST MEASURE)
  (LET (ANS MAX TEMP)
    (ITERATE FOR X IN LST DO (SETQ TEMP (FUNCALL MEASURE X))
	     (COND ((OR (NULL MAX) (> TEMP MAX))
		    (SETQ MAX TEMP)
		    (SETQ ANS (LIST X)))
		   ((EQUAL TEMP MAX)
		    (SETQ ANS (NCONC1 ANS X)))))
    ANS))

(DEFUN MEANING-SIMPLIFIER (TERM)

;   When the theorem-prover assents to a theorem or accepts a definition, in
;   which theory is it working?  Heretofore, the answer has been= in the theory
;   consisting of chapter 3 of ACL plus the user's definitions and axioms.
;   Because of the addition of metatheorems, the answer to that question is no
;   longer so simple.

;   To answer the question, we first elaborate the notion of a "history"
;   presented in the meta paper.  Let us say that an event is a pair (ev term)
;   where ev is either DEFN, ADD-SHELL, ADD-AXIOM, PROVE-LEMMA, or DCL.  An
;   "urchronology" is a sequence of events with the properties that for each
;   member (ev term) if ev is DCL, then term is a function symbol and otherwise
;   term is a term.  Given a list of events, we say that a function symbol is
;   "new" for it provided that the symbol is not used in any shell invocation,
;   has not been defined, has not been DCLed, and is not mentioned in the basic
;   axioms.  A "chronology" is an "urchronology" such that in each definition,
;   the concept being defined is new, and all the other function symbols are
;   not new; for a shell invocation all the introduced symbols (excepting
;   possibly the default objects) are new; for a DCL, the symbol is new; for a
;   theorem or arbitrary axiom, none of the symbols used are new and the
;   theorems are provable from the preceding axioms (including definitions and
;   shell invocations).

;   We define a "user" chronology to be a chronology in which the function
;   symbols on META-NAMES are DCLed or defined at the beginning of the
;   chronology as in BOOT-STRAP-INSTRS, immediately after each DCL and
;   DEFINITION the MEANING and ARITY axioms for the newly introduced function
;   symbol are added as arbitrary axioms, and there is otherwise no mention of
;   any META-NAME except in theorems.

;   We vouch that our theorem-prover only calls "theorems" facts that can be
;   proved in the user chronology.

;   We now make a "psychological" remark.  A user may object that he does not
;   like to work in a chronology with all those metaaxioms

;   To make the user happy, we show that corresponding to any user chronology
;   is a "real" chronology whose axioms and definitions differ from "his"
;   axioms and definitions only by the addition of more definitions.
;   Furthermore, we observe that in the real chronology, all the theorems of
;   the user chronology (the ones the theorem-prover proved) are theorems in
;   the real chronology after we replace each function symbol in META-NAMES
;   with another function symbol.  Thus, any theorem proved in the user
;   chronology about concepts he has defined or DCLed are literally theorems in
;   the real chronology.  If he objects to having extra definitions around,
;   then tough luck for him.

;   Given a "user" chronology, we produce the "real" chronology by deleting the
;   initial BOOT-STRAP events that mention META-NAMES, replacing the MEANING
;   and ARITY axiom after each DCL or definition with the collection of
;   definitions called the metadefinitions in the meta paper for the i non-new
;   function symbols at that point in the chronology -- amended by indexing
;   each META-NAME with i -- and altering each theorem by adding to each
;   META-NAME the appropriate index.  Note we do not have to index user
;   supplied axioms or definitions since they may not contain META-NAMES.  Note
;   we are forbidding the user from using META-NAMES in definitions even if he
;   want to define concepts to help him prove metalemmas!

;   Why is a "real" chronology a chronology, i.e., how do we know that the
;   indexed theorems can be proved?  The answer is that at any point i in the
;   user chronology (that is, after i definitions and declarations) and for
;   each axiom about a META-NAME in the user chronology, we can prove, in the
;   real chronology, at the corresponding point, the indexed version of the
;   axiom.  The proof of this assertion is merely the observation that the
;   metaaxioms follow from the metadefinitions, so the indexed metaaxioms
;   follow from the indexed metadefinitions.

;   The foregoing facts are independent of the use of metalemmas.

;   Now let us consider how metalemmas are used.  Suppose that a metalemma is
;   proved at some constructive point i in a user chronology and that at some
;   point i+p we use the metalemma.  We claim that the inference can be proved
;   at point i+p in the user chronology.  As a corollary to what has been said
;   before, we also conclude that the inference can be proved in the
;   corresponding "real" theory.  The proof of this claim for the user
;   chronology is obvious since the metatheorem at i was proved about the same
;   symbol MEANING we will use at i+p to lift and drop the formulas in
;   question.

  (LET (X ALIST FN TL)
    (MATCH! TERM (MEANING X ALIST))
    (COND ((VARIABLEP X) TERM)
	  ((SHELLP X)
	   (COND ((NOT (EQ (FN-SYMB X) (QUOTE CONS)))
		  (CONS-TERM (QUOTE LOOKUP) (FARGS TERM)))
		 (T (SETQ FN (ARGN X 1))
		    (SETQ TL (ARGN X 2))
		    (COND ((AND (QUOTEP FN)
				(SYMBOLP (CADR FN)))
			   (COND ((EQ (CADR FN)
				      (QUOTE QUOTE))
				  (FCONS-TERM* (QUOTE CAR)
					       TL))
				 ((AND (GET (CADR FN)
					    (QUOTE TYPE-PRESCRIPTION-LST))
				       (NOT (MEMBER-EQ (CADR FN)
						       META-NAMES)))
				  (CONS-TERM
				   (CADR FN)
				   (ITERATE FOR I FROM 1 TO (ARITY (CADR FN))
					    COLLECT
					    (FCONS-TERM*
					     (QUOTE MEANING)
					     (FCONS-TERM* (QUOTE CAR)
							  (CELL (1- I)
								TL))
					     ALIST))))
				 (T TERM)))
			  (T TERM)))))
	  (T TERM))))

(DEFUN MEMB-NEGATIVE (LIT CL)
  (COND ((ATOM CL) NIL)
	((COMPLEMENTARYP LIT (CAR CL)) T)
	(T (MEMB-NEGATIVE LIT (CDR CL)))))

(DEFUN MENTIONSQ (AT TREE)
  (COND ((ATOM TREE) (EQ AT TREE))
	(T (OR (MENTIONSQ AT (CAR TREE))
	       (MENTIONSQ AT (CDR TREE))))))

(DEFUN MENTIONSQ-LST (LST TREE)
  (COND ((ATOM TREE) (MEMBER-EQ TREE LST))
	(T (OR (MENTIONSQ-LST LST (CAR TREE))
	       (MENTIONSQ-LST LST (CDR TREE))))))

(DEFUN MERGE-CAND1-INTO-CAND2 (CAND1 CAND2)

;   Note: The guts of this function is MERGE-TESTS-AND-ALISTS-LSTS.  The tests
;   preceding it are heuristic only.  If MERGE-TESTS-AND-ALISTS-LSTS returns
;   non-NIL then it returns a sound induction; indeed, it merely extends some
;   of the substitutions in the second candidate.

  (LET (SCORE1 CONTROLLERS1 CHANGED-VARS1 UNCHANGEABLES1
	       TESTS-AND-ALISTS-LST1 JUSTIFICATION1 TERM1 OTHER-TERMS1
	       SCORE2 CONTROLLERS2 CHANGED-VARS2 UNCHANGEABLES2
	       TESTS-AND-ALISTS-LST2 JUSTIFICATION2 TERM2 OTHER-TERMS2
	       ALISTS TESTS-AND-ALISTS-LST VARS)
    (MATCH CAND1 (CANDIDATE SCORE1 CONTROLLERS1 CHANGED-VARS1
			    UNCHANGEABLES1 TESTS-AND-ALISTS-LST1
			    JUSTIFICATION1 TERM1 OTHER-TERMS1))
    (MATCH CAND2 (CANDIDATE SCORE2 CONTROLLERS2 CHANGED-VARS2
			    UNCHANGEABLES2 TESTS-AND-ALISTS-LST2
			    JUSTIFICATION2 TERM2 OTHER-TERMS2))

;   We once merged only if both cands agreed on the intersection of the
;   CHANGED-VARS.  But the theorem that, under suitable conditions, (EV FLG X
;   VA FA N) = (EV FLG X VA FA K) made us realize it was important only to
;   agree on the intersection of the controllers.  Note in fact that we mean
;   the changing controllers -- there seems to be no need to merge two
;   inductions if they only share unchanging controllers.  However the theorem
;   that (GET I (SET J VAL MEM)) = ... (GET I MEM) ...  illustrates the
;   situation in which the controllers, {I} and {J} do not even overlap; but
;   the accumulators {MEM} do and we want a merge.  So we want agreement on the
;   intersection of the changing controllers (if that is nonempty) or on the
;   accumulators.

;   For soundness it does not matter what list of vars we want to agree on
;   because no matter what, MERGE-TESTS-AND-ALISTS-LSTS returns either NIL or
;   an extension of the second candidates alists.

    (AND (SETQ VARS
	       (OR (INTERSECTION-EQ
		    CONTROLLERS1
		    (INTERSECTION-EQ CONTROLLERS2
				     (INTERSECTION-EQ
				      CHANGED-VARS1
				      CHANGED-VARS2)))
		   (INTERSECTION-EQ CHANGED-VARS1 CHANGED-VARS2)))
	 (NOT (INTERSECTP UNCHANGEABLES1 CHANGED-VARS2))
	 (NOT (INTERSECTP UNCHANGEABLES2 CHANGED-VARS1))
	 (SETQ TESTS-AND-ALISTS-LST
	       (MERGE-TESTS-AND-ALISTS-LSTS TESTS-AND-ALISTS-LST1
					    TESTS-AND-ALISTS-LST2
					    VARS))
	 (MAKE CANDIDATE (+ SCORE1 SCORE2)
	       (UNION-EQ CONTROLLERS1 CONTROLLERS2)
	       (UNION-EQ CHANGED-VARS1 CHANGED-VARS2)
	       (UNION-EQ UNCHANGEABLES1 UNCHANGEABLES2)
	       TESTS-AND-ALISTS-LST JUSTIFICATION2 TERM2
	       (ADD-TO-SET TERM1
			   (UNION-EQUAL OTHER-TERMS1 OTHER-TERMS2))))))

(DEFUN MERGE-CANDS (CAND1 CAND2)
  (OR (FLUSH-CAND1-DOWN-CAND2 CAND1 CAND2)
      (FLUSH-CAND1-DOWN-CAND2 CAND2 CAND1)
      (MERGE-CAND1-INTO-CAND2 CAND1 CAND2)
      (MERGE-CAND1-INTO-CAND2 CAND2 CAND1)))

(DEFUN MERGE-DESTRUCTOR-CANDIDATES (LST)

;   The elements of LST are lists of terms.  Whenever the CARs of two elements
;   are EQUAL we UNION together the CDRs.

  (TRANSITIVE-CLOSURE LST (FUNCTION (LAMBDA (X Y)
				      (COND ((EQUAL (CAR X) (CAR Y))
					     (CONS (CAR X)
						   (UNION-EQUAL (CDR X)
								(CDR Y))))
					    (T NIL))))))

(DEFUN MERGE-TESTS-AND-ALISTS (TA1 TA2)
  (AND (SETQ
	ALISTS
	(PIGEON-HOLE
	 (ACCESS TESTS-AND-ALISTS ALISTS TA1)
	 (ACCESS TESTS-AND-ALISTS ALISTS TA2)
	 (FUNCTION (LAMBDA (ALIST1 ALIST2)

;   Union the two alists if they have a non-trivial intersection, that is, they
;   intersect with a pair other than one like (x . x), and they agree on their
;   intersection.

		     (AND (ITERATE FOR PAIR1 IN ALIST1
				   THEREIS (AND (NOT (EQ (CAR PAIR1) (CDR PAIR1)))
						(MEMBER-EQUAL PAIR1 ALIST2)))
			  (ITERATE FOR PAIR1 IN ALIST1 WITH PAIR2
				   WHEN (SETQ PAIR2 (ASSOC-EQ (CAR PAIR1) ALIST2))
				   ALWAYS (EQUAL PAIR2 PAIR1))
			  (UNION-EQUAL ALIST1 ALIST2))))
	 T NIL))
       (MAKE TESTS-AND-ALISTS (ACCESS TESTS-AND-ALISTS TESTS TA2)
	     ALISTS)))

(DEFUN MERGE-TESTS-AND-ALISTS-LSTS
  (TESTS-AND-ALISTS-LST1 TESTS-AND-ALISTS-LST2 VARS)

;   If every alist in TESTS-AND-ALISTS-LST1 fits into an alist in
;   TESTS-AND-ALISTS-LST2, then return the new TESTS-AND-ALISTS-LST obtained by
;   putting each alist in TESTS-AND-ALISTS-LST1 into every alist in
;   TESTS-AND-ALISTS-LST2 into which it fits.  Else return NIL.  ALIST1 fits
;   into ALIST2 iff the two agree on every var in VARS.  To merge one alist
;   into another we extend the second alist by adding to it every pair of the
;   first, provided that pair does not clash with an existing pair of the
;   second.

  (LET (BUCKETS ALIST FLG)
    (SETQ BUCKETS (ITERATE FOR TA IN TESTS-AND-ALISTS-LST2
			   COLLECT (ITERATE FOR ALIST
					    IN (ACCESS TESTS-AND-ALISTS ALISTS TA)
					    COLLECT (CONS ALIST NIL))))
    (COND ((ITERATE FOR TA1 IN TESTS-AND-ALISTS-LST1
		    ALWAYS
		    (ITERATE FOR ALIST1 IN (ACCESS TESTS-AND-ALISTS ALISTS TA1)
			     ALWAYS
			     (PROGN
			       (SETQ FLG NIL)
			       (ITERATE FOR BUCKET IN BUCKETS
					DO
					(ITERATE FOR PAIR IN BUCKET
						 DO
						 (COND ((FITS ALIST1 (CAR PAIR) VARS)
							(RPLACD
							 PAIR
							 (ADD-TO-SET
							  (EXTEND-ALIST
							   ALIST1 (CAR PAIR))
							  (CDR PAIR)))
							(SETQ FLG T)))))
			       FLG)))
	   (ITERATE FOR TA IN TESTS-AND-ALISTS-LST2 AS BUCKET IN BUCKETS
		    COLLECT (MAKE TESTS-AND-ALISTS
				  (ACCESS TESTS-AND-ALISTS TESTS TA)
				  (ITERATE FOR X IN BUCKET
					   WITH ITERATE-ANS
					   DO (SETQ ITERATE-ANS
						    (UNION-EQUAL (OR (CDR X) X)
								 ITERATE-ANS))
					   FINALLY (RETURN ITERATE-ANS)))))
	  (T NIL))))

(DEFUN META-LEMMAP (X) (ATOM (ACCESS REWRITE-RULE CONCL X)))

(DEFUN MULTIPLE-PIGEON-HOLE (PIGEONS HOLES FN)
  (LET (TEMP PAIRLST)
    (SETQ PAIRLST (ITERATE FOR X IN HOLES COLLECT (CONS NIL X)))
    (COND ((ITERATE FOR PIGEON IN PIGEONS
		    ALWAYS (ITERATE FOR PAIR IN PAIRLST WITH FLG
				    DO (SETQ TEMP (FUNCALL FN PIGEON (CDR PAIR)))
				    (COND (TEMP (RPLACD PAIR TEMP) (SETQ FLG T)))
				    FINALLY (RETURN FLG)))
	   (ITERATE FOR PAIR IN PAIRLST COLLECT (CDR PAIR)))
	  (T (ERROR1 (PQUOTE (PROGN MULTIPLE-PIGEON-HOLE |failed| |to|
				    |get| |everything| |in| |a| |pot.|))
		     (BINDINGS)
		     (QUOTE HARD))))))
