signature SCUTILS =
  sig
    structure Term : TERM
    structure F : FORMATTER

    structure Switch : SWITCH

    structure Abbrev :
      sig
        val mft : Term.term -> F.format
        val mft' : Term.term -> F.format
        val mfv : Term.varbind -> F.format
        val mfl : ('a -> F.format list) -> 'a list -> F.format


        val mst : Term.term -> string
        val mst' : Term.term -> string
        val msv : Term.varbind -> string
        val msl : ('a -> string) -> 'a list -> string

        val pt : Term.term -> unit
        val pt' : Term.term -> unit
        val pv : Term.varbind -> unit
        val pl : ('a -> 'b) -> 'a list -> unit
      end

    val is_eq : Term.term * Term.term -> bool

    val is_closed : Term.term -> Term.term list

    val get_type : Term.term -> Term.term
    val general_head_args : Term.term -> Term.term * Term.term list

    val forced_sb : Term.term -> Term.term -> Term.term -> Term.term
    val forced_sb_p : Term.term -> (Term.term -> bool) -> Term.term
                      -> Term.term

    val type_sb_closed : (bool * int) -> (Term.term list) ->
                         Term.term -> Term.term -> Term.term -> Term.term
(*
    val type_sb_open : Term.term -> Term.term -> Term.term -> Term.term
 *)
    val occurs_in_p : (Term.term -> bool) -> Term.term -> bool
    val occurs_in : Term.term -> Term.term -> bool

    val get_evars : Term.term -> Term.term list
    val get_uvars : Term.term -> Term.term list
    val get_uevars : Term.term -> Term.term list
    val get_bvars : Term.term -> Term.term list

    val instantiate : Term.term -> Term.term

  end
