signature LISTS =
  sig
   exception ListsError of string

   (* General lists *)

   val some: ('a -> bool) -> 'a list -> bool
   val all: ('a -> bool) -> 'a list -> bool
   val filter: ('a -> bool) -> 'a list -> 'a list
   val flatten: ('a list) list -> 'a list
   val nthhead : 'a list * int -> 'a list
   val left : 'a list * int -> 'a list
   val right: 'a list * int -> 'a list
   val mid  : 'a list * int * int -> 'a list
   val split_at : ('a -> bool) -> 'a list -> ('a list * 'a list)

   val last: 'a list -> 'a
   val butlast: 'a list -> 'a list

   val zip: 'a list -> 'b list -> ('a * 'b) list
   val unzip: ('a * 'b) list -> ('a list * 'b list)

   val makestring_list:  ('a -> string) -> 'a list -> string
   val print_list: ('a -> 'b) -> 'a list -> unit

   (* Lists with user-provided equality *)

   val is_inEQ : ('a * 'a -> bool) -> 'a -> 'a list -> bool
   val unionEQ : ('a * 'a -> bool) -> 'a list -> 'a list -> 'a list
   val intersectEQ : ('a * 'a -> bool) -> 'a list -> 'a list -> 'a list
   val removeEQ: ('a * 'a -> bool) -> 'a -> 'a list -> 'a list
   val minusEQ : ('a * 'a -> bool) -> 'a list -> 'a list -> 'a list

   (* Lists with SML-equality *)

   val is_in : ''a -> ''a list -> bool
   val union : ''a list -> ''a list -> ''a list
   val intersect : ''a list -> ''a list -> ''a list
   val remove: ''a -> ''a list -> ''a list
   val minus : ''a list -> ''a list -> ''a list

   (* Lists with user-provided lessequal predicate *)

   val merge:  ('a * 'a -> bool) -> 'a -> 'a list -> 'a list
   val sort :  ('a * 'a -> bool) -> 'a list -> 'a list
   val unique: ('a * 'a -> bool) -> 'a list -> 'a list list

  end
