functor Lists() : LISTS =
  struct
    exception ListsError of string

    fun flatten l =
        let fun fl nil res = res
              | fl (h::t) res = fl t (res @ h)
        in fl l nil end
    
    fun filter p l =
        let fun fi nil res = rev res
              | fi (h::t) res = fi t (if p h then h::res else res)
        in fi l nil end

    fun some p nil = false
      | some p (h::t) = (p h) orelse (some p t)

    fun all p nil = true
      | all p (h::t) = (p h) andalso (all p t)

    fun split_at p l =
        let fun sp nil front = (rev front, nil)
              | sp (l as (h::t)) front = if p h then (rev front, l)
                                            else sp t (h::front)
        in sp l nil end

    fun last [h] = h
     |  last (h::t) = last t
     |  last nil = raise ListsError "last: list is empty"

    fun nthhead(l,n) =
        let fun nh l 0 res = res
              | nh nil n res = raise ListsError "nthhead: list is empty"
              | nh (h::t) n res = nh t (n-1) (h::res)
        in
          rev(nh l n nil)
        end
    
    val left = nthhead

    fun right(l,n) = nthtail(l, (length l)-n)

    fun mid(l,pos,len) = left(nthtail(l, pos-1), len)
                         handle ListsError s => (nthtail(l, pos-1))
                        
    fun butlast l = 
        let fun bl [_] res = rev res
              | bl (h::(t as (_::_))) res = bl t (h::res)
              | bl nil _ = raise ListsError "butlast: list is empty"
        in bl l nil end
    
    
    fun zip l1 l2 =
        let fun z nil nil res = rev res
              | z (h::t) (h'::t') res = z t t' ((h,h')::res)
              | z _ _ _ = raise ListsError "zip: lists of different length"
        in z l1 l2 nil end

    fun unzip l =
        let fun uz nil res = res
              | uz ((h,h')::t) (res,res') = uz t ((h::res),(h'::res'))
        in uz (rev l) (nil,nil) end

    
    fun makestring_list mstr l =
        let fun m nil res = res
             |  m (h::h'::t) res = m (h'::t) (","^(mstr h)^res)
             |  m [h] res = (mstr h)^res
        in "["^(m (rev l) "")^"]" end

    fun print_list pel l =
        let fun pl nil = ()
             |  pl (h::h'::t) = (pel h; print ","; pl (h'::t))
             |  pl [h] = (pel h; ())
         in
           (print "["; pl l; print "]")
        end

  (* Lists with equality *)

    fun is_inEQ eq =
        let fun isin e nil = false
              | isin e (h::t) = eq(e,h) orelse isin e t
        in isin end
    val is_in = is_inEQ (op =)

    fun unionEQ eq =
        let fun union nil l = l
             |  union l nil = l
             |  union l' l =
                let fun u nil res = res
                      | u (h::t) res = u t (if is_inEQ eq h res
                                            then res else h::res)
                in u (rev l') l end
        in union end
    val union = unionEQ (op =)

    fun intersectEQ eq =
        let fun isect nil l = nil
             |  isect l nil = nil
             |  isect l' l =
                let fun i nil res = res
                      | i (h::t) res = i t (if is_inEQ eq h l
                                            then h::res else res)
                in i (rev l') nil end
        in isect end
    val intersect = intersectEQ (op =)

    fun removeEQ eq =
        let fun remove a l =
            let fun rm nil res = rev res
                  | rm (h::t) res = rm t (if eq(a,h) then res else h::res)
             in rm l nil end
        in remove end
    val remove = removeEQ (op =)

    fun minusEQ eq =
        let fun minus l nil = l
              | minus nil l = nil
              | minus l (h::t) = minus (removeEQ eq h l) t
        in minus end
    val minus = minusEQ (op =)
    

    (* Lists with user-provided inequality *)

    fun merge leq el l =
       let fun mrg nil res = rev (el::res)
             | mrg (l as (h::t)) res = if leq(el,h)
                                       then (rev (el::res)) @ l
                                       else mrg t (h::res)
       in mrg l nil end

    fun sort leq l =
        let fun srt nil res = res
              | srt (h::t) res = srt t (merge leq h res)
        in srt l nil end

    fun unique leq l =
        let fun eq(a,b) = leq(a,b) andalso leq(b,a)
            fun class nil res = rev res
              | class (h::t) nil = class t [[h]]
              | class (h::t) (cl as (c::cr)) =
                   case c of
                     nil => raise ListsError "unique: Shouldn't occur"
                   | (h'::_) => if eq(h,h')
                                then class t ((h::c)::cr)
                                else class t ([h]::cl)
        in class (sort leq l) nil end

  end
