(* Copyright (c) 1991, 1992, 1993 by Carnegie Mellon University *)
(* Modified: Ekkehard Rohwedder <er@cs.cmu.edu>           *)

(* Requires much cleaning up !!! *)

functor ElfTools
   (structure Term : TERM
    structure Sign : SIGN  sharing Sign.Term = Term
    structure Constraints : CONSTRAINTS  sharing Constraints.Term = Term
    structure Progtab : PROGTAB  sharing Progtab.Term = Term
    structure Store : STORE
       sharing Store.Term = Term
       sharing Store.Sign = Sign
       sharing Store.Progtab = Progtab
    structure Deps : DEPS
       sharing Deps.Term = Term
       sharing Deps.Sign = Sign
       sharing Deps.Constraints = Constraints
       sharing Deps.Progtab = Progtab
    (* structure Cover : COVER *)
    ) : ELFTOOLS =
struct

  structure Store = Store

  (* Augmenting help information *)
  local 
   fun h () =
    print
  " Additional functions in ElfTools:\n\
  \ families ()             --- print type families and their hierarchy-level\n\
  \ deps ()                 --- print dependency classes for top-level\n\
  \ ceps ()                 --- print dependencies for all top-level clauses\n"
  in val _ = Store.addhelp h end
  (*
  \ cover \"{x1}..{xn} M\"    --- coverage analysis\n
  *)

  (*** Displaying type family "hierarchy" ***)

  (* val cover = Cover.coverage *)

  fun families () =
        (print "Levels of type families:\n";
         map (fn (filename,timestamp,Store.Static _)
                  => (print (filename ^ " --- " ^ (makestring timestamp)
                              ^ " --- " ^ "static\n");
                      Deps.print_levels (Store.find_sig filename))
               | (filename,timestamp,Store.Dynamic _)
                  => (print (filename ^ " --- " ^ (makestring timestamp)
                              ^ " --- " ^ "dynamic\n");
                      Deps.print_levels (Store.find_sig filename)))
             (!Store.topenv); 
         ())

  (*** Displaying dependency information ***)

  fun deps() = (print "Type-family dependency classes:\n";
                Deps.print_list_deps(Store.topsign());
                print "\n";
                ())
  fun cdeps () = (print "Dependencies induced by each clause:\n";
                  Deps.print_clause_deps(Store.topsign());
                  ())

end  (* functor ElfTools *)
