(* Copyright (c) 1991 by Carnegie Mellon University *)
(* Author: Frank Pfenning <fp@cs.cmu.edu>           *)

(* Parser primitives *)

signature PARSE =
sig

  structure Parser : PARSER

  exception ParseError of (Parser.pos * Parser.pos) * string
     sharing type Parser.pos = int

  type token_stream
  val file_open : string -> (unit -> unit) * token_stream
  val file_parse : token_stream -> (Parser.result * token_stream) option
  val interactive_parse : string -> string -> Parser.result option
  val stream_init : instream -> (string -> string) -> token_stream
  val stream_parse : token_stream -> (Parser.result * token_stream) option

end  (* signature PARSE *)
