(* Copyright (c) 1991 by Carnegie Mellon University *)
(* Author: Frank Pfenning <fp@cs.cmu.edu>           *)

(* Abstract syntax, Elf specific part *)

signature ELF_ABSYN =
sig

  structure Term : TERM

  datatype parse_result
    = ParsedSigentry of (string list * Term.varbind) * (int * int)
    | ParsedQuery of string list * Term.term
    | ParsedFixity of (Term.fixity * int) * Term.sign_entry list
    | ParsedNamePref of Term.sign_entry * string list

end  (* signature ELF_ABSYN *)
