;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		Test.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

(eval-when (compile load eval)
  (export
   '(test-dtp) ))

;;;----------------------------------------------------------------------------

(defparameter *test-ignore-answer* '**)

;;;----------------------------------------------------------------------------

(defun test-dtp (&key (reset t))
  "Resets theorem prover, loads and runs test suite"
  (when reset (reset-dtp))
  (let (testfile)
    (setq testfile (concatenate 'string *dtp-logic-directory* "dtp.test"))
    #-lucid (setq testfile (translate-logical-pathname testfile))
    (with-open-file (tf testfile :direction :input)
      (loop
	  with *package* = *dtp-package*
	  with errors = 0
	  with tests = 0
	  initially (format t "~&")
	  for sexp = (read tf nil nil)
	  until (null sexp)
	  for expected-answer = (read tf nil nil)
	  with answer
	  do (when (find :tests *trace*)
	       (if (eq expected-answer *test-ignore-answer*)
		   (format t "[~(~S~)]~%" sexp)
		 (format t "~(~S~)~%" sexp) ))
	     (setq answer (eval sexp))
	     (when (and (find :tests *trace*)
			(not (eq expected-answer *test-ignore-answer*)) )
	       (format t "-> ~S~%" answer) )
	     (unless (eq expected-answer *test-ignore-answer*)
	       (incf tests)
	       (unless (equal expected-answer answer)
		 (incf errors)
		 (when (find :tests *trace*)
		   (format t "Error: Should have gotten~%   ~A~%"
			   expected-answer ))
		 ))
	  finally
	    (when (find :tests *trace*)
	      (format t "~D test~:P checked, ~D error~:P~%" tests errors) )
	    (return errors) ))))

;;;----------------------------------------------------------------------------
