;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		Misc-Inference.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

;;;----------------------------------------------------------------------------
;;;
;;;	Generic functions

(defgeneric expand (node)
  (:documentation "Attempt to find another <answer> for NODE") )

(defgeneric exhausted-p (node)
  (:documentation "Test whether there might be more answers from NODE") )

(defgeneric propogate (answer node)
  (declare (type answer answer))
  (:documentation "Inform NODE that ANSWER is another answer") )

;;;----------------------------------------------------------------------------
;;;
;;;	Miscellaneous

(defun answer-equal-p (ans1 ans2)
  (and (binding-list-equal-p
	(answer-binding-list ans1)
	(answer-binding-list ans2) )
       (label-equal-p (answer-label ans1) (answer-label ans2)) ))

;;;----------------------------------------------------------------------------
