;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		DTP.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)
;;;
;;;	Documentation Notes
;;;
;;;		Exported functions are intended to be called by users.  All
;;;		other functions and symbols are intended to be internal.
;;;
;;;		Many files have a "public" and a "private" section.  Functions
;;;		defined in the "private" section are ONLY called by functions
;;;		within the same file.  All functions called by routines in
;;;		other files are placed in the "public" section.

(in-package "COMMON-LISP-USER")

(eval-when (compile eval load)
  (defpackage "DTP"
    #-lucid (:use "COMMON-LISP") ))

(in-package "DTP")

;;;----------------------------------------------------------------------------
;;;
;;;	Options to change for new system installation

(eval-when (compile load eval)
  
  ;; Customize feature
  ;; Options: Present (:customize-dfg) or absent
  ;; Controls: Default directories for files.  If present, set up for Geddis
  (pushnew :customize-dfg *features*)
  
  ;; Debug feature
  ;; Options: Present (:dtp-debug) or absent
  ;; Controls: Whether to optimize compilation steps, or leave debugging info 
  (pushnew :dtp-debug *features*)
  
  ;; Code status feature
  ;; Options: Internal only (:dtp-alpha), external testing (:dtp-beta),
  ;;    or absent if approved for general use
  (pushnew :dtp-alpha *features*)

  )

#-lucid
(eval-when (compile load eval)
  (setf (logical-pathname-translations "dtp")
    #+(and customize-dfg allegro)
    '(("*.*.*" "~geddis/Lisp/DTP/")
      ("logic;*.*.*" "~geddis/Lisp/DTP/Logic/") )
    #+(and customize-dfg mcl)		; Bug means most specific must be first
    '(("logic;*.*.*" "Don Geddis:DTP:Logic:")
      ("*.*.*" "Don Geddis:DTP:") )
    #-customize-dfg  
    '(("*.*.*" "") ("logic;*.*.*" "")) ))

;;;----------------------------------------------------------------------------

(eval-when (compile load eval)
  (defparameter *dtp-major-version* 2)
  (defparameter *dtp-minor-version* 0)
  (defparameter *dtp-release-status*
      #+dtp-alpha "alpha"
      #+dtp-beta "beta"
      #-(or dtp-alpha dtp-beta) "released" )
  (defparameter *dtp-compilation*
      #+dtp-debug "[debugging]"
      #-dtp-debug "[production]" ))

(eval-when (compile load eval)
  (defparameter *dtp-version*
      (format nil "~D.~2,'0D ~A ~A"
	      *dtp-major-version*
	      *dtp-minor-version*
	      *dtp-release-status*
	      *dtp-compilation* ))
  (export '(*dtp-version*)) )


(eval-when (compile load eval)
  (format t "~&DTP version ~A~%" *dtp-version*) )

;;;----------------------------------------------------------------------------

(eval-when (compile load eval)
  (defparameter *dtp-directory*
      #-lucid "dtp:"
      #+(and lucid customize-dfg) "/lisp/dtp/"
      #+(and lucid (not customize-dfg)) "" )
  (defparameter *dtp-logic-directory*
      #-lucid "dtp:logic;"
      #+(and lucid customize-dfg) "/lisp/dtp/"
      #+(and lucid (not customize-dfg)) "" )
  (export '(*dtp-directory* *dtp-logic-directory*)) )

(eval-when (compile load eval)
  (unless (find :dtp-defsystem *features*)
    (load (concatenate 'string *dtp-directory* "defsystem")) ))

;;;----------------------------------------------------------------------------

(dtp-ds:defsystem :dtp
    :source-pathname #-lucid "dtp:"
    #+(and lucid customize-dfg) "/lisp/dtp/"
    #+(and lucid (not customize-dfg)) ""
    :components
    ((:module :dtp-data-structures
	      :source-pathname ""
	      :components
	      ((:file "types")
	       (:file "structures")
	       (:file "classes")
	       (:file "variables") ))
     (:module :dtp-extensions
	      :source-pathname ""
	      :components
	      ((:file "internals")) )
     (:module :dtp-defsystem
	      :source-pathname ""
	      :components
	      ((:file "defsystem") ))
     (:module :dtp-unification
	      :source-pathname ""
	      :components
	      ((:file "symbols")
	       (:file "bindings")
	       (:file "binding-dag")
	       (:file "match")
	       (:file "cnf") ))
     (:module :dtp-kb
	      :source-pathname ""
	      :components
	      ((:file "literals")
	       (:file "clauses")
	       (:file "labels")
	       (:file "database") )
	      :depends-on (:dtp-data-structures :dtp-extensions) )
     (:module :dtp-inference
	      :source-pathname ""
	      :components
	      ((:file "misc-inference")
	       (:file "terms")
	       (:file "subgoals")
	       (:file "conjunctions")
	       (:file "memoing")
	       (:file "ordering")
	       (:file "prover") )
	      :depends-on (:dtp-data-structures :dtp-extensions) )
     (:module :dtp-misc
	      :source-pathname ""
	      :components
	      ((:file "hierarchy")
	       (:file "output")
	       (:file "file")
	       (:file "test") )
	      :depends-on (:dtp-data-structures :dtp-extensions) )
     ))

;;;----------------------------------------------------------------------------

(defun load-dtp-system ()
  (dtp-ds:operate-on-system :dtp 'compile :verbose t)
  (dtp-ds:operate-on-system :dtp 'load :verbose t) )
(eval-when (load eval)
  (export '(load-dtp-system)) )

(eval-when (load eval)
  (load-dtp-system) )

;;;----------------------------------------------------------------------------
