;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		Test.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

(eval-when (compile load eval)
  (export
   '(test-dtp) ))

;;;----------------------------------------------------------------------------

(defparameter *test-ignore-answer* '**)

;;;----------------------------------------------------------------------------

(defun test-dtp ()
  "Resets theorem prover, loads and runs test suite"
  (let ((testfile (concatenate 'string *dtp-logic-directory* "dtp.test")))
    (reset-dtp)
    (with-open-file (tf testfile :direction :input)
      (loop
	  with *package* = *dtp-package*
	  with errors = 0
	  with tests = 0
	  initially (format t "~&")
	  for sexp = (read tf nil nil)
	  until (null sexp)
	  for expected-answer = (read tf nil nil)
	  with answer
	  do (when (trace-tests *tracemap*)
	       (if (eq expected-answer *test-ignore-answer*)
		   (format t "~(~S~)~%" sexp)
		 (format t "~S~%" sexp) ))
	     (setq answer (eval sexp))
	     (when (and (trace-tests *tracemap*)
			(not (eq expected-answer *test-ignore-answer*)) )
	       (format t "-> ~S~%" answer) )
	     (unless (eq expected-answer *test-ignore-answer*)
	       (incf tests)
	       (unless (equal expected-answer answer)
		 (incf errors)
		 (when (trace-tests *tracemap*)
		   (format t "Error: Should have gotten~%   ~A~%"
			   expected-answer ))
		 ))
	  finally
	    (when (trace-tests *tracemap*)
	      (format t "~D test~:P checked, ~D error~:P~%" tests errors) )
	    (return errors) ))))

;;;----------------------------------------------------------------------------
