;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		Proof-Setup.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

;;;----------------------------------------------------------------------------

(defun prove-all-answers (query)
  (loop
      for answer = (prove-first-answer query) then (prove-next-answer)
      while answer
      collect answer ))

(defun prove-n-answers (query n)
  (loop
      for count from 1 to n
      for answer = (prove-first-answer query) then (prove-next-answer)
      while answer
      collect answer ))

;;;----------------------------------------------------------------------------

(defun prove-first-answer (query)
  "Returns (1) first answer to query, and (2) proof object"
  (setf (proof-query *proof*) query
	(proof-answers *proof*) nil
	(proof-negated-goals *proof*) nil
	(proof-subgoals *proof*) nil
	(proof-gensym-count *proof*) 0
	(proof-rename-gensym-count *proof*) 0
	(proof-node-id-count *proof*) 0
	(proof-gate-count *proof*) 0
	(proof-answer-count *proof*) 0
	(proof-design-goals *proof*) nil
	(proof-cached-answers *proof*) (make-hash-table :test #'eq)
	(proof-pure-literal-nodes *proof*) (make-hash-table :test #'eq) )
  (query-to-negated-goals)
  (setf (proof-agenda *proof*) (proof-negated-goals *proof*))
  (prove-next-answer) )

;;;----------------------------------------------------------------------------

(defun query-to-negated-goals ()
  (setf (proof-negated-goals *proof*)
    (loop
	with answer-literal = (query-to-answer-literal (proof-query *proof*))
	with rewritten-query = (list 'not (proof-query *proof*))
	for goal in (sentence-to-cnf rewritten-query)
	for breadth from 1
	for new-clause =
	  (make-clause-node
	   :literals (mapcar #'list-to-literal goal)
	   :answer-literals (list answer-literal) )
	collect
	  (make-agenda-node
	   :id (make-new-id "NG" breadth)
	   :breadth breadth
	   :clause new-clause
	   :origin 'negated-goal )
	  )))

;;;----------------------------------------------------------------------------
