;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		Logic.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

;;;----------------------------------------------------------------------------

(defun logic-to-cnf (logic)
  "FOPC to conjunctive-normal (clausal) form"
  (let ((cnf logic))
    (setq cnf (implications-out cnf))
    (setq cnf (negations-in cnf))
    (setq cnf (standardize-variables cnf))
    (setq cnf (existentials-out cnf))
    (setq cnf (universals-out cnf))
    (setq cnf (disjunctions-in cnf))
    (setq cnf (operators-out cnf))
    #| (setq cnf (rename-variables cnf)) |# ; Automatic with DB lookup
    cnf ))

;;;----------------------------------------------------------------------------

(defun implications-out (sentence)
  "Step one of converting to clausal form"
  (if (consp sentence)
      (let ((operator (first sentence))
	    (subsentences (mapcar #'implications-out (rest sentence))) )
	(case operator
	  (<=
	   `(or ,(first subsentences)
		,@(mapcar #'negate-list (rest subsentences)) ))
	  (=>
	   `(or ,@(mapcar #'negate-list (butlast subsentences))
		,(first (last subsentences)) ))
	  (<=>
	   `(and
	     (or ,(first subsentences)
		 ,@(mapcar #'negate-list (rest subsentences)) )
	     (or ,@(mapcar #'negate-list (butlast subsentences))
		 ,(first (last subsentences)) )))
	  (otherwise
	   (cons operator subsentences) )))
    sentence ))

;;;----------------------------------------------------------------------------

(defun negations-in (sentence)
  "Step two of converting to clausal form"
  (cond
   ((and (consp sentence)
	 (eq (first sentence) 'not) )
    (cond
     ((and (consp (second sentence))
	   (eq (first (second sentence)) 'not) )
      (let ((operator (first sentence))
	    (subsentences (mapcar #'negations-in (rest sentence))) )
	(if (eq operator 'not)
	    )))))))	    

;;;----------------------------------------------------------------------------
